#version 450
layout (location = 0) in vec3 vertex;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texc;

uniform mat4 pmatrix;
uniform mat4 nmatrix;
out vec2 texcoord;
out vec4 normalvec;

void main(){
  gl_Position = pmatrix * vec4(vertex, 1.0);
  texcoord = texc;
  mat4 nm = transpose(inverse(nmatrix));
  normalvec = normalize(nm * vec4(normal, 1.0));
}
