#version 450

layout (location = 0) out vec4 FragColor;
uniform sampler2D img;
in vec2 texcoord;
in vec4 normalvec;

void main(void){
   vec4 lightpos = vec4(0.0, 0.4, 0.1, 1.0);
   vec4 diffuse = texture(img, texcoord);
   vec4 darker = diffuse - vec4(0.1);
   vec4 lighter = diffuse + vec4(0.1);;
   float costheta = dot(normalvec, lightpos);
   float a = 0.5 + 0.5 * costheta;
   vec4 ambient = mix(darker, lighter, a);
   FragColor = ambient;
}
