#version 450

layout (location = 0) out vec4 FragColor;
in vec4 norm;
in vec2 tc;
in vec3 vpos;
uniform sampler2D glasstex;
uniform float time;

void main(void){

   vec3 lightpos = vec3(100, time, time);
   //vec4 glasscolor = vec4(1.0, 1.0, 1.0, 1.0);
   //vec4 opaque = vec4(0.0, 0.9, 0.0, 0.2);

   float distance = length(lightpos - vpos);
   vec3 lightvector = normalize(lightpos - vpos);
   float diffuse = max(dot(vec3(norm), lightvector), 0.1);
   //diffuse = diffuse * (1.0 / (1.0 + (0.25 * distance * distance)));

   vec2 tc2 = tc;
   tc2.y = tc2.y - (time / 5.0);
   vec4 glasscolor = texture(glasstex, tc2);

   FragColor = glasscolor; //opaque;//mix(glasscolor, opaque, r);
}
