#version 450

#define KERNELSIZE 15

layout (location = 0) out vec4 FragColor;

uniform sampler2D color0;
uniform sampler2D depth;
in vec2 texcoord;

float gausscoef(float sigma, int x, int y) {
   float e = exp( -1.0 * (x*x + y*y) / (2.0 * sigma*sigma) );
   return 1.0 / (2.0 * 3.14 * sigma*sigma) * e;
}

vec4 blur(int kernelsize, float sigma, sampler2D img, vec2 tc, vec2 screen){
   int dc = (kernelsize - 1) / 2;
   vec4 sum = vec4(0.0);
   vec4 blurcolor = vec4(0.0);
   float tmp[KERNELSIZE][KERNELSIZE]; //FIXME maximal kernel size is 33!

   for(int i = 0; i < kernelsize; i++){
      for(int j = 0; j < kernelsize; j++){
         tmp[i][j] = gausscoef(sigma, i - dc, j - dc);
         sum += tmp[i][j];
      }
   }

   for(int i = 0; i < kernelsize; i++){
      for(int j = 0; j < kernelsize; j++){
         vec2 t = tc + screen * vec2(float(i - dc), float(j - dc));
         blurcolor += (tmp[i][j] / sum) * texture(img, t);
      }
   }

   return blurcolor;
}

void main(void){
   vec2 tsize = 1.0 / textureSize(color0, 0);
   float dist = max(texture(depth, texcoord).r - 0.99, 0.0) * 100.0;

   FragColor = blur(KERNELSIZE, 0.01 + dist * dist * 12.0, color0, texcoord, tsize);
}
