lmpr:          EQU  &FA
hmpr:          EQU  &FB
vmpr:          EQU  &FC
rom0_off:      EQU  %00100000
mode_4:        EQU  %01100000

NUM_LINES: EQU 192

LENGTH:	EQU	1024
STRENGTH:	EQU	64
CENTER:	EQU	64
BASESINE:	EQU	&8A00
change: EQU &820a
LINES: EQU &8400

	autoexec
	ORG	&8000
	DUMP &8000

	;di
	;ld hl,cstart
	;ld de,&4000
	;ld bc,cend-cstart
	;ldir
	;jp &4000

cstart:
	
	di
	ld hl,&F000
	ld sp,hl

gensine0:
	EXX
	LD DE,BASESINE
	EXX

	LD HL,CENTER*256
	LD DE,-LENGTH
epi256:
	ADD HL,DE
	EX DE,HL
	ADD HL,BC
	EX DE,HL
	LD A,H
	PUSH AF

	CP CENTER
JR NC,nodown

	LD BC,STRENGTH
	LD A,(change)
	OR A
	JR NZ,nochang1
		LD DE,-LENGTH
        nochang1:
	INC A
	LD (change),A
    JR noup

    nodown:
        LD BC,-STRENGTH
        LD A,(change)
	DEC A
        JR NZ,nochang2
        LD DE,LENGTH
    nochang2:
	XOR A
	LD (change),A
    noup:

    POP AF
    EXX
	;SRL A
	;SLL A
SUB 128

	LD (DE),A
	INC E
	EXX
    JR NZ,epi256

	xor a
	ld bc,&0ff8
	out (c),a

	ld c,4
do4_30:
	ld a,c
	or rom0_off
	out (lmpr),a
	;or mode_4
	;out (vmpr),a

	ld hl,0
	ld d,h
	ld e,128
oox:
	;ld a,e
	;dec a

	push hl
	push de

	ld a,e
	add 31
	ld e,a

	ld h,d
	ld l,d
	ld a,c
	add 224
	ld b,a
mul_a:
	add hl,de
	dec b
	jr nz,mul_a
	ld a,h
	pop de
	pop hl

	and 15
	srl a
	srl a
	srl a
	dec a

	ld (hl),a
	inc hl
	
	dec e
	jr nz,oox

	ex de,hl
	;ld hl,16*128
	;ld de,17*128
	push bc
	ld bc,24448
	ldir

	pop bc

	ld a,c
	add 2
	ld c,a
	cp 32
	jr nz,do4_30

cloop:

	ld hl,(NFRAME)
	inc hl
	ld (NFRAME),hl

	ld a,h
	add a
	add a
	add a
	add a
	ld (autom3+1),a

	ld h,BASESINE/256
	ld a,l
	ld b,h
	add a
	ld c,a

	ld de,LINES
sineLines:
	ld a,(bc)
	add a,(hl)
	inc l
	inc c
	srl a
	srl a
	srl a
	srl a
	add a

	;cp 4
	;jr nc,noUnder
	;ld a,4
;noUnder:
	ld (de),a
	inc e

	ld a,e
	cp NUM_LINES
	jr nz,sineLines

waitVsync:
	in a,(249)
	and 8
jr nz,waitVsync

	xor a
	out (249),a

	ld hl,LINES
	ld c,&f8
	ld d,0
	ld a,(NFRAME)
	ld e,a
flipLines:
	waitLine:
		in a,(249)
		and 1
	jr nz,waitLine

	ld a,(hl)
	inc l
	or mode_4
	out (vmpr),a

	ld a,d
	add e
	srl a
	srl a
autom3:
	add 32
	ld b,15
	out (c),a

	inc d
	ld a,d
	out (249),a

	cp NUM_LINES
	jr nz,flipLines

jr cloop


NFRAME:
dw 256

cend:
