; Cuarta K Onda
;
; This entry is inspired by a work of art I encountered at the Museo National
; de Bellas Artes in Buenos Aires about a month before Flashparty.
;
;   Ondulante
;   María Martorell
;   1968
;   https://www.bellasartes.gob.ar/coleccion/obra/8526/
;
; I could not achieve a fully faithful reproduction, but the influences should
; be evident.
;
; I spent more bytes on getting a basic tango rhythm than I had hoped. I'm sure
; there are many inefficiencies that could free up enough space to put back in
; the greets.
;
; Special thanks to HellMood for breaking so much ground in the 256b space and
; thoroughly documenting his entries.

org 0x100
bits 16

;%define greets

main:
frame:               ; we won't be using this again
    mov al, 0x13
    int 0x10

working_space:       ; we won't be using this again
    mov ax, ds:[2]   ; next seg
    sub ax, 4096     ; subtract 64k of paragraphs
    mov fs, ax       ; set FS to free segment
    fninit

;   end of initialization

display_loop:
    call wait_for_vsync

    xor si, si
    mov bp, 200
precalc_outer:
    mov cx, 200

precalc_inner:
    mov cs:[working_space], bp
    fild word cs:[working_space]            ; k
    fld st0                                 ; k, k
    mov cs:[working_space], cx              ;
    fild word cs:[working_space]            ; line, k, k
    fild word cs:[frame]                    ; frame, line, k, k
    faddp st1                               ; f + l, k, k
    fdivrp st1                              ; (f+l)/k, k
    fsin                                    ; sin((f+l)/k), k
    fmul st1                                ; k * sin((f+l)/k), k
    fxch st0, st1
    fadd st0, st0
    fild word cs:[frame]                    ; frame, offset, k
    fdivrp st1
    fcos
    fmulp st1

    fistp word cs:[working_space]
    mov ax, cs:[working_space]

    add ax, 160
    mov fs:[si], ax
    inc si
    inc si
    loop precalc_inner
    sub bp, 40
    jnz  precalc_outer

;   Render loop
    push 0xa000         ; video memory
    pop es

    mov ah, 200
    xor di, di
    xor si, si
loop_y:
    mov cx, 320
loop_x:
    mov al, 64
    mov dx, 10000b
    xor bp, bp
loop_sub_x:
    cmp cx, fs:[si+bp]
    jge skip_1
    or  al, dl
skip_1:
    add bp, 400
    shr dl, 1
    jnc loop_sub_x

    stosb
    loop loop_x
    inc si
    inc si
    dec ah
    jnz loop_y

    inc word cs:[frame]

    inc bx              ; increment timing value
    test bx, 15         ; play a note every 16th step
    jnz nomusic         ; quit if in between
    mov si, $sound1
    mov dl, bl
    xor dl, 00100000b
    ; The low 4 bits will be zero. The next 3 bits are used as 8th notes in a
    ; measure. By xor'ing the second bit, the 8th notes with a bit sum of one
    ; give the rhythm (123) (456) (78).
    ; 000 010 1
    ; 001 011 2
    ; 010 000 0
    ; 011 001 1
    ; 100 110 2
    ; 101 111 3
    ; 110 100 1
    ; 111 101 2
    shl dl, 2
    adc ah, 0
    shl dl, 1
    adc ah, 0
    shl dl, 1
    adc ah, 0
    mov dx,0x330        ; port number for MIDI
    dec ah
    jnz  noswitch
    ; turn off old note -- this isn't the place for endless reverb.
    ; The bytes feel wasted, but the result sounds horrible/even worse without.
    mov al, 0x83
    out dx, al
    mov al, cs:[pitch]
    out dx, al
    mov al, 0x70
    out dx, al

    mov si, $sound2
    mov cx, bx
    shr cx, 7
    imul ax, cx, 7*4321
    shr ax, 11
    add al, 22
    mov byte cs:[pitch], al
noswitch:
    mov cl, 5
out_loop:
    outsb               ; send MIDI note data
    loop out_loop

nomusic:
;   poll for esc key
    in   al,60h
    dec  ax
    jnz  display_loop

;   reset to text mode
    mov ax, 0x0003
    int 0x10

%ifdef greets
    mov dx, $greets_msg
    mov ah, 9
    int 0x21
%endif

wait_for_vsync:
    mov  dx, 0x3DA
    in   al, dx
    test al, 8
    jz   wait_for_vsync
    ret

%ifdef greets
greets_msg:
    db 'Saludos a todos en Flashparty 2023', 0x0a, '$'
%endif

sound1: db 0xc3, 13, 0x93, 70, 0x28
sound2: db 0xc3, 33, 0x93
pitch: db 66, 0x70