#version 450

layout (location = 0) in vec3 v_normal;
layout (location = 1) in vec3 v_tangent;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    vec3 color;
};

layout (set = 1, binding = 5) uniform sampler2D env_map;

void main() {
    vec3 normal = normalize(v_normal);
    vec4 env_color = texture(env_map, normal.xy * 0.5 + 0.5);
    f_color = vec4(env_color.rgb * color, 1.0);
}
