#version 450

layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

#include "particles.glsl"

layout (set = 0, binding = 1) buffer ParticlesCurrent {
    Particle buf[];
} particles;

void main() {
    uint num_particles = particles.buf.length();

    // Calculate the new position and velocity of the particle.
    uint index = gl_GlobalInvocationID.x;
    if (index >= num_particles) {
        return;
    }


    particles.buf[index] = init_particle(index);
}
