mat4 rotate_x(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    mat4 matrix;
    matrix[0] = vec4(1, 0, 0, 0);
    matrix[1] = vec4(0, c, s, 0);
    matrix[2] = vec4(0, -s, c, 0);
    matrix[3] = vec4(0, 0, 0, 1);
    return matrix;
}

mat4 rotate_y(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    mat4 matrix;
    matrix[0] = vec4(c, 0, s, 0);
    matrix[1] = vec4(0, 1, 0, 0);
    matrix[2] = vec4(-s, 0, c, 0);
    matrix[3] = vec4(0, 0, 0, 1);
    return matrix;
}

mat4 rotate_z(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    mat4 matrix;
    matrix[0] = vec4(c, s, 0, 0);
    matrix[1] = vec4(-s, c, 0, 0);
    matrix[2] = vec4(0, 0, 1, 0);
    matrix[3] = vec4(0, 0, 0, 1);
    return matrix;
}

mat4 rotate(vec3 angle) {
    return rotate_x(angle.x) * rotate_y(angle.y) * rotate_z(angle.z);
}


float opSmoothUnion( float d1, float d2, float k )
{
    float h = clamp( 0.5 + 0.5*(d2-d1)/k, 0.0, 1.0 );
    return mix( d2, d1, h ) - k*h*(1.0-h);
}

float sdSphere( vec3 p, float s )
{
    return length(p)-s;
}

float sdCappedTorus( vec3 p, vec2 sc, float ra, float rb)
{
    p.x = abs(p.x);
    float k = (sc.y*p.x>sc.x*p.y) ? dot(p.xy,sc) : length(p.xy);
    return sqrt( dot(p,p) + ra*ra - 2.0*ra*k ) - rb;
}

float sdTorus( vec3 p, vec2 t )
{
    vec2 q = vec2(length(p.xz)-t.x,p.y);
    return length(q)-t.y;
}

float sdf(vec3 pos) {

//    vec3 sphere_pos1 = vec3(sin(time*0.4), sin(time*0.5), sin(time*0.6)) * 1.7;
//    vec3 sphere_pos2 = vec3(cos(time*0.434), sin(time*0.145), sin(time*0.334)) * 0.8;

    vec3 pos_1 = mat3(rotate(torus_1_rotate)) * pos;
    float torus_1 = sdTorus(pos_1 - torus_1_pos, torus_1_size);

    vec3 pos_2 = mat3(rotate(torus_2_rotate)) * pos;
    float torus_2 = sdTorus(pos_2 - torus_2_pos, torus_2_size);

    return opSmoothUnion(torus_1, torus_2, 0.6);

//    float sphere1 = sdSphere(pos - sphere_pos_1, 1.0);
//    float sphere2 = sdSphere(pos - sphere_pos_2, 1.0);
//    float spheres = opSmoothUnion(sphere1, sphere2, 1);
}

//float sdf(vec3 pos) {
//    vec3 p = pos;
//
////    const float k = sdf_foo_1.x; // or some other amount
////    float c = cos(k*p.x);
////    float s = sin(k*p.x);
////    mat2  m = mat2(c,-s,s,c);
////    p = vec3(m*p.xy,p.z);
//
//    float rotation = sdf_foo_1.y;
//    mat4 rot = inverse(rotate_z(rotation));
//    p = (rot * vec4(p, 1)).xyz;
//
//    return sdf_inner(p);
//}