#version 450

layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct Particle {
    vec3 pos;
    vec3 vel;
    float size;
    float _pad;
};

layout (set = 0, binding = 1) buffer ParticlesCurrent {
    Particle buf[];
} particles;

void main() {
    uint num_particles = particles.buf.length();

    // Calculate the new position and velocity of the particle.
    uint index = gl_GlobalInvocationID.x;
    if (index >= num_particles) {
        return;
    }

    vec3 pos = vec3(sin(float(index+1) * 0.3122), sin(index) *1.2 + 2.25, sin(float(index) * 2.3122));
    vec3 vel = vec3(0, 0, 0);

    particles.buf[index] = Particle(pos, vel, 0, 0);
}
