#version 450

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_depth_map_uv;
layout (location = 1) out vec3 v_ray_eye;
layout (location = 2) out vec3 v_ray_direction;

layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_camera;
    mat4 g_camera_from_world;
    vec3 g_light_dir;
    float g_z_near;
};

void calculate_shadow_ray(vec2 uv, out vec3 eye, out vec3 dir) {
//    vec2 fov = vec2(1 / g_projection_from_camera[0][0], 1 / g_projection_from_camera[1][1]);
    mat4 inverse_rotation = inverse(g_camera_from_world);
    vec3 pos_cs = vec3(-uv.x, -uv.y, 1) * g_z_near;
    eye = (inverse_rotation * vec4(pos_cs, 1)).xyz;
    dir = -g_light_dir;
}

void main() {
    gl_Position = vec4(a_position.x, -a_position.y, 0, 1);
    v_depth_map_uv = a_uv;

    vec2 screen_uv = a_uv * 2 - 1;
    calculate_shadow_ray(screen_uv, v_ray_eye, v_ray_direction);
}