const float SDF_DISTANCE_MAX = 100;
const float SDF_SURFACE_PROXIMITY = 0.0001;

// TODO: use tetrahedron sampling instead of cube sampling
vec3 calculate_sdf_normal(vec3 pos) {
    float eps = 0.0001;
    vec3 x = vec3(eps, 0, 0);
    vec3 y = vec3(0, eps, 0);
    vec3 z = vec3(0, 0, eps);
    return normalize(vec3(
        sdf(pos + x) - sdf(pos - x),
        sdf(pos + y) - sdf(pos - y),
        sdf(pos + z) - sdf(pos - z)
    ));
}

/// Returns -1 if no intersection, otherwise returns distance to intersection
float trace_sdf(vec3 eye, vec3 dir) {
    float distance = 0;
    for (int i = 0; i < 100; i++) {
        if (distance > SDF_DISTANCE_MAX) {
            return -1;
        }
        vec3 p = eye + dir * distance;
        float sdf_value = sdf(p);
        if (abs(sdf_value) < SDF_SURFACE_PROXIMITY) {
            break;
        }
        distance += sdf_value;
    }
    return distance;
}