#version 130

float waveSpeed=2.;
float waveAmplitude=16.;
float distanceDivider=8.;

uniform float iTime = 0;
uniform sampler2D currentTexture;

vec4[] lines = vec4[] (
                        vec4(0., 0.05, 1., 0.1),
                        vec4(0., 0.17, 1., .22),
                        vec4(0., .27, 1., .3),
                        vec4(0., .4, 1., .64),
                        vec4(0., 0.61, 1., .8),
                        vec4(0., 0.81, 1., .92)
                        
                      );

float lineDist(vec2 p, vec4 l)
{
    float a = abs((l.z - l.x) * (l.y - p.y) - (l.x - p.x) * (l.w - l.y));
    float b = sqrt(pow(l.z - l.x, 2.) + pow(l.w - l.y, 2.));
        
    return a / b;
}

void main()
{
    // Normalized pixel coordinates (from 0 to 1)
    // vec2 uv = fragCoord/iResolution.xy;
    vec2 uv = gl_TexCoord[0].xy;
    
    float minDist = 100000.;
    
    for (int x = 0; x < lines.length(); x++)
    {
        vec4 moveLine = vec4(0., sin(iTime * waveSpeed + float(x)) / waveAmplitude, 0., sin(iTime * waveSpeed + float(x)) / waveAmplitude);
    
        minDist = clamp(min(minDist, lineDist(uv, lines[x] + moveLine)),0., 1.);
    }
    
    vec3 col = texture(currentTexture, vec2(uv.x, uv.y + (minDist / distanceDivider))).rgb;
    //col = vec3(minDist);

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}