#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0; 
uniform sampler2D texture1; // fft

uniform float intensity = 1.0;
uniform float zoom = 3.0;

uniform vec3 iResolution;

uniform vec4 color = vec4(1);

void main()
{
    //fragColor = vec4(texCoord.x, texCoord.y, 0, 1);
    vec2 coord = (texCoord.yx-vec2(.5,.5))/vec2(iResolution.z,1.0)/zoom;
    //coord.y = 0.0;
    //coord.x /= 2.0;
    //if (coord.x > 0.5) {coord.x -= 0.5;}
    //else if (coord.x < 0.5) {coord.x += 0.5;}

    float r = length(coord);
    //float t = atan(coord.y, coord.x) / (3.14159 * 2.0);

    float c = mix(0.0, 1.0, texture2D(texture1, vec2(r)).r*intensity);
    fragColor = mix(vec4(0),vec4(1),vec4(c,c-r*10.0,0,c))*color;
}
