;-------------------------------------------------------------------------------
;
; Christmas Tree
; for the Vintage Computing Christmas Challenge 2021
;
; System: Atari ST
;
; (w)2021 by lsl/checkpoint
;
; size: 56 bytes
; executable size: 88 bytes (32 bytes executable header)
;
;
; program should be run in low-resolution, for correct graphics centering
;-------------------------------------------------------------------------------
                OPT D-          ; no symbol table
                OUTPUT 'XMASTREE.PRG'
;-------------------------------------------------------------------------------

                lea     set_cursor_text(PC),A6 ; length_list, upside/down

                pea     (A6)            ; set_cursor_text
                move.w  #9,-(SP)        ; gemdos 9
loop_y:

; x_pos   = width/2 + 32  - length/2
; 2*x_pos = 2 * (width/2 + 32) - length
; 2*x_pos = 2 * (40/2 + 32) - length

                moveq   #2*(40/2+32),D7
                sub.b   -(A6),D7        ; -length
end:            bcs.s   end

                lsr.b   #1,D7           ; x_pos

                lea     set_cursor_text+3(PC),A5 ; x_pos
loop_x:
                move.b  D7,(A5)         ; x_pos
                addq.b  #1,D7           ; x_pos++

                trap    #1              ; output text (set_cursor_text)

                subq.b  #1,(A6)         ; length--
                bne.s   loop_x

                addq.b  #1,-(A5)        ; y_pos++

                bra.s   loop_y          ; <-- lo-byte: terminal (bcs.s end)

length_list:                            ; upside/down
                DC.B 3
                DC.B 3
                DC.B 23
                DC.B 17
                DC.B 11
                DC.B 5
                DC.B 15
                DC.B 11
                DC.B 7
                DC.B 3
                DC.B 7
                DC.B 5
                DC.B 3
                DC.B 1
set_cursor_text:
                DC.B 27,"Y"     ;         set cursor position
                DC.B 32+(25-14)/2 ; +2    y_pos     (y_max-height)/2
                DC.B 32         ;   +3    x_pos
                DC.B "*"        ;   +4
                DC.B 0

                END
