/* Zu Beginn werden die globalen Variablen deklariert und initialisiert, sowie ihre Typen festgelegt
und mit Werten versehen, sodass sie im weiteren Programm nutzbar sind*/

/*Hierbei wird zuerst die Variable spielmodus definiert,
da diese im folgenden Programm dazu genutzt wird um zum eigentlichen Spiel
weiterzuleiten und später zwischen weiteren Bildschirmen zu wechseln mit Hilfe einer switch case
0 Startbildschirm, 1 Anleitung, 2 Spielmodus, 3 Leave Bildschirm, 4 Game over */
int spielmodus=0;

//Danach legen wir mit der Variable ballsize die Größe des Pingpongballes fest.
int ballsize=20;

// Es wird die Anfangsposition des Balles definiert.
int xpos=10, ypos=10;

// Lage der Koordinatenverschiebung auf den jeweiligen Achsen.
int xv=1,  yv=1;

// Variable für die Geschwindigkeit des Balles.
int v=1;

// Höhe und Breite des Balken, so wie x- und y-Achsenlage.
int heightrecty=20, widthrectx=200, xposrect= 320, yposrect=670;

// Geschwindigkeit des Balkens.
int rectv=4;

// Erstellen einer Variable zum Zählen des Scores.
int score=0;

// Deklaration und Initialisierung der ersten Wolke, bestehend aus 3 Rechtecken.
int cloud1xpos=5 , cloud1ypos=300, widthcloud1=150, heightcloud1=10;
int cloud1xpos2= 35, cloud1ypos2=290, widthcloud1zwei= 100;
int cloud1xpos3= 55, cloud1ypos3= 280, widthcloud1drei=50;

// Deklaration und Initialisierung der zweiten Wolke, bestehend aus 3 Rechtecken.
int cloud2xpos=500, cloud2ypos= 350, widthcloud2=130, heightcloud2=10;
int cloud2xpos2=515 , cloud2ypos2=340 , widthcloud2zwei = 100;
int cloud2xpos3=535 , cloud2ypos3= 330, widthcloud2drei= 60;

//Geschwindigkeit der Wolken.
int cloud1xv=1, cloud2xv=1;

// Initialisierung und Deklaration der boolschen Variable scorerot, die dazu dient den Specialeffect des Balles und Balkens zu ermöglichen.
boolean scorerot;

// Es werden die Variablen vom Typ float erstellt, die eine Funktion ermöglichen das Spielfeld zu verlassen.
float pxl=0, pyl=0, sxl=50, syl=25, swl=100, shl=50;

// Es werden die Variablen vom Typ float erstellt, um die Umleitung des Game-Over-Bildschirms zum Spiel zu ermöglichen.
float pxge=0, pyge=0, sxge=200, syge=420, swge=300, shge=45;

// Es werden die Variablen vom Typ float erstellt, um die Umleitung des Game-Over-Bildschirms zum Startbildschirm zu ermöglichen.
float pxgz=0, pygz=0, sxgz=200, sygz=520, swgz=300, shgz=45;

//Variablen für die Überleitung vom Leave Bildschirm zum Spielbildschiem mit Hilfe von "Fortsetzen" (f)
//Überprüfen ob x Koordinate der Maus im Bereich der Schrift liegt
float pxlf=0;

//Überprüfen ob y Koordinate der Maus im Bereich der Schrift liegt
float pylf=0;

//Angaben für das Rechteck, bei dem überprüft werden soll, ob die Maus drin liegt mit x Koordinate, y Koordinate, width und height
float sxlf=100, sylf=250, swlf=400, shlf=100;

//Variablen für die Überleitung vom Leave Bildschirm zum Startbildschirm mit Hilfe von "Zürück zum Start" (z)
//Überprüfen ob x Koordinate der Maus im Bereich der Schrift liegt
float pxlz=0;

//Überprüfen ob y Koordinate der Maus im Bereich der Schrift fortsetzen liegt
float pylz=0;

//Angaben für das Rechteck, bei dem überprüft werden soll, ob die Maus drin liegt mit x Koordinate, y Koordinate, width und height
float sxlz=100, sylz=450, swlz=400, shlz=100;

//Variable HIntergrundbild für Startbildschirm
PImage hs;

//Variable Hintergrundbild für weitere Bildschirme 
PImage hb;



//Danach wird im Code das Hauptprogramm aufgerufen und das void setup einmal ausgeführt.

void setup()
{
  //die Größe des Zeichenfensters wird auf 700 mal 700 Pixel festgelegt
  size(700,700);
 
  //Variable des Startbildschirms wird mit dem Laden der zugehörigen Bilddatei belegt 
  hs = loadImage("Startbildschirm Bat Ball.jpg");
 
  //Variable des Leavebildschirms wird mit dem Laden der zugehörigen Bilddatei belegt
  hb = loadImage ("Hintergrund Bat Ball.jpg");
  
}

// Danach wird zum Spiel weitergeleitet.
void draw()
{
  //die verschieden Bildschirmoptionen werden an das case gekoppelt, um später die Bildschirme wechseln zu können
  switch (spielmodus)
  {
    //zeichnet Startbildschirm
    case 0:
    drawStartbildschirm();
    
    //wenn eine Taste gedrückt wird, wird die Variable Spielmodus um einen erhöhrt, sodass case 1 zutrifft und vom Startbildschirm zur Anleitung gewechselt wird
    if(keyPressed && spielmodus == 0)
    {      
      spielmodus++;
    }
    break;
    
    //zeichnet Bildschirm für Anleitung
    case 1:
    drawAnleitung();
    
    //wenn die Maus gedrückt wird, wird die Variable Spielmodus um einen erhöhrt, sodass case 2 zutrifft und von der Anleitung in den Spielmodus gewechselt wird
    if(mousePressed)
    {
      spielmodus++;
    }
    break;
    
    case 2:
    // Jetzt startet das Spiel und es wird bei jedem Durchlaufen der Hintergrund blau eingefärbt.
    background (hb);
 
    // Der Ball wird gezeichnet.
    zeichneBall();
 
    // Der Balken wird gezeichnet.
    zeichneBalken();
    
    // Das Programm zeichnet die Wolken.
    zeichneWolke();
    
    // Der Ball ist nun beweglich.
    ballBewegung();
   
    ballPralltAb();
    
    // Nun kann der Ball am Balken abprallen.
    BallErkenntBalken();
    
    // Die Prozedur leaveButton wird vom Programm abgerufen und ausgeführt.
    leaveButton();
    
    // Der Score kann gezählt werden.
    zaehleScore();
    
    // Der Ball erkennt die Wolken als Hindernisse.
    erkenneWolke();
    
    // Ab jetzt sind die Wolken beweglich.
    bewegeWolke1();
    bewegeWolke2();
    

    break;
    
    //der case erstellt den Leave Bildschirm
    case 3:
    drawLeave();
    
    // Es wird die Prozedur des Leave-Buttons mit der Funktion des Fortfahrens im Spiel ausgeführt.
    leaveFortfahren();
 
    // Es wird die Prozedur des Leave-Buttons mit der Funktion zurück zum Spiel ausgeführt.
    leaveZurueck();
    
    break;
    
    //der case erstellt den Game Over Bildschirm
    case 4:
    drawGameOver();
    
    // Es wird die Erneut versuchen Prozedur ausgeführt.
    GOErneut();
    
    // Es wird die Prozedur des Zurück zum Start-Buttons auf dem GameOver-Bildschirm ausgeführt.
    GOzurueckZumStart();
    
    // Der case wird beendet.
    break;
    
    //Fehler im switch werden abgefangen wenn keiner der cases zutrifft
    default:
    
    //gibt dazu error aus
    println("error");
    
    //Ende switch
    break;
    }
}
    
    
//Funktion zum Aussehen des Startbildschirms
void drawStartbildschirm()
{
  //der Hintergrund wird mit der entsprechenden Bilddatei eingefärbt
  background(hs);
 
  //die Koordinaten für das Textfeld werden für die Mitte des Feldes angeben
  textAlign(CENTER);
 
  //Schriftgröße auf 65 für den folgenden Text
  textSize(70);
 
  //der Text wird Lila
  fill(137,43,152);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("BAT BALL", width/2, 125);
 
  //Schriftgröße auf 20 für den folgenden Text
  textSize(20);
 
  //der Text wird Grau
  fill(168,168,180);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text("Zum Starten Taste drücken",width/2,625);
}

//Funktion zum Aussehen des Bildschirm, der das Spiel erklärt
void drawAnleitung()
{
  //der Hintergrund wird mit der entsprechenden Bilddatei eingefärbt
  background(hb);
 
  //die Koordinaten für das Textfeld werden für die Mitte des Feldes angeben
  textAlign(CENTER);
 
  //Schriftgröße auf 25 für den folgenden Text
  textSize(25);
 
  //der Text wird Grau
  fill (168,168,180);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("Spielprinzip:", width/2, 100);
 
   //Schriftgröße auf 15 für den folgenden Text
  textSize(15);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("der Ball soll mit Hilfe des Balkens so lange wie möglich in der Luft gehalten werden, ",width/2,200);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("er darf den unteren Bildrand nicht verlassen.", width/2, 300);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("Passiert dies, kommt es zu einem Game Over. ", width/2, 400);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("Die Steueruung des Balkens erfolgt über die Pfeiltasten nach links und rechts.", width/2, 500);
 
  //Schriftgröße auf 20 für den folgenden Text
  textSize(20);
 
    //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("Zum Fortfahren auf das Zeichenfenster klicken", width/2, 600);
}
   
//Funktion zum Aussehen des Leave Bildschirms
void drawLeave()
{
  //der Hintergrund wird mit der entsprechenden Bilddatei eingefärbt
  background(hb);
 
  //die Koordinaten für das Textfeld werden für die Mitte des Feldes angeben
  textAlign(CENTER);
 
  //Schriftgröße auf 45 für den folgenden Text
  textSize(45);
 
  //der Text wird Grau
  fill(168,168,180);
 
   //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("Fortfahren", width/2, 300);
 
  //Schriftgröße auf 25 für den folgenden Text
  textSize(25);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text("Zurück zum Start",width/2,500);
}

//Funktion zum Aussehen des Game Over Bildschirms
void drawGameOver()
{
  //der Hintergrund wird mit der entsprechenden Bilddatei eingefärbt
  background(hb);
 
  //die Koordinaten für das Textfeld werden für die Mitte des Feldes angeben
  textAlign(CENTER);
 
  //Schriftgröße auf 85 für den folgenden Text
  textSize(85);
 
  //der Text wird Lila
  fill(137,43,152);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("GAME OVER", width/2, 215);
 
  //Schriftgröße auf 25 für den folgenden Text
  textSize(25);
 
  //der Text wird Grau
  fill(168,168,180);
 
   //der Text soll in dem Zeichenbereich ausgegeben werden
  text ("Score", width/2, 350);
    
  // Der aktuelle Punktestand wird neben dem Schriftzug "Score" angezeigt.
  text (score, 420, 350);
 
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text("Erneut versuchen",width/2,450);
   
  //der Text soll in dem Zeichenbereich ausgegeben werden
  text("Zurück zum Start",width/2,550);
}
 
// Es wird nun die Prozedur keyPressed() angelegt, damit der Balken gesteuert werden kann.
void keyPressed()    
{  
   // Hierzu wird zunächst die if-Funktion angelegt, die beim Druck einer Taste auf den Inhalt der Funktion zugreift.
   if (key==CODED)
   {
     
     // Nun wird zunächst geprüft, ob die linke Preiltaste gedrückt wurde und der Balken noch nicht am linken Rand angelangt ist
     if (keyCode == LEFT && xposrect>=width-width)
     {   
        // Und die Koordinaten der Balkenlage so verändert, dass sich der Balken nach links bewegt.
        xposrect-= rectv;
     }
     
     // Wurde allerdings die rechte Pfeiltaste gedrückt und der Balken hat noch nicht den rechten Rand erreicht.
     if (keyCode == RIGHT && xposrect<=width-(widthrectx+1))
     {
       
        // Werden die Koordinaten so geändert, dass sich der Balken nach rechts bewegt.
        xposrect += rectv;
     }
   }
}

// Zur Erstellung des Balles wird die Prozedur zeichneBall erstellt.
void zeichneBall()
{
 
    // Es werden alle geometrischen Figuren ohne Kontur gezeichnet.
    noStroke();
    
    //Und komplett rot ausgefüllt sind.
    fill(137,43,152);
 
    // Das ermöglicht nun die Erstellung des schwarzen Pingpongballs nach Lage der oben festgelegten Variablen.
    ellipse(xpos,ypos,ballsize,ballsize);
}

// Prozedur zur Erstellung des Balkens.
void zeichneBalken()
{  
    // Es werden alle geometrischen Figuren ohne Kontur gezeichnet.
    noStroke();
    
    // Ab jetzt wird alles braun eingefärbt.
    fill(62,36,3);
    
    // Sowie die Erstellung des Balkens, nach oben vorgegebenen Größenmaßstäben und Koordinatenlage.
    rect(xposrect,yposrect,widthrectx,heightrecty);
}

// Prozedur zur Bewegung des Balles.
void ballBewegung()
{
    // Ballposition wird durch Multiplikation der x-Achsenposition mit der Geschwindigkeit geändert und anschließend mit der x-Position addiert.
    xpos += xv*v;
 
    // Ballposition wird in y-Lage verändert, indem die Geschwindigkeit mit der y-Achsenlage multipliziert wird und anschließend auf die Position des Balles addiert wird.
    ypos += yv*v;
   
}

// Prozedur zur Funktion des Abprallens.
void ballPralltAb()
{
 
    // Es wird geprüft, ob der Ball am linken Bildschirmrand ist
    if (xpos < 0+ballsize/2)
    {
      
      // Wenn Bedingung erfüllt, prallt er im 45°Winkel nach rechts ab.
      xv *= -1;
    }
 
    // Prüfung ob Ball am rechten Rand ist.
    if (xpos > width-ballsize/2)
    {
      
      // Wenn Bedingung erfüllt, prallt er im 45°Winkel nach links ab.
      xv *= -1;
      
    }
    
    // Es wird geprüft ob der Ball oben angekommen ist.
    if ( ypos < 0+ballsize/2)
    {
      // Wenn Bedingung erfüllt, prallt er im 45°Winkel nach unten ab.
      yv *= -1;

    }
     
    // Nun wird geprüft ob er am unteren Rand angekommen ist.
    if (ypos==height + ballsize/2  || ypos==height + ballsize/2 && score%5==0)
    {
      
      // Wenn Bedingung erfüllt, wird zum Game Over Bildschirm weitergeleitet
      spielmodus= spielmodus+2;

      // Und anschließend alle notwendigen Daten auf Anfangszustand gesetzt.
      xpos=10;
      ypos=10;
      v=1;
      widthrectx=200;
      xposrect= 320;
     
    }
}

// Hier wird nun die Prozedur für die Abprallfunktion des Balkens erstellt.
void BallErkenntBalken()
{
 
  // Prüfung, ob Ball auf dem Balken auftrifft.
  if(xpos >= xposrect && xpos <= xposrect+(widthrectx+1) && ypos+10  >= yposrect && ypos+10  <= yposrect + heightrecty )
  {
    
    // Ist dies der Fall, prallt er im 45°Winkel nach oben ab.
    yv*=-1;
    
  }
  
  // Prüfung ob Ball am äußeren linken Rand des Balkens
  if(xpos+ballsize/2 == xposrect && ypos >= yposrect && ypos <= yposrect+heightrecty  )
  {
    
    // Wenn Bedingung erfüllt, wird die Richtung des Balles in die entgegengesetzte Richtung geändert. 
    xv*=-1;
  }
  
  // Prüfung ob Ball am äußeren linken Rand des Balkens
  if(xpos-ballsize == xposrect+widthrectx && ypos >= yposrect && ypos <= yposrect+heightrecty)
  {
    // Wenn Bedingung erfüllt, wird die Richtung des Balles in die entgegengesetzte Richtung geändert. 
    xv*=-1;
  }
 
}


// Prozedur zur Zählung des Punktestandes.
void zaehleScore()
{
 
  // Prüfung ob Ball am Balken auftrifft.
  if(xpos >= xposrect && xpos <= xposrect+widthrectx && ypos+10  >= yposrect  && ypos+10  <= yposrect + heightrecty)
  {
    
    // Trifft er auf den Balken wird der Score um 1 Punkt erhöht.
    score++;
    
    // Test zur Funktionalität der Prozedur.
    println(score);
  }  
 
  // Nun wird geprüft, ob der Score den erforderlichen Wert hat, damit der Specialeffect ausgeführt werden kann.
  if (score%5==0 && score>0)
  {
    
    // Und dann die boolsche Variable auf true gesetzt.
    scorerot=true;
    
    // Ist der nötige Punktestand erreicht und liegt der Ball auf dem Balken auf...
    if(scorerot==true && xpos >= xposrect && xpos <= xposrect+widthrectx && ypos+10  >= yposrect  && ypos+10  <= yposrect + heightrecty)
    {
    
      // Dann werden die Special Effects ausgeführt.
      specialEffekt();
    
    }
  }
    
  // Nachdem die Funktionen ausgeführt und überprüft wurden, wird eine Schriftgröße 15 festgelegt.
  textSize(20);
    
  // Und definiert, dass der zu erstellende Text oben rechts in der Ecke erscheinen soll.
  textAlign(RIGHT,TOP);
    
  // Nun wird an den Koordinaten x 600 und y 50 der Text Score: ausgegeben.
  text("Score:", 600, 50);
 
  // Und der Score vor seiner Ausgabe auf seine Höhe geprüft, um ihn gegebenenfalls rot einzufärben und zu vergrößern.
  scoreBunt();
 
  // Und dahinter an die Koordinaten x 650 und y 50 der aktuelle Wert vom score ausgegeben.
  text(score, 650, 50);
 
}

// Es wird die Prozedur zeichneWolke erstellt, damit das Programm die Hindernisse anlegen kann.
void zeichneWolke()
{
 
  // Hierzu werden die nachfolgenden Formen weiß gefüllt.
  fill (168,168,180);
 
  // Und nun zuerst die erste Wolke, bestehend aus 3 Rechtecken, mit den global festgelegten Variablenparametern gezeichnet.
  rect(cloud1xpos, cloud1ypos, widthcloud1, heightcloud1);
  rect(cloud1xpos2, cloud1ypos2, widthcloud1zwei, heightcloud1);
  rect(cloud1xpos3, cloud1ypos3, widthcloud1drei, heightcloud1);
 
  // Danach wird die zweite Wolke gezeichnet, bestehend aus 3 Rechtecken und ebenfalls den global festgelegten Parametern für die zweite Wolke.
  rect(cloud2xpos, cloud2ypos, widthcloud2, heightcloud2);
  rect(cloud2xpos2, cloud2ypos2, widthcloud2zwei, heightcloud2);
  rect(cloud2xpos3 , cloud2ypos3, widthcloud2drei, heightcloud2);
}

// Es wird die Prozedur bewegeWolke1 angelegt.
void bewegeWolke1()
{

  // Es werden die Wolkenteile gleichmäßig um 1Pixel bewegt.
  cloud1xpos += cloud1xv;
  cloud1xpos2+= cloud1xv;
  cloud1xpos3+= cloud1xv;
 
  // Danach wird geprüft, ob die Wolke den Bildschirmrand erreicht hat.
  if(cloud1xpos == 0 || cloud1xpos+ widthcloud1 == width )
  {
    
    // Ist diese Bedingung erfüllt wird die Richtung der Wolke in die entgegengesetzte Richtung verändert.
    cloud1xv *=-1 ;
    
  }
 
}

// Es wird die Prozedur bewegeWolke1 angelegt.
void bewegeWolke2()
{
 
  // Es werden die Wolkenteile gleichmäßig um 1Pixel bewegt.
  cloud2xpos  += cloud2xv;
  cloud2xpos2 += cloud2xv;
  cloud2xpos3 += cloud2xv;
 
  // Prüfung ob Wolke am Bildschirmrand angelangt ist.
  if(cloud2xpos == 0 || cloud2xpos+ widthcloud2 == width )
  {
    
    // Wenn ja wird die Richtung gewechselt.
    cloud2xv *=-1 ;
  }
 
}

// Es wird die Prozedur zur Erkennung der Wolken als Hindernisse definiert.
void erkenneWolke()
{
 
  // Es wird geprüft ob der Ball gegen die erste Wolke fliegt.
  if (xpos >= cloud1xpos && xpos <= cloud1xpos+ widthcloud1 & ypos >= cloud1ypos+ballsize/2 && ypos <= cloud1ypos+ballsize/2 + heightcloud1 && yv<0)
  {
    
    // Ist die Bedingung erfüllt, prallt der Ball im 45° Winkel nach unten ab.
    yv*=-1;
  }
 
  // Sollte er auf der zweiten Wolke angelangen, prallt er auch hier im 45°Winkel ab
  if (xpos >= cloud2xpos && xpos <= cloud2xpos+ widthcloud2 && ypos >= cloud2ypos+ballsize/2 && ypos <= cloud2ypos+ballsize/2 + heightcloud2 && yv<0)
  {
    yv*=-1;
  }
}

// Nun wird der Specialeffect eingebaut, in dem der Ball ab einer Scoreerhöhung in 10er Schritten schneller wird.
// Hierzu wird zunächst eine boolsche Prozedur erstellt, die einen Rückgabewert übermittelt und zur verknüpfung mit dem Effekt genutzt.
boolean ballEffektBoolean(int point)
{
 
  // Dafür wird geprüft, ob der Score einen durch einen bestimmten Wert ohne Rest erreicht hat.
  if(point%5==0 && score >0)
  {
    // Und als wahr zurückgegeben.
    return true;
  }
  else
  {
    // Ist der Wert noch nicht erreicht, wird falsch zurückgegeben.
    return false;
  }
}

// Damit der Score bunt eingefärbt werden kann, wird zunächst die Prozedur scoreBunt erstellt.
void scoreBunt()
{
 
  //Und mit der if-Funktion verbunden, die Prüft, ob der Wert des scores den Anforderungen der boolschen Prozedur des Balleffektes entspricht und als wahr angegeben werden kann.
  if(ballEffektBoolean(score) && score >0)
  {
    
    // Dann wird der Score rot eingefärbt.
    fill(#FC0303);
    
    // Und dazu die Schriftgröße erhöht.
    textSize(30);
  }
}

// Damit der Ball einen Specialeffect erhält, wird nun die Prozedur ballEffekt erstellt.
void specialEffekt()
{

  // Diese Prüft nun aus welcher Richtung der Ball kommt, ob der Score schon höher als 0 ist und ebenso ob der erforderliche Punktestand erreicht wurde.
  if(score%5==0 && score>0 )
  {
    
     // Ist die Bedingung erfüllt wird der Ball schneller und der Balken kleiner.
     v++;
     widthrectx=widthrectx-15;

     // Ausgabe zum Testen der Funktion.
     println("Ball prallt ab");
  }
}

// Es wird die boolsche Prozedur erstellt und mit den globalen Variablen verknüpft, die in der Klammer genannt werden.
boolean pointRectl(float pxl, float pyl, float rxl, float ryl, float rwl, float rhl)
{
  // Danach wird gefragt, ob die Maus im erforderlichen Bereich des Rechtecks ist.
  if (pxl>=rxl&&pxl<=rxl+rwl&&pyl>=ryl&&pyl<=ryl+rhl)
  {
    
    // Und die Prozedur als wahr zurückgegeben.
    return true;
  }
 
  // Ansonsten gibt das Programm falsch wieder.
  return false;
}

// Es wird die boolsche Prozedur erstellt und mit den globalen Variablen verknüpft, die in der Klammer genannt werden
boolean pointRectge(float pxge, float pyge, float rxge, float ryge, float rwge, float rhge)
{
  // Danach wird gefragt, ob die Maus im erforderlichen Bereich des Rechtecks ist.
  if (pxge>=rxge&&pxge<=rxge+rwge&&pyge>=ryge&&pyge<=ryge+rhge)
  {
    // Und die Prozedur als wahr zurückgegeben.
    return true;
  }
 
  // Ansonsten gibt das Programm falsch wieder.
  return false;
}

// Es wird die boolsche Prozedur erstellt und mit den globalen Variablen verknüpft, die in der Klammer genannt werden
boolean pointRectgz(float pxgz, float pygz, float rxgz, float rygz, float rwgz, float rhgz)
{
  // Danach wird gefragt, ob die Maus im erforderlichen Bereich des Rechtecks ist.
  if (pxgz>=rxgz&&pxgz<=rxgz+rwgz&&pygz>=rygz&&pygz<=rygz+rhgz)
  {
    // Und die Prozedur als wahr zurückgegeben.
    return true;
  }
 
  // Ansonsten gibt das Programm falsch wieder.
  return false;
}

// Es wird die boolsche Prozedur erstellt und mit den globalen Variablen verknüpft, die in der Klammer genannt werden
boolean pointRectlf(float pxlf, float pylf, float rxlf, float rylf, float rwlf, float rhlf)
{
  // Danach wird gefragt, ob die Maus im erforderlichen Bereich des Rechtecks ist, hier für die Schrift fortsetzen
  if (pxlf>=rxlf&&pxlf<=rxlf+rwlf&&pylf>=rylf&&pylf<=rylf+rhlf)
  {
    // Und die Prozedur als wahr zurückgegeben.
    return true;
  }
  // Ansonsten gibt das Programm falsch wieder.
  return false;
}

// Es wird die boolsche Prozedur erstellt und mit den globalen Variablen verknüpft, die in der Klammer genannt werden
boolean pointRectlz(float pxlz, float pylz, float rxlz, float rylz, float rwlz, float rhlz)
{
  // Danach wird gefragt, ob die Maus im erforderlichen Bereich des Rechtecks ist, hier für die Schrift zurück zum Start
  if (pxlz>=rxlz&&pxlz<=rxlz+rwlz&&pylz>=rylz&&pylz<=rylz+rhlz)
  {
    // Und die Prozedur als wahr zurückgegeben.
    return true;
  }
  // Ansonsten gibt das Programm falsch wieder.
  return false;
}

// Es wird eine Prozedur zur Erstellung des Leave-Buttons erstellt.
void leaveButton()
{
    //Schriftgröße auf 15 für den folgenden Text
    textSize(20);
 
    // Das Programm überprüft in welchem Bereich der Mauszeiger ist und weist nun den Variablen pxl und pyl die jeweiligen Koordinaten der Mauslage zu.
    pxl=mouseX;
    pyl=mouseY;
    
    // Danach wird eine boolsche Variable hit erstellt und ihr die boolsche Prozedur pointRectl zugewiesen, mit den Werten aus den oben definierten Variablen.
    boolean hit = pointRectl(pxl,pyl,sxl,syl,swl,shl);
    
    // Danach wird in einer if-Funktion geprüft, ob die Maus gedrückt wird und sie im Bereich des definierten Rechteckes liegt.
    if (hit && mousePressed)
    {
      
       // Tritt dieser Fall ein, wird auf Case 2 gewechselt.
       spielmodus++;
    }
    
    // Tritt die Bedingung nicht ein..
    else
    {
      
      // Wird nachfolgend alles in den angegebenen Farbwerten ausgefüllt.
      fill(168,168,180);
    }
    
    // Nun werden alle Formen ohne Umrisse gezeichnet.
    noStroke();
    
    // Und nicht eingefärbt.
    noFill();
    
    // Danach ein farb- und umrissloses Rechteck gezeichnet, mit den Werten der oben definierten Variablenwerten.
    rect(sxl,syl,swl,shl);
    
    // Ab jetzt wird alles blau eingefärbt.
    fill (168,168,180);
    
    // Es wird ein Text "Leave" erstellt, in blauer Farbe und der definierten Koordinatenlage.
    text ("Leave", 100, 50);
}

// Es wird eine Prozedur für eine Buttonfunktion "Fortfahren" des Leave-Buttons erstellt.
void leaveFortfahren()
{
  // die Variablen werden neu zugewiesen an die Mausposition
    pxlf=mouseX;
    pylf=mouseY;
    
    // Danach wird eine boolsche Variable hit2 erstellt und ihr die boolsche Prozedur pointRectlf zugewiesen, mit den Werten aus den oben definierten Variablen.
    boolean hit2 = pointRectlf(pxlf,pylf,sxlf,sylf,swlf,shlf);
    
    // Danach wird in einer if-Funktion geprüft, ob die Maus gedrückt wird und sie im Bereich des definierten Rechteckes liegt.
    if (hit2 && mousePressed)
    {
        //falls zutreffend wird die Variable Spielmodus um einen reduziert und somit zu case 2 gewechselt (Spielmodus)
        spielmodus--;
    }
    
    //sonst...
    else
    {
      //wird die Form weiss gefüllt
      fill(255);
    }
    
    //der Umriss wird entfernt
    noStroke();
    
    //die Füllung wird entfernt
    noFill();
    
    //das rechteck mithilfe der oben zugewiesenen Variablen gebildet
    rect(sxlf,sylf,swlf,shlf);
   
    //die Koordinaten für das Textfeld werden für die Mitte des Feldes angeben
    textAlign(CENTER);
 
    //Schriftgröße auf 45 für den folgenden Text
    textSize(45);
 
}

// Es wird die Prozedur leaveZurueck für die Zurück zum Start Funktion erstellt.
void leaveZurueck()
{
   // die Variablen werden neu zugewiesen an die Mausposition    
    pxlz=mouseX;
    pylz=mouseY;
    
    // Danach wird eine boolsche Variable hit3 erstellt und ihr die boolsche Prozedur pointRectlz zugewiesen, mit den Werten aus den oben definierten Variablen.
    boolean hit3 = pointRectlz(pxlz,pylz,sxlz,sylz,swlz,shlz);
    
    // Danach wird in einer if-Funktion geprüft, ob die Maus gedrückt wird und sie im Bereich des definierten Rechteckes liegt.
    if (hit3 && mousePressed)
    {
        //falls zutreffend wird die Variable Spielmodus um drei reduziert und somit zu case 0 gewechselt (Startbildschirm)
        spielmodus=spielmodus-3;
    }
    
    //sonst...
    else
    {
      //wird die Form weiss gefüllt
      fill(255);
    }
    
    //der Umriss wird entfernt
    noStroke();
    
    //die Füllung wird entfernt
    noFill();
    
    //das rechteck mithilfe der oben zugewiesenen Variablen gebildet
    rect(sxlz,sylz,swlz,shlz);
 
    //die Koordinaten für das Textfeld werden für die Mitte des Feldes angeben
    textAlign(CENTER);
    
    //Schriftgröße auf 25 für den folgenden Text
    textSize(25);

}

// Erstellung der Prozedur für den GameOver-Bildschirms für die Funktion des Erneut versuchens.
void GOErneut()
{
      // Es wird erneut die Lage der Maus abgerufen und die Werte den oben definierten Variablen zugewiesen.
    pxge=mouseX;
    pyge=mouseY;
    
    //Danach wird die lokale boolsche Variable hit4 erstellt und ihr der Rückgabewert der boolschen Prozedur pointRectge zugewiesen.
    boolean hit4 = pointRectge(pxge,pyge,sxge,syge,swge,shge);
    
    // Sind nun die Bedingungen der hit2 Variable, wie auch die gedrückte Maus eingetreten.
    if (hit4 && mousePressed)
    {
      
      // Wird von case 4 auf case 2 zum Spiel weitergeleitet.
      spielmodus=spielmodus-2;
      
      // Und der Score für ein erneutes Spiel auf 0 zurückgesetzt.
      score=0;
      
    }
    
    // Ansonsten wird alles weiß eingefärbt
    else
    {
      fill(255);
    }
    
    // Nun werden alle Formen ohne Umrisse gezeichnet.
    noStroke();
    
    //Und ohne Farbfüllung
    noFill();
    
    // Es wird ein Rechteck ohne Farbe und Umrisse in den Werten der oben definierten Lage gezeichnet.
    rect(sxge,syge,swge,shge);
   
}


// Prozedur zur Erstellung des Zurück zum Start Buttons auf dem GameOver-Bildschirm
void GOzurueckZumStart()
{
  // Es wird wieder die aktuelle Lage der Maus abgerufen und den Punkten px- und pyge zugewiesen.
    pxgz=mouseX;
    pygz=mouseY;
    
    // Danach wird der lokalen Variable hit5 der Rückgabewert der boolschen Prozedur pointRectge zugewiesen.
    boolean hit5 = pointRectgz(pxgz,pygz,sxgz,sygz,swgz,shgz);
    
    // Es wird geprüft, ob hit3 true ist und die Maus gedrückt wird.
    if (hit5 && mousePressed)
    {
      
      // Ist der Fall eingetreten, wird zum case 0 weitergeleitet.
      spielmodus=spielmodus-4;
      
      // Und der Score für ein erneutes Spiel auf 0 zurückgesetzt.
      score=0;
      
    }
    
    // Ansonsten wird alles weiß ausgefüllt.
    else
    {
      fill(255);
    }
    
    // Es werden nur noch Formen ohne Umrisse gezeichnet.
    noStroke();
    
    // Und ohne Farbe.
    noFill();
    
    // Es wird ein farb- und umrissloses Rechteck mit den global definierten Variablenwerten erstellt.
    rect(sxgz,sygz,swgz,shgz);
}
