//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
    ld  a,#17
    call    PAGER

    ;---clr
    ld  hl,#5800
    ld  de,#5801
    ld  bc,767
    ld  (hl),l
    ldir

    ;---grid
    xor a
    ld  hl,#4000
    ld  de,#4001
    ld  lx,6
ini1
    ld  bc,256*4
    ld  (hl),a
    ldir
    xor #ff
    dec lx
    jp  nz,ini1
    ld  hl,#4000
    ld  de,#c000
    ld  bc,6912
    ldir


    ;--- set im2 routine
    ld  hl,fxim2
    ld  (IM2CALL),hl
    
    ;--- make palette
    ld  hl,PAL1
    ld  bc,palette0
    ld  a,#00
    call mkpl0
    ld  hl,PAL2
    ld  bc,palette1
    ld  a,#40
mkpl0
    ld  d,h
    ld  e,l
    ld  (mkplor),a
    ld  hx,16
mkpl2
    push    hl
    ld  lx,16
    ld  a,(de)
    add a,a:add a,a:add a,a
    ld  ly,a
mkpl1
    ld  a,ly
    or (hl)
    or  0
mkplor equ $-1
    ld  (bc),a
    inc c
    inc hl
    dec lx
    jp  nz,mkpl1
    pop hl
    inc de
    dec hx
    jp  nz,mkpl2 
    
    
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT

    ;ld  a,1:out (#fe),a
    call    calc_buff
    ;ld  a,2:out (#fe),a
    call    tits
    ;ld  a,0:out (#fe),a
    call    movatr
    ;ld  a,0:out (#fe),a

    ;--- move points
    ld  ix,points
    ld  b,3
pointlp
    push    bc
    ;---
    ld  a,(ix)
    add a,(ix+1)
    ld  (ix),a
    ld  h,cosx / 256
    ld  l,a
    ;---
    ld  a,(ix+2)
    add a,(ix+3)
    ld  (ix+2),a
    ld  d,cosy / 256
    ld  e,a
    ;---
    ld  c,(ix+4)
    ld  b,(ix+5)
    ;---
    ld  a,(de)
    sub 5
    ld  (ix+6),a
    add a,(hl)
    ld  (bc),a
    inc bc
    ;-
    ld  a,(hl)
    ld  (ix+7),a
    add a,#c0
    ld  (bc),a
    ;-
    ld  bc,8
    add ix,bc
    ;---
    pop bc
    djnz    pointlp

    ret
    
;ballList[1] = {ax: 0, ay:0, axStep: 4, ayStep: 3};
;ballList[2] = {ax: 64, ay:64, axStep: 3, ayStep: 5};
;ballList[3] = {ax: 128, ay:128, axStep: 4, ayStep: 3};

points
    db  0,  4
    db  0,  3
    dw  point1
    db  0,0 ;y,x

    db  64,  3
    db  64,  5
    dw  point2
    db  0,0 ;y,x

    db  128,  4
    db  128,  3
    dw  point3
    db  0,0 ;y,x
    
    
//======================================================== FX_PROCEDURES
fxim2
    ld  a,(PAGE)
    xor #08
    call PAGER
    jp  IM2CALL_RET
    



movatr
    ld  a,(PAGE)
    or  7
    call    PAGER

    and #08
    ld  hl,#5800
    ld  de,#d800
    ld  bc,palette0 + (palette1 / 256)
    jr  nz,swp1
    ex  de,hl
    ld  bc,palette1 + (palette0 / 256)
swp1
    ld  (atradr1),hl
    ld  (atradr2),de
    ld  a,b
    ld (atrpal1),a
    ld  a,c
    ld (atrpal2),a
    

    ld  h,palette0 / 256
atrpal1 equ $-1
    ld  de,#5800
atradr1 equ $-2
    call    movatr0
    ld  h,palette1 / 256
atrpal2 equ $-1
    ld  de,#d800
atradr2 equ $-2

movatr0
    ld  (sohrsp),sp
    ld  sp,buff    ;buff
    ld  a,24
movatr1
    dup 16

    pop bc      ;10
    ld  l,c     ;4
    ldi         ;16
    ld  l,b     ;4
    ldi         ;16 /50

    edup

    dec a
    jp  nz,movatr1
    ;---
    ld  sp,0
sohrsp equ $-2
    ret

;----------------------
calc_buff
    ld  a,(PAGE)
    and %11111000
    call    PAGER

    ld  bc,#c000    ;point1
point1_dx equ $-1
point1_dy equ $-2
point1 equ $-2
    ld  hl,#d030    ;point2
point2_dx equ $-1
point2_dy equ $-2
point2 equ $-2
    ld  de,buff
    push    bc
    push    hl
    exx
    ld  hl,#e010    ;point3
point3_dx equ $-1
point3_dy equ $-2
point3 equ $-2
    ld  d,clrtop / 256       ;sum_top
    ld  b,clrbott / 256      ;sum_bott
    push    hl
    exx
    ld  lx,24
lpp1
    ;-----------------
    dup 31
    ;---
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    inc c           ;4
    inc l           ;4
    exx             ;4
    add a,(hl)      ;7
    inc l           ;4
    ld  e,a     ;4
    exx         ;4
    ;---
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    inc b           ;4
    inc h           ;4
    exx             ;4
    add a,(hl)      ;7
    inc h           ;4
    ld  c,a     ;4
    ex  de,hl   ;4
    ld  a,(bc)  ;7
    or  (hl)    ;7
    ex  de,hl   ;4
    exx         ;4
    ;---
    ld  (de),a  ;7
    inc e       ;4
    ;---
    edup
    ;-------------
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    inc c           ;4
    inc l           ;4
    exx             ;4
    add a,(hl)      ;7
    inc l           ;4
    ld  e,a     ;4
    exx         ;4
    ;---
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    exx             ;4
    add a,(hl)      ;7
    ld  c,a     ;4
    ex  de,hl   ;4
    ld  a,(bc)  ;7
    or  (hl)    ;7
    ex  de,hl   ;4
    pop hl: inc l:inc l
    exx         ;4
    ;---
    pop hl: inc l:inc l
    pop bc: inc c:inc c
    push bc
    push hl
    exx
    push hl
    exx
    ;---
    ld  (de),a  ;7
    inc de       ;6
    ;-------------
    dec lx
    jp  nz,lpp1
    ;---
    pop bc:pop bc:pop bc
    ret


tits
    ld  hl,(points+6+8)
    ld  a,48-9
    sub l
    ld  l,a
    ld  a,32
    sub h
    ld  h,a        
    call tits1

    ld  hl,(points+6)
    call tits1

    ld  hl,(points+6+16)
tits1
    ld  de,titoutt
    bit 0,l
    jr  nz,tits2
    ld  de,titoutb
tits2
    ld  a,h
    cp  3
    jr  nc,tits3
    inc de:inc de
    cp  2
    jr  nc,tits3
    inc de:inc de
    cp  1
    jr  nc,tits3
    inc de:inc de
tits3

    cp  #1f
    jr  c,tits4
    dec de:dec de
    cp  #20
    jr  c,tits4
    dec de:dec de
    cp  #21
    jr  c,tits4
    dec de:dec de

tits4
    ;---
    ld  c,h
    ld  a,l
    and %11111110
    add a,8
    
    ld  l,a
    ld  h,0
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    ld  b,buff/256
    add hl,bc
    ex de,hl
    ld  a,(hl)
    inc hl
    ld  h,(hl)
    ld  l,a
    jp  (hl)
    ret




;----------------
    dw  0
    dw  0
    dw  0
    dw  titouttr2
    dw  titouttr1
titoutt
    dw  titoutt_all
    dw  titoutt2
    dw  titoutt1
    dw  titoutt0
    dw  0
    dw  0
    dw  0
;----------------
    dw  0
    dw  0
    dw  0
    dw  titoutbr2
    dw  titoutbr1
titoutb
    dw  titoutb_all
    dw  titoutb2
    dw  titoutb1
    dw  titoutb0
    dw  0
    dw  0
    dw  0
;----------------
titout_none
    ret
    
    
titoutt_all
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    dec l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#23
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret
    
titoutt2
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),#23
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret
    
titoutt1
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    ld  (hl),#23
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret

titoutt0
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret

    
titouttr1
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    dec l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#23
    inc l
    ld  (hl),d

    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret

titouttr2
    ex de,hl
    ld  de,#3313
    
    dec hl
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    dec l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#23
    add hl,bc

    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a

    ret


;----------------
titoutb_all
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d

    add hl,bc
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#32
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    
    add hl,bc
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret

titoutb2
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    add hl,bc
    
    ld  (hl),d
    inc l
    ld  (hl),#32
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    
    add hl,bc
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret

titoutb1
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    add hl,bc
    
    ld  (hl),#32
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    dec hl
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret
    
titoutb0
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc
    
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    dec hl
    ld  (hl),d
    
    ret



titoutbr1
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    dec hl
    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d

    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d

    add hl,bc
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#32
    inc l
    ld  (hl),d
    
    add hl,bc
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret

titoutbr2
    ex de,hl
    ld  de,#3331
    dec hl
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    dec hl
    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d

    add hl,bc
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#32
    
    add hl,bc
    ld  (hl),d
    dec l
    ld  (hl),d

    
    ret




//======================================================== FX_INCLUDE_DATA
;PAL1	DB	0,7,2,2,0,1,1,5,3,3,0,0,0,0,0,0
;PAL2	DB	0,2,0,2,0,0,3,3,3,0,0,0,0,0,0,0

PAL1	DB	0,7,2,2,4,5,4,5,6,7,2,0,0,0,0,0
PAL2	DB	0,2,0,2,1,5,5,6,7,7,0,0,0,0,0,0

;PAL1	DB	0,7,2,2,1,1,4,1,6,7,2,0,0,0,0,0
;PAL2	DB	0,2,0,2,0,1,1,5,5,7,0,0,0,0,0,0






//======================================================== FX_TABLES
    align   256
cosx include "bin/cosx.asm"
cosy include "bin/cosy.asm"
    
clrtop include "bin/clr-bott.asm"
clrbott include "bin/clr-top.asm"
palette0 ds  256,0
palette1 ds  256,0
    
buff
