<?
$img = imagecreatefrompng(__DIR__ . '/font.png');
$text = file_get_contents(__DIR__ . '/text.txt');

$fontCodes = array();
$n = 0;
$fontCodes[32] = $n++;
for ($i = 65; $i <= 90; $i++) {
    $fontCodes[$i] = $n++;
}
for ($i = 48; $i <= 57; $i++) {
    $fontCodes[$i] = $n++;
}
$fontCodes[ord('!')] = $n++;
$fontCodes[ord(':')] = $n++;
$fontCodes[ord(',')] = $n++;
$fontCodes[ord('`')] = $n++;
$fontCodes[ord('?')] = $n++;
$fontCodes[ord('.')] = $n++;
$fontCodes[ord('*')] = $n++;
$fontCodes[ord('-')] = $n++;
$fontCodes[ord('/')] = $n++;
$fontCodes[ord('%')] = $n++;

$usedFontCodes = array(
    32 => 0,
);

$colorCodes = array(
    'B' => 0x41,
    'R' => 0x42,
    'M' => 0x43,
    'G' => 0x44,
    'C' => 0x45,
    'Y' => 0x46,
    'W' => 0x47,
);

$textBin = '';
$colorBin = '';
$text = explode("\r\n", $text);
foreach ($text as $line) {
    for ($i = 0; $i < 16; $i++) {
        $charCode = $i < strlen($line) ? ord(strtoupper($line[$i])) : 32;
        if (isset($fontCodes[$charCode])) {
            $id = isset($usedFontCodes[$charCode]) ? $usedFontCodes[$charCode] : sizeof($usedFontCodes);
            $usedFontCodes[$charCode] = $id;
            $code = 6 + $id * 2;
            $textBin .= chr($code);
        } else {
            echo chr($charCode) . "\r\n";
        }
    }
}
file_put_contents(__DIR__ . '/../text.bin', $textBin);


$fontBin = '';
foreach ($usedFontCodes as $charCode => $id) {
    for ($y = 0; $y < 8; $y++) {
        
        for ($x = 0; $x < 2; $x++) {
            $byte = 0;
            for ($bx = 0; $bx < 8; $bx++) {
                $clr = imagecolorat($img, $x*8+$bx, $y + $fontCodes[$charCode]*8);
                if ($clr != 0) {
                    $byte += pow(2,7-$bx);
                }
            }
            $fontBin .= chr($byte);
        }
        
    }
}
file_put_contents(__DIR__ . '/../font.bin', $fontBin);