//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
//======================================================== FX_INIT
EFF_INI_
	ei
	halt
	ld	a,#17
	call	PAGER

	;--- clr
	ld	a,0
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),0
	ldir

	;--- grid
	xor a
	ld	hl,#4000
	ld	de,#4001
	ld	c,6
grid1	;-
	ld	b,4
grid2
	ld	(hl),a
	inc	l
	jp	nz,grid2
	inc	h
	djnz	grid2
	cpl
	dec	c
	jp	nz,grid1
	ld	hl,#4000
	ld	de,#c000
	ld	bc,6912
	ldir
	
	call	sprfade

	ret
//======================================================== FX_MAINLOOP
EFF_RUN_
	ei
	halt
	
	if SHOW_FRAMES = 1
	  ld	a,(FRAMES_QTY)
	  ;out	(#fe),a
	  xor	a
	  ld	(FRAMES_QTY),a
	endif
	
	ld	a,0
faze	equ $-1
	or	a
	jp	z,text
	dec	a
	jp	z,scrini
	dec	a
	jp	z,scrout

fx_ret
	if SHOW_FRAMES = 1
	  xor	a
	  ;out	(#fe),a
	endif
	ret
//======================================================== FX_PROCEDURES
text
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),l
	ldir

	ld	hl,tbl
tbladr equ $-2
	ld	a,(hl)
	inc	hl
	or	a
	jp	z,lp2
	ld	b,a
lp1
	ld	c,(hl)
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	a,(hl)
	ld	lx,a
	inc	hl
	ld	a,(hl)
	ld	hx,a
	inc	hl
	call	sprout
	djnz	lp1
	
	call	sprfade

lp2	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl
	ex	de,hl

	ld	hl,(MUSPOS)
	and	a
	sbc	hl,bc
	jp	c,fx_ret

	ld	a,112
	ld	(sprout_fade),a
	ld	(tbladr),de
	ld	a,(de)
	or	a
	jp	nz,fx_ret
	ld	hl,faze
	inc	(hl)
	
	jp	fx_ret


sprfade_de
	dw	#0703
	dw	#0703
	dw	#0703
	dw	#0703
	dw	#0703
	dw	#0603
	dw	#0502
	dw	#0402
	dw	#0301
	dw	#0200
	dw	#0100
	dw	#0000

sprfade
	push	hl
	ld	a,112
sprout_fade equ $-1
	sub	1
	adc	a,0
	ld	(sprout_fade),a
	ld	de,#0000
	cp	2*12
	jp	nc,sprfade0
	rra
	and	%00001111
	add	a,a
	ld	e,a
	ld	d,0
	ld	hl,sprfade_de
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)

sprfade0
	ld	hl,sprfade_tbl+#40
	ld	(hl),0
	ld	hl,sprfade_tbl
	ld	(hl),0

	ld	a,#40+7
	call	sprfade1
	ld	a,#00+7
	call	sprfade1
	ld	a,#40+7*8
	call	sprfade1
	ld	a,#00+7*8
	call	sprfade1
	ld	a,#40+7*8+7
	call	sprfade1
	ld	a,#00+7*8+7
	call	sprfade1

	ld	a,#40+3
	call	sprfade1
	ld	a,#00+3
	call	sprfade1
	ld	a,#40+3*8
	call	sprfade1
	ld	a,#00+3*8
	call	sprfade1

	ld	a,#40+7*8+3
	call	sprfade1
	ld	a,#40+3*8+7
	call	sprfade1
	ld	a,#00+7*8+3
	call	sprfade1
	ld	a,#00+3*8+7
	call	sprfade1

	pop	hl
	ret
sprfade1
	ld	l,a
	and	#40
	ld	c,a
	;---
	ld	a,l
	and	7
	jr	z,2f
	cp	7
	jr	z,1f
	sub	e
	jr	2f
1	sub	d
2	ld	b,a
	;---
	ld	a,l
	rra
	rra
	rra
	and	7
	jr	z,2f
	cp	7
	jr	z,1f
	sub	e
	jr	2f
1	sub	d
2	add	a,a
	add	a,a
	add	a,a
	or	b
	or	c
	ld	(hl),a
	ret

sprout	push	bc
	push	hl

	push	ix
	pop	hl
	ex	de,hl

	ld	a,c
	ld	(spox),a

	ld	lx,3
spo2	;---
	ld	b,sprfade_tbl/256
	ld	hx,0
spox equ $-1
	push	hl
spo1	;---
	ld	a,(de)
	ld	c,a
	ld	a,(bc)
	ld	(hl),a
	inc	l
	inc	de
	dec	hx
	jp	nz,spo1
	pop	hl
	ld	bc,32
	add	hl,bc
	dec	lx
	jp	nz,spo2

	pop	hl
	pop	bc
	ret
	
scrini
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),l
	ldir
	
	ld	hl,scrdata
	ld	de,#4000
	ld	bc,6144
	ldir

	ld	hl,faze
	inc	(hl)
	
	jp	fx_ret

scroutend
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),l
	ldir
	jp	fx_ret



scrout
	ld	a,224
scrouta equ $-1
	sub	1
	adc	a,0
	ld	(scrouta),a
	jr	z,scroutend
	
	ld	hl,tblscr1
	cp	112+32
	jr	nc,scrout0
	cp	112-32
	jr	c,scrout1
	
	and	8
	jr	z,scrout0

scrout1
	ld	hl,tblscr2
scrout0
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl

	ld	a,0
swpa	equ	$-1
	xor	#ff
	ld	(swpa),a
	jr	z,swp1
	push	bc
	pop	de

swp1	push	hl
	ex	de,hl
	ld	de,#5800
	ld	bc,768
	ldir
	
	pop	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ex	de,hl
	ld	b,9
scrdiff
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	dup	8
	ld	a,(hl)
	ld	(de),a
	inc	hl
	inc	d
	edup
	djnz	scrdiff

	jp	fx_ret

tblscr1
	dw	attr_restrict_0
	dw	attr_restrict_1
	dw	diff_restrict
tblscr2
	dw	attr_allow_0
	dw	attr_allow_1
	dw	diff_allow
	
//======================================================== FX_INCLUDE_DATA
tbl	
	db	0
	dw	112*0 + 28

	db	1
	db	32
	dw	#5920
	dw	attr_demarche
	dw	112*1 + 28

	db	2
	db	23
	dw	#58e0 + 4
	dw	attr_invites
	db	11
	dw	#5980 + 10
	dw	attr_you
	dw	112*2 + 28

	db	2
	db	21
	dw	#58e0 + 6
	dw	attr_tothe
	db	29
	dw	#5980 + 1
	dw	attr_paradize
	dw	112*3 + 28

	db	2
	db	11
	dw	#58e0 + 11
	dw	attr_for
	db	32
	dw	#5980
	dw	attr_realman
	dw	112*4 + 28

	db	0
	dw	#ffff


attr_demarche	incbin "bin/attr-demarche.bin"
attr_invites	incbin "bin/attr-invites.bin"
attr_you	incbin "bin/attr-you.bin"
attr_tothe	incbin "bin/attr-tothe.bin"
attr_paradize	incbin "bin/attr-paradize.bin"
attr_for	incbin "bin/attr-for.bin"
attr_realman	incbin "bin/attr-realman.bin"

scrdata	incbin "bin/ooc-restrict_pix_0.bin"

attr_restrict_0	incbin "bin/ooc-restrict_attr_0.bin"
attr_restrict_1	incbin "bin/ooc-restrict_attr_1.bin"
diff_restrict	include "bin/diff_restrict.asm"

attr_allow_0	incbin "bin/ooc-allow_attr_0.bin"
attr_allow_1	incbin "bin/ooc-allow_attr_1.bin"
diff_allow	include "bin/diff_allow.asm"

sprfade_tbl equ ($/256+1)*256

	
