<?
/*
1. demarche invites you to a real man's paradise
2. take your stick and paint
3. come and be gentle
*/


$imgFont = imagecreatefrompng(__DIR__ . '/font_text.png');


$wordList = array(
    'come',
    'and',
    'be',
    'gentle',
);
$palette = array(
    0x07,
    array(0x43,0x43, 0x03,0x06, 0x06,0x06, 0x06,0x07, 0x07,0x07, 0x07,0x07),
    array(0x00,0x00, 0x03,0x03, 0x03,0x06, 0x06,0x06, 0x06,0x07, 0x07,0x07),
    array(0x00,0x00, 0x03,0x03, 0x03,0x06, 0x06,0x06, 0x06,0x07, 0x07,0x07),
);

$palette = array(
    0x07,
    array(0x02,0x06, 0x03,0x06, 0x06,0x06, 0x06,0x07, 0x07,0x07, 0x07,0x07),
    array(0x00,0x00, 0x03,0x03, 0x03,0x06, 0x06,0x06, 0x06,0x07, 0x07,0x07),
    array(0x00,0x00, 0x03,0x03, 0x03,0x06, 0x06,0x06, 0x06,0x07, 0x07,0x07),
);
make_text($imgFont, $wordList, $palette);


$wordList = array(
    'take',
    'your',
    'stick',
    'and',
    'paint',
);
$palette = array(
    0x03,
    array(0x00,0x00, 0x02,0x00, 0x02,0x02, 0x03,0x02, 0x03,0x03, 0x03,0x03),
    array(0x47,0x47, 0x47,0x07, 0x07,0x06, 0x07,0x03, 0x06,0x03, 0x03,0x03),
    array(0x47,0x47, 0x47,0x07, 0x07,0x06, 0x07,0x03, 0x06,0x03, 0x03,0x03),
    //array(0x07,0x07, 0x07,0x06, 0x06,0x06, 0x06,0x03, 0x03,0x03, 0x03,0x03),
);
make_text($imgFont, $wordList, $palette);


function make_text($imgFont, $wordList, $palette) {
    $colorIdxList = array(
        0x000000 => 0,
        0x0000ff => 1,
        0xffffff => 2,
        0xE0E0E0 => 3,
        0xC0C0C0 => 3,
    );
    
    $wordAsm = "";
    $wordAsmTbl = "word_tbl\r\n";
    foreach ($wordList as $n => $word) {
        $lines = array();
        for ($y = 0; $y < 3; $y++) {
            $lines[$y] = array();
        }
        for ($w = 0; $w < strlen($word); $w++) {
            $char = ord(strtoupper($word[$w]));
            $y = 6 * ($char == 32 ? 0 : $char - 64);
            $width = 3;
            for ($by = 0; $by < 6; $by++) {
                for ($bx = 0; $bx < 5; $bx++) {
                    $clr = imagecolorat($imgFont, $bx, $y+$by);
                    if ($clr != 0) {
                        $width = max($width, $bx+1);
                    }
                }
            }
            $width++;
            $x0 = sizeof($lines[0]);
            for ($by = 0; $by < 6; $by++) {
                for ($bx = 0; $bx < $width; $bx++) {
                    $clr = imagecolorat($imgFont, $bx, $y+$by);
                    $cIdx = $colorIdxList[$clr];
                    if ($by%2 == 0) {
                        $lines[floor($by/2)][$x0 + $bx] = $cIdx;
                    } else {
                        $lines[floor($by/2)][$x0 + $bx] += 4*$cIdx;
                    }
                }
            }
        }
        $wordAsm .= "word_" . $word . "\r\n";
        for ($y = 0; $y < 3; $y++) {
            $wordAsm .= "\tdb\t" . implode(', ', $lines[$y]) . "\r\n";
        }
        $wordAsmTbl .= "\t;-----\r\n";    
        $wordAsmTbl .= "\tdb\t1\t\t;qty\r\n";
        $wordAsmTbl .= "\tdb\t" . sizeof($lines[0]) . "\t\t;size-x\r\n";
        $wordAsmTbl .= "\tdw\t#5920 + " . floor((32 - sizeof($lines[0]))/2) . "\t\t;attr adr\r\n";
        $wordAsmTbl .= "\tdw\tword_" . $word . "\t\t;text adr\r\n";
        $wordAsmTbl .= "\tdw\t28*" . $n . "\t\t;time\r\n";
    }
    $wordAsmTbl .= "\t;-----\r\n";
    $wordAsmTbl .= "\tdb\t0\t\t;qty\r\n";
    $wordAsmTbl .= "\tdw\t#ffff\t\t;time\r\n";

    $wordAsm = $wordAsmTbl . "\r\n" . $wordAsm . "\r\n";

    for ($fade = 0; $fade < floor(sizeof($palette[1]) / 2); $fade++) {
        for ($pal = 0; $pal < 2; $pal++) {
            $colors = [];
            for ($i = 0; $i < 4; $i++) {
                for ($p = 0; $p < 4; $p++) {
                    $ink = $i == 0 ? $palette[0] : $palette[$i][$fade*2 + $pal];
                    $paper = $p == 0 ? $palette[0] : $palette[$p][$fade*2 + $pal];
                    $colors[] = ($ink & 7) . ' + 8*' . ($paper & 7) . ' + ' . (($paper & 0x40) | ($ink & 0x40));
                }
            }
            $wordAsm .= "\talign 256\r\n";
            $wordAsm .= "pal" . ($pal+1) . "_" . $fade
                . "\tdb\t" . implode(', ', $colors) . "\r\n";
        }
    }

    file_put_contents(__DIR__ . '/' . implode('_', $wordList) . '.asm', $wordAsm);
}