;AIRSCREW - 256 byte intro by Abaddon
;2020.12.08. FASM source
;code: TomCat

CENTER EQU 320*99+154
RADIUS EQU 48

ORG 256                 ; assuming: AH=0, BX=0, CH=0, SI=256, BP=2334
 DW RADIUS              ; constant int value for FPU (XOR [BX+SI],AL)
 MOV AL,19              ; 320x200 VGA mode
 INT 16

 XCHG AX,BX             ; AL=0 index for the 1st color of the palette
 MOV DX,3C8H
 OUT DX,AL              ; The 8-gradinet palette!
 INC DX                 ; combining together two 4-gradient palettes
.1:                     ; Check my article about color palettes:
 INC AX                 ; https://abaddon.hu/256b/colors.html
 MOV CL,0
.2:
 PUSHA
 XOR AH,255
 JZ .3
 DEC CX
 DEC CX
 NEG CX
.3:
 SHR AL,CL
 OUT DX,AL
 POPA
 INC CX
 JPO .2
 INC AX
 JNZ .1

 MOV DX,64              ; DX: nice constant used by many parts of the intro
 MOV AL,77              ; 77*257 -> nearly 60Hz
 OUT DX,AL              ; interrupt speedup
 OUT DX,AL

nextcircle:
 PUSH CS                ; reseting DS register
 POP DS

 ADD DWORD [BP+DI],11   ; dirty trigonometry: int 11 -> close to PI/2
 FILD DWORD [BP+DI]     ; [BP+DI]: angle of rotation
 FSINCOS                ; sina cosa
 FIMUL WORD [SI]        ; r*sina cosa
 FISTP WORD [BP+SI]     ; cosa
 IMUL AX,[BP+SI],320    ; AX: r*sina*320
 FIMUL WORD [SI]        ; r*cosa
 FISTP WORD [BP+SI]     ; -
 ADD AX,[BP+SI]         ; AX: r*sina*320+r*cosa
 ADD AX,CENTER          ; AX: r*sina*320+r*cosa+CENTER

 PUSH 8000H             ; segment address of backbuffer
 POP ES
 PUSH ES                ; DS and ES also points to the backbuffer
 POP DS

nextpixel:              ; AX: 2D rotated center of the big circle
 PUSHA                  ; backup AX and other regiters
 CMP CL,DL              ; CL: base color of the circle, DL: 64
 JNB .1                 ; if it is the first circle
 MOV [DI],CH            ; then clear the background (DH: 0)
.1:
 ADD CH,[DI]            ; if the pixel is empty
 JZ .2                  ; then it is sure we can update this pixel
 SUB CH,CL              ; if the first and last circle meet
 JNS .7                 ; then we should avoid of updating this pixel color
.2:
 SUB AX,DI              ; AX: distance of the center and the current pixel
 PUSHF                  ; save the sign of this distance
 JNS .3                 ; if it is negative
 NEG AX                 ; then take the absolute value
.3:
 ADD SI,DX              ; SI: 320, number of pixels in a raw
 CWD                    ; we need zero to DX for the division
 IDIV SI                ; AX: ycoord, DX: xcoord of the pixel
 SUB DX,160             ; DX: -160...159
 MOV SI,DX              ; saving xcoord
 SUB DX,AX              ; DX: xcoord-ycoord
 POPF                   ; backup the sign of distance
 JNS .4                 ; if the pixel is in the lower side of the circle
 NEG DX                 ; then flip DX
.4:
 IMUL AL                ; AX: ycoord2
 IMUL SI,SI             ; SI: xcoord2
 ADD AX,SI              ; AX: ycoord2+xcoord2
 CMP AX,RADIUS*RADIUS   ; if the point is outside of the circle
 JNC .7                 ; then go to the next pixel
 CMP AX,29              ; if the point very close to center of the circle
 JNC .5                 ; then make some fake specular highlight
 MOV AL,[DI+BX]         ; BX: -320*20+20
 CMP AL,CL              ; if the pixel above and right by 20-20 pixels
 JB .5                  ; is same colored (so the same circle)
 ADD BYTE [DI+BX],11    ; then make it brighter
.5:
 SUB AH,DL              ; AH: (ycoord2+xcoord2)/256-(xcoord-ycoord)
 JNS .6                 ; if it is negative
 MOV AH,0               ; then clamp to zero -> no diffuse light on the sphere
.6:
 SHR AX,10              ; scaling diffuse component
 ADD AL,CL              ; adding surface color
 SUB AL,8               ; adjusting the brightness (the ambient color)
 STOSB                  ; putpixel (main object)
.7:
 POPA                   ; restoring registers
 INC DI                 ; if it wasn't the last pixel
 JNZ nextpixel          ; then go to the next pixel
 SUB CL,-64             ; the index color of next circle is 64 higher
nextframe:              ; SUB instead of ADD because we need CARRY
 JC nextcircle          ; go to next pixel or next frame

copy:                   ; replicate the object in the background
 MOV DI,SP              ; DI: starting point in the backbuffer
.1:
 MOV CL,52              ; a small object is 52 pixel wide
.2:
 MOV BX,DI              ; BX: DI*4, the source pixel offset
.3:
 ADD BX,BX
 JNC .4
 SUB BX,DX              ; adjusting the source offset after one raw of objects
.4:
 NEG SI                 ; we know SI was a positive number
 JS .3                  ; loop 2x
 MOV AL,[BX-96]         ; get the source pixel
 TEST AL,32             ; if it is not from the big object
 JZ .8                  ; then we skip this pixel
 AND AL,NOT 32          ; shift the color to another gradient

 MOV BX,-6*52           ; BX: offset and loop counter
.5:
 CMP [BX+DI],DH         ; if the background is not clear
 JNZ .7                 ; then skip this pixel

 PUSH AX                ; backup source color and make some cheap shadow
 TEST BYTE [BX+DI-320*8+12],32
 JZ .6                  ; is the pixel above-right is the main object?
 AAM 32                 ; if yes then we make the current pixel darker
 SHR AL,1               ; the 2 most significant bits select the color gradient
 AAD 32                 ; the 5 least significant bits give the color intensity
.6:
 MOV [BX+DI],AL         ; then putpixel (background objects)
 POP AX                 ; restore source color

.7:
 ADD BX,52              ; next small object offset
 JNZ .5                 ; loop 6x
.8:
 INC DI                 ; next pixel of the small object
 LOOP .2                ; loop 52x
 ADD DI,268             ; DI: pixeloffset point to next raw
 JNC .1                 ; end of backbuffer? if not then copy to next line

 SUB DI,DI              ; DI: zero
 HLT                    ; waiting for timer interrupt
 PUSH 40946             ; instead of 0A000H shifted by 160 pixels
 POP ES                 ; mem seg of video mem
 MOV CX,DS              ; CX: 32768
 REP MOVSW              ; fast copy to video memory

 MOV BX,-320*20+20      ; BX: constant for shifting the highlight
 MOV CL,32+16           ; CL: the first color gradient index

 IN AL,96               ; key check
 DAS                    ; nothing pressed?
 JC nextframe           ; then go to next frame (with short relative jump)

 XCHG AX,DI             ; The End
 OUT DX,AL              ; AX: zero
 OUT DX,AL              ; restore interrupt speed
 MOV Al,3
 INT 16                 ; switch back to text mode
RETN                    ; clean exit to DOS
