#version 330 core

#define float2 vec2
#define float3 vec3
#define float4 vec4


vec3 sample(vec2 tc);
vec3 blur(vec2 tc, float offs);
vec3 highlights(vec3 pixel, float thres);
uniform float time = 1.0;
uniform float syncmultiplier = 0.5;

in float2 texCoord;
in float4 vertexFragColor;
out float4 fragColor;
uniform sampler2D texture0;

void main()
{
	vec4 n = texture(texture0, (texCoord+vec2(0,0.0025)));
    vec4 e = texture(texture0, (texCoord+vec2(0.0025,0)));
    vec4 s = texture(texture0, (texCoord+vec2(0,-0.0025)));
    vec4 w = texture(texture0, (texCoord+vec2(-0.0025,0)));
	vec4 diffuse = texture(texture0, texCoord);
    vec4 dy = (n - s)*.5;
    vec4 dx = (e - w)*.5;
    vec4 edge = sqrt(dx*dx + dy*dy);
    vec4 angle = atan(dy, dx);
    
  

	  
	vec2 tc = texCoord.xy;
	vec3 color = blur(tc, 0.0);
	color += 0.5*blur(tc, 1.021);
	color += blur(tc, 0.021);
	color += blur(tc, 0.019);
	color += blur(tc, 0.008);
	color += blur(tc, 0.025);

	 color /= 2.0;
	
	 color += sample(tc);

	float div_pos = 0.0;
	float divider = smoothstep(div_pos - 0.01, div_pos + 0.01, tc.x);
	vec3 blurred = mix(sample(tc), color, divider) * (divider * divider + (1.0 - divider) * (1.0 - divider));
	fragColor.xyz = diffuse.xyz*.66+(blurred.xyz*0.5-edge.xyz*5.5)*.33;
	fragColor.w = 1.0;
	//fragColor.xyz=blurred;
}

vec3 sample(vec2 tc)
{
	return pow(texture(texture0, tc).xyz, vec3(2.2, 2.2, 2.2));
}

vec3 hsample(vec2 tc)
{
	return highlights(sample(tc), 0.5);
}

vec3 blur(vec2 tc, float offs)
{
	vec4 xoffs = offs * vec4(-3.0, -2.0, 2.0, 2.0) * .3521;
	vec4 yoffs = offs * vec4(-3.0, -2.0, 2.0, 2.0) * .3521;
	

	vec3 color = vec3(0.0, 0.0, 0.0);
	color += hsample(tc + vec2(xoffs.x, yoffs.x)) * 0.1;
	color += hsample(tc + vec2(xoffs.y, yoffs.x)) * 0.1;
	color += hsample(tc + vec2(    0.0, yoffs.x)) * 0.1;
	color += hsample(tc + vec2(xoffs.z, yoffs.x)) * 0.1;
	color += hsample(tc + vec2(xoffs.w, yoffs.x)) * 0.1;
	
	color += hsample(tc + vec2(xoffs.x, yoffs.y)) * 0.1;
	color += hsample(tc + vec2(xoffs.y, yoffs.y)) * 0.1;
	color += hsample(tc + vec2(    0.0, yoffs.y)) * 0.1;
	color += hsample(tc + vec2(xoffs.z, yoffs.y)) * 0.1;
	color += hsample(tc + vec2(xoffs.w, yoffs.y)) * 0.1;
	
	color += hsample(tc + vec2(xoffs.x, 0.0)) * 0.1;
	color += hsample(tc + vec2(xoffs.y, 0.0)) * 0.1;
	color += hsample(tc + vec2(    0.0, 0.0)) *0.1;
	color += hsample(tc + vec2(xoffs.z, 0.0)) * 0.1;
	color += hsample(tc + vec2(xoffs.w, 0.0)) * 0.1;
	
	color += hsample(tc + vec2(xoffs.x, yoffs.z)) *0.1;
	color += hsample(tc + vec2(xoffs.y, yoffs.z)) * 0.1;
	color += hsample(tc + vec2(    0.0, yoffs.z)) * 0.1;
	color += hsample(tc + vec2(xoffs.z, yoffs.z)) * 0.1;
	color += hsample(tc + vec2(xoffs.w, yoffs.z)) * 0.1;
	
	color += hsample(tc + vec2(xoffs.x, yoffs.w)) * 0.1;
	color += hsample(tc + vec2(xoffs.y, yoffs.w)) * 0.1;
	color += hsample(tc + vec2(    0.0, yoffs.w)) * 0.1;
	color += hsample(tc + vec2(xoffs.z, yoffs.w)) * 0.1;
	color += hsample(tc + vec2(xoffs.w, yoffs.w)) * 0.1;



	return color*0.99;
}

vec3 highlights(vec3 pixel, float thres)
{
	float val = (pixel.x + pixel.y + pixel.z) / 0.5;
	return pixel * smoothstep(thres - 0.5, thres + 0.5, val);
}