#pragma once
#include <iostream>
#include "CGengine.hpp"

using namespace cg_engine;

class CandyScene: public Scene{
	public:
		CandyScene();
		void show(double time);
	private:
		Texture *candytex;
		ShaderProgram *defaultshader;
		Matrix pmatrix;
		Sprite *candysprite;
};

class CircleTrans: public Scene {
	public:
		CircleTrans(double s, double e1, double e2);
		void show(double time);
	private:
		Sprite        *fullscreensprite;
		Sprite        *skipadsprite;
		Texture       *christmastex;
		Texture       *eastertex;
		Texture       *skipadtex;
		ShaderProgram *circshader;
		ShaderProgram *spriteshader;
		double         end2;
};

class CircleTrans2: public CircleTrans {
	public:
		CircleTrans2();
		void show(double time);
};

class SkipAdOverlay: public Scene {
	public:
		SkipAdOverlay();
		void show(double time);
	private:
		Texture       *skipad;
		Sprite        *skipsprite;
		Matrix         skmatrix;
		ShaderProgram *skshader;
};

class SpriteTest: public Scene {
	public:
		SpriteTest();
		void show(double time);
	private:
		Sprite        *sprite;
		Texture       *title;
		Texture       *christmastree;
		ShaderProgram *spriteshader;
		Matrix         spritematrix;
};

class ToyScene: public Scene {
	public:
		ToyScene();
		void show(double time);
	private:
		Sprite *sprite;
		Texture *toytex;
		ShaderProgram *toyshader;
		Matrix toymatrix;
};

class ReligionScene: public Scene {
	public:
		ReligionScene();
		void show(double time);
	private:
		Sprite *sprite;
		Texture *relitex;
		ShaderProgram *relishader;
		Matrix relimatrix;
};

class Christmas: public Demo{
	public:
		Christmas(int w, int h);
		void init();
};
