#include "karacsony.hpp"

using namespace cg_engine;

CandyScene::CandyScene(){
	start = 13;
	end   = 16.7;
	defaultshader = new ShaderProgram();
	defaultshader->addShader((char*)"data/sprite.vs", GL_VERTEX_SHADER);
	defaultshader->addShader((char*)"data/default.fs", GL_FRAGMENT_SHADER);
	defaultshader->compile();

	pmatrix.translate(0.0, 0.0, 0.0);
	candytex = new Texture((char*)"data/candy.jpg", JPEGType);

	candysprite = new Sprite();
}

void CandyScene::show(double time){
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	defaultshader->use();
	defaultshader->addTexture((char*)"img", candytex);

	Matrix scale;
	scale.scale(1.0 + (time - this->start) / 3000.0, 1.0 + (time - this->start) / 3000.0, 1.0);
	pmatrix = pmatrix * scale;
	GLuint loc = glGetUniformLocation(defaultshader->getProgramID(), "pmatrix");
	glUniformMatrix4fv(loc, 1, GL_FALSE, pmatrix.matrix());

	loc = glGetUniformLocation(defaultshader->getProgramID(), "zscore");
	glUniform1f(loc, 0.1f);

	candysprite->draw();
}

SkipAdOverlay::SkipAdOverlay()
{
	start = 8;
	end   = 22;

	skshader = new ShaderProgram();
	skshader->addShader((char*)"data/sprite.vs", GL_VERTEX_SHADER);
	skshader->addShader((char*)"data/default.fs", GL_FRAGMENT_SHADER);
	skshader->compile();

	skipad = new Texture((char*)"data/skipad.jpg", JPEGType);
	skipsprite = new Sprite();

	Matrix tr;
	tr.translate(0.89, -0.8, 0.0);
	skmatrix.scale(0.125, 0.09, 0.125);
	skmatrix = skmatrix * tr;
}

void SkipAdOverlay::show(double time)
{
	skshader->use();
	skshader->addTexture((char*)"img", skipad);

	GLuint loc = glGetUniformLocation(skshader->getProgramID(), "zscore");
	glUniform1f(loc, 0.09f);

	loc = glGetUniformLocation(skshader->getProgramID(), "pmatrix");
	glUniformMatrix4fv(loc, 1, GL_FALSE, skmatrix.matrix());

	skipsprite->draw();
}

SpriteTest::SpriteTest()
{
	start = 0;
	end   = 2.6;

	christmastree = new Texture((char*)"data/christmas.jpg", JPEGType);
	title         = new Texture((char*)"data/title.png", PNGType);
	spriteshader  = new ShaderProgram();
	spriteshader->addShader((char*)"data/sprite.vs", GL_VERTEX_SHADER);
	spriteshader->addShader((char*)"data/doubletex.fs", GL_FRAGMENT_SHADER);
	spriteshader->compile();
	sprite        = new Sprite();
	spritematrix.translate(0.0, 0.0, 0.0);
}

void SpriteTest::show(double time)
{
	Matrix tr;
	GLuint loc;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	spriteshader->use();
	spriteshader->addTexture((char*)"img", christmastree);
	spriteshader->addTexture((char*)"title", title);

	loc = glGetUniformLocation(spriteshader->getProgramID(), "zscore");
	glUniform1f(loc, 0.1f);

	loc = glGetUniformLocation(spriteshader->getProgramID(), "pmatrix");
	spritematrix.translate(0.0, 0.0, 0.0);
	glUniformMatrix4fv(loc, 1, GL_FALSE, spritematrix.matrix());

	sprite->draw();
}

CircleTrans::CircleTrans(double s, double e1, double e2)
{
	start = s;
	end   = e1;
	end2  = e2;

	fullscreensprite = new Sprite();
	skipadsprite     = new Sprite();
	christmastex     = new Texture((char*)"data/christmas.jpg", JPEGType);
	eastertex        = new Texture((char*)"data/easter.jpg", JPEGType);
	skipadtex        = new Texture((char*)"data/skipad.jpg", JPEGType);
	circshader       = new ShaderProgram();
	spriteshader     = new ShaderProgram();

	spriteshader->addShader((char*)"data/sprite.vs",  GL_VERTEX_SHADER);
	spriteshader->addShader((char*)"data/default.fs", GL_FRAGMENT_SHADER);
	spriteshader->compile();

	circshader->addShader((char*)"data/sprite.vs", GL_VERTEX_SHADER);
	circshader->addShader((char*)"data/circle.fs", GL_FRAGMENT_SHADER);
	circshader->compile();
}

void CircleTrans::show(double time)
{
	GLuint loc;
	Matrix m;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	circshader->use();
	circshader->addTexture((char*)"chrimg", christmastex);
	circshader->addTexture((char*)"easimg", eastertex);
	loc = glGetUniformLocation(circshader->getProgramID(), "degree");
	float perc = (time - this->start) / (end2 - this->start);
	if(perc > 0.96) perc = 0.96;
	glUniform1f(loc, perc * 6.28);

	loc = glGetUniformLocation(circshader->getProgramID(), "zscore");
	glUniform1f(loc, 0.1f);

	loc = glGetUniformLocation(circshader->getProgramID(), "pmatrix");
	m.translate(0.0, 0.0, 0.0);
	glUniformMatrix4fv(loc, 1, GL_FALSE, m.matrix());
	fullscreensprite->draw();
}

ToyScene::ToyScene()
{
	start = 10.0;
	end   = 13.0;

	toytex     = new Texture((char*)"data/toys.jpg", JPEGType);
	toyshader  = new ShaderProgram();
	toyshader->addShader((char*)"data/sprite.vs", GL_VERTEX_SHADER);
	toyshader->addShader((char*)"data/default.fs", GL_FRAGMENT_SHADER);
	toyshader->compile();
	sprite     = new Sprite();
	toymatrix.translate(0.0, 0.0, 0.0);

}

void ToyScene::show(double time)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	toyshader->use();
	toyshader->addTexture((char*)"img", toytex);

	GLuint loc = glGetUniformLocation(toyshader->getProgramID(), "zscore");
	glUniform1f(loc, 0.1f);

	loc = glGetUniformLocation(toyshader->getProgramID(), "pmatrix");
	glUniformMatrix4fv(loc, 1, GL_FALSE, toymatrix.matrix());

	sprite->draw();
}

ReligionScene::ReligionScene()
{
	start = 16.7;
	end   = 20.3;

	relitex     = new Texture((char*)"data/religion.jpg", JPEGType);
	relishader  = new ShaderProgram();
	relishader->addShader((char*)"data/sprite.vs", GL_VERTEX_SHADER);
	relishader->addShader((char*)"data/religion.fs", GL_FRAGMENT_SHADER);
	relishader->compile();
	sprite     = new Sprite();
	relimatrix.translate(0.0, 0.0, 0.0);

}

void ReligionScene::show(double time)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	relishader->use();
	relishader->addTexture((char*)"img", relitex);

	GLuint loc = glGetUniformLocation(relishader->getProgramID(), "zscore");
	glUniform1f(loc, 0.1f);

	loc = glGetUniformLocation(relishader->getProgramID(), "pmatrix");
	glUniformMatrix4fv(loc, 1, GL_FALSE, relimatrix.matrix());

	loc = glGetUniformLocation(relishader->getProgramID(), "mixrate");
	glUniform1f(loc, (time - this->start) / (this->end - this->start));

	sprite->draw();
}

Christmas::Christmas(int w, int h): Demo(w, h){
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glEnable(GL_DEPTH_TEST);
}

void Christmas::init(){
	scenes.push_back(new CircleTrans(2.6, 10.0, 5.0));              
	scenes.push_back(new CandyScene());                             
	scenes.push_back(new SpriteTest());                             
	scenes.push_back(new ToyScene());                               
	scenes.push_back(new CircleTrans(20.3, 22.0, 22.0));            
	scenes.push_back(new ReligionScene());                          
	scenes.push_back(new SkipAdOverlay());                          
}

