#pragma once
#include <GL/glew.h>
namespace cg_engine {

	enum ImgType {JPEGType, PNGType, TGAType};

	class Texture
	{
	private:
		GLuint texid = 0;
		int width;
		int height;
	public:
		Texture(char *filename, ImgType imgtype);
		~Texture();
		GLuint getTexID();
		void loadTGA(char *filename, GLuint texid);
		void loadJPEG(char *filename, GLuint texid);
		void loadPNG(char *filename, GLuint texid);
		int getWidth();
		int getHeight();
	};

}

