#pragma once

#include <GL/glew.h>
#include "Shader.hpp"
#include "Texture.hpp"

namespace cg_engine
{
	class ShaderProgram
	{
	public:
		ShaderProgram();
		~ShaderProgram();
		void compile();
		void addShader(char *filename, GLenum shadertype);
		void addTexture(char *varname, Texture *texture);
		void addTexture(char *varname, GLuint texnum);
		void use();
		GLuint getProgramID();
	private:
		GLuint programid;
		int texturecount;
	};
}

