#include "ShaderProgram.hpp"
#include <stdio.h>
#include "ShaderError.hpp"

using namespace cg_engine;

ShaderProgram::ShaderProgram()
{
	programid = glCreateProgram();
}

ShaderProgram::~ShaderProgram()
{
	glDeleteProgram(programid);
}

void ShaderProgram::addShader(char *filename, GLenum shadertype)
{
	Shader *shader = new Shader(filename, shadertype);
	glAttachShader(programid, shader->getShaderId());
}

void ShaderProgram::compile()
{
	int error;
	glLinkProgram(programid);
	glGetProgramiv(programid, GL_LINK_STATUS, &error);
	if (error == GL_FALSE) {
		printf("Link error\n");
		ShaderError::errorStr(programid, PROGRAM_ERROR);

	}
	glValidateProgram(programid);
	glGetProgramiv(programid, GL_VALIDATE_STATUS, &error);
	if (error == GL_FALSE) {
		printf("Validate error\n");
		ShaderError::errorStr(programid, PROGRAM_ERROR);
	}
}

GLuint ShaderProgram::getProgramID()
{
	return(programid);
}

void ShaderProgram::use()
{
	glUseProgram(programid);
	texturecount = 0;
}

void ShaderProgram::addTexture(char *varname, GLuint texnum)
{
	glActiveTexture(GL_TEXTURE0 + texturecount);
	glBindTexture(GL_TEXTURE_2D, texnum);
	GLint loc = glGetUniformLocation(programid, varname);
        glUniform1i(loc, texturecount);
	texturecount++;
}

void ShaderProgram::addTexture(char *varname, Texture *texture)
{
	addTexture(varname, texture->getTexID());
}
