#pragma once
#include <GL/glew.h>
#include "ShaderProgram.hpp"
namespace cg_engine {
	class Renderbuffer
	{
	public:
		Renderbuffer(int w, int h, int sy, int texnum, bool adddepth);
		~Renderbuffer();
		GLuint getFramebuffer();
		GLuint getRenderTexture(int index);
		void firstPass();
		void secondPass();
		void addShader(ShaderProgram *prg);
		void setFade(float f);
		void setVertexArray(GLuint v);
		void setKernelSize(int ks);
		void setVignette(float v);
		void setAvg(int s);
		bool getError();
		void setZoom(float z);
	private:
		GLuint framebuffer;
		GLuint renderTexture[3];
		GLuint vao;
		int width;
		int height;
		int starty;
		bool isError;
		int maxtexture;
		float fade;
		int kernelsize;
		int avg;
		float vignette;
		float zoom;
		ShaderProgram *postprocessing;
	};

}
