#version 450

layout (location = 0) out vec4 FragColor;

uniform sampler2D chrimg;
uniform sampler2D easimg;
uniform float degree;

in vec2 texcoord;

void main(void){
   float deg = atan(texcoord.x - 0.5, texcoord.y - 0.5) + 3.14;
   vec4 outcol;

   if(deg < degree){
      outcol = vec4(texture(easimg, texcoord));
   }
   else {
      outcol = vec4(texture(chrimg, texcoord));
   }

   FragColor = outcol;
}
