/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.ConnectableOutput;
import com.jsyn.ports.InputMixingBlockPart;
import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.SettablePort;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitOutputPort;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.io.PrintStream;

public class UnitInputPort
extends UnitBlockPort
implements ConnectableInput,
SettablePort {
    private double minimum = 0.0;
    private double maximum = 1.0;
    private double defaultValue = 0.0;
    private double[] setValues;
    private boolean valueAdded = false;

    public UnitInputPort(int n, String string, double d) {
        super(n, string, d);
        this.setDefault(d);
        this.setValues = new double[n];
        for (int i = 0; i < n; ++i) {
            this.setValues[i] = d;
        }
    }

    public UnitInputPort(String string, double d) {
        this(1, string, d);
    }

    public UnitInputPort(String string) {
        this(1, string, 0.0);
    }

    public UnitInputPort(int n, String string) {
        this(n, string, 0.0);
    }

    @Override
    protected void makeParts(int n, double d) {
        this.parts = new InputMixingBlockPart[n];
        for (int i = 0; i < n; ++i) {
            this.parts[i] = new InputMixingBlockPart(this, d);
        }
    }

    @Override
    public void pullData(long l, int n, int n2) {
        for (PortBlockPart portBlockPart : this.parts) {
            ((InputMixingBlockPart)portBlockPart).pullData(l, n, n2);
        }
    }

    @Override
    protected void setValueInternal(int n, double d) {
        super.setValueInternal(n, d);
        this.setValues[n] = d;
    }

    public void set(double d) {
        this.set(0, d);
    }

    public void set(final int n, final double d) {
        this.setValues[n] = d;
        this.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                UnitInputPort.this.setValueInternal(n, d);
            }
        });
    }

    public void set(double d, TimeStamp timeStamp) {
        this.set(0, d, timeStamp);
    }

    public void set(double d, double d2) {
        this.set(0, d, d2);
    }

    public void set(int n, double d, double d2) {
        this.set(n, d, new TimeStamp(d2));
    }

    @Override
    public void set(final int n, final double d, TimeStamp timeStamp) {
        this.getValue(n);
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                UnitInputPort.this.setValueInternal(n, d);
            }
        });
    }

    @Override
    public double get(int n) {
        return this.setValues[n];
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double d) {
        this.minimum = d;
    }

    public double getDefault() {
        return this.defaultValue;
    }

    public void setDefault(double d) {
        this.defaultValue = d;
    }

    public void setup(double d, double d2, double d3) {
        this.setMinimum(d);
        this.setMaximum(d3);
        this.setDefault(d2);
        this.set(d2);
    }

    public void setup(UnitInputPort unitInputPort) {
        this.setup(unitInputPort.getMinimum(), unitInputPort.getDefault(), unitInputPort.getMaximum());
    }

    public boolean isValueAdded() {
        return this.valueAdded;
    }

    public void setValueAdded(boolean bl) {
        this.valueAdded = bl;
    }

    public void connect(int n, UnitOutputPort unitOutputPort, int n2, TimeStamp timeStamp) {
        unitOutputPort.connect(n2, this, n, timeStamp);
    }

    public void connect(int n, UnitOutputPort unitOutputPort, int n2) {
        unitOutputPort.connect(n2, this, n);
    }

    public void connect(UnitOutputPort unitOutputPort) {
        this.connect(0, unitOutputPort, 0);
    }

    @Override
    public void connect(ConnectableOutput connectableOutput) {
        connectableOutput.connect(this);
    }

    public void disconnect(int n, UnitOutputPort unitOutputPort, int n2) {
        unitOutputPort.disconnect(n2, this, n);
    }

    @Override
    public PortBlockPart getPortBlockPart() {
        return this.parts[0];
    }

    public ConnectableInput getConnectablePart(int n) {
        return this.parts[n];
    }

    @Override
    public void disconnect(ConnectableOutput connectableOutput) {
        connectableOutput.disconnect(this);
    }

    public void printConnections(PrintStream printStream, int n) {
        for (PortBlockPart portBlockPart : this.parts) {
            ((InputMixingBlockPart)portBlockPart).printConnections(printStream, n);
        }
    }
}

