"use strict";

class MaterialManager {
    _materials = {};

    loadShaders(name, vertexShaderPath, fragmentShaderPath) {
        var me = this;
        var vertexPromise = this.loadFile(vertexShaderPath);
        var fragmentPromise = this.loadFile(fragmentShaderPath);

        return new Promise((resolve) => {
            Promise.all([vertexPromise, fragmentPromise]).then((values) => {
				var material = new THREE.ShaderMaterial( {
					vertexShader: values[0],
                    fragmentShader: values[1],
                    uniforms: {}
                } );
                me._materials[name] = material
                resolve();
              });
        });
    }


    get(materialName) {
        return this._materials[materialName];
    }

    // ----------------------------------------------------------------------------------------------------


    loadFile(path) {
        return new Promise((resolve) => {
            new THREE.FileLoader().load(path, (data) => {
                resolve(data);
            });
        });       
    }
}