uniform float time;

uniform sampler2D texture1;
uniform sampler2D texture2;

varying vec2 vUV;

void main( void ) {

    vec2 position = - 1.0 + 2.0 * vUV;

    vec4 noise = texture2D( texture1, vUV );
    vec2 t1 = vUV + vec2( 1.1, - 1.7 ) * time * 0.02;
    vec2 t2 = vUV + vec2( - 0.3, 1.2 ) * time * 0.01;

    t1.x += noise.x * 2.0;
    t1.y += noise.y * 2.0;
    t2.x -= noise.y * 0.4;
    t2.y += noise.z * 0.4;

    float p = texture2D( texture1, t1 ).a;

    vec4 color = texture2D( texture2, t2 );
    color = 0.6 * color * vec4(p) + 0.8 * color * color;

    if( color.r > 1.0 ) color.gb += color.r - 1.0; 
    if( color.g > 1.0 ) color.rb += color.g - 1.0; 
    if( color.b > 1.0 ) color.rg += color.b - 1.0;  

    gl_FragColor = color;

}