INCLUDE gba_common.ld

__text_start  = ORIGIN(iwram);

SECTIONS {
    /* VMA LAYOUT:
     *
     * IWRAM:
     * * stuff
     * * sbss
     * * STACK
     * EWRAM:
     * * bss
     * * HEAP
     */

    /* IWRAM stuff */

    __iwram_lma = .;
    .text ORIGIN(iwram) : AT (__iwram_lma)
    {
        __iwram_startv = ABSOLUTE(.);
        *(.text.startup)
        *(.text* .iwram* .rodata* .data*)
    } >iwram = 0xff
    __romrep_end = .;

    __iwram_endl = __iwram_lma + SIZEOF(.text);
    __iwram_endv = ABSOLUTE(.); /*ORIGIN(iwram) + SIZEOF(.iwram) + SIZEOF(.data.iwram);*/

    .bss.iwram ALIGN(4) (NOLOAD) :
    {
        PROVIDE(__iwbss_start = ABSOLUTE(.));
        *(.bss.iwram* .sbss*)
    } AT>iwram

    .stack ALIGN(4) (NOLOAD) :
    {
        __sp_max = ABSOLUTE(.);
        ASSERT(__sp_max < __sp_sys - __min_stack_size, "No space left for stack!");
    } AT>iwram

    /* EWRAM stuff */

    __ewram_lma = __iwram_lma + SIZEOF(.text);
    .ewram __romrep_end : AT (__ewram_lma)
    {
        __ewram_startv = ABSOLUTE(.);
        . = ALIGN(2);
        *(.ewram*)
    } >ewram =0xff

    __ewram_endl = __ewram_lma + SIZEOF(.ewram);
    __ewram_endv = ABSOLUTE(.); /*ORIGIN(ewram) + SIZEOF(.ewram) + SIZEOF(.data);*/

    .bss ALIGN(2) (NOLOAD) :
    {
        PROVIDE(__ewbss_start = ABSOLUTE(.));
        . = ALIGN(2);
        *(.bss* .bss.ewram*)
    } AT>ewram

    .heap ALIGN(4) (NOLOAD) :
    {
        __heap_start = ABSOLUTE(.);
        PROVIDE(__heap_start = __heap_start);
        /*ASSERT(__heap_start < __heap_end - __min_heap_size, "No space left for heap!");*/
    }

    __rom_end = __ewram_lma + SIZEOF(.ewram);
}

