@ vim: set ft=armv4 noet:

@#define ALIGN(x) ((((x)&3) == 0) ? (x) : (x+(4-((x)&3))))
#define ALIGN(x) (x+(4-((x)&3)))

.arch armv4
.cpu  arm7tdmi

.section .text.crt0,"ax",%progbits

.arm

.type _start,%function
.globl _start
_start:
	b main

	@ nintendo logo
	.fill 156,1,0
	@ game code (16 bytes)
	.fill 16,1,0
	@ maker code (2 bytes)
	.byte 0, 0
	@ ROM magic! (1 byte), main unit type (1 byte)
	.byte 0x96
	.byte 0
	@ device type (1 byte), reserved (7 bytes)
	.byte 0
	.fill 7,1,0
	@ sw version, checksum
	.byte 0, 0x00
	@ reserved?
	.byte 0, 0

	@ multiboot entrypoint
.arm
.type _start,%function
.globl mb$_start
mb$_start:
	b main

	@ multiboot stuff: boot method, slave number (both set by bios)
	.byte 0, 0

.arm
.align 4
.type main,%function
.globl main
main:
	mov r7, #0x03000000
	mov r4, #0x04000000
	add r0, pc, #5
	mov r2, #((payload_end - payload) >> 2)
	bx  r0

.thumb
.thumb_func
.type main$thumb,%function
main$thumb:
	add r0, pc, #12
	mov r1, r7
	swi 0x0C
	mov r1, r7
	lsl r7, #1
	mov r4, #0x40
	lsl r4, #20
	mov pc, r1

.type payload,%object
.globl payload
payload:
	.incbin "obj/payload.bin"
payload_end_unal:
	@.balign 4 @ reqd for BIOS 0x0C
	.org ALIGN(payload_end_unal)
.globl payload_end
payload_end:

