const mac = navigator.platform.startsWith('Mac') || navigator.platform.startsWith('iP');
document.head.innerHTML = '<style>.v{background-color:white;color:black;font-family:futura,sans-serif;text-align:center;font-size:30vh;}b{visibility:hidden;}@keyframes v{0%{left:-2vh;top:2vh}50%{left: 2vh;top:-2vh}}</style>'
document.body.innerHTML = '<div class="v"><div style="font-size:8vh">🎼 Gasman/H-Prg presents 🎼</div><div style="font-size:20vh">1️⃣2️⃣'+(mac?'\u{1f5d3}\ufe0f':'\u{1f4c5}')+'🎄</div><div style="font-size:8vh">a 4K intro for Hogmanay 2020</div><div><button style="margin:5vh;padding:1vh;font-size:8vh">🖥 fullscreen</button><button style="margin:5vh;padding:1vh;font-size:8vh">▶️ start demo</button></div><div style="font-size:5vh">🔈 turn sound up!';
const v = document.getElementsByClassName('v')[0];
document.getElementsByTagName('button')[0].onclick=()=>{v.requestFullscreen()}
document.getElementsByTagName('button')[1].onclick=()=>{
    v.innerHTML = '';
    let ac = new AudioContext;
    let sampleRate = ac.sampleRate;
    let node = ac.createScriptProcessor(512, 0, 1);
    node.connect(ac.destination);

    let notePeriods = [];
    for (let i = 73; i < 255; i++) {
        let freq = 220 * 2 ** ((i-97)/12);
        notePeriods[i] = sampleRate / freq;
    }

    let intro = (day) => (() => {
        v.innerHTML = '<b>'+day+'</b><b>'+(mac?'\u{1f5d3}\ufe0f':'\u{1f4c5}')+'</b><b>\u{1f384}</b><br><b>\u{1f491}</b><b>\u{1f4ee}</b><b>\u{1f64b}</b>'
        let i = 0;
        let show = () => {
            v.children[i++].style.visibility = 'visible';
            if (i < 7) {
                setTimeout(show, 400);
            }
        }
        setTimeout(show, 400);
    })
    let drummers = () => {
        v.innerHTML = mac?'<span style="position:relative"><div style="position: absolute;font-size:25vh;letter-spacing:-4vh;left:-90vh;width:180vh">💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️<a style="position:absolute;font-size:20vh;letter-spacing:1vh;left:30vh;top:22vh">🥁🥁🥁🥁🥁🥁</a></div><div style="position: absolute;font-size:25vh;letter-spacing:-4vh;left:-90vh;width:180vh;top:45vh">💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️<a style="position:absolute;font-size:20vh;letter-spacing:1vh;left:30vh;top:22vh">🥁🥁🥁🥁🥁🥁':'<span style="position:relative"><div style="position: absolute;font-size:25vh;letter-spacing:-4vh;left:-90vh;width:180vh;top:0">💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️<a style="position:absolute;font-size:20vh;letter-spacing:1vh;left:15vh;top:25vh">🥁🥁🥁🥁🥁🥁</a></div><div style="position: absolute;font-size:25vh;letter-spacing:-4vh;left:-90vh;width:180vh;top:45vh">💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️💂‍♂️<a style="position:absolute;font-size:20vh;letter-spacing:1vh;left:15vh;top:25vh">🥁🥁🥁🥁🥁🥁'
    }
    let pipers = () => {
        v.innerHTML = mac?'<span style="position:relative"><div style="position: absolute;top:55vh;left:-60vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:55vh;left:-30vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:55vh;left:0;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:55vh;left:30vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:25vh;left:-45vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:25vh;left:-15vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:25vh;left:15vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:-60vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:-30vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:0;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:30vh;font-size:25vh"><a style="position:absolute;font-size:30vh;left:-2vh;top:-5vh;">🏴󠁧󠁢󠁳󠁣󠁴󠁿</a><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleX(-1)">🎺':'<span style="position:relative"><div style="position: absolute;top:55vh;left:-60vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:55vh;left:-30vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:55vh;left:0;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:55vh;left:30vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:25vh;left:-45vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:25vh;left:-15vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:25vh;left:15vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:-60vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:-30vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:0;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺</div></div><div style="position: absolute;top:-5vh;left:30vh;font-size:25vh"><a style="position:absolute">💂‍♂️</a><div style="position:absolute;top:20vh;left:13vh;font-size:15vh;transform:scaleY(-1)">🎺'
    }
    let lords = () => {
        v.innerHTML = '<div style="padding-top:10vh;font-size:25vh;line-height:25vh;letter-spacing: 10vh">🤸‍♂️🤸‍♂️🤸‍♂️<br>🤸‍♂️🤸‍♂️🤸‍♂️🤸‍♂️<br>🤸‍♂️🤸‍♂️🤸‍♂️'
    }
    let ladies = () => {
        v.innerHTML = '<div style="padding-top:10vh;font-size:25vh;line-height:25vh;letter-spacing: 10vh">💃💃💃💃<br>💃💃💃<br>💃💃'
    }
    let maids = () => {
        v.innerHTML = mac?'<span style="position:relative"><div style="position:absolute;top:-5vh;left:-70vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:0;left:-35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:-5vh;left:0">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:0;left:35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:30vh;left:-70vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:35vh;left:-35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:30vh;left:0">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div><div style="position:absolute;top:35vh;left:35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:15vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:15vh;top:25vh;">🥛</a></div>':'<span style="position:relative"><div style="position:absolute;top:-5vh;left:-70vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:0;left:-35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:-5vh;left:0">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:0;left:35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:30vh;left:-70vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:35vh;left:-35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:30vh;left:0">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div><div style="position:absolute;top:35vh;left:35vh">🐄<a style="position:absolute;font-size:15vh;left:0;top:20vh">👩‍🌾</a><a style="position:absolute;font-size:8vh;left:20vh;top:30vh;">🥛</a></div>'
    }
    let swans = () => {
        v.innerHTML = mac?'<span style="position:relative"><div style="position:absolute;width:160vh;top:0;left:-80vh;font-size:70vh">🌊🌊</a><a style="position: absolute;font-size:20vh;left:40vh;top:45vh;letter-spacing: 14vh;">🦢🦢🦢</a><a style="position: absolute;font-size:20vh;left:20vh;top:55vh;letter-spacing: 14vh;">🦢🦢🦢🦢':'<span style="position:relative"><div style="position:absolute;width:180vh;top:0;left:-90vh;font-size:50vh">🌊🌊</a><a style="position: absolute;font-size:15vh;left:55vh;top:30vh;letter-spacing: 10vh;">🦢🦢🦢</a><a style="position: absolute;font-size:15vh;left:40vh;top:40vh;letter-spacing: 10vh;">🦢🦢🦢🦢'
    }
    let geese = (grouse) => (() => {
        v.innerHTML = mac?('<span style="position: relative"><div style="position:absolute;left:-65vh;top:0;width:140vh">\u{1f986}<a style="font-size:10vh">\u{1f95a}</a>\u{1f986}<a style="font-size:10vh">\u{1f95a}</a>\u{1f986}<a style="font-size:10vh">\u{1f95a}</a></div><div style="position:absolute;left:-65vh;top:40vh;width:140vh">\u{1f986}<a style="font-size:10vh">\u{1f95a}</a>\u{1f986}<a style="font-size:10vh">\u{1f95a}</a>\u{1f986}<a style="font-size:10vh">\u{1f95a}</a></div>'+(grouse?'<p style="position:absolute;text-align:right;font-size:4vh;top:80vh;width:80vh;left:-20vh;color:#888">why is there no goose emoji :-(</p>':'')):('<span style="position:relative;font-size:25vh;"><div style="position:absolute;left:-65vh;top:0;width:50vh;vertical-align:baseline">🦆<a style="position:absolute;left:37vh;top:20vh;font-size:10vh">🥚</a></div><div style="position:absolute;left:-25vh;top:0;width:50vh;vertical-align:baseline">🦆<a style="position:absolute;left:37vh;top:20vh;font-size:10vh">🥚</a></div><div style="position:absolute;left:15vh;top:0;width:50vh;vertical-align:baseline">🦆<a style="position:absolute;left:37vh;top:20vh;font-size:10vh">🥚</a></div><div style="position:absolute;left:-65vh;top:40vh;width:50vh;vertical-align:baseline">🦆<a style="position:absolute;left:37vh;top:20vh;font-size:10vh">🥚</a></div><div style="position:absolute;left:-25vh;top:40vh;width:50vh;vertical-align:baseline">🦆<a style="position:absolute;left:37vh;top:20vh;font-size:10vh">🥚</a></div><div style="position:absolute;left:15vh;top:40vh;width:50vh;vertical-align:baseline">🦆<a style="position:absolute;left:37vh;top:20vh;font-size:10vh">🥚</a></div>'+(grouse?'<p style="position:absolute;text-align:right;font-size:4vh;top:80vh;width:80vh;left:-20vh;color:#888">why is there no goose emoji :-(</p>':''))
    })
    let rings = () => {
        v.innerHTML = '<span style="position:relative;animation-name:v;animation-duration:100ms;animation-iteration-count:infinite;"><div style="position:absolute;left:-15vh;top:0">💍</div><div style="position:absolute;left:-55vh;top:15vh">💍</div><div style="position:absolute;left:25vh;top:15vh">💍</div><div style="position:absolute;left:-35vh;top:50vh">💍</div><div style="position:absolute;left:5vh;top:50vh">💍'
    }
    let birds = () => {
        v.innerHTML = mac ? '<span style="position:relative"><div style="position:absolute;left:-85vh;top:10vh;width:80vh">📞🐦</div><div style="position:absolute;left:5vh;top:10vh;width:80vh;transform:scaleX(-1)">📞🐦</div><div style="position:absolute;left:-85vh;top:50vh;width:80vh">📞🐦</div><div style="position:absolute;left:5vh;top:50vh;width:80vh;transform:scaleX(-1)">📞🐦' : '<span style="position:relative;font-size:25vh;letter-spacing:-5vh"><div style="position:absolute;left:-95vh;top:10vh;width:100vh">📞🐦</div><div style="position:absolute;left:-5vh;top:10vh;width:100vh;transform:scaleX(-1)">📞🐦</div><div style="position:absolute;left:-95vh;top:50vh;width:100vh">📞🐦</div><div style="position:absolute;left:-5vh;top:50vh;width:100vh;transform:scaleX(-1)">📞🐦'
    }
    let hens = () => {
        v.innerHTML = '<span style="position:relative"><div style="position:absolute;left:-65vh;top:10vh;"><a style="font-size:15vh;position:absolute;left:24vh;top:-3vh;">\u{1f1eb}\u{1f1f7}</a><a style="font-size:15vh;position:absolute;left:10vh">\u{1f956}</a><a style="position:absolute">\u{1f413}</a></div><div style="position:absolute;left:30vh;top:10vh;"><a style="font-size:15vh;position:absolute;left:24vh;top:-3vh;">\u{1f1eb}\u{1f1f7}</a><a style="font-size:15vh;position:absolute;left:10vh">\u{1f956}</a><a style="position:absolute">\u{1f413}</a></div><div style="position:absolute;left:-20vh;top:50vh;"><a style="font-size:15vh;position:absolute;left:24vh;top:-3vh;">\u{1f1eb}\u{1f1f7}</a><a style="font-size:15vh;position:absolute;left:10vh">\u{1f956}</a><a style="position:absolute">\u{1f413}'
    }
    let doves = () => {
        v.innerHTML = '<span style="position:relative"><div style="position:absolute;left:-50vh;top:30vh;">\u{1f422}<div style="position:absolute;top:-30%;left:-30%">\ufe0f\u{1f54a}\ufe0f</div></div><div style="position:absolute;left:25vh;top:30vh;">\u{1f422}<div style="position:absolute;top:-30%;left:-30%">\u{1f54a}\ufe0f'
    }
    let partridge = (noAnd) => (() => {
        v.innerHTML = (noAnd?'':'\u2795') + '<b style="font-size:70vh;position:relative;"><b>🌳<a style="font-size:10vh;position:absolute;left:40vh;top:20vh;">🍐</a><a style="font-size:10vh;position:absolute;left:25vh;top:40vh;">🍐</a><a style="font-size:10vh;position:absolute;left:50vh;top:45vh;">🍐</a></b><a style="font-size:20vh;position:absolute;left:10vh;top:15vh;">🐦'
        setTimeout(() => {
            document.getElementsByTagName('b')[0].style.visibility = 'visible';
            setTimeout(() => {
                document.getElementsByTagName('b')[1].style.visibility = 'visible';
            }, 1200);
        }, noAnd ? 0 : 400);
    })

    let noteLen = 0.1 * sampleRate;
    let genPeriod = sampleRate / 440;
    let gen = 0;
    let genVol;

    let bassGenPeriod = sampleRate / 440;
    let bassGen = 0;
    let bassGenVol;

    let h1GenPeriod = sampleRate / 440;
    let h1Gen = 0;
    let h1GenVol;

    let h2GenPeriod = sampleRate / 440;
    let h2Gen = 0;
    let h2GenVol;

    let noteLenCounter = 0;
    let notePtr = 0;

    let barNum = -1;
    let bar = '';
    let bassBar = '';
    let h1Bar = '';
    let h2Bar = '';
    let notes = [
        '........',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj.', 'k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.a.f.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.kkk.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.kkk.', 'mmm.h.j.kkk.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.kkk.', 'mmm.h.j.kkk.', 'mmm.h.j.kkk.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.a.f.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.k.h.', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.a.f.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.j.f.hhh.fffffffffff.',
        'a.a.aaa.f.f.fff.e.f.h.j.k.h.jjjjjj...', 'mmm.h.j.k.h.', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'mmm.h.j.k.h.', 'm.m.h.j.k.h.', 'mmm.h.j.k.h.', 'mmmmmmm.oolllll.mmmmmmmmmmmmmm..', 'mmk.j.h.fff.', 'kkk.ccc.fff.', 'hhf.e.c.aaa.', 'j.k.mmm.o.k.jj.ff.hhhhhh.rrrrrrrrrrrrrrrrr.',
    ]
    let harm1 = [
        '........',
        '...................................', '..............................',
        '.....................................', '............', '................................',
        '.....................................', '............', '............', '................................',
        '.....................................', '............', '............', '............', '................................',
        '.....................................', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmm.qqq.jjjjjjjjjjj.',
        'h.k.jjj.mmm.mmm.mmm.q.r.q.t.mmmmmm...', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'ttt.q.r.ttt.', 'vvvvvvv.ttttttt.tttttttttttttt..', 'rrr.rrr.mmm.', 'ooo.kkk.ooo.', 'ooo.lll.hhh.', 'r.r.rrr.rrr.mmmmm.yyyyyy.vvvvvvvvvvvvvvvvv.',
    ];
    let harm2 = [
        '........',
        '...................................', '..............................',
        '.....................................', '............', '................................',
        '.....................................', '............', '............', '................................',
        '.....................................', '............', '............', '............', '................................',
        '.....................................', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjj.kkk.fffffffffff.',
        'eee.fff.jjj.jjj.jjj.mmm.mmm.ffffff...', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'mmm.mmm.mmm.', 'rrrrqqq.ooooooo.rrrrrrrrqqqqqq..', 'jjj.hhh.jjj.', 'kkk.fff.kkjj', 'lll.fff.eee.', 'm.k.jjj.kkk.jjjjj.wwwwww.mmmmmmmmmmmmmmmmm.',
    ];
    let basses = [
        '........',
        '...................................', '..............................',
        '.....................................', '............', 'kkk.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmaaa.ffffffffffff',
        'aaaafffffff.fffffff.eeeeaaaaffffffff.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'mmmmmmmmmmm.', 'jjjjjjj.hhhhhhh.mmmmmmmmmmmmmm..', 'fffffffffff.', 'kkkkkkkkkkk.', 'llllhhhhmmm.', 'm.k.jjjjkkkkmmmmmmaaaaaa.ffffffffffffffffff',
    ]
    let scenes = [
        (()=>{}),intro('1\ufe0f\u20e3'), partridge(1),
        intro('2\ufe0f\u20e3'), doves, partridge(),
        intro('3\ufe0f\u20e3'), hens, doves, partridge(),
        intro('4\ufe0f\u20e3'), birds, hens, doves, partridge(),
        intro('5\ufe0f\u20e3'), rings, birds, hens, doves, partridge(),
        intro('6\ufe0f\u20e3'), geese(), rings, birds, hens, doves, partridge(),
        intro('7\ufe0f\u20e3'), swans, geese(), rings, birds, hens, doves, partridge(),
        intro('8\ufe0f\u20e3'), maids, swans, geese(1), rings, birds, hens, doves, partridge(),
        intro('9\ufe0f\u20e3'), ladies, maids, swans, geese(), rings, birds, hens, doves, partridge(),
        intro('1\ufe0f\u20e30\ufe0f\u20e3'), lords, ladies, maids, swans, geese(), rings, birds, hens, doves, partridge(),
        intro('1\ufe0f\u20e31\ufe0f\u20e3'), pipers, lords, ladies, maids, swans, geese(), rings, birds, hens, doves, partridge(),
        intro('1\ufe0f\u20e32\ufe0f\u20e3'), drummers, pipers, lords, ladies, maids, swans, geese(), rings, birds, hens, doves, partridge(),
    ]

    node.onaudioprocess = (e) => {
        let buf = e.outputBuffer.getChannelData(0);
        for (let i = 0; i < buf.length; i++) {
            if (noteLenCounter <= 0) {
                let h1Note = h1Bar.charCodeAt(notePtr);
                let h2Note = h2Bar.charCodeAt(notePtr);
                let bassNote = bassBar.charCodeAt(notePtr);
                let note = bar.charCodeAt(notePtr++);
                if (isNaN(note)) {
                    barNum++;
                    bar = notes[barNum];
                    bassBar = basses[barNum];
                    h1Bar = harm1[barNum];
                    h2Bar = harm2[barNum];
                    if (!bar) {
                        ac.close();
                        return;
                    }
                    notePtr = 0;
                    scenes[barNum]();
                    h1Note = h1Bar.charCodeAt(notePtr);
                    h2Note = h2Bar.charCodeAt(notePtr);
                    bassNote = bassBar.charCodeAt(notePtr);
                    note = bar.charCodeAt(notePtr++);
                }
                if (note == 46) { // rest
                    genVol = 0;
                } else {
                    genVol = 0.5;
                    genPeriod = notePeriods[note];
                }
                if (h1Note == 46) { // rest
                    h1GenVol = 0;
                } else {
                    h1GenVol = 0.15;
                    h1GenPeriod = notePeriods[h1Note-12];
                }
                if (h2Note == 46) { // rest
                    h2GenVol = 0;
                } else {
                    h2GenVol = 0.15;
                    h2GenPeriod = notePeriods[h2Note-12];
                }
                if (bassNote == 46) { // rest
                    bassGenVol = 0;
                } else {
                    bassGenVol = 0.2;
                    bassGenPeriod = notePeriods[bassNote-24];
                }
                noteLenCounter += noteLen;
            }
            noteLenCounter--;

            gen = (gen+1) % genPeriod;
            h1Gen = (h1Gen+1) % h1GenPeriod;
            h2Gen = (h2Gen+1) % h2GenPeriod;
            bassGen = (bassGen+1) % bassGenPeriod;
            buf[i] = genVol * (gen / genPeriod - 0.5) + h1GenVol * (h1Gen / h1GenPeriod - 0.5) + h2GenVol * (h2Gen / h2GenPeriod - 0.5) + bassGenVol * (bassGen / bassGenPeriod < 0.5 ? -0.5:0.5);
        }
    }
}
