;FASM source

RESX EQU 640
RESY EQU 480
RADIUS EQU 32
HEIGHT EQU 48

ORG 256
 MOV AH,0A0H
 MOV ES,AX
 ADD SI,SI
 PUSHA

 MOV BX,112H
 MOV AX,4F02H
 INT 10H
 MOV AH,9
 MOV DX,text
 INT 21H

 POPA
 XCHG CX,AX
.1:
 MUL BX
 STOSW
 STOSW
 PUSH DI
 SCASB
 POP AX
 JE .4
 MOV WORD [SI],RESX*4
 DIV WORD [SI]
 XCHG AX,DX
 CMP AL,94
 JB .3
 CMP AL,164
 JA .3
.2:
 SUB AX,SP
.3:
 PUSH AX
 ADD AX,14
 IMUL AX,AX,9;10;9
 SUB [SI],AX                    ; CX
 IMUL AX,DX,21
 MOV [SI+6],AL
 LODSW
 IMUL AX,DX,-HEIGHT
 ADD AX,HEIGHT*9+750-384;288
 MOV [SI],AX                    ; CY
 LODSW
 POP AX
 MOV DL,AL
 SUB AL,64
 CBW
 XOR AL,AH
 ADD AH,DL
 CWD
 XOR AH,DL
 ADD AX,AX
 MOV [SI],AX
 LODSW
 LODSB
.4:
 DEC DI
 LOOP .1

nextframe:
 PUSH DX
 SUB SI,7
 MOV CX,RESY*3-384
 MOV DI,SP
nextline:
 MOV BP,RESX*4
nextpixel:
 MOV    AX,4F05H
 SUB    DI,SP
 JNZ    nobank
 INT    10H
 INC    DX
nobank:
 PUSHA
 FILD   WORD [SI]               ; CX
 FISUB  WORD [BX-16]            ; DX
 FLD    ST0                     ; DX DX
 FMUL   ST0,ST0                 ; DX2 DX
 FILD   WORD [SI+2]             ; CY DX2 DX
 FISUBR WORD [BX-8]             ; DY DX2 DX
 FADD   ST2,ST0                 ; DY DX2 DX+DY
 FMUL   ST0,ST0                 ; DY2 DX2 DX+DY
 FADDP  ST1,ST0                 ; DY2+DX2 DX+DY
 FILD   WORD [Radius2]          ; R DY2+DX2 DX+DY
 FMUL   ST0,ST0                 ; R2 DY2+DX2 DX+DY
 FCOMI  ST0,ST1                 ; R2 DX2+DY2 DX+DY
 FSUBRP ST1,ST0                 ; R2-DX2-DY2 DX+DY
 JNA    pixelok
intersection:
 FSQRT                          ; DZ DX+DY
 FIST   WORD [SI+BP]            ; DZ DX+DY
 MOV    DX,[SI+BP]
 CMP    [ES:DI+3],DL            ; Z buffer test
 JA     pixelok
 FADD   ST1,ST0                 ; DZ N.S
 FADD   ST0,ST1                 ; N.H N.S
 FXCH   ST1                     ; N.S N.H
 FMUL   DWORD [MAXCOL-2]        ; Intensity N.H
 FISTP  WORD [SI+BP]            ; N.H
 FLD    DWORD [Shine-2]         ; Shine N.H
VideoPtr:
 MOV    AX,[SI+BP]              ; Intensity
 NOT    AH                      ; Shadow test
 AND    AL,AH                   ; Diffuse
 ADD    AL,37*2;55;37*2         ; Diffuse+Ambient
 MUL    BYTE [BX+SI+4]          ; Color*(Diffuse+Ambient)
 FCOMI  ST0,ST1                 ; Shine N.H
 SALC                           ; Highlight test
 OR     AL,AH                   ; Color*(Diffuse+Ambient)+Specular
 STOSB
 INC    BX
 JPO    VideoPtr
 XCHG   AX,DX                   ; Z coord
 STOSB                          ; write Z buffer
pixelok:
 FUCOMPP                        ; -

 POPA
 ADD    BP,SP
 JNZ    nextpixel
 DEC    CX
 DEC    CX
 LOOP   nextline
 POP DX
 CMP SI,buffer
 JA nextframe
 MOV DWORD [SI-buffer+MAXCOL+1],0A843CC3EH
 JE nextframe

;XCHG AX,CX
;INT 16H
;MOV AX,3
;INT 10H
RETN

text:   DB 'Functi N$'

MAXCOL: DB 0FAH,3FH ; DD 7.8125 ; 2*125/RADIUS
Shine:  DB 9CH,42H ; DD 78.08   ; 2.44*RADIUS
Radius2 DW RADIUS;*RADIUS

 DW 656-44,416-52
 DB 0A0H,0A0H,0C0H
buffer:
