COLOR1 EQU 15
COLOR2 EQU 116
COLOR3 EQU 236

COLOR1 EQU 37
COLOR2 EQU 45
COLOR3 EQU 236

;COLOR1 EQU 42
;COLOR2 EQU 51
;COLOR3 EQU 236

TEMPO1 EQU 23

ORG 256
 DB 3FH
 MOV DX,331H
 OUTSB

 XCHG CX,AX             ; set time counter to zero
 MOV AL,19
 INT 16

 MOV AL,77              ; set timer irq to 60Hz
 OUT 40H,AL
 OUT 40H,AL

 PUSH 0A000H+(4*320+64)/16
 POP ES

 PUSH 60*27;66
 PUSH 6

nextframe:
 HLT
 CWD
 MOV AX,CX
 MOV SI,TEMPO1
tempo:
 DIV SI
 TEST DX,DX
 JNZ skip
 CMP BP,48
 JB .1
 SUB BP,BP
 INC BYTE [tempo-2]
.1:
 MOV DX,330H
 MOV AL,90H
 OUT DX,AL
 MOV AL,[BP+notes]
 OUT DX,AL
 MOV AL,48H
 OUT DX,AL
 INC BP
skip:

 SUB DI,DI
 MUL DI
nextdot:
 MOV BH,0
 MOV SI,40F0H   ;7.5
 PUSHA          ; [DI]: 20cdH, 0, 60*66, r, x, t, y, i, ?, ?, 40F0H, 0
;FLD1           ; 1

; f(tixy)=sin(t*(x-7.5)*(y-7.5)/66)
 FILD WORD [DI-10]      ; t
 FIDIV WORD [DI-4]      ; t/Hz/66
 FILD WORD [DI-8]       ; x t/Hz/66
 FSUB DWORD [DI-22]     ; x-7.5 t/Hz/66
 FILD WORD [DI-12]      ; y x-7.5 t/Hz/66
 FSUB DWORD [DI-22]     ; y-7.5 x-7.5 t/Hz/66
 FMULP
 FMULP
 FSIN

;FUCOMI ST0,ST1          ; clamping [-1,+1]
;FCMOVNB ST0,ST1
;FXCH
;FCHS
;FUCOMI ST0,ST1
;FCMOVB ST0,ST1
 FIMUL WORD [DI-6]

 POPA
 MOV BH,16
 MOV SI,BX
 FIST WORD [BX]
 SAR WORD [BX],15
 FMUL ST0,ST0
 FISTP WORD [BX+SI]
;FSTP ST0

 INC BL
 INC AX
 AND AL,15
 JNZ nextdot
 INC DX
 TEST BL,BL
 JNZ nextdot

.1:
 MOV DH,-6
.2:
 MOV DL,-6
.3:
 MOV AL,DL
 IMUL AL
 XCHG SI,AX
 MOV AL,DH
 IMUL AL
 ADD AX,SI
 INC AX
 MOV SI,BX
 CMP AX,[BX+SI]
 MOV AL,COLOR3
 JZ .4
 SALC
 JNC .4
 MOV AL,COLOR2-COLOR1
 AND AL,[BX]
 ADD AL,COLOR1
.4:
 STOSB
 INC DL
 CMP DL,6
 JNE .3
 INC BL
 TEST BL,15
 JNZ .2
 SUB DI,-(320-16*12)
 SUB BL,BH
 INC DH
 CMP DH,DL
 JNE .2
 ADD BL,BH
 JNZ .1

 INC CX
 IN AL,60H
 DEC AX
 JNZ nextframe

exit:
 OUT 40H,AL
 OUT 40H,AL
 MOV AL,3
 INT 16
 INT 32

notes:
db 67,74,79,86,82,91
db 60,67,75,82,79,87
db 65,72,77,84,81,89
db 58,65,74,81,77,86
db 55,62,67,74,70,79
db 60,67,75,82,79,87
db 62,69,74,81,78,86
db 55,62,71,79,74,83
