.autoimport
.importzp _upd_off,_oam_off,_oam_step
.importzp _pal_scr,_pal_req



.segment "ZEROPAGE"

SPR_X:					.res 2
SPR_Y:					.res 2
SPR_XOFF:				.res 2
SPR_YOFF:				.res 2
SPR_PAL:				.res 1
SPR_PTR:				.res 2



.segment "FIXED"



ft_music_play_buf:

	cli			;very important, it allows MMC3 IRQ to overlap music player in NMI
	
	lda <MUSIC_PRG
	jsr mmc3_set_prg_temp
	
	jsr ft_music_play
	
	lda <BUF_4000
	sta $4000
	lda <BUF_4001
	sta $4001
	lda <BUF_4002
	sta $4002

	lda <BUF_4003
	cmp <PREV_4003
	beq :+
	sta <PREV_4003
	sta $4003
:

	lda <BUF_4004
	sta $4004
	lda <BUF_4005
	sta $4005
	lda <BUF_4006
	sta $4006

	lda <BUF_4007
	cmp <PREV_4007
	beq :+
	sta <PREV_4007
	sta $4007
:

	lda <BUF_4008
	sta $4008
	lda <BUF_4009
	sta $4009
	lda <BUF_400A
	sta $400A
	lda <BUF_400B
	sta $400B
	lda <BUF_400C
	sta $400C
	lda <BUF_400D
	sta $400D
	lda <BUF_400E
	sta $400E
	lda <BUF_400F
	sta $400F
	
	rts
	
	
	
;void __fastcall__ ovl_call(unsigned char prg,void (*func)(void));

.export _ovl_call

_ovl_call:

	sta <TEMP+1
	stx <TEMP+2
	
	lda #$4c			;JMP
	sta <TEMP+0
	
	jsr popa
	jsr mmc3_set_prg

	jsr TEMP

	lda #PRG_MAIN
	jmp mmc3_set_prg	;jsr:rts

;------------------------------------------------------------------------------

;void __fastcall__ oam_clear_fast(void);

.export _oam_clear_fast

_oam_clear_fast:

	lda #240

	.repeat 64,I
	sta OAM_BUF+I*4
	.endrepeat

	rts
	
;------------------------------------------------------------------------------	
	
timing_delay:

;;;;;;;;;;;;;;;;;;;;;;;;
; Delays A clocks + overhead
; Clobbers A. Preserves X,Y.
; Time: A+25 clocks (including JSR)
;;;;;;;;;;;;;;;;;;;;;;;;
                  ;       Cycles              Accumulator         Carry flag
                  ; 0  1  2  3  4  5  6          (hex)           0 1 2 3 4 5 6
                  ;
                  ; 6  6  6  6  6  6  6   00 01 02 03 04 05 06
:      sbc #7     ; carry set by CMP
delay_a_25_clocks:
       cmp #7     ; 2  2  2  2  2  2  2   00 01 02 03 04 05 06   0 0 0 0 0 0 0
       bcs :-     ; 2  2  2  2  2  2  2   00 01 02 03 04 05 06   0 0 0 0 0 0 0
       lsr        ; 2  2  2  2  2  2  2   00 00 01 01 02 02 03   0 1 0 1 0 1 0
       bcs *+2    ; 2  3  2  3  2  3  2   00 00 01 01 02 02 03   0 1 0 1 0 1 0
       beq :+     ; 3  3  2  2  2  2  2   00 00 01 01 02 02 03   0 1 0 1 0 1 0
       lsr        ;       2  2  2  2  2         00 00 01 01 01       1 1 0 0 1
       beq @rts   ;       3  3  2  2  2         00 00 01 01 01       1 1 0 0 1
       bcc @rts   ;             3  3  2               01 01 01           0 0 1
:      bne @rts   ; 2  2              3   00 00             01   0 1         0
@rts:  rts        ; 6  6  6  6  6  6  6   00 00 00 00 01 01 01   0 1 1 1 0 0 1
; Total cycles:    25 26 27 28 29 30 31

;------------------------------------------------------------------------------


;void morph_palette(void);

MP_COL1=TEMP+0
MP_COL2=TEMP+1
MP_HUE1=TEMP+2
MP_HUE2=TEMP+3
MP_BRIGHT1=TEMP+4
MP_BRIGHT2=TEMP+5

.export _morph_palette

_morph_palette:

	ldx #0

@loop:

	txa
	beq :+
	and #3
	bne :+
	jmp @skip
	
:
	ldy _pal_req,x	;col2
	sty <MP_COL2
	lda _pal_scr,x	;col1
	sta <MP_COL1

	cpy #$30
	bne @notwhite
	
	clc
	adc #$10
	cmp #$40
	bcc :+
	lda #$30
:
	sta <MP_COL1

	jmp @next
	
@notwhite:

	and #$0f
	sta <MP_HUE1
	tya
	and #$0f
	sta <MP_HUE2
	cmp <MP_HUE1
	beq @bright
	
	lda <MP_COL1
	and #$0f
	cmp #$0e
	bcc :+
	lda <MP_COL2
	and #$0f
	sta <MP_COL1
	
	jmp @next
	
:

	lda <MP_HUE1
	cmp <MP_HUE2
	beq @bright
	bcs :+
	
	inc <MP_COL1
	jmp @next
	
:

	dec <MP_COL1
	jmp @next

@bright:

	lda <MP_COL1
	and #$f0
	sta <MP_BRIGHT1
	lda <MP_COL2
	and #$f0
	sta <MP_BRIGHT2
	
	cmp <MP_BRIGHT1
	beq @next
	bcc :+
	
	lda <MP_COL1
	clc
	adc #$10
	sta <MP_COL1
	jmp @next
	
:

	lda <MP_COL1
	sec
	sbc #$10
	sta <MP_COL1
	jmp @next

@next:

	lda <MP_COL1
	sta _pal_scr,x
	
@skip:

	inx
	cpx #16
	beq :+
	jmp @loop
:
	rts