; Cloudy by Abaddon
; code: TomCat
; cloud texture idea: Geoffrey Y. Gardner (1985)

XPHASE EQU SI
YPHASE EQU SI+1
XYPHASE EQU SI

ORG 256
 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

 MOV FS,AX
 MOV AL,13H
colors:
 INT 10H
 MOV CH,48
 IMUL DX,BX,64
 MOV AX,1010H
 INC BL
 JNZ colors

 MOV BH,50
costab:
 FLDPI                  ; PI
 FMUL DWORD [SI]        ; PI/128
 FIMUL WORD [DI]        ; counter*PI/128
 FCOS                   ; COS(counter*PI/128)
 FIMUL WORD [SI]        ; 127*COS(counter*PI/128)
 FISTP WORD [BX+SI]     ; -
 INC BX
 INC BYTE [DI]          ; loop 256x
 JNZ costab             ; BX = cosinus table

 MOV DX,logo
 MOV AH,9
 INT 21H
 PUSH 0A000H
 POP ES
 MOV AH,31
copytext:
 MOV CL,[ES:SI]
 MOV DX,7F80H
 MOV GS,DX
 SHR DX,CL
 MOV [DI+2+155*320+76-200],DX
 INC DI
 CMPSB
 DEC AX
 JNZ copytext

nextpixel:              ; XPhase=0.9, YPhase=0.7
 MOV AX,0CCCDH
 MUL DI
 SUB DH,200+29H
 NEG DH
 MOV AX,1329H           ; Hello Hellmood, Memories is so great!
 div dh                 ; reverse divide AL = C/Y'
 xchg dx,ax             ; DL = C/Y', AL = X
 mul dl                 ; AH = CX/Y'
 ADD DL,[FS:46CH]
 MOV DH,AH

 MOV WORD [XPHASE],37+256*29
 MOV BP,77*77           ; BP:Amplitude*Amplitude=0.3*0.3
 MOV CX,6+256*5         ; CL:XFreq=2*PI*0.023, CH:YFreq=2*PI*0.021
 SUB AX,AX
fori:
 PUSH DX
 PUSH AX
 MOV AL,DH
twice:
 ADD AL,[YPHASE]
 MUL CH
cosine:
 MOV BL,AL
 MOV AL,[BX]
 CBW
 ADD AX,54
 XCHG DX,AX
 XCHG CL,CH
 XOR SI,1
 JPE twice
 IMUL DX
 IMUL BP
 POP AX
 ADD DX,AX
 POP AX
 PUSH AX
 PUSH DX
 MOV BL,AH
 MUL CL
 XCHG AL,BL
 MOV DH,[BX]            ; DH:YPHASE
 MUL CH
 MOV BL,AL
 MOV DL,[BX]            ; DL:XPHASE
 MOV [XYPHASE],DX
 POP AX
 POP DX

 SHR BP,1
 SHL CX,1
 JNS fori

 NEG AH                 ; AL:CLAMP(0..255)
 JZ .1
 CWD
 XCHG AX,DX
.1:

 MOV [GS:DI],AL
nextframe:
 INC DI
 JNZ nextpixel

 PUSH DI

blur:                   ; 4x4
.1:
 MOV BP,SP              ; BP:-4
 SALC
.2:
 ADD BP,320
 CMC
 JBE .3
 SUB BP,4*320-1
.3:
 ADD AL,[GS:DI+BP]
 ADC AH,0
 TEST BP,BP
 JNZ .2
 SHR AX,4
 OR AL,1
 MOV [GS:DI],AL
 INC DI
 JNZ .1

 MOV CX,320*166
 MOV SI,320*38
 MOV DI,320*17
copy:
 CMP CH,BH
 JA .1
 XOR AL,[SI]
 JPE .2
.1:
 GS
.2:
 MOVSB
 SALC
 LOOP copy

 POP DI

 IN AL,60H
 DAS
 JC nextframe

RETN

logo:
 DB 10,10,'ABADDON$'
