#version 450

uniform float time;
uniform mat4 mvp;

in vec4 a_position;
in vec3 a_normal;
in vec2 a_texcoord;

out VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} outData;

mat2 rot(float t) {
    float c = cos(t), s = sin(t);
    return mat2(c, s, -s, c);
}

void march(inout vec3 p, inout vec3 n, float r, float a) {
    vec3 c = p + r * n;
    mat2 m = rot(a * sign(r));
    p -= c;
    p.xy *= m;
    n.xy *= m;
    p += c;
}

vec3 map(float t)
{
    if (t < 0.2) return vec3(.6, 3.14/2., .2);
    if (t < 0.4) return vec3(-.3, 1.6*3.14, .4 + mix(-.4, .0, fract(time)));
    return vec3(.6, 3.14, .5);
}

const float instanceCount = 120;
void recmarch(inout vec3 p, inout vec3 n, int idx, int offset)
{
    float speed = 0.2;
    float fl = floor(mix(.2, 1., idx/instanceCount) + time * speed);
    float cx = clamp(mix(.2, 1., (idx + offset)/instanceCount) + time * speed - fl, 1./instanceCount, 1);
    n = vec3(0.,-1.,0.);
    p = vec3(0.);
    float t = 0.;
    for (int i = 0 ; i < 20 ; ++i) {
        vec3 s = map(t);
        s.y *= min((cx - t) / s.z, 1.0);
        march(p, n, s.x, s.y);
        t += s.z;
        if (t > cx) break;
    }
}

void main() {
	vec4 p = vec4(a_position.xyz, 1.0);

	p.x += gl_InstanceID;

	//p.z -= 1.0;
	gl_Position = mvp * p;
}
