#version 450

uniform float time;
uniform mat4 mvp;

in vec4 a_position;
in vec3 a_normal;
in vec2 a_texcoord;

out VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} outData;

void main() {
	vec4 p = a_position;
	p.xy *= vec2(1.77, 1.) * 2.0;
    gl_Position = mvp * p;

    outData.v_position = p;
    outData.v_normal = a_normal;
    outData.v_texcoord = a_texcoord;
}
