#version 150

uniform float time;

in VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} inData;

out vec4 fragColor;

float sat(float x) { return clamp(x, 0., 1.); }
float demix(float a, float b, float t) { return (t - a) / (b - a); }

void main(void)
{
    vec2 uv = -1. + 2. * inData.v_texcoord;
    uv.x /= 1.77;

    float t = mix(0., 1., sat(demix(0., 5., time)));

    uv.x *= 10;

    vec3 col = sin(t)+.5 + 1.5 * sin((vec3(.0,.33,.67) + uv.x) * 6.28);

    col *= step(abs(uv.x - .1), .5);

    float ypos = mix(-1., 1., pow(sat(demix(1., 2., time)), .3));
    col *= step(uv.y, ypos);

    fragColor = vec4(col, 1.0);

    float fade = mix(1., 0., smoothstep(3., 3.5, time));
    fragColor*= fade;
}
