#version 150

uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform vec3 spectrum;
uniform mat4 mvp;
uniform sampler2D passA;

in vec4 a_position;
in vec3 a_normal;
in vec2 a_texcoord;

out VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} outData;

float sat(float x) { return clamp(x, 0., 1.); }
float demix(float a, float b, float t) { return (t - a) / (b - a); }

mat2 rot(float t) {
    float c = cos(t), s = sin(t);
    return mat2(c, s, -s, c);
}

void march(inout vec3 p, inout vec3 n, float r, float a) {
    vec3 c = p + r * n;
    mat2 m = rot(a * sign(r));
    p -= c;
    p.xy *= m;
    n.xy *= m;
    p += c;
}

vec3 map0(float t)
{
    float dt = 0, l = 0;
    l += dt; dt = .2; if (t < l + dt) return vec3(-.45, 3.14/2.*3., dt);
    l += dt; dt = .05; if (t < l + dt) return vec3(.4, 3.14/4., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.5, 3.14/4.*3., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.3, 3.14*2., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(.3, 3.14*1., dt);
//    l += dt; dt = .2; if (t < l + dt) return vec3(-.3, -3.14*1., dt);
    return vec3(0., 3.14, .5);
}

vec3 map1(float t)
{
    float dt = 0, l = 0;
    l += dt; dt = .2; if (t < l + dt) return vec3(-1.5, 3.14/4., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(.3, 3.14, dt);
    return vec3(0., 3.14, .5);
}

vec3 map2(float t)
{
    float dt = 0, l = 0;
    l += dt; dt = .2; if (t < l + dt) return vec3(-1.5, 3.14/4.*.5, dt);
    l += dt; dt = .1; if (t < l + dt) return vec3(.1, 3.14/2.*.5, dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(.3, 3.14*1., dt);
    return vec3(0., 3.14, .5);
}

vec3 map3(float t)
{
    float dt = 0, l = 0;
    l += dt; dt = .2; if (t < l + dt) return vec3(-1.5, 3.14/8., dt);
    l += dt; dt = .05; if (t < l + dt) return vec3(-.2, 3.14/2.*1.5, dt);
    l += dt; dt = .1; if (t < l + dt) return vec3(1.5, 3.14/8., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.1, 3.14/2., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.3, 3.14*1.3, dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-1.6, 3.14/8., dt);
    return vec3(0., 3.14, .5);
}

const vec3 start_p[] = vec3[](
    vec3(-1., 0., 0.),
    vec3(.73, .85, 0.),
    vec3(.85, -.7, 0.),
    vec3(1.1, .1, 0.)
);

const vec3 start_n[] = vec3[](
    vec3(1., 0., 0.),
    vec3(cos(3.14-3.14/4.), sin(3.14-3.14/4.), 0.),
    vec3(cos(3.14/4.), sin(3.14/4.), 0.),
    vec3(cos(3.14-3.14/8.), sin(3.14-3.14/8.), 0.)
);

void recmarch(inout vec3 p, inout vec3 n, int idx, int offset, int mapIndex, float instanceCount)
{
    float speed = 0.2;
    float fl = floor(mix(.2, 1., idx/instanceCount) + time * speed);
    float cx = clamp(mix(.2, 1., (idx + offset)/instanceCount) + time * speed - fl, 1./instanceCount, 1);
    n = start_n[mapIndex];
    p = start_p[mapIndex];
    float t = 0.;
    for (int i = 0 ; i < 20 ; ++i) {
        vec3 s = mapIndex < 2 ? mapIndex == 0 ? map0(t) : map1(t) : mapIndex == 2 ? map2(t) : map3(t);
        s.y *= min((cx - t) / s.z, 1.0);
        march(p, n, s.x, s.y);
        t += s.z;
        if (t > cx) break;
    }
}

void main(void)
{
    int instance_count = 2400;
    int layer_count = 2;
    int shape_count = 4;
    int layer_len = instance_count / layer_count;
    int udx = gl_InstanceID / layer_len;
    int layer_idx = udx;
    int idx = gl_InstanceID % layer_len;
    int shape_len = layer_len/shape_count;
    int shape_idx = idx/shape_len;
    vec3 part;

    float glitch1 = mix(.0, .1, sat(demix(3., 3.5, time)));
    float glitch2 = mix(.0, 6., max(
        pow(sat(demix(11.9, 12., time)), .5) * .1,
        pow(sat(demix(12., 13., time)), .5)
    ));
    float glitch3 = mix(.0, .1, step(time, 10.) - step(time, 10.05) + step(time, 10.1) - step(time, 10.2));

    vec3 c0, n0;
    recmarch(c0, n0, idx, 0, shape_idx, float(shape_len));
    vec3 c1, n1;
    recmarch(c1, n1, idx, 1, shape_idx, float(shape_len + glitch3 * layer_len/2));

    float fy = a_position.y*.5+.5;
    vec3 n = mix(n0, n1, fy);
    vec3 c = mix(c0, c1, fy);

    vec4 p = a_position;
    //p = mix(p-vec4(.5,.0,.0,0.), p, a_position.y);
    part = (c + n * a_position.x*.1);
    part.z -= udx * glitch1 * pow(1. - fract(time * 2. + part.y), 4.);
    //p.xz *= rot(1.*time);
    p.x *= 1.;
    p.xy *= rot(-atan(n.y, n.x));
    p.xyz *= .02;
    p.xyz = part;

    p.xyz *= mix(10., 1., sat(demix(0., 6., time)));

    p.xyz += glitch2 * n0;

    gl_Position = mvp * p;
    outData.v_position = p;
    outData.v_normal = a_normal;
    outData.v_texcoord = vec2((gl_InstanceID+a_position.y*.5+.5)/120.,a_position.x*.5+.5);
}
