#version 150

uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform vec3 spectrum;

uniform sampler2D prevFrame;
uniform sampler2D prevPass;

in VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} inData;

out vec4 fragColor;

void main(void)
{
    vec2 uv = inData.v_texcoord;
    vec3 col = sin(time*2.)+.5 + 1.5 * sin((vec3(.0,.33,.67) + uv.y) * 6.28);
    fragColor = vec4(col, 1.0);

    fragColor *= 1. - smoothstep(12.5, 13., time);
}
