#version 150

uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform vec3 spectrum;
uniform mat4 mvp;
uniform sampler2D passA;

in vec4 a_position;
in vec3 a_normal;
in vec2 a_texcoord;

out VertexData
{
    vec4 v_position;
    vec3 v_normal;
    vec2 v_texcoord;
} outData;

mat2 rot(float t) {
    float c = cos(t), s = sin(t);
    return mat2(c, s, -s, c);
}

void march(inout vec3 p, inout vec3 n, float r, float a) {
    vec3 c = p + r * n;
    mat2 m = rot(a * sign(r));
    p -= c;
    p.xy *= m;
    n.xy *= m;
    p += c;
}

vec3 map1(float t)
{
    float dt = 0, l = 0;
    l += dt; dt = .2; if (t < l + dt) return vec3(-.45, 3.14/2.*3., dt);
    l += dt; dt = .05; if (t < l + dt) return vec3(.4, 3.14/4., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.5, 3.14/4.*3., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.3, 3.14*2., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(.3, 3.14*1., dt);
    l += dt; dt = .2; if (t < l + dt) return vec3(-.3, -3.14*1., dt);
    return vec3(.6, 3.14, .5);
}

vec3 map2(float t)
{
    float dt = 0, l = 0;
    l += dt; dt = .2; if (t < l + dt) return vec3(-1.5, 3.14/4., dt);
    l += dt; dt = .05; if (t < l + dt) return vec3(.3, 3.14, dt);
    return vec3(1.6, 3.14, .5);
}

const float instanceCount = 120;
void recmarch(inout vec3 p, inout vec3 n, int idx, int offset, int mapIndex)
{
    float speed = 0.2;
    float fl = floor(mix(.2, 1., idx/instanceCount) + time * speed);
    float cx = clamp(mix(.2, 1., (idx + offset)/instanceCount) + time * speed - fl, 1./instanceCount, 1);
    n = mapIndex == 1 ? vec3(1.,0.,0.) : vec3(rot(3.14-3.14/4.)[0],0.);
    p = mapIndex == 1 ? vec3(-1.,0.,0.) : vec3(.75,.85,0.);
    float t = 0.;
    for (int i = 0 ; i < 20 ; ++i) {
        vec3 s = mapIndex == 1 ? map1(t) : map2(t);
        s.y *= min((cx - t) / s.z, 1.0);
        march(p, n, s.x, s.y);
        t += s.z;
        if (t > cx) break;
    }
}

void main(void)
{
    int udx = gl_InstanceID / 120;
    int layer_idx = udx / 2;
    int shape_idx = udx % 2;
    vec3 part;
    
    vec3 c0, n0;
    recmarch(c0, n0, gl_InstanceID, 0, shape_idx);
    vec3 c1, n1;
    recmarch(c1, n1, gl_InstanceID, 1, shape_idx);
    
    float fy = a_position.y*.5+.5;
    vec3 n = mix(n0, n1, fy);
    vec3 c = mix(c0, c1, fy);

    vec4 p = a_position;
    //p = mix(p-vec4(.5,.0,.0,0.), p, a_position.y);
    part = (c + n * a_position.x*.1);
    part.z -= udx * .4 * pow(1. - fract(time * 2. + part.y), 4.);
    //p.xz *= rot(1.*time);
    p.x *= 1.;
    p.xy *= rot(-atan(n.y, n.x));
    p.xyz *= .02;
    p.xyz = part;

    p.xyz *= 2;

    gl_Position = mvp * p;
    outData.v_position = p;
    outData.v_normal = a_normal;
    outData.v_texcoord = vec2((gl_InstanceID+a_position.y*.5+.5)/instanceCount,a_position.x*.5+.5);
}
