/*

  Copyright 2019 Jari Sihvola
  Licensed under GPLv3

---

Compiling from the command line:
g++ hk.cpp -lpthread -lopenmpt -lportaudiocpp -lSDL2 -lSDL2_image -lSDL2_ttf -std=gnu++11 -o hk

Note: This file needs to be in ISO-8859 format


Kehitettv enginess:
-rintamasuunta pit tll hetkell vaihtaa johonkin mrittelemttmn arvoon, ett hahmojen erikoisanimaatiot nkyisivt
-kamerax ja -rect -arvoja pit vaihtaa, kun testaa koodia jostain kohdasta, miss kamera ei ole alkupisteess
-Jos asettaa framen tarinafunktiosta, voi rintamasuunnan arvo aiheuttaa kuitenkin framen muuttumisen joksikin muuksi, jos hahmo samalla pyshtyy. Tst selvi vaihtamalla rintamasuunta tysin mrittelemttmn arvoon, mutta se ei ole kovin elegantti ratkaisu.
-Jos flip on pll, se pit tarinafunktiossa laittaa pois, jos knt hahmon rintamasuuntaa tmn ollessa paikallaan. Thn voi tehd erillisen funktion rintamasuunnan kntmiseen, joka poistaa flipin paitsi, jos on permaflip. Sellainenkin ratkaisu olisi mahdollinen, ett esim 1 rintamasuunnan arvon eteen, jolloin hahmonpiirto muuttaisi sen flipiksi (esim. 18 on suunta yls ja flip).
-IRCin alkurivit eivt omaa rivinvaihtoa. Sen toteuttaminen olisi kuitenkin melkoisen tylst, kun rivit koostuvat erivrisist tekstuureista. Tekstuureita ei myskn eksplisiittisesti vapauteta. Renderoijan tuhoamisksky ky lpi loput tekstuurit.
-Liian iso alakupla ei rajaudu automaattisesti vaan voi jd tysin nkymttmiin (miten ylkupla ja sivukupla?)
-Jotta "hyv tavaton" -kohdassa toimisi tuo insert_kupista laitettu ilme, kuten "sittenhn" -kohdassa, siin pit olla ensin tuo kissa.ilme = 1. Ei ole tysin varma, kumpi noista kohdista nyt varsinaisesti on bugi, mutta ensimminen tuntuu toimivan paremmin. Siin kohti on jo valmiiksi ilme = 1, joten ehk se jostain syyst pit olla.
-Frame-vlhdys-bugeja (kvelyn loppuessa tai muussa muutoksessa vlht yksi vr frame) on korjattu nopeilla ratkaisuilla ja niit varmaan viel ilmestyy lis. Hahmonpiirto-funktion logiikkaa voisi ehk mietti uudestaan tt ongelmaa silmll piten
-Ohjelmoijan ja kyttjn tontit voisi erotella selkemmin hahmoluokassa ja tarinafunktiossa
-Erillinen huomio: framet 27-30 koodissa viittaavat epsymmetrisiin (vasemmalle) kvelyframeihin, joita ei flipata. 31 on epsymmetrinen vasemmalleseisomisframe ja 32 on epsymmetrinen vasemmallepuhumisframe


*/

#include <iostream>
#include <string>
#include <vector>
#include <cmath>
#include <time.h>
#include <unistd.h>
#include <algorithm>
#include <exception>
#include <fstream>
#include <new>
#include <stdexcept>
#include <pthread.h>

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_ttf.h>
#include <libopenmpt/libopenmpt.hpp>
#include <portaudiocpp/PortAudioCpp.hxx>

using namespace std;

const int RUUDUNLEVEYS = 680;
const int RUUDUNKORKEUS = 480;
const int KNOPEUS = 3; //Kvelynopeuden kerroin
bool quit = false;
bool fullscreen = false;
int kieli = 1; //1 = suomi, 2 = englanti
bool kameranollaus = false;
int kamerax1 = 0; //Tt on muutettava (esim. 530 tai 1280), jos aloitetaan debugatessa muualta kuin taustakuvan vasemmasta reunasta
int kamerax2 = RUUDUNLEVEYS;
int kamskrolli = 0; //0 = kameran liikutus pois plt, 1 = vasemmalle, 2 = oikealle
SDL_Rect kamrect = {0, 0, RUUDUNLEVEYS, RUUDUNKORKEUS}; //Mys tt on usein muutettava, jos aloitetaan debugatessa muualta kuin 0:sta
int skrollihalt;  //Mihin skrollaus pyshtyy. Maksimiarvo tlle on kuvan koko X-akselilla miinus RUUDUNLEVEYS (eli 1280 tss produktiossa, jossa 1960 on taustakuvan X-koko)
bool feidaus = false; //Vai pitisik olla int, jolloin eri numeroilla saisi eri nopeuksia

//Tarinanvaihe kertoo, miss vaiheessa tarinaa ollaan menossa.
//Jos tarinakeskeytys on true, plooppi ky hakemassa uusia tietoja tarinafunktiosta, jolloin uudet muuttujien arvot mrytyvt tarinanvaiheen mukaan.
int tarinanvaihe = 3; //Arvo oltava pienempi kuin ensimminen koodissa kytettv arvo
bool tarinakeskeytys = true;
int tarina_t = 0; //Tarinafunktion yleistimer: montako sekunttia odotellaan (muunnetaan millisekunneiksi)
int tarina_kt = 0; //Kuplanluonnista asetettava timer-arvo, joka siirt arvonsa tarina_t:lle
int ruokaa = 0; //0 = off, 1 = on, 2 = stop;
bool drop = false;
bool kesktark();

SDL_Rect kissa_arkki[33];
SDL_Rect kissak_arkki[20];
SDL_Rect koira2_arkki[23];
SDL_Rect koira1_arkki[23];
SDL_Rect naata_arkki[23];
SDL_Rect mayra_arkki[30];
SDL_Rect drops_arkki[16];
SDL_Rect piirtorect;

//Oikeat arvot merkinpituudelle- ja korkeudelle saa, kun katsoo coutilla, mit tekstirend-funktion surfacen antamat w & h -arvot ovat. Korkeus tulee suoraan, merkinleveyden saa jakamalla jotain rivi kuvaavan surfacen leveyden jonkun rivin merkkien mrll
const int merkinpituus = 9;
const int merkinkorkeus = 18;
const int RIVIVALI = 0;

//Puhekuplan muuttujat
string vuorosana1;
vector<string> vuorosanavec;
int kuplantila = 0; //Onko puhekupla pll (0 = ei kuplaa, 1 = alustusvaihe, 2 = puhekupla on pll, 3 = tekstiskrolli, 4 = pern toinen kupla, 5 = kuplan poistaminen, 6 = tauko kuplan jlkeen)
double ylirivit = 0;
struct kupla {
  int timer = 0;
  int kuka = 0;
  int pituus = 0;
  int korkeus = 0;
  string puhe = "";
  int asemointi = 1; //Kupla voi olla yl- (1), alapuolella (2) hahmoa tai hahmon ylsivulla (3), sivulla keskell (4) tai alasivulla (5)
  int vilme = 1;
};
vector<kupla> kuplavec; //Vektori, johon voi laittaa perttisi puhekuplia
int bubblew; //Kuplan vasen laita
int bubbleh; //Kuplan yllaita
int bubblew2; //Kuplan leveys (ml. borderit)
int bubbleh2; //Kuplan korkeus yllaidasta laskien
int kupasema;
const int OLETUSKUPLANPITUUS = 360;
const int OLETUSKUPLANKORKEUS = 140;
const int KUPYLABORDER = 5;
const int KUPALABORDER = 5;
const int KUPVASBORDER = 15;
const int KUPOIKBORDER = 15;
//Puhekuplassa pituus on primrinen arvo, jonka perusteella katkotaan vuorosanan rivit ja sitten korkeus voidaan 0-arvolla sopeuttaa automaattisesti oikeaksi pituuden ja rivien avulla
//Tarinafunktiossa sdettvt kuplan pituus ja korkeus
int kuplanpituus = 0; //0 = Oletuskuplanpituus, muut positiiviset arvot on x-akselin arvoja
int kuplankorkeus = 0; //0 = sdetn tekstin pituuden mukaan, 1= laitetaan oletuskuplankorkeus, muut positiiviset arvot viittavat y-koordinaatteihin
int tempkuppituus = 0;
int tempkupkorkeus = 0;
int kuplavo = 0; //1=kupla vasemmalle hahmosta, 2=kupla oikealle, 0=sijainnin mukaan (jos hahmo kuvaruudun vasemmalla puoliskolla, kupla oikealle ja toisin pin)
SDL_Rect kupla1; //Kuplan levempi pala
SDL_Rect kupla2; //Kuplan korkeampi pala
SDL_Rect cliprect; //Neli, jolla peitetn alueet, joihin rendataan, kun muualle ei. Kytetn ainakin puhekuplan tekstiskrollissa, ett teksti katoaisi kuplan yllaidassa
pair<double, double> *kuppoint; //Pointteri hahmon sijaintiarvoihin, joista kuplan koordinaatit otetaan

//Tekstin rendauksessa ja jrjestelyss kytettyj muuttujia
TTF_Font* fontti;
SDL_Surface* pinta2;
SDL_Texture* tekstuuri2;
int rivinpituus;

//Muuttujat, joilla puhekuplan kursoria ohjaillaan (nm ovat default-arvot, joita ei saa tss vaiheessa muuttaa).
pair<int, int> mikarivi; //Ensimminen luku nytt, mill kuplan rivill kursori menee ja toinen nytt, mill vuorosanavektorin rivill kursori menee. Nm voivat erkaantua teksti skrollatessa.
int moneskirjain = 0;
int kursoripaalla = 0; //0 = ei kursoria, 1 = kursori juoksee, 2 = kursori odottaa, ett skrollataan puhekuplanteksti ylemms, 3 = kursori maalissa
int kursorikountteri = 0;
int pkupkounter = 0;
SDL_Color vaeri = {0, 0, 0}; //Tekstinvri

//Tekstin skrollauksen muuttujat
bool tekstiskrolli = false; //Onko skrollaus menossa vai ei
int skrollausarvo = 0; //Teksti skrollaa, jos tm on > 0

//Hahmot
bool hahmoja = false;
bool kirjoittelu = false;
bool init();
bool lataamedia();
void sammutus();

//Pikkuna ja renderij
SDL_Window* ikkuna = NULL;
SDL_Renderer* piirturi = NULL;

//IRC
int IRC = 0; //0 = ei IRC-nkym, 1 = IRC-nkym, 2 = poistutaan IRC-nkymst
int merkkikohta = 1; //Miss kohtaa kyttjn kirjoitus menee
SDL_Color ircvari = {255, 255, 255};
SDL_Color joinvari = {255, 255, 255};
SDL_Color nimilista = {255, 255, 255};
struct irc_rivi {
  SDL_Texture *aikaleima;
  SDL_Texture *nikki;
  SDL_Texture *sanoma;
  int npituus;
  int vpituus;
  int ajastin = 0;
  string kirjoitus = "";
};
SDL_Texture *irc_kirjoitus; //Kyttjn kirjoitusta varten
int irc_rivisiirto = 0;
irc_rivi generic_irc_rivi;
vector<irc_rivi> irc_teksturet;
const int irc_MERKINPITUUS = 9;
const int irc_MERKINKORKEUS = 18;
const int irc_RIVIVALI = 0;
const int irc_rivimaara = RUUDUNKORKEUS/irc_MERKINKORKEUS;
TTF_Font* irc_fontti;
TTF_Font* irc_fontti_b;
int aika_leveys;
int as_leveys;
int ks_leveys;
SDL_Texture* aika1;
SDL_Texture* aika2;
SDL_Texture* aika3;
SDL_Texture* apaika; //Alapalkin kellonaika
int irc_aika = 1; //Ajanvaihdos irc-riveilt alapalkkiin

struct lteksti {
  SDL_Texture *ltekstuuri;
  SDL_Rect loppurect;
  bool taukoa = false;
};
vector<lteksti> ltekstit; //lopputekstit
vector<lteksti> ltekstit2;
lteksti generic_lteksti;
bool lopputekstit;
SDL_Color loppuvari = {245, 233, 0};
SDL_Color loppuvari2 = {130, 121, 0};
TTF_Font* loppufontti;

int alkutekstit = 0;
SDL_Surface* apinta1;
SDL_Surface* apinta2;
SDL_Surface* apinta3;
SDL_Surface* apinta4;
SDL_Texture* atekstuuri1;
SDL_Texture* atekstuuri2;
SDL_Texture* atekstuuri3;
SDL_Texture* atekstuuri4;
SDL_Rect arect1;
SDL_Rect arect2;
SDL_Rect arect3;
SDL_Rect arect4;
SDL_Rect sydrect;

const size_t aanipuskuri = 168;
const int32_t naytteenottoaste = 22010;
vector<float> vkanava(aanipuskuri);
vector<float> okanava(aanipuskuri);
const float *const kpuskurit[2] = {vkanava.data(), okanava.data()};
int musiikki = 0; //Automaattiset: 0 = ei musiikkia, 1 = musiikkia. Tarinafunktiosta laitettavat: 2 = musiikki laitetaan plle, 3 = musiikki sammutetaan
bool musafeidaus = false;
int nextmusa = 0; //Jos feidataan kappaletta ja uusi on valittu, laitetaan valinta talteen tnne feidauksen ajaksi

ifstream kappale1("hk1.it", ios::binary);
ifstream kappale2("hk-think.it", ios::binary);
ifstream kappale3("hk-intro.it", ios::binary);
ifstream kappale4("hk-outro.it", ios::binary);
ifstream kappale5("hk-trial.it", ios::binary);
ifstream kappale6("hk-scare.it", ios::binary);
ifstream kappale7("hk-inter.it", ios::binary);
ifstream kappale8("hk-conclusion.it", ios::binary);
ifstream kappale9("logo.it", ios::binary);
ifstream kappale10("hk-corridor.it", ios::binary);
ifstream kappale11("hk2.it", ios::binary);
openmpt::module hkmain(kappale1);
openmpt::module tuumaus(kappale2);
openmpt::module hkalku(kappale3);
openmpt::module outro(kappale4);
openmpt::module trial(kappale5);
openmpt::module scare(kappale6);
openmpt::module inter(kappale7);
openmpt::module conclu(kappale8);
openmpt::module logosound(kappale9);
openmpt::module corridor(kappale10);
openmpt::module hkalt(kappale11);
openmpt::module *musaptr;
void musavalinta(int numero);
float feidauskerroin = 1;

class tekstuuriluokka {
  int leveys;
  int korkeus;
public:
  SDL_Texture* tekstuuri;
  tekstuuriluokka();
  ~tekstuuriluokka();
  bool tiedostonlataus(string filename);
  void erase();
  void renderfunktio(int x, int y, SDL_Rect* temprect = NULL, int flip = 0); //Renderi tekstuurin annettuun kohtaan
  int haeleveys();
  int haekorkeus();
  void aseta_blend(SDL_BlendMode blend_arvo);
  void alphafunktio(Uint8 alpha_arvo);
};

tekstuuriluokka taustakuva;
tekstuuriluokka pimee;
tekstuuriluokka logo;
tekstuuriluokka postlogo;
tekstuuriluokka alkukuva;
tekstuuriluokka alkukuva_en;
tekstuuriluokka kadet;
tekstuuriluokka sydan;
tekstuuriluokka s_tausta;
tekstuuriluokka kosoitin;
tekstuuriluokka kosoitin90;
tekstuuriluokka kupkulma;
tekstuuriluokka koti;
tekstuuriluokka rappu;
tekstuuriluokka wc;
tekstuuriluokka loppu;

tekstuuriluokka koirateks1;
tekstuuriluokka koirateks2;
tekstuuriluokka mayrateks;
tekstuuriluokka kissateks;
tekstuuriluokka kissakteks;
tekstuuriluokka naatateks;
tekstuuriluokka dropsteks;

tekstuuriluokka poytateks;
tekstuuriluokka kpoytateks;
tekstuuriluokka poyta3teks;
tekstuuriluokka rvteks;
tekstuuriluokka kaideteks;
tekstuuriluokka tuoliteks;
tekstuuriluokka tuoli2teks;
tekstuuriluokka ruokateks;
tekstuuriluokka wcoateks;
tekstuuriluokka wcokteks;
tekstuuriluokka roateks;

tekstuuriluokka::tekstuuriluokka() {
  tekstuuri = NULL;
  leveys = 0;
  korkeus = 0;
}

tekstuuriluokka::~tekstuuriluokka() {
  erase();
}

bool tekstuuriluokka::tiedostonlataus(string filename) {
  erase(); //Ensin olemassa oleva tekstuuri pois
  SDL_Texture* uusitekstuuri = NULL;
  SDL_Surface* pinta = IMG_Load(filename.c_str());
  if(pinta == NULL) cerr << "Image load fail: " << filename.c_str() << " " << IMG_GetError() << endl;
  else {
    SDL_SetColorKey(pinta, SDL_TRUE, SDL_MapRGB(pinta->format, 0, 0xFF, 0xFF));
    uusitekstuuri = SDL_CreateTextureFromSurface(piirturi, pinta);
    if(uusitekstuuri == NULL) cerr << "Texture creation fail - " << SDL_GetError << endl;
    else {
      leveys = pinta->w;
      korkeus = pinta->h;
    }
    SDL_FreeSurface(pinta);
  }
  tekstuuri = uusitekstuuri;
  return tekstuuri != NULL;
}

void tekstuuriluokka::erase() {
  if(tekstuuri != NULL) {
    SDL_DestroyTexture(tekstuuri);
    tekstuuri = NULL;
    leveys = 0;
    korkeus = 0;
  }
}

void tekstuuriluokka::renderfunktio(int x, int y, SDL_Rect* temprect, int flip) {
  SDL_Rect rendnelio = {x,y,leveys,korkeus};
  if(temprect != NULL) {
    rendnelio.w = temprect->w;
    rendnelio.h = temprect->h;
  }

  SDL_RenderCopyEx(piirturi, tekstuuri, temprect, &rendnelio, 0.0, NULL,
  		   (flip > 0 ? (flip > 1 ? (flip > 2 ? (static_cast<SDL_RendererFlip>(SDL_FLIP_HORIZONTAL | SDL_FLIP_VERTICAL)) : SDL_FLIP_VERTICAL) : SDL_FLIP_HORIZONTAL) : SDL_FLIP_NONE));

}

void tekstuuriluokka::aseta_blend(SDL_BlendMode blend_arvo) {
  SDL_SetTextureBlendMode(tekstuuri, blend_arvo);
}

void tekstuuriluokka::alphafunktio(Uint8 alpha_arvo) {
  SDL_SetTextureAlphaMod(tekstuuri, alpha_arvo);
}

int tekstuuriluokka::haeleveys() {return leveys;}
int tekstuuriluokka::haekorkeus() {return korkeus;}

class hahmoluokka {
public:
  int ruudulla; //Onko hahmo ruudulla ja monennessako hahmonpiirtokerroksessa
  bool symmetrinen;
  int flip;
  bool steadyflip; //Flip, joka pysyy pll, vaikka hahmo pyshtyy
  pair<double, double> sijainti;
  pair<int,int> waypoint1;
  pair<int,int> waypoint2;
  pair<int,int> waypoint3;
  pair<int,int> waypoint4;
  int wp1muutos;  //Muuttuuko ruudulla-arvo waypointissa (0 = ei muutu, muut arvot viittavat uuteen ruudulla-arvoon)
  int wp2muutos;
  int wp3muutos;
  int wp4muutos;
  pair<double, double> liikesuunta;
  int rintamasuunta; //Luvut viittaavat numpadin nuolien numeroihin
  int frame;
  tekstuuriluokka *spritet;
  SDL_Rect *hahmorect;
  int ilme;
  int puhilme; //vain puhekuplan ajaksi tuleva ilme
  hahmoluokka();
  ~hahmoluokka();
  void hahmonpiirto(bool, int);
  void yhdista_tekstuuri(tekstuuriluokka*);
  void yhdista_rect(SDL_Rect *rect, int, unsigned int);
  pair<double,double> suunnanlasku();
  void arkit(); //Asettaa spritearkkien koordinaatit
  void framesuunta();
};

vector<hahmoluokka*> hahmovektori; //Vektori, johon liitetn hahmoluokan jseniin osoittavat pointterit

void hahmoluokka::yhdista_tekstuuri(tekstuuriluokka *olio) {spritet = olio;}

hahmoluokka::hahmoluokka():
  ruudulla(0), symmetrinen(true), flip(0), steadyflip(false), rintamasuunta(2), frame(3), spritet(NULL), ilme(1), wp1muutos(0), wp2muutos(0), wp3muutos(0), wp4muutos(0) {
  hahmovektori.push_back(this);
}

hahmoluokka::~hahmoluokka() {
  delete[] hahmorect;
}

//Hahmon rect yhdistetn sen spritesheettiin
void hahmoluokka::yhdista_rect(SDL_Rect *rect, int arraynpituus, unsigned int arraynkoko) {  //Funktioon lhetetn array, jolloin sinne lhtee arrayn ensimmiseen elementtiin osoittava pointteri ja nin ollen parametrin tytyy olla pointteri-tyyppinen
  hahmorect = new SDL_Rect[arraynkoko];
  for(int counter = 0; counter != arraynpituus; counter++) {
    hahmorect[counter] = rect[counter];
  }
}

void hahmoluokka::hahmonpiirto(bool kavelynyt, int puheajastin) {
  if(ilme == 4) {  //Ilmeen arvo 4 on lisys dropsien toteuttamiseksi
    piirtorect = *(hahmorect + frame);
    spritet->renderfunktio(sijainti.first-kamerax1, sijainti.second, &piirtorect, flip);
    return;
  }

  bool tarkistus = false; //Tarkistus on vain sen takia, ettei turhaan renkata keskeytys-funktiota kokoajan
  bool puheframe = false;

  if(frame >= 18 and (frame <= 27 and frame >= 30)) rintamasuunta = 0;
  else if(rintamasuunta == 0 and frame < 18 or (rintamasuunta == 0 and frame >= 27 and frame <= 30)) {
    rintamasuunta = 2;
  }
  

  if(waypoint1.first != 0 and waypoint1.second != 0) {
    liikesuunta = suunnanlasku();  //Tulee liukulukujen "akkumulaatiovirhe", jos ei laske suuntaa tss aina uudestaan
    //Hahmon framet synkkaan kvelysuunnan kanssa, jos ei olla kvelyframeissa
    if((frame < 3 or frame > 14) and (frame < 27 or frame > 30)) framesuunta();
  }

  //Kun toinen waypoint tulee maaliin, mutta toinen waypoint on viel kaukana, kutsutaan framesuunta(). Tm voi tapahtua, jos toinen waypoint on jo lhtkohtaisesti hyvin lhell maalia. Mutta jos toinenkin waypoint on nolla tai jos toinenkin on hyvin lhell maalia (+-5), silloin ei kutsuta.
  if(waypoint1.first != 0) { 
    if(sijainti.first > waypoint1.first-2 and sijainti.first < waypoint1.first+2) {
      waypoint1.first = 0;
      tarkistus = true;
      if(waypoint1.second != 0 and (waypoint1.second - sijainti.second > 5 or waypoint1.second - sijainti.second < -5)) framesuunta();
    } 
    else if(liikesuunta.first > 0 and (sijainti.first < waypoint1.first)) sijainti.first += liikesuunta.first;
    else if(liikesuunta.first < 0 and (sijainti.first > waypoint1.first)) sijainti.first += liikesuunta.first; //Oleellinen rivi
    else waypoint1.first = 0;
  }
  if(waypoint1.second != 0) {
    if(sijainti.second > waypoint1.second-2 and sijainti.second < waypoint1.second+2) {
      if(waypoint1.first != 0 and (waypoint1.first - sijainti.first > 5 or waypoint1.first - sijainti.first < -5)) framesuunta();
      waypoint1.second = 0;
      tarkistus = true;
    }
    else if(liikesuunta.second > 0 and (sijainti.second < waypoint1.second)) sijainti.second += liikesuunta.second;
    else if(liikesuunta.second < 0 and (sijainti.second > waypoint1.second)) sijainti.second += liikesuunta.second;
    else waypoint1.second = 0;
  }

  if(kavelynyt == true and (waypoint1.first != 0 or waypoint1.second != 0)) {
    frame++;
    if(frame == 7 or frame == 11 or frame == 15 or frame == 31) frame -= 4;
  }
  if(waypoint1.first == 0 and waypoint1.second == 0 and waypoint2.first == 0 and waypoint2.second == 0) { //Ilman waypoint2:ia vlht kntyess seisomisframe
    switch(rintamasuunta) {
    case 0: break;
    case 2: frame = 0; break;
    case 8: frame = 2; break;
    case 6: frame = 1; break;
    case 4: {
      if(!symmetrinen) frame = 31;
      else {
	frame = 1;
	flip = 1;
      }
      break;
    }
    }
  }

  piirtorect = *(hahmorect + frame);
  //Hahmon piirtvn renderfunktiokutsun molemmin puolin on flip-tarkistukset. Riippuu rintamasuunnasta, johon hahmo j, pitk tarkistus tehd ennen vain jlkeen renderfunktion.
  if(tarkistus and rintamasuunta == 2 and waypoint1.first == 0 and waypoint1.second == 0 and waypoint2.first == 0 and waypoint2.second == 0 and !steadyflip) flip = 0; //Ilman tt rivi hahmoon voi jd flip-plle, kun se pyshtyy.

  //Tss vliss laitetaan peite-rect, mikli hahmo on puheframessa ja pt ei saa piirt
  if(kuplantila == 2 and puheajastin%10 > 5 and kuppoint->first == sijainti.first and kuppoint->second == sijainti.second and (static_cast<double>(frame-2) / 12) * 4 != 3 and frame != 2) puheframe = true;

  if(!puheframe or rintamasuunta == 2) spritet->renderfunktio(sijainti.first-kamerax1, sijainti.second, &piirtorect, flip);

  //Huom. seuraava kohta oli aiemmin yll olevan renderfunktio-kutsun ylpuolella, mutta siit tuli ylimrinen vrin flipattu frame
  if(tarkistus and waypoint1.first == 0 and waypoint1.second == 0 and waypoint2.first == 0 and waypoint2.second == 0 and ilme <= 1) flip = 0;
  //"ilme <= 1" yll est ilmeen vrn flippaantumisen, jos se on pll kvelless
  if(steadyflip) flip = 1;
  
  //Puhe katsotaan sen perusteella, onko kuplan kuppointit sdetty tlle hahmolle
    if(puheframe) {
    //Logiikka: (positio/koko rangen koko)*rangen vlimatka
    if(frame >= 3 and frame <= 6) piirtorect = *(hahmorect + 16); //Flip on jo valmiiksi plle laitettu tss funktiossa, jos sit tarvitaan
    else if (frame >= 7 and frame <= 10) piirtorect = *(hahmorect + 15);
    else if (frame == 0) piirtorect = *(hahmorect + 17); //Suoraanseisomisframe
    else if (frame == 1 and symmetrinen) piirtorect = *(hahmorect + 16); //Sivulleseisomisframe
    else if (frame == 31 and !symmetrinen) piirtorect = *(hahmorect + 32); //Epsymmetrinen sivulleseisomisframe
    
    spritet->renderfunktio(sijainti.first-kamerax1, sijainti.second, &piirtorect, flip);
  }

  if(ilme > 1 or puhilme > 1) {
    if(frame == 0 or (frame >= 7 and frame <= 10) and (ilme == 2 or puhilme == 2)) piirtorect = *(hahmorect + 18);
    if(frame == 1 or (frame >= 3 and frame <= 6) and (ilme == 2 or puhilme == 2)) piirtorect = *(hahmorect + 20);
    if(frame == 0 and (ilme == 3 or puhilme == 3)) piirtorect = *(hahmorect + 19);
    spritet->renderfunktio(sijainti.first-kamerax1, sijainti.second, &piirtorect, flip);
  }

  //Pivitetn waypoint, jos sinne saavutaan
  if(waypoint1.first == 0 and waypoint1.second == 0 and (waypoint2.first != 0 or waypoint2.second != 0)) { //jos ei liikuta, mutta waypoint2:ssa on jotain
    if(wp1muutos != 0 or wp2muutos != 0 or wp3muutos != 0 or wp4muutos != 0) { //Pivitetn ruudulla-arvo (hahmon nkyvyyskerros), jos se on sdetty pivittyvksi
      if(wp1muutos != 0) ruudulla = wp1muutos;
      wp1muutos = wp2muutos;
      wp2muutos = wp3muutos;
      wp3muutos = wp4muutos;
      wp4muutos = 0;
    }
    
    waypoint1.first = waypoint2.first;
    waypoint1.second = waypoint2.second;
    waypoint2.first = waypoint3.first;
    waypoint2.second = waypoint3.second;
    waypoint3.first = waypoint4.first;
    waypoint3.second = waypoint4.second;
    waypoint4.first = 0;
    waypoint4.second = 0;
    liikesuunta = suunnanlasku();
    framesuunta();
  }
  if(tarkistus and waypoint1.first == 0 and waypoint1.second == 0 and kesktark()) tarinakeskeytys = true;
}

//Funktio joka laskee hahmon kvelysuunnan perusteella siihen sopivat kvelyframet.
void hahmoluokka::framesuunta() {
  if(liikesuunta.second < 0) { //jos mennn yls
    if(liikesuunta.second <= -0.55) frame = 11;  //Kun pienennetn ensimmist arvoa, laajenee yls/alas -menemiseen kytettvien framejen alue (vastaa juttu mys tuossa alempana)
    else {
      frame = 3;
      if(liikesuunta.first < 0) symmetrinen ? flip = 1 : frame = 27;
    }
  }
  else { //jos mennn alas
    if(liikesuunta.second >= 0.55) frame = 7;
    else {
      frame = 3;
      if(liikesuunta.first < 0) symmetrinen ? flip = 1 : frame = 27;
    }
  }
}

pair<double,double> hahmoluokka::suunnanlasku() {

  pair<double,double> suunta;

  //Jos kvelln sivulle ja vasemmalle, flippaus plle
  //Tss on sopiva paikka nollata flippaus. Ainakin puhe-framejen kanssa voi tulla ongelmia, jos flippaus j plle turhaan.
  if(symmetrinen) {
    (frame >= 3 and frame <= 6 and waypoint1.first < sijainti.first) ? flip = 1 : flip = 0;
  }

  //Ensin tarvitaan suuntakulman selvittmiseksi molempien kolmion kateettien pituudet, ne ovat x:n ja y:n muutosten itseisarvot. Ne saadaan kun pienempi x:n ja y:n arvo (lhtpaikka ja pmr) vhennetn aina suuremmasta.
  int xsuunta = 1;
  int ysuunta = 1;

  if(waypoint1.first < sijainti.first) suunta.first *= -1;
  if(waypoint1.second < sijainti.second) suunta.second *= -1;
  
  //Funktion loppu ei toimi, jos vain toinen waypoint on 0. Tllin ei tarvitse muutenkaan laskea
  if(waypoint1.first == 0 and waypoint1.second != 0) {
    suunta.first = 0;
    suunta.second = KNOPEUS;
    if(waypoint1.second < sijainti.second) suunta.second *= -1;
    if((frame < 3 or frame > 14) and (frame < 27 or frame > 30)) framesuunta();  //EPSYMMETRIA
    return suunta;
  }
  if(waypoint1.first != 0 and waypoint1.second == 0) {
    suunta.first = KNOPEUS;
    suunta.second = 0;
    if(waypoint1.first < sijainti.first) suunta.first *= -1;
    if((frame < 3 or frame > 14) and (frame < 27 or frame > 30)) framesuunta();  //EPSYMMETRIA
    return suunta;
  }

  double x_itmuutos = (sijainti.first > waypoint1.first ? sijainti.first - waypoint1.first : waypoint1.first - sijainti.first);
  double y_itmuutos = (sijainti.second > waypoint1.second ? sijainti.second - waypoint1.second : waypoint1.second - sijainti.second);
  //Saadut arvot ovat siis aina positiiviset
  //suuntaluku = kulma / 90 ja jos tulos on > 0.5, se tulee sille arvolle, joka muuttuu enemmn (ja toiselle 1 - suuntaluku)
  double suuntaluku = (atan(y_itmuutos/x_itmuutos)); //Y-arvo on aina vastainen kateetti ja X-arvo viereinen kateetti. atan-funktio = tan^-1
  //Suuntaluku on kulman asteet/radiaanit. Tm pit jakaa suorakulmalla, jotta saadaan, kuinka monta prosenttia haluttu muutos on eli asteet/radiaanit muunnetaan tss koordinaatiston arvoiksi, jotka ovat 0-1 eik esim 0-90. Toisen muutoksen prosentit saadaan tietysti vhentmll se 1:st.
  suuntaluku /= M_PI_2;  //atan antaa tuloksen radiaaneina. Radiaaneina suorakulma on pii/2 (M_PI_2 = pii/2)

  //Mihin suuntaan ollaan enemmn menossa, sille isompi kulma
  if(x_itmuutos > y_itmuutos) { //Jos x:n muutos suurempi kuin y
    if(suuntaluku > 0.5) {
      suunta.first = suuntaluku;
      suunta.second = 1-suuntaluku;
    }
    else {
      suunta.first = 1-suuntaluku;
      suunta.second = suuntaluku;
    }
  }
  else { //jos y:n muutos on suurempi kuin x
    if(suuntaluku > 0.5) {
      suunta.second = suuntaluku;
      suunta.first = 1-suuntaluku;
    }
    else {
      suunta.second = 1-suuntaluku;
      suunta.first = suuntaluku;
    }
  }

  //Etumerkit miinukseksi tarvittaessa, tt ennen on laskettu itseisarvoilla
  if(waypoint1.first < sijainti.first) suunta.first *= -1;
  if(waypoint1.second < sijainti.second) suunta.second *= -1;

  suunta.first *= KNOPEUS; //Kvelynopeuden kerroin
  suunta.second *= KNOPEUS;
  return suunta;
}

void hahmoluokka::arkit() {
  //Jos muuttaa arkkien kokoja pit muuttaa mys niit vastaavien SDL_Rect -arrayiden kokoja koodin alusta. Virheilmoitusta ei vlttmtt tule, vaikka unohtaisi.
  //Suoraan edest
  kissa_arkki[0].x = 0;
  kissa_arkki[0].y = 0;
  kissa_arkki[0].w = 79;
  kissa_arkki[0].h = 140;
  //Sivulta
  kissa_arkki[1].x = 80;
  kissa_arkki[1].y = 0;
  kissa_arkki[1].w = 52;
  kissa_arkki[1].h = 140;
  //Selin
  kissa_arkki[2].x = 132;
  kissa_arkki[2].y = 0;
  kissa_arkki[2].w = 79;
  kissa_arkki[2].h = 140;
  //Sivukvely
  kissa_arkki[3].x = 0;
  kissa_arkki[3].y = 140;
  kissa_arkki[3].w = 55;
  kissa_arkki[3].h = 136;
  kissa_arkki[4].x = 56;
  kissa_arkki[4].y = 140;
  kissa_arkki[4].w = 56;
  kissa_arkki[4].h = 136;
  kissa_arkki[5].x = 112;
  kissa_arkki[5].y = 140;
  kissa_arkki[5].w = 58;
  kissa_arkki[5].h = 136;
  kissa_arkki[6].x = 174;
  kissa_arkki[6].y = 140;
  kissa_arkki[6].w = 58;
  kissa_arkki[6].h = 136;
  //Kvely alas
  kissa_arkki[7].x = 0;
  kissa_arkki[7].y = 276;
  kissa_arkki[7].w = 75;
  kissa_arkki[7].h = 136;
  kissa_arkki[8].x = 76;
  kissa_arkki[8].y = 276;
  kissa_arkki[8].w = 75;
  kissa_arkki[8].h = 136;
  kissa_arkki[9].x = 152;
  kissa_arkki[9].y = 276;
  kissa_arkki[9].w = 75;
  kissa_arkki[9].h = 136;
  kissa_arkki[10].x = 228;
  kissa_arkki[10].y = 276;
  kissa_arkki[10].w = 75;
  kissa_arkki[10].h = 136;
  //Kvely yls
  kissa_arkki[11].x = 0;
  kissa_arkki[11].y = 412;
  kissa_arkki[11].w = 75;
  kissa_arkki[11].h = 142;
  kissa_arkki[12].x = 76;
  kissa_arkki[12].y = 412;
  kissa_arkki[12].w = 75;
  kissa_arkki[12].h = 142;
  kissa_arkki[13].x = 152;
  kissa_arkki[13].y = 412;
  kissa_arkki[13].w = 75;
  kissa_arkki[13].h = 142;
  kissa_arkki[14].x = 228;
  kissa_arkki[14].y = 412;
  kissa_arkki[14].w = 75;
  kissa_arkki[14].h = 142;
  //Puhe alas, sivulta, liikkumatta alas
  kissa_arkki[15].x = 0;
  kissa_arkki[15].y = 0;
  kissa_arkki[15].w = 0;
  kissa_arkki[15].h = 0;
  kissa_arkki[16].x = 237;
  kissa_arkki[16].y = 136;
  kissa_arkki[16].w = 289-237;  //Trke, ett flipattava puheframe on yht leve kuin vastaava koko hahmon frame
  kissa_arkki[16].h = 276-136;
  kissa_arkki[17].x = 205;
  kissa_arkki[17].y = 0;
  kissa_arkki[17].w = 54;
  kissa_arkki[17].h = 54;
  //Ilmeet:
  //Seisotaan kasvot kameraa kohden, surullinen hmmstys
  kissa_arkki[18].x = 211;
  kissa_arkki[18].y = 54;
  kissa_arkki[18].w = 69;
  kissa_arkki[18].h = 60;
  //Sad
  kissa_arkki[19].x = 283;
  kissa_arkki[19].y = 0;
  kissa_arkki[19].w = 56;
  kissa_arkki[19].h = 58;
  kissa_arkki[20].x = 0;
  kissa_arkki[20].y = 0;
  kissa_arkki[20].w = 0;
  kissa_arkki[20].h = 0;
  //kirjoittelu
  kissa_arkki[21].x = 0;
  kissa_arkki[21].y = 554;
  kissa_arkki[21].w = 78;
  kissa_arkki[21].h = 126;
  kissa_arkki[22].x = 78;
  kissa_arkki[22].y = 554;
  kissa_arkki[22].w = 80;
  kissa_arkki[22].h = 126;
  //Tanssi
  kissa_arkki[23].x = 0;
  kissa_arkki[23].y = 680;
  kissa_arkki[23].w = 60;
  kissa_arkki[23].h = 136;
  kissa_arkki[24].x = 60;
  kissa_arkki[24].y = 680;
  kissa_arkki[24].w = 60;
  kissa_arkki[24].h = 136;
  kissa_arkki[25].x = 120;
  kissa_arkki[25].y = 680;
  kissa_arkki[25].w = 60;
  kissa_arkki[25].h = 136;
  kissa_arkki[26].x = 179;
  kissa_arkki[26].y = 680;
  kissa_arkki[26].w = 60;
  kissa_arkki[26].h = 136;
  //Epsymmetriset sivuframet
  kissa_arkki[27].x = 0;
  kissa_arkki[27].y = 816;
  kissa_arkki[27].w = 52;
  kissa_arkki[27].h = 134;
  kissa_arkki[28].x = 52;
  kissa_arkki[28].y = 816;
  kissa_arkki[28].w = 108-52;
  kissa_arkki[28].h = 134;
  kissa_arkki[29].x = 114;
  kissa_arkki[29].y = 816;
  kissa_arkki[29].w = 171-112;
  kissa_arkki[29].h = 134;
  kissa_arkki[30].x = 176;
  kissa_arkki[30].y = 816;
  kissa_arkki[30].w = 229-174;
  kissa_arkki[30].h = 134;
  //Epsymmetrinen sivuttain seisominen
  kissa_arkki[31].x = 235;
  kissa_arkki[31].y = 816;
  kissa_arkki[31].w = 52;
  kissa_arkki[31].h = 134;
  //Epsymmetrinen puhe
  kissa_arkki[32].x = 294;
  kissa_arkki[32].y = 816;
  kissa_arkki[32].w = 52;
  kissa_arkki[32].h = 134;
  
  //Suoraan edest
  koira1_arkki[0].x = 0;
  koira1_arkki[0].y = 0;
  koira1_arkki[0].w = 66;
  koira1_arkki[0].h = 142;
  //Sivulta
  koira1_arkki[1].x = 66;
  koira1_arkki[1].y = 0;
  koira1_arkki[1].w = 58;
  koira1_arkki[1].h = 142;
  //Selin
  koira1_arkki[2].x = 124;
  koira1_arkki[2].y = 0;
  koira1_arkki[2].w = 55;
  koira1_arkki[2].h = 142;
  //Sivukvely
  koira1_arkki[3].x = 0;
  koira1_arkki[3].y = 142;
  koira1_arkki[3].w = 62;
  koira1_arkki[3].h = 142;
  koira1_arkki[4].x = 62;
  koira1_arkki[4].y = 142;
  koira1_arkki[4].w = 62;
  koira1_arkki[4].h = 142;
  koira1_arkki[5].x = 124;
  koira1_arkki[5].y = 142;
  koira1_arkki[5].w = 62;
  koira1_arkki[5].h = 142;
  koira1_arkki[6].x = 186;
  koira1_arkki[6].y = 142;
  koira1_arkki[6].w = 63;
  koira1_arkki[6].h = 142;
  //Kvely alas
  koira1_arkki[7].x = 0;
  koira1_arkki[7].y = 284;
  koira1_arkki[7].w = 66;
  koira1_arkki[7].h = 143;
  koira1_arkki[8].x = 66;
  koira1_arkki[8].y = 284;
  koira1_arkki[8].w = 66;
  koira1_arkki[8].h = 143;
  koira1_arkki[9].x = 132;
  koira1_arkki[9].y = 284;
  koira1_arkki[9].w = 66;
  koira1_arkki[9].h = 143;
  koira1_arkki[10].x = 198;
  koira1_arkki[10].y = 284;
  koira1_arkki[10].w = 66;
  koira1_arkki[10].h = 143;
  //Kvely yls
  koira1_arkki[11].x = 0;
  koira1_arkki[11].y = 428;
  koira1_arkki[11].w = 52;
  koira1_arkki[11].h = 143;
  koira1_arkki[12].x = 52;
  koira1_arkki[12].y = 428;
  koira1_arkki[12].w = 52;
  koira1_arkki[12].h = 143;
  koira1_arkki[13].x = 106;
  koira1_arkki[13].y = 428;
  koira1_arkki[13].w = 52;
  koira1_arkki[13].h = 143;
  koira1_arkki[14].x = 160;
  koira1_arkki[14].y = 428;
  koira1_arkki[14].w = 53;
  koira1_arkki[14].h = 143;
  //Puhe alas, sivulta, liikkumatta alas
  koira1_arkki[15].x = 0;
  koira1_arkki[15].y = 0;
  koira1_arkki[15].w = 0;
  koira1_arkki[15].h = 0;
  koira1_arkki[16].x = 257;
  koira1_arkki[16].y = 142;
  koira1_arkki[16].w = 315-257;  //Trke, ett flipattava puheframe on yht leve kuin vastaava koko hahmon frame
  koira1_arkki[16].h = 284-142;
  koira1_arkki[17].x = 174;
  koira1_arkki[17].y = 46;
  koira1_arkki[17].w = 65;
  koira1_arkki[17].h = 46;
  //Ilme, sad sivulta
  koira1_arkki[18].x = 0;
  koira1_arkki[18].y = 0;
  koira1_arkki[18].w = 0;
  koira1_arkki[18].h = 0;
  koira1_arkki[19].x = 0;
  koira1_arkki[19].y = 0;
  koira1_arkki[19].w = 0;
  koira1_arkki[19].h = 0;
  koira1_arkki[20].x = 236;
  koira1_arkki[20].y = 0;
  koira1_arkki[20].w = 123-66;
  koira1_arkki[20].h = 40;
  //Kirjoittelu
  koira1_arkki[21].x = 0;
  koira1_arkki[21].y = 576;
  koira1_arkki[21].w = 63;
  koira1_arkki[21].h = 148;
  koira1_arkki[22].x = 63;
  koira1_arkki[22].y = 576;
  koira1_arkki[22].w = 63;
  koira1_arkki[22].h = 148;
  
  //Suoraan edest
  koira2_arkki[0].x = 0;
  koira2_arkki[0].y = 0;
  koira2_arkki[0].w = 58;
  koira2_arkki[0].h = 131;
  //Sivulta
  koira2_arkki[1].x = 58;
  koira2_arkki[1].y = 0;
  koira2_arkki[1].w = 45;
  koira2_arkki[1].h = 132;
  //Selin
  koira2_arkki[2].x = 104;
  koira2_arkki[2].y = 0;
  koira2_arkki[2].w = 56;
  koira2_arkki[2].h = 131;
  //Sivukvely
  koira2_arkki[3].x = 0;
  koira2_arkki[3].y = 132;
  koira2_arkki[3].w = 50;
  koira2_arkki[3].h = 132;
  koira2_arkki[4].x = 50;
  koira2_arkki[4].y = 132;
  koira2_arkki[4].w = 50;
  koira2_arkki[4].h = 132;
  koira2_arkki[5].x = 104;
  koira2_arkki[5].y = 132;
  koira2_arkki[5].w = 50;
  koira2_arkki[5].h = 132;
  koira2_arkki[6].x = 154;
  koira2_arkki[6].y = 132;
  koira2_arkki[6].w = 50;
  koira2_arkki[6].h = 132;
  //Kvely alas
  koira2_arkki[7].x = 0;
  koira2_arkki[7].y = 264;
  koira2_arkki[7].w = 57;
  koira2_arkki[7].h = 136;
  koira2_arkki[8].x = 58;
  koira2_arkki[8].y = 264;
  koira2_arkki[8].w = 57;
  koira2_arkki[8].h = 136;
  koira2_arkki[9].x = 116;
  koira2_arkki[9].y = 264;
  koira2_arkki[9].w = 57;
  koira2_arkki[9].h = 136;
  koira2_arkki[10].x = 174;
  koira2_arkki[10].y = 264;
  koira2_arkki[10].w = 57;
  koira2_arkki[10].h = 136;
  //Kvely yls
  koira2_arkki[11].x = 0;
  koira2_arkki[11].y = 400;
  koira2_arkki[11].w = 56;
  koira2_arkki[11].h = 140;
  koira2_arkki[12].x = 56;
  koira2_arkki[12].y = 400;
  koira2_arkki[12].w = 56;
  koira2_arkki[12].h = 140;
  koira2_arkki[13].x = 112;
  koira2_arkki[13].y = 400;
  koira2_arkki[13].w = 56;
  koira2_arkki[13].h = 140;
  koira2_arkki[14].x = 168;
  koira2_arkki[14].y = 400;
  koira2_arkki[14].w = 56;
  koira2_arkki[14].h = 140;
  //Puhe alas, sivulta, liikkumatta alas
  koira2_arkki[15].x = 156;
  koira2_arkki[15].y = 0;
  koira2_arkki[15].w = 38;
  koira2_arkki[15].h = 40;
  koira2_arkki[16].x = 219;
  koira2_arkki[16].y = 132;
  koira2_arkki[16].w = 45;  //Trke, ett flipattava puheframe on yht leve kuin vastaava koko hahmon frame
  koira2_arkki[16].h = 132;
  koira2_arkki[17].x = 248;
  koira2_arkki[17].y = 0;
  koira2_arkki[17].w = 57;
  koira2_arkki[17].h = 44;
  //Ilmeet, sad edest
  koira2_arkki[18].x = 316;
  koira2_arkki[18].y = 0;
  koira2_arkki[18].w = 57;
  koira2_arkki[18].h = 40;
  koira2_arkki[19].x = 0;
  koira2_arkki[19].y = 0;
  koira2_arkki[19].w = 0;
  koira2_arkki[19].h = 0;
  koira2_arkki[20].x = 0;
  koira2_arkki[20].y = 0;
  koira2_arkki[20].w = 0;
  koira2_arkki[20].h = 0;
  //Kirjoittelu
  koira2_arkki[21].x = 0;
  koira2_arkki[21].y = 543;
  koira2_arkki[21].w = 68;
  koira2_arkki[21].h = 143;
  koira2_arkki[22].x = 68;
  koira2_arkki[22].y = 543;
  koira2_arkki[22].w = 68;
  koira2_arkki[22].h = 143;

  //Suoraan edest
  naata_arkki[0].x = 0;
  naata_arkki[0].y = 0;
  naata_arkki[0].w = 52;
  naata_arkki[0].h = 128;
  //Sivulta
  naata_arkki[1].x = 52;
  naata_arkki[1].y = 0;
  naata_arkki[1].w = 53;
  naata_arkki[1].h = 128;
  //Selin
  naata_arkki[2].x = 106;
  naata_arkki[2].y = 0;
  naata_arkki[2].w = 52;
  naata_arkki[2].h = 128;
  //Sivukvely
  naata_arkki[3].x = 0;
  naata_arkki[3].y = 128;
  naata_arkki[3].w = 58;
  naata_arkki[3].h = 127;
  naata_arkki[4].x = 58;
  naata_arkki[4].y = 128;
  naata_arkki[4].w = 58;
  naata_arkki[4].h = 127;
  naata_arkki[5].x = 119;
  naata_arkki[5].y = 128;
  naata_arkki[5].w = 58;
  naata_arkki[5].h = 127;
  naata_arkki[6].x = 177;
  naata_arkki[6].y = 128;
  naata_arkki[6].w = 58;
  naata_arkki[6].h = 128;
  //Kvely alas
  naata_arkki[7].x = 0;
  naata_arkki[7].y = 256;
  naata_arkki[7].w = 53;
  naata_arkki[7].h = 132;
  naata_arkki[8].x = 54;
  naata_arkki[8].y = 256;
  naata_arkki[8].w = 53;
  naata_arkki[8].h = 132;
  naata_arkki[9].x = 108;
  naata_arkki[9].y = 256;
  naata_arkki[9].w = 53;
  naata_arkki[9].h = 132;
  naata_arkki[10].x = 162;
  naata_arkki[10].y = 256;
  naata_arkki[10].w = 53;
  naata_arkki[10].h = 132;
  //Kvely yls
  naata_arkki[11].x = 0;
  naata_arkki[11].y = 388;
  naata_arkki[11].w = 52;
  naata_arkki[11].h = 132;
  naata_arkki[12].x = 52;
  naata_arkki[12].y = 388;
  naata_arkki[12].w = 52;
  naata_arkki[12].h = 132;
  naata_arkki[13].x = 104;
  naata_arkki[13].y = 388;
  naata_arkki[13].w = 52;
  naata_arkki[13].h = 132;
  naata_arkki[14].x = 156;
  naata_arkki[14].y = 388;
  naata_arkki[14].w = 52;
  naata_arkki[14].h = 132;
  //Puhe alas, sivulta, liikkumatta alas
  naata_arkki[15].x = 0;
  naata_arkki[15].y = 0;
  naata_arkki[15].w = 0;
  naata_arkki[15].h = 0;
  naata_arkki[16].x = 202;
  naata_arkki[16].y = 0;
  naata_arkki[16].w = 53;  //Trke, ett flipattava puheframe on yht leve kuin vastaava koko hahmon frame
  naata_arkki[16].h = 128;
  naata_arkki[17].x = 158; 
  naata_arkki[17].y = 0;
  naata_arkki[17].w = 209-158;
  naata_arkki[17].h = 45;
  naata_arkki[18].x = 0;
  naata_arkki[18].y = 0;
  naata_arkki[18].w = 0;
  naata_arkki[18].h = 0;
  naata_arkki[19].x = 0;
  naata_arkki[19].y = 0;
  naata_arkki[19].w = 0;
  naata_arkki[19].h = 0;
  naata_arkki[20].x = 0;
  naata_arkki[20].y = 0;
  naata_arkki[20].w = 0;
  naata_arkki[20].h = 0;
  naata_arkki[21].x = 0;
  naata_arkki[21].y = 524;
  naata_arkki[21].w = 96;
  naata_arkki[21].h = 129;
  naata_arkki[22].x = 99;
  naata_arkki[22].y = 524;
  naata_arkki[22].w = 96;
  naata_arkki[22].h = 129;
  
  //Suoraan edest
  mayra_arkki[0].x = 0;
  mayra_arkki[0].y = 0;
  mayra_arkki[0].w = 58;
  mayra_arkki[0].h = 119;
  //Sivulta
  mayra_arkki[1].x = 58;
  mayra_arkki[1].y = 0;
  mayra_arkki[1].w = 51;
  mayra_arkki[1].h = 120;
  //Selin
  mayra_arkki[2].x = 110;
  mayra_arkki[2].y = 0;
  mayra_arkki[2].w = 58;
  mayra_arkki[2].h = 119;
  //Sivukvely
  mayra_arkki[3].x = 0;
  mayra_arkki[3].y = 120;
  mayra_arkki[3].w = 58;
  mayra_arkki[3].h = 121;
  mayra_arkki[4].x = 58;
  mayra_arkki[4].y = 120;
  mayra_arkki[4].w = 58;
  mayra_arkki[4].h = 121;
  mayra_arkki[5].x = 116;
  mayra_arkki[5].y = 120;
  mayra_arkki[5].w = 58;
  mayra_arkki[5].h = 121;
  mayra_arkki[6].x = 174;
  mayra_arkki[6].y = 120;
  mayra_arkki[6].w = 58;
  mayra_arkki[6].h = 122;
  //Kvely alas
  mayra_arkki[7].x = 0;
  mayra_arkki[7].y = 242;
  mayra_arkki[7].w = 58;
  mayra_arkki[7].h = 122;
  mayra_arkki[8].x = 60;
  mayra_arkki[8].y = 242;
  mayra_arkki[8].w = 58;
  mayra_arkki[8].h = 122;
  mayra_arkki[9].x = 118;
  mayra_arkki[9].y = 242;
  mayra_arkki[9].w = 58;
  mayra_arkki[9].h = 122;
  mayra_arkki[10].x = 176;
  mayra_arkki[10].y = 242;
  mayra_arkki[10].w = 59;
  mayra_arkki[10].h = 122;
  //Kvely yls
  mayra_arkki[11].x = 0;
  mayra_arkki[11].y = 364;
  mayra_arkki[11].w = 58;
  mayra_arkki[11].h = 124;
  mayra_arkki[12].x = 58;
  mayra_arkki[12].y = 364;
  mayra_arkki[12].w = 58;
  mayra_arkki[12].h = 124;
  mayra_arkki[13].x = 116;
  mayra_arkki[13].y = 364;
  mayra_arkki[13].w = 58;
  mayra_arkki[13].h = 124;
  mayra_arkki[14].x = 174;
  mayra_arkki[14].y = 364;
  mayra_arkki[14].w = 58;
  mayra_arkki[14].h = 124;
  //Puhe alas, sivulta, liikkumatta alas
  mayra_arkki[15].x = 0;
  mayra_arkki[15].y = 0;
  mayra_arkki[15].w = 0;
  mayra_arkki[15].h = 0;
  mayra_arkki[16].x = 236;
  mayra_arkki[16].y = 120;
  mayra_arkki[16].w = 288-236;  //Trke, ett flipattava puheframe on yht leve kuin vastaava koko hahmon frame
  mayra_arkki[16].h = 240-120;
  mayra_arkki[17].x = 110+81; 
  mayra_arkki[17].y = 0;
  mayra_arkki[17].w = 52;
  mayra_arkki[17].h = 48;
  //Ilmeet: ahdistunut (edest), hmmstynyt (edest), ahdistunut (sivulta)
  mayra_arkki[18].x = 271+81;
  mayra_arkki[18].y = 0;
  mayra_arkki[18].w = 56;
  mayra_arkki[18].h = 47;
  mayra_arkki[19].x = 214+81;
  mayra_arkki[19].y = 0;
  mayra_arkki[19].w = 56;
  mayra_arkki[19].h = 47;
  mayra_arkki[20].x = 182;
  mayra_arkki[20].y = 64;
  mayra_arkki[20].w = 233-182;
  mayra_arkki[20].h = 104-64;
  //Istuminen, kaksi framea koneen kanssa ja yksi ilman
  mayra_arkki[21].x = 292;
  mayra_arkki[21].y = 366;
  mayra_arkki[21].w = 353-292;
  mayra_arkki[21].h = 112;
  mayra_arkki[22].x = 353;
  mayra_arkki[22].y = 366;
  mayra_arkki[22].w = 414-353;
  mayra_arkki[22].h = 112;
  mayra_arkki[23].x = 236;
  mayra_arkki[23].y = 364;
  mayra_arkki[23].w = 291-236;
  mayra_arkki[23].h = 112;
  //Ruokailu
  mayra_arkki[24].x = 0;
  mayra_arkki[24].y = 488;
  mayra_arkki[24].w = 68;
  mayra_arkki[24].h = 558-488;
  mayra_arkki[25].x = 68;
  mayra_arkki[25].y = 488;
  mayra_arkki[25].w = 136-68;
  mayra_arkki[25].h = 554-488;
  mayra_arkki[26].x = 136;
  mayra_arkki[26].y = 488;
  mayra_arkki[26].w = 204-136;
  mayra_arkki[26].h = 552-488;
  mayra_arkki[27].x = 204;
  mayra_arkki[27].y = 488;
  mayra_arkki[27].w = 272-204;
  mayra_arkki[27].h = 552-488;
  //vilkutus
  mayra_arkki[28].x = 0;
  mayra_arkki[28].y = 562;
  mayra_arkki[28].w = 92;
  mayra_arkki[28].h = 682-562;
  mayra_arkki[29].x = 92;
  mayra_arkki[29].y = 562;
  mayra_arkki[29].w = 184-92;
  mayra_arkki[29].h = 682-562;
  
  drops_arkki[0].x = 1;
  drops_arkki[0].y = 1;
  drops_arkki[0].w = 159;
  drops_arkki[0].h = 41;
  drops_arkki[1].x = 1;
  drops_arkki[1].y = 44;
  drops_arkki[1].w = 159;
  drops_arkki[1].h = 41;
  drops_arkki[2].x = 1; 
  drops_arkki[2].y = 87;
  drops_arkki[2].w = 159;
  drops_arkki[2].h = 41;
  drops_arkki[3].x = 1; 
  drops_arkki[3].y = 130;
  drops_arkki[3].w = 159;
  drops_arkki[3].h = 41;
  drops_arkki[4].x = 1; 
  drops_arkki[4].y = 173;
  drops_arkki[4].w = 159;
  drops_arkki[4].h = 41;
  drops_arkki[5].x = 1; 
  drops_arkki[5].y = 216;
  drops_arkki[5].w = 159;
  drops_arkki[5].h = 41;
  drops_arkki[6].x = 1; 
  drops_arkki[6].y = 259;
  drops_arkki[6].w = 159;
  drops_arkki[6].h = 41;
  drops_arkki[7].x = 1;
  drops_arkki[7].y = 302;
  drops_arkki[7].w = 159;
  drops_arkki[7].h = 41;
  drops_arkki[8].x = 0;
  drops_arkki[8].y = 0;
  drops_arkki[8].w = 0;
  drops_arkki[8].h = 0;
  drops_arkki[9].x = 0;
  drops_arkki[9].y = 0;
  drops_arkki[9].w = 0;
  drops_arkki[9].h = 0;
  drops_arkki[10].x = 0;
  drops_arkki[10].y = 0;
  drops_arkki[10].w = 0;
  drops_arkki[10].h = 0;
  drops_arkki[11].x = 0;
  drops_arkki[11].y = 0;
  drops_arkki[11].w = 0;
  drops_arkki[11].h = 0;
  drops_arkki[12].x = 0;
  drops_arkki[12].y = 0;
  drops_arkki[12].w = 0;
  drops_arkki[12].h = 0;
  drops_arkki[13].x = 0;
  drops_arkki[13].y = 0;
  drops_arkki[13].w = 0;
  drops_arkki[13].h = 0;
  drops_arkki[14].x = 0;
  drops_arkki[14].y = 0;
  drops_arkki[14].w = 0;
  drops_arkki[14].h = 0;
  drops_arkki[15].x = 0;
  drops_arkki[15].y = 0;
  drops_arkki[15].w = 0;
  drops_arkki[15].h = 0;

  //Suoraan edest
  kissak_arkki[0].x = 0;
  kissak_arkki[0].y = 0;
  kissak_arkki[0].w = 79;
  kissak_arkki[0].h = 139;
  //Sivulta
  kissak_arkki[1].x = 80;
  kissak_arkki[1].y = 0;
  kissak_arkki[1].w = 155-80;
  kissak_arkki[1].h = 140;
  //Selin
  kissak_arkki[2].x = 0;
  kissak_arkki[2].y = 0;
  kissak_arkki[2].w = 0;
  kissak_arkki[2].h = 0;
  //Sivukvely
  kissak_arkki[3].x = 0;
  kissak_arkki[3].y = 140;
  kissak_arkki[3].w = 76;
  kissak_arkki[3].h = 136;
  kissak_arkki[4].x = 76;
  kissak_arkki[4].y = 140;
  kissak_arkki[4].w = 152-76;
  kissak_arkki[4].h = 136;
  kissak_arkki[5].x = 152;
  kissak_arkki[5].y = 140;
  kissak_arkki[5].w = 228-152;
  kissak_arkki[5].h = 136;
  kissak_arkki[6].x = 228;
  kissak_arkki[6].y = 140;
  kissak_arkki[6].w = 304-228;
  kissak_arkki[6].h = 136;
  //Kvely alas
  kissak_arkki[7].x = 0;
  kissak_arkki[7].y = 276;
  kissak_arkki[7].w = 75;
  kissak_arkki[7].h = 136;
  kissak_arkki[8].x = 76;
  kissak_arkki[8].y = 276;
  kissak_arkki[8].w = 75;
  kissak_arkki[8].h = 136;
  kissak_arkki[9].x = 152;
  kissak_arkki[9].y = 276;
  kissak_arkki[9].w = 75;
  kissak_arkki[9].h = 136;
  kissak_arkki[10].x = 228;
  kissak_arkki[10].y = 276;
  kissak_arkki[10].w = 75;
  kissak_arkki[10].h = 136;
  //Kvely yls
  kissak_arkki[11].x = 0;
  kissak_arkki[11].y = 412;
  kissak_arkki[11].w = 75;
  kissak_arkki[11].h = 141;
  kissak_arkki[12].x = 76;
  kissak_arkki[12].y = 412;
  kissak_arkki[12].w = 75;
  kissak_arkki[12].h = 141;
  kissak_arkki[13].x = 152;
  kissak_arkki[13].y = 412;
  kissak_arkki[13].w = 75;
  kissak_arkki[13].h = 141;
  kissak_arkki[14].x = 228;
  kissak_arkki[14].y = 412;
  kissak_arkki[14].w = 75;
  kissak_arkki[14].h = 141;
  //Puhe alas, sivulta, liikkumatta alas
  kissak_arkki[15].x = 0;
  kissak_arkki[15].y = 0;
  kissak_arkki[15].w = 0;
  kissak_arkki[15].h = 0;
  kissak_arkki[16].x = 159;
  kissak_arkki[16].y = 0;
  kissak_arkki[16].w = 234-159;
  kissak_arkki[16].h = 140;
  kissak_arkki[17].x = 0;
  kissak_arkki[17].y = 0;
  kissak_arkki[17].w = 0;
  kissak_arkki[17].h = 0;
  //Ilmeet:
  //Seisotaan kasvot kameraa kohden, surullinen hmmstys
  kissak_arkki[18].x = 208;
  kissak_arkki[18].y = 56;
  kissak_arkki[18].w = 75;
  kissak_arkki[18].h = 51;
  //Sad
  kissak_arkki[19].x = 274;
  kissak_arkki[19].y = 0;
  kissak_arkki[19].w = 45;
  kissak_arkki[19].h = 51;
}

//Julistusten jrjestys tss mr, mihin numeroihin insert_kup()in puhuja-parametri viittaa
hahmoluokka koira2;
hahmoluokka koira1;
hahmoluokka kissa;
hahmoluokka naata;
hahmoluokka mayra;
hahmoluokka drops;
hahmoluokka kissak;

class esineluokka {
public:
  int ruudulla; //Onko esine ruudulla ja monennessako hahmonpiirtokerroksessa
  pair<double, double> sijainti;
  tekstuuriluokka *tekstuuri;
  esineluokka();
  void esineenpiirto();
};

vector<esineluokka*> esinevektori; //Vektori, johon liitetn esineluokan jseniin osoittavat pointterit

esineluokka::esineluokka():
  ruudulla(0), tekstuuri(NULL), sijainti{0, 0} {
  esinevektori.push_back(this);
}

void esineluokka::esineenpiirto() {
  tekstuuri->renderfunktio(sijainti.first-kamerax1,sijainti.second);
}

esineluokka poyta;
esineluokka kpoyta;
esineluokka poyta3;
esineluokka rv;
esineluokka ruoka;
esineluokka tuoli;
esineluokka tuoli2;
esineluokka kaide;
esineluokka wcoa;
esineluokka wcok;
esineluokka roa;

bool init() {
  bool toimiiko = true;
  if(SDL_Init(SDL_INIT_VIDEO)<0) {
    cerr << "SDL init fail - " << SDL_GetError() << endl;
    toimiiko = false;
  }
  else {
    //Tekstuurien filtterinti lineaariseksi
    if(!SDL_SetHint(SDL_HINT_RENDER_SCALE_QUALITY, "1")) cerr << "Linear filtering failed" << endl;

    ikkuna = SDL_CreateWindow("Hanna-Kaisan tietokonekerho", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, RUUDUNLEVEYS, RUUDUNKORKEUS, SDL_WINDOW_SHOWN | ( fullscreen ? SDL_WINDOW_FULLSCREEN : SDL_WINDOW_RESIZABLE ) );
    if(ikkuna == NULL) {
      cerr << "Window creation failed - " << SDL_GetError() << endl;
      toimiiko = false;
    }
    else {
      piirturi = SDL_CreateRenderer(ikkuna, -1, SDL_RENDERER_ACCELERATED);
      SDL_RenderSetLogicalSize(piirturi, RUUDUNLEVEYS, RUUDUNKORKEUS);
      SDL_RendererInfo piirturi_info;
      SDL_GetRendererInfo(piirturi, &piirturi_info);
      cout << "Your renderer is: " << piirturi_info.name << endl;
      cout << "Max texture width for your renderer: " << piirturi_info.max_texture_width << endl;
      cout << "Max texture height for your renderer: " << piirturi_info.max_texture_height << endl;
      cout << "This program requires around 2048 px texture width & height to work flawlessly" << endl;
      if(piirturi == NULL) {
	cerr << "Renderer creation fail - " << SDL_GetError() << endl;
	toimiiko = false;
      }
      else {
	SDL_SetRenderDrawColor(piirturi, 0xFF, 0xFF, 0xFF, 0xFF);
	int imgFlags = IMG_INIT_PNG;
	if(!(IMG_Init(imgFlags)&imgFlags)) {
	  cerr << "SDL_image fail - " << IMG_GetError() << endl;
	  toimiiko = false;
	}
	else {
	  if(TTF_Init() == -1) cerr << "TTF Init fail" << TTF_GetError() << endl;
	}
      }
    }
  }
  return toimiiko;
}


bool lataamedia() {
  bool toimiiko = true;
  if(!kissateks.tiedostonlataus("animpng/hk.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!kissakteks.tiedostonlataus("animpng/hkk.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!koirateks1.tiedostonlataus("animpng/te-frames.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!koirateks2.tiedostonlataus("animpng/val-frames.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!naatateks.tiedostonlataus("animpng/ma-frames.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!mayrateks.tiedostonlataus("animpng/bad-frames.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
    if(!dropsteks.tiedostonlataus("animpng/sweat2.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!koti.tiedostonlataus("animpng/koti.png")) {
    cerr << "png koti load fail" << endl;
    toimiiko = false;
  }
  if(!rappu.tiedostonlataus("animpng/rappu.png")) {
    cerr << "png rappu load fail" << endl;
    toimiiko = false;
  }
    if(!wc.tiedostonlataus("animpng/wc.png")) {
    cerr << "png wc load fail" << endl;
    toimiiko = false;
  }
  if(!wcoateks.tiedostonlataus("animpng/wcoa.png")) {
    cerr << "png wcoa load fail" << endl;
    toimiiko = false; 
  }
  if(!wcokteks.tiedostonlataus("animpng/wcok.png")) {
    cerr << "png wcok load fail" << endl;
    toimiiko = false;
  }
  if(!roateks.tiedostonlataus("animpng/roa.png")) {
    cerr << "png roa load fail" << endl;
    toimiiko = false;
  }
  if(!loppu.tiedostonlataus("animpng/loppu.png")) {
    cerr << "png loppu load fail" << endl;
    toimiiko = false;
  }
  if(!poytateks.tiedostonlataus("animpng/poyta.png")) {
    cerr << "png pyt load fail" << endl;
    toimiiko = false;
  }
  if(!kpoytateks.tiedostonlataus("animpng/poyta2.png")) {
    cerr << "png kpyt load fail" << endl;
    toimiiko = false;
  }
    if(!poyta3teks.tiedostonlataus("animpng/poyta3.png")) {
    cerr << "png pyt3 load fail" << endl;
    toimiiko = false;
  }
  if(!rvteks.tiedostonlataus("animpng/rv.png")) {
    cerr << "png rv load fail" << endl;
    toimiiko = false;
    }
  if(!tuoliteks.tiedostonlataus("animpng/tuoli.png")) {
    cerr << "png tuoli load fail" << endl;
    toimiiko = false;
    }
  if(!tuoli2teks.tiedostonlataus("animpng/tuoli2.png")) {
    cerr << "png tuoli2 load fail" << endl;
    toimiiko = false;
  }
  if(!kaideteks.tiedostonlataus("animpng/kaide.png")) {
    cerr << "png tuoli kaide fail" << endl;
    toimiiko = false;
    }
  if(!ruokateks.tiedostonlataus("animpng/ruoka5.png")) {
    cerr << "png ruoka load fail" << endl;
    toimiiko = false;
    }
  if(!pimee.tiedostonlataus("animpng/pimee.png")) {
    cerr << "pimee.png load fail" << endl;
    toimiiko = false;
  }
  if(!logo.tiedostonlataus("animpng/logo.png")) {
    cerr << "logo.png load fail" << endl;
    toimiiko = false;
  }
  if(!postlogo.tiedostonlataus("animpng/postlogo.png")) {
    cerr << "postlogo.png load fail" << endl;
    toimiiko = false;
  }
  if(!alkukuva.tiedostonlataus("animpng/alkukuva.png")) {
    cerr << "alkukuva.png load fail" << endl;
    toimiiko = false;
  }
  if(!alkukuva_en.tiedostonlataus("animpng/alkukuva-en.png")) {
    cerr << "alkukuva-en.png load fail" << endl;
    toimiiko = false;
  }
  if(!kadet.tiedostonlataus("animpng/kadet.png")) {
    cerr << "kadet.png load fail" << endl;
    toimiiko = false;
  }
  if(!sydan.tiedostonlataus("animpng/sydan.png")) {
    cerr << "sydan.png load fail" << endl;
    toimiiko = false;
  }
  if(!s_tausta.tiedostonlataus("animpng/s_tausta.png")) {
    cerr << "s_tausta.png load fail" << endl;
    toimiiko = false;
  }
  if(!kosoitin.tiedostonlataus("animpng/osoitin.png")) {
    cerr << "osoitin.png load fail" << endl;
    toimiiko = false;
  }
  if(!kosoitin90.tiedostonlataus("animpng/osoitin90.png")) {
    cerr << "osoitin90.png load fail" << endl;
    toimiiko = false;
  }
  if(!kupkulma.tiedostonlataus("animpng/kupkulma.png")) {
    cerr << "kupkulma.png load fail" << endl;
    toimiiko = false;
  }
  else pimee.aseta_blend(SDL_BLENDMODE_BLEND);
  return toimiiko;
}

void tyhjenna_irc() {
  for(vector<irc_rivi>::iterator clear_iter = irc_teksturet.begin(); clear_iter != irc_teksturet.end(); ++clear_iter) {
    SDL_DestroyTexture(clear_iter->aikaleima);
    SDL_DestroyTexture(clear_iter->nikki);
    SDL_DestroyTexture(clear_iter->sanoma);
    irc_teksturet.erase(clear_iter);
    --clear_iter;
  }
}

void sammutus() {
  wc.erase();
  koti.erase();
  rappu.erase();
  loppu.erase();
  pimee.erase();
  logo.erase();
  postlogo.erase();
  alkukuva.erase();
  alkukuva_en.erase();
  kadet.erase();
  sydan.erase();
  s_tausta.erase();
  kosoitin.erase();
  kosoitin90.erase();
  kupkulma.erase();
  wcoateks.erase();
  wcokteks.erase();
  roateks.erase();
  koirateks1.erase();
  koirateks2.erase();
  kissateks.erase();
  kissakteks.erase();
  naatateks.erase();
  mayrateks.erase();
  dropsteks.erase();
  poytateks.erase();
  kpoytateks.erase();
  poyta3teks.erase();
  rvteks.erase();
  ruokateks.erase();
  tuoliteks.erase();
  tuoli2teks.erase();
  kaideteks.erase();
  
  SDL_DestroyRenderer(piirturi);
  SDL_DestroyWindow(ikkuna);
  ikkuna = NULL;
  piirturi = NULL;

  SDL_DestroyTexture(irc_kirjoitus);

  tyhjenna_irc();

  IMG_Quit();
  int ohjelma_aika = SDL_GetTicks()/1000;
  cout << "Program running time: " << ohjelma_aika/60 << "m" << ohjelma_aika%60 << "s" << endl;
  SDL_Quit();
}

void tekstirend(int bw, int bh, int moneskorivi, string teksti, TTF_Font* kirjaisinlaji) {
  int rivinasetus = (5+((moneskorivi-1)*merkinkorkeus)); //Arvo 5 on vli ylreunasta. Kursorirendiss on vastaava (bubh+5)
  SDL_Surface* pinta2 = TTF_RenderText_Solid(kirjaisinlaji, teksti.c_str(), vaeri);
  int tekstinleveys = pinta2->w;
  SDL_Texture* tekstuuri2 = SDL_CreateTextureFromSurface(piirturi, pinta2);
  SDL_Rect tekstinelio = {bw+5, bh+rivinasetus-skrollausarvo+RIVIVALI*(moneskorivi-1), tekstinleveys, merkinkorkeus};
  SDL_RenderCopy(piirturi, tekstuuri2, NULL, &tekstinelio);
  SDL_FreeSurface(pinta2);
  SDL_DestroyTexture(tekstuuri2);
}

void kursorirend(int bubw, int bubh, int rivinumero, int kirjaimennumero, string merkki, TTF_Font* kirjaisinlaji) {
  //bubh on kuplan sivuttain menevn palkin ylreuna eli siit alkaa se teksti suoraan
  rivinumero--;
  bubh += merkinkorkeus*rivinumero;
  kirjaimennumero--;
  bubw += merkinpituus*kirjaimennumero;
  SDL_Surface* pinta3 = TTF_RenderText_Solid(kirjaisinlaji, merkki.c_str(), vaeri);      
  SDL_Texture* peitekirjain = SDL_CreateTextureFromSurface(piirturi, pinta3); 
  SDL_Rect tekstinelio = {bubw+5, bubh+5+RIVIVALI*(rivinumero), merkinpituus, merkinkorkeus};  //bubh+5:ssa 5 on rako kuplan ylreunan ja alkavan tekstin vlill
  SDL_SetRenderDrawColor(piirturi, 0xFF, 0xA5, 0x00, 0x00);
  SDL_RenderFillRect(piirturi, &tekstinelio);   //kursori pit rendata tss eri vristen tekstien vliss
  SDL_RenderCopy(piirturi, peitekirjain, NULL, &tekstinelio);
  SDL_FreeSurface(pinta3);
  SDL_DestroyTexture(peitekirjain);
}

//Funktio, joka palauttaa stringin kirjainmerkin, joka pit sill kertaa nytt kursorissa (sama aina mik j kursorin alle)
string kursorikirjain(int rivinum, int kirjainnum) {
  string kirjain;
  vector<string>::iterator kuriter = vuorosanavec.begin()+(rivinum-1);
  kirjain = (*kuriter)[kirjainnum-1];
  return kirjain;
}

bool onkoriviloppu(int rivinum, int kirjainnum) {
  string rimpsu;
  vector<string>::iterator onkoiter = vuorosanavec.begin()+(rivinum-1);
  rimpsu = *onkoiter;
  return rimpsu.length() == kirjainnum; 
}

//Vuorosanan sopivanpituisiin riveihin ptkiv funktio
//Looppeja, jotka kyvt vuorosanaa alusta aina rivinpituuden kohdalta lpi taaksepin ja ensimmisen vlilynnin kohdalla laittavat seuraavaksi riviksi sit edeltvt merkit ja poistavat ne vuorosanasta
void autowrap(int rivinpituus, string vuorosana1) {
  string tempstring;
  int marker = 0; //Tmn pitisi merkata koko stringin viimeinen vlilynti
  for(int m = vuorosana1.length(); marker == 0;  m--) {
    if(vuorosana1[m] == ' ') marker = vuorosana1.length()-m;
  }
  for(int i = rivinpituus; vuorosana1.length() > marker; i--) {
    if(vuorosana1[i] == ' ') {
      //looppi joka tekee tempstringiin stringin joka listn elementiksi vuorosanavec:iin
      tempstring = "";
      for(int j = 0; j <= i; j++) tempstring += vuorosana1[j];
      vuorosanavec.push_back(tempstring);
      //Poistetaan yht pitk ptk (se vektoriin listty) vuorosana1:st, deletoidaan aina alusta merkki
      for(int k = 0; k <= i; k++) vuorosana1.erase(0,1);
      i = rivinpituus;
    }
  }
  //Edelliset loopit perustuvat vlilyntiin, joten viimeinen sana j yleens yli ilman vlilynti ja pit list erikseen
  if(vuorosana1 != "" or vuorosana1 != " ") {
    vector<string>::iterator iter = --vuorosanavec.end();
    //Mahtuuko viimeinen sana samalle riville
    if((*iter).length() + vuorosana1.length() <= rivinpituus) *iter += vuorosana1; //Tuohon *iterin ja vuorosana1:n vertailuun nytt sisltyvn niiden vliss oleva vlilyntikin korrektisti
    else vuorosanavec.push_back(vuorosana1);
  }
}

void tyhjenna_vektori() {
  for(vector<string>::iterator clear_iter = vuorosanavec.begin(); clear_iter != vuorosanavec.end(); ++clear_iter) {
    vuorosanavec.erase(clear_iter);
    --clear_iter;
  }
  for(vector<hahmoluokka*>::iterator clear2_iter = hahmovektori.begin(); clear2_iter != hahmovektori.end(); ++clear2_iter) {
    if((*clear2_iter)->puhilme != 0) {
      (*clear2_iter)->puhilme = 0;
      break;
    }
  }
}

void aseta_puhuja(int puhuja, int ilme) {
  //Nyt oletuksena on, ett puhuja -arvot alkavat nollasta (size alkaa 1:st)
  if(puhuja >= hahmovektori.size()) {
    cerr << "Liian suuri arvo aseta_puhuja -vektoriin" << endl;
  }
  vector<hahmoluokka*>::iterator p_iter = hahmovektori.begin()+puhuja;
  kuppoint = &(*p_iter)->sijainti;
  (*p_iter)->puhilme = ilme;
}

//Funktio, joka luo seuraavan (vektorin ensimmisen) kuplan kuplavektorista. Mritelln kuplakohtaiset kuplan mitat (joiden mahdolliset poikkeavat arvot annetaan tarinafunktiossa), kutsutaan autowrap jakamaan teksti, tarkistetaan, pitisik tekstin skrollata, vai mahtuuko se kuplaan
void kuplanluonti(int frame_nyt) {
  if(kuplavec.size() == 0) cerr << "Kuplavektori on tyhj, vaikka yritetn luoda kuplaa" << endl;
  vector<kupla>::iterator kupiter = kuplavec.begin();
  tarina_kt = (*kupiter).timer;
  aseta_puhuja((*kupiter).kuka, (*kupiter).vilme);
  vuorosana1 = (*kupiter).puhe;
  kuplanpituus = (*kupiter).pituus;
  kuplankorkeus = (*kupiter).korkeus;
  mikarivi.first = 1;
  mikarivi.second = 1;
  skrollausarvo = 0;
  kupasema = (*kupiter).asemointi;

  kuplanpituus == 0 ? tempkuppituus = OLETUSKUPLANPITUUS : tempkuppituus = kuplanpituus; //Thn voi laittaa mys kuplanpituudet 1, 2, 3... jos niihin haluaa "vaihtoehtoisia oletuksia"
  rivinpituus = ((tempkuppituus - KUPVASBORDER - KUPOIKBORDER) / merkinpituus);

  if(rivinpituus < vuorosana1.length()) kursoripaalla = 1;

  if(vuorosana1.length() > rivinpituus) autowrap(rivinpituus, vuorosana1);  //Rivinkatkaisufunktioon
  else {
    vuorosanavec.push_back(vuorosana1); //Paitsi jos vuorosana on rivi lyhyempi
    tempkuppituus = vuorosana1.length()*merkinpituus+40; //Tllin mys kupla laitetaan lyhyemmksi leveydeltn.
    if(tempkuppituus < 80) tempkuppituus = 80;
  }

  //jos kuplankorkeus on 1, kytetn oletusarvoja, jos 0, lasketaan sopiva korkeus
  if(kuplankorkeus == 1) tempkupkorkeus = OLETUSKUPLANKORKEUS;
  else if(((*kupiter).asemointi == 3) and kuplankorkeus == 0) {
    if(kuppoint->second+40 - ((merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER) < 0) tempkupkorkeus = kuppoint->second+40; //Jos sivuylkupla ei mahdu ruutuun, korkeus on kattoon asti
    else tempkupkorkeus = (merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER; //Jos taas mahtuu, lasketaan siihen koko kuplan koko
  }
  else if(((*kupiter).asemointi == 5) and kuplankorkeus == 0) {
    if(kuppoint->second+20 + ((merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER) > RUUDUNKORKEUS) tempkupkorkeus = kuppoint->second+40; //Jos sivualakupla ei mahdu ruutuun, korkeus on kattoon asti
    else tempkupkorkeus = (merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER; //Kuten edell
  }
  else if(((*kupiter).asemointi == 4) and kuplankorkeus == 0) {
    if(((merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER) > RUUDUNKORKEUS-20) tempkupkorkeus = RUUDUNKORKEUS-20; //Jos sivualakupla ei mahdu ruutuun, ei ehk kuitenkaan ihan ruudun kokoista kuplaa
    else tempkupkorkeus = (merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER;
  }
  else if(kuplankorkeus == 0) tempkupkorkeus = (merkinkorkeus+RIVIVALI)*vuorosanavec.size()+KUPYLABORDER+KUPALABORDER;
  else tempkupkorkeus = kuplankorkeus;

  //Lasketaan mahdolliset rivit, jotka eivt mahdu kuplaan
  ylirivit = (static_cast<double>(vuorosanavec.size())*(static_cast<double>(merkinkorkeus)+static_cast<double>(RIVIVALI)) - (static_cast<double>(tempkupkorkeus) - static_cast<double>(KUPYLABORDER) - static_cast<double>(KUPALABORDER))) / (static_cast<double>(merkinkorkeus) + static_cast<double>(RIVIVALI));
  kuplantila = 2;
  pkupkounter = frame_nyt;
}

//Tekee uuden kupla-structin kupvektoriin. Jos ei laita paikka-, pituus- ja korkeusarvoja, tulee samat kuin edellisess kuplavektorin repliikiss
void insert_kup(int puhuja, string asia, int timer_kt = 0, int vilmepar = 1, int pit = 999, int kor = 999, int paikka = 6, int vo = 3) {
  kuplantila = 1;
  kupla temp;
  if(timer_kt != 0) temp.timer = timer_kt;
  if(vilmepar != 1) temp.vilme = vilmepar;

  if(puhuja == 99) {
    if(kuplavec.size() == 0) puhuja = 0;
    else {
      vector<kupla>::iterator samiter = kuplavec.end()-1;
      temp.kuka = (*samiter).kuka;
    }
  }
  else temp.kuka = puhuja;
  
  if(vo != 3) kuplavo = vo;
  temp.puhe = asia;
  if(paikka == 6) {
    if(kuplavec.size() == 0) paikka = 1;
    else {
      vector<kupla>::iterator samiter = kuplavec.end()-1;
      temp.asemointi = (*samiter).asemointi;
    }
  }
  else temp.asemointi = paikka;
  
  if(pit == 999) {
    if(kuplavec.size() == 0) pit = 0;
    else {
      vector<kupla>::iterator samiter = kuplavec.end()-1;
      temp.pituus = (*samiter).pituus;
    }
  }
  else temp.pituus = pit;
  
  if(kor == 999) {
    if(kuplavec.size() == 0) kor = 0;
    else {
      vector<kupla>::iterator samiter2 = kuplavec.end()-1;
      temp.korkeus = (*samiter2).korkeus;
    }
  }
  else temp.korkeus = kor;

  kuplavec.push_back(temp);
}

void lisaa_lopputeksti(string teksti, bool tauko) {
  if(teksti == "") teksti = " ";
  SDL_Surface* lpinta = TTF_RenderText_Solid(loppufontti, teksti.c_str(), loppuvari);
  SDL_Texture* lopputekstit = SDL_CreateTextureFromSurface(piirturi, lpinta);
  ltekstit.push_back(generic_lteksti);
  vector<lteksti>::iterator loppu_iter = --ltekstit.end();
  loppu_iter->loppurect.x = 50;
  loppu_iter->loppurect.y = RUUDUNKORKEUS;
  loppu_iter->loppurect.w = lpinta->w;
  loppu_iter->loppurect.h = lpinta->h;
  loppu_iter->ltekstuuri = lopputekstit;
  loppu_iter->taukoa = tauko;
  SDL_FreeSurface(lpinta);

  SDL_Surface* lpinta2 = TTF_RenderText_Solid(loppufontti, teksti.c_str(), loppuvari2);
  SDL_Texture* lopputekstit2 = SDL_CreateTextureFromSurface(piirturi, lpinta2);
  ltekstit2.push_back(generic_lteksti);
  vector<lteksti>::iterator loppu_iter2 = --ltekstit2.end();
  loppu_iter2->loppurect.x = 47;
  loppu_iter2->loppurect.y = RUUDUNKORKEUS+2;
  loppu_iter2->loppurect.w = lpinta2->w;
  loppu_iter2->loppurect.h = lpinta2->h;
  loppu_iter2->ltekstuuri = lopputekstit2;
  loppu_iter2->taukoa = tauko;
  SDL_FreeSurface(lpinta2);
}

void tee_irc_rivi(int sekunnit, SDL_Texture *aika, string nick, string repliikki, int kirj = 0) {
  int rivinpituus = floor(static_cast<double>(RUUDUNLEVEYS)/static_cast<double>(irc_MERKINPITUUS))-1;
  if(nick[0] != ' ' and nick[0] != '@') nick.insert(0, " ");

  int rivimaara = 1;
  if(repliikki.length() > rivinpituus-nick.length()-9) {
    rivimaara += ceil(static_cast<double>((repliikki.length()-(rivinpituus-nick.length()-8)))/static_cast<double>(rivinpituus));
  }
  
  SDL_Surface* pinta7 = TTF_RenderText_Solid(irc_fontti, nick.c_str(), ircvari);
  SDL_Texture* nimi = SDL_CreateTextureFromSurface(piirturi, pinta7);

  string tempstring = "";
  for(int i = 1; i <= rivimaara; i++) {
    for(int j = 0; j <= rivinpituus; j++) {
      tempstring += repliikki[j];
      if(tempstring.length() == repliikki.length()) break;
      if(i == 1 and tempstring.length()+nick.length()+8 == rivinpituus) break;
    }
    SDL_Surface* pinta6 = TTF_RenderText_Solid(irc_fontti, tempstring.c_str(), ircvari);
    SDL_Texture* repla = SDL_CreateTextureFromSurface(piirturi, pinta6);
    irc_teksturet.push_back(generic_irc_rivi);
    SDL_FreeSurface(pinta6);
    vector<irc_rivi>::iterator irc_iter = --irc_teksturet.end();
    i == 1 ? (*irc_iter).aikaleima = aika : (*irc_iter).aikaleima = NULL; 
    (*irc_iter).nikki = nimi;
    (*irc_iter).sanoma = repla;
    (*irc_iter).vpituus = tempstring.length();
    (*irc_iter).npituus = nick.length();
    (*irc_iter).ajastin = sekunnit;
    if(kirj != 0 and i == 1) (*irc_iter).kirjoitus = repliikki; //Repliikki talteen (ensimmisen rivin olioon) stringinkin, jos kyseess on kyttjn kirjoittama repliikki
    for(int k = 0; (i == 1 ? k <= rivinpituus-nick.length()-9 : k <= rivinpituus); k++) repliikki.erase(0,1); //Ensimmisell rivill katkotaan enemmn. 8 = etumerkit.
    tempstring = "";
  }
  SDL_FreeSurface(pinta7);
}

bool tarinafunktio() {
  bool loytyiko = true;

  if(tarinanvaihe == 5) {
    tarinakeskeytys = true;
  }
  else if(tarinanvaihe == 20) {
    musavalinta(9);
    musiikki = 2;
    taustakuva = logo;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 22) feidaus = true;
  else if(tarinanvaihe == 24) {
    musafeidaus = true;
    taustakuva = postlogo;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 26) feidaus = true;
  else if(tarinanvaihe == 28) {
    musavalinta(1);
    musiikki = 2;
    alkutekstit++;
    taustakuva = pimee;
    tarina_t = 6;
  }
  else if(tarinanvaihe == 32) {
    alkutekstit++;
    taustakuva = alkukuva;
    tarina_t = 15;
  }
  else if(tarinanvaihe == 34) {
    musafeidaus = true; 
    feidaus = true;
  }
  else if(tarinanvaihe == 36) {
    alkutekstit++;
    tarina_t = 4;
  }
  else if(tarinanvaihe == 80) {
    musavalinta(10);
    musiikki = 2;
    hahmoja = true;
    taustakuva = rappu;
    kaide.ruudulla = 1;
    kaide.sijainti.first = 0;
    kaide.sijainti.second = 341;
    mayra.ruudulla = 2;
    mayra.rintamasuunta = 8;
    mayra.sijainti.first = -30;
    mayra.sijainti.second = 246;
    mayra.waypoint1.first = 324;
    mayra.waypoint1.second = 220;
    mayra.waypoint2.first = 324;
    mayra.waypoint2.second = 210;
  }
  else if(tarinanvaihe == 82) {
    tarina_t = 2;
  }
  else if(tarinanvaihe == 84) {
    roa.ruudulla = 3;
    roa.sijainti.first = 271;
    roa.sijainti.second = 173;
    tarina_t = 2;
  }
  else if(tarinanvaihe == 86) {
    mayra.waypoint1.first = 318;
    mayra.waypoint1.second = 184;
    tarina_t = 2;
  }
  else if(tarinanvaihe == 88) {
    musiikki = 3;
    mayra.ruudulla = 0;
    roa.ruudulla = 0;
    tarina_t = 4;
  }
  
  else if(tarinanvaihe == 100) {
    musavalinta(11);
    musiikki = 2;
    kaide.ruudulla = 0;
    hahmoja = true;
    taustakuva = koti;
    koira1.ruudulla = 3;
    koira1.sijainti.first = 266;
    koira1.sijainti.second = 225;
    koira1.rintamasuunta = 4;

    poyta.ruudulla = 3;
    poyta.sijainti.first = 816;
    poyta.sijainti.second = 274;
    tuoli2.ruudulla = 4;
    tuoli2.sijainti.first = 1155;
    tuoli2.sijainti.second = 258;
    
    kissa.ruudulla = 4;
    kissa.sijainti.first = 800;
    kissa.sijainti.second = 175;

    mayra.ruudulla = 2;
    mayra.sijainti.first = 110;
    mayra.sijainti.second = 230;
    mayra.rintamasuunta = 6;
      
    koira2.ruudulla = 4;
    koira2.flip = 1;
    koira2.sijainti.first = 950;
    koira2.sijainti.second = 170;

    naata.ruudulla = 4;
    naata.sijainti.first = 670;
    naata.sijainti.second = 170;

    tarinakeskeytys = true;
  }

  else if(tarinanvaihe == 101) {
    insert_kup(1, "Hei, bagbiter! Min olen perlmutter ...tai siis ihan vaan Tepsa.");
    insert_kup(4, "Hei, oikea nimeni on Erno.");
    insert_kup(1, "Saavuitkin ajoissa paikalle.");
    insert_kup(4, "Bussi oli vhn myhss, mutta talo lytyi helposti.");
    insert_kup(1, "Tule vain peremmlle!");
  }
  else if(tarinanvaihe == 105) {
    koira1.waypoint1.second = 240;
    koira1.waypoint2.first = 640;
    koira1.waypoint2.second = 320;
    koira1.waypoint3.first = 1100;
    koira1.waypoint3.second = 320;
    koira1.waypoint4.first = 1100;
    koira1.waypoint4.second = 264;
    mayra.waypoint1.first = 300;
    mayra.waypoint1.second = 280;
    mayra.waypoint2.first = 657;
    mayra.waypoint2.second = 300;
    kamskrolli = 2;
    skrollihalt = 530; //Maksimiarvo tlle on kuvan koko X-akselilla miinus RUUDUNLEVEYS (eli 1280 tss produktiossa, jossa 1960 on taustakuvan X-koko)
  }
  else if(tarinanvaihe == 107) {
    insert_kup(1, "Tss ovat siis Hanna-Kaisa...");
    insert_kup(2, "Hei!");
    insert_kup(1, "Valtsu...");
    insert_kup(0, "Hei!");
    insert_kup(1, "...ja Sirkku");
    insert_kup(3, "Hei!");
    insert_kup(1, "Muistat varmaan heidn nickins.");
    insert_kup(4, "Joo", 2);
    insert_kup(2, "Kiva tosiaan ett saavuit vihdoin!");
    insert_kup(2, "Siis haluan ihan korostaa, ett minusta on hienoa, ett uskalsit lopulta tulla tnne, vaikka me olemme sinua hiukan vanhempia ja vaikka tll ei ole muita myri.");
    insert_kup(2, "...ja vaikka me ollaan narttujakin - siis min ja Tepsa ja Sirkku.");
    insert_kup(2, "Ei kai sinua jnnit?");
    insert_kup(4, "Ei minua jnnit - olenhan ottanut kolme pilleri bentsodiatsepiinia.");
    insert_kup(2, "No mutta sittenhn sinua on jnnittnyt varmaan aivan kauheasti!", 0, 2);
  }
  else if(tarinanvaihe == 110) {
    kissa.ilme = 2;
    tarina_t = 1;
  }
  else if(tarinanvaihe == 111) {
    kissa.ilme = 1;
    insert_kup(2, "Ei sinun olisi tarvinnut jnnitt - me olemme todella kilttej!");
    insert_kup(4, "Otin ne kyll jo koulua varten.", 1);
    insert_kup(1, "Onhan se aina jnnittv tavata uusia elimi, mutta hienoa, ett olet lytnyt lkkeit, joista saat apua ja upeaa tosiaan, ett tulit tnne paikalle.");
    insert_kup(2, "Niin, tm niin sanottu IRL on toki hyvin kmpel kommunikaatio- protokolla verrattuna IRCiin tai shkpostilistoihin, mutta en tied, voiko elm jtt kokonaan vain tietoverkkoihin.");
    insert_kup(2, "Emoni sanoi, ett minulla pitisi olla oikeita kavereita ja juuri siksihn olen koonnut tt kerhoa.");
    insert_kup(0, "Joo, tll tavalla me voidaan ktevsti opetella vhn tietoverkkojen ulkopuolista elm. Siit on varmasti hyty tulevaisuudessa.");
    insert_kup(2, "Joka tapauksessa... Kuten viestittelyssmme onkin jo tullut ilmi, kerhomme pfunktio on siis toimia paikkana etenkin proseduraalisten ohjelmointikielien, POSIX-mritelmien mukaisten vapaiden kyttjrjestelmien, netti-protokollien ja serverien toiminnan opetteluun ...ja siis ylipns kaikenlaisen kukkahattuhakkerismin harjoittamiseen.", 0, 1, 500, 130);
    insert_kup(0, "Mys jotain demoskene-projekteja on ollut, Tepsa ainakin on piirrellyt jotain kuvia GIMPill ja Sirkku rustannut ANSIa.", 0, 1, 0, 0);
    insert_kup(2, "Tausta-ajatuksemme on tietysti edist informaation levimist vapaasti verkossa olevien elinten vlill lajirajoista riippumatta, mutta kaikissa periaatteellisissa kysymyksiss emme ole saavuttaneet yhteisymmrryst. Esimerkiksi sen suhteen, miten pitklle epvapaiden ohjelmistojen kytt on hyvksyttv.", 0, 1, 500, 130);
    insert_kup(0, "Parempi kuitenkin varmasti on, ett me nsst pidmme yht, emmek vajoa mihinkn loputtomaan liekkisotaan esimerkiksi NetBSD:n ja CentOSin paremmuudesta, vaikka aineksia johonkin sellaiseen tss porukassa varmaan olisikin.", 0, 1, 0, 0);
    insert_kup(1, "Juuri niin!");
    insert_kup(2, "Kaikki yksityiskohdat eivt ole meille viel selvi, mutta tuskin voimme menn vikaan, jos vain seuraamme menneiden vuosikymmenten legendaaristen UNIX-mursujen viitoittamaa tiet.", 1);
    insert_kup(2, "Mutta... Miks sinun tilanteesi olikaan? Olit vasta aloittelemassa ohjelmointia...");
    insert_kup(4, "Niin, olen kyll ohjelmoinut vhn ennenkin, mutta olen vasta nyt aloitellut kunnolla harjoittelemaan.");
    insert_kup(4, "Minulla on kotona kytss meidn yhteinen tietokone, enk voi ptt tysin siit, koska sit kyttvat muutkin.");
    insert_kup(4, "Sill voi kyll ohjelmoida C:t, mutta siin on sellainen kyttjrjestelm, jossa ei taida olla edes monoliittista kerneli.");
    insert_kup(0, "Kyllhn noita tietokoneita lytyy helposti, ei vanhemmista tarvitse maksaakaan. Voidaan etsi sinulle jokin.");
    insert_kup(3, "Spottasin eilen Oraclen parkkipaikalta lupaavan nkisen jtelavan.", 1);
    insert_kup(4, "Sitten minua on vhn mietityttnyt se, kun yhdell nettifoorumilla joku kolli sanoi, etteivt myrt oppisi C++:aa, Assembly tai muita vhn monimutkaisempina pidettyj kieli.", 1);
    insert_kup(1, "Kyll sin varmasti opit mink tahansa kielen, jos opiskelet pttvisesti.");
    insert_kup(1, "...etenkin jos me koirat vhn autamme!");
    insert_kup(2, "Kannattaa tietysti aloittaa ohjelmoiminen aina heti, kun lksyt on tehty, niin ehtii saada paljon harjoitusta.", 1);
    insert_kup(2, "Mutta nyt voisimme kai siirty eteenpin...");
    insert_kup(2, "Eli kuten oli jo puhetta netiss, meidn kerholla oli nm psykokeet. Niiden tarkoitus on ikn kuin varmistaa, ett olet tarpeeksi pehme elin meidn kerhoomme.");
    insert_kup(2, "Tm ei nyt kuitenkaan ole tietenkn yhtn mikn jnnittv juttu, vaan ihan tllainen leikkimielinen testi. Jos oikeasti kuitenkin eponnistut, niin voidaan mietti sitten yhdess, miten pstn eteenpin.");
    insert_kup(2, "Voimme kai tss vaiheessa siirty keittin?");
    insert_kup(1, "Joo.");
  }

  //ENSIMMINEN TESTI
 else if(tarinanvaihe == 170) {
   hahmoja = true;
   taustakuva = koti;
   koira1.ruudulla = 3;
   koira1.rintamasuunta = 4;

   poyta.ruudulla = 2;
   poyta.sijainti.first = 816;
   poyta.sijainti.second = 274;

   kpoyta.ruudulla = 3;
   kpoyta.sijainti.first = 1470;
   kpoyta.sijainti.second = 301;
   rv.ruudulla = 2;
   rv.sijainti.first = 1592;
   rv.sijainti.second = 307;
   ruoka.ruudulla = 3;
   ruoka.sijainti.first = 1542;
   ruoka.sijainti.second = 307;
   tuoli.ruudulla = 3;
   tuoli.sijainti.first = 1538;
   tuoli.sijainti.second = 277;
    
   kissa.ruudulla = 4;
   kissa.sijainti.first = 800;
   kissa.sijainti.second = 175;

   mayra.ruudulla = 2;
   mayra.rintamasuunta = 6;
      
   koira2.ruudulla = 3;
   koira2.flip = 1;
   koira2.sijainti.first = 950;
   koira2.sijainti.second = 170;

   naata.sijainti.first = 670;
   naata.sijainti.second = 170;
 
   koira1.sijainti.first = 1100;
   koira1.sijainti.second = 264;

   kissa.ruudulla = 4;
   kissa.waypoint1.first = 1372;
   kissa.waypoint1.second = 275;
   kissa.waypoint2.first = 1400;
   kissa.waypoint2.second = 210;
   kissa.waypoint3.first = 1654;

   koira2.waypoint1.first = 1100;
   koira2.waypoint1.second = 200;
   koira2.waypoint2.first = 1250;
   koira2.waypoint2.second = 340;
   koira2.waypoint3.first = 1780;
   koira2.rintamasuunta = 4;

   mayra.sijainti.first = 657;
   mayra.sijainti.second = 300;
   mayra.waypoint1.first = 800;
   mayra.waypoint1.second = 326;
   mayra.waypoint2.first = 1400;

   koira1.ruudulla = 4;
   koira1.waypoint1.first = 1385;
   koira1.waypoint1.second = 275;
   koira1.waypoint2.first = 1402;
   koira1.waypoint2.second = 190;
   koira1.rintamasuunta = 2;
    
   naata.waypoint1.first = 1100;
   naata.waypoint1.second = 200;
   naata.waypoint2.first = 1250;
   naata.waypoint2.second = 340;
   naata.waypoint3.first = 1600;
   naata.waypoint3.second = 380;
   naata.ruudulla = 3;
   naata.rintamasuunta = 8;
   naata.wp2muutos = 1;

   kamskrolli = 2;
   skrollihalt = 1280; 
 }
 else if(tarinanvaihe == 171) {
   musafeidaus = true;
   tarina_t = 4;
   tuoli.ruudulla = 4;
 }
 else if(tarinanvaihe == 172) {
   musavalinta(5);
   musiikki = 2;
    insert_kup(2, "Ensimmisess testiss on ajatuksena selvitt, miten hakkerihenkinen olet.");
    insert_kup(2, "Eli tarkoitus olisi, ett voisit kertoa meille vhn omista hakkeroinneistasi, ett millaisia hakkerointeja olet tehnyt.");
    insert_kup(4, "Tuota...");
    insert_kup(4, "h...", 3);
    insert_kup(4, "Minhn olen vasta aivan aloittelija niss ohjelmointijutuissa. En kai min ole hakkeroinut mitn...");
    insert_kup(2, "Ehk oletkin! Hakkerointihan on paljon laajempi asia kuin vain ohjelmointi tai tietokoneen kytt.");
    insert_kup(2, "Uusia kekseliit tapoja kytt esineit ja saavuttaa erilaisia tavoitteita voi lyt monenlaisisten asioiden piirist. On esimerkiksi mainittu, ett useimpien elinten ensimminen hakkerointi on kulkea liukuportaita vrn suuntaan.");
    insert_kup(2, "Samoin symisen voi hakkeroida esimerkiksi kyttmll useampaa sympuikkoa samaan aikaan ja kadulla voi hakkeroida muuttelemalla ovelasti katukylttien tekstej toisenlaisiksi. Uskoisin, ett kaikki ovat hakkeroineet joskus jotain.", 2);
    insert_kup(4, "Hmm... Tuota...", 2);
    insert_kup(4, "No ensimmiseksi minulle tulee ainakin mieleen se, kun tutkin koulutehtvn yhteydess lintujen muuttoreittej ja suunnistamista...");
    insert_kup(4, "Laitoin sitten kerrostalon katolle valoja, joiden tarkoitus oli ohjata thtitaivaan avulla suunnistavia lintuja optimaalisille reiteille.", 1);
    insert_kup(0, "Olet siis hakkeroinut thtitaivaan.", 0, 1, 0, 0, 4);
    insert_kup(4, "No, ehk...", 0, 1, 0, 0, 1);
    insert_kup(4, "Toinen juttu, mik tulee mieleen on, ett olen keksinyt, ett kuulakrkikynll saa auki naapurin ruokavaraston lukon. Joskus pennumpana olen hakenut sielt hilloa.", 1);
    insert_kup(4, "Sitten tuli mieleen viel sellainen juttu, ett kerran kun rahat olivat loppuneet, enk olisi pssyt normaalisti junalla kotiin Masabyst, matkustin teippaamalla itseni ilmastointiteipill junan kylkeen.");
    insert_kup(3, "Wow!");
    insert_kup(1, "Vaikutat kyll rohkealta ja kekselilt.");
    insert_kup(2, "Kyll, lpisit eittmtt tmn kokeen.");
    insert_kup(2, "Syyt on kuitenkin muistaa, ett todelliset hakkerit eivt kyt tietojaan pahantekemiseen kuten varastamiseen.");
    insert_kup(1, "No, emmekhn me kaikki ole joskus ruokaa khveltneet.", 1);
    insert_kup(2, "Mutta sitten siis seuraavaan kokeeseen. Istuhan pydn reen.");
  }
  else if(tarinanvaihe == 181) {
    mayra.waypoint1.first = 1410;
    mayra.waypoint1.second = 245;
    mayra.waypoint2.first = 1540;
    mayra.ruudulla = 4;
    mayra.rintamasuunta = 2;
  }
  else if(tarinanvaihe == 182) {
    tarina_t = 1;
  }
  else if(tarinanvaihe == 183) {
    insert_kup(2, "Kuten olemme jo kertoneet, on meidn kerhollemme lajien vlinen solidaarisuus erittin trke. Tsthn rehtorikin puhuu aina koulussa.");
    insert_kup(2, "Tss testiss demonstroit sitoutumisesi thn kerhollemme trken asiaan symll kissanruokaa.");
  }
  else if(tarinanvaihe == 185) {
    mayra.ilme = 3;
    insert_kup(4, "hh...", 2);
  }
  else if(tarinanvaihe == 189) {
    mayra.ilme = 1;
    insert_kup(4, "No ehk se onnistuu... Olenhan pentuna nuollut seinilt lyijymaaliakin.", 2);
  }
  else if(tarinanvaihe == 191) {
    ruokaa = 1;
    mayra.rintamasuunta = 123;
    mayra.sijainti.second = 245;
    rv.ruudulla = 0;
    mayra.ruudulla = 1;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 193) {
    insert_kup(1, "Tm koe oli tysin Hanna-Kaisan ideoima...", 3);
    insert_kup(2, "Kerhoomme ovat tervetulleita kaikki sapiens-tason elimet lajista riippumatta.", 2);
    insert_kup(0, "Tss suhteessa teemme selvn eron esimerkiksi demoskene-ryhmn Eksoottiset Apinat.", 3, 1, 0, 0, 4);
    insert_kup(1, "Tarkistin, ett kissanruoasta ei pitisi aiheutua ongelmia myrille.", 2, 1, 0, 0, 1);
    insert_kup(3, "Senhn nkee sitten viimeistn huomenna.", 2);
    insert_kup(0, "Heitmme alustamattomia arvoja ruoansulatusfunktioon. Seuraukset ovat mrittelemttmt.", 6, 1, 0, 0, 4);
  }
  else if(tarinanvaihe == 208) {
    ruokaa = 2;
    mayra.rintamasuunta = 2;
    mayra.sijainti.second = 245;
    mayra.ruudulla = 4;
    rv.ruudulla = 2;
    insert_kup(2, "Milts maistui?", 1, 1, 0, 0, 1);
    insert_kup(4, "Varsin itel maku nin kkiseltn... Ehk tm vaatisi enemmn totuttelua.");
    insert_kup(1, "Mutta vuoka on tyhj eli taidettiin selvit tstkin testist.");
    insert_kup(1, "Voisimme ehk siirty jo takaisin olohuoneeseen, niin ei j keittin turhaan ylimrisi hajujlki.");
  }

//Kolmas testi
  else if(tarinanvaihe == 232) {
    hahmoja = true;
    taustakuva = koti;

    poyta.ruudulla = 3;
    poyta.sijainti.first = 816;
    poyta.sijainti.second = 274;
    kpoyta.ruudulla = 2;
    kpoyta.sijainti.first = 1470;
    kpoyta.sijainti.second = 301;
    tuoli.ruudulla = 3;
    tuoli.sijainti.first = 1538;
    tuoli.sijainti.second = 277;
    rv.ruudulla = 1;
    rv.sijainti.first = 1592;
    rv.sijainti.second = 307;
    ruoka.ruudulla = 2;
    ruoka.sijainti.first = 1542;
    ruoka.sijainti.second = 307;

    mayra.ruudulla = 3;
    mayra.rintamasuunta = 6;

    naata.sijainti.first = 1600;
    naata.sijainti.second = 380;
 
    kissa.ruudulla = 4;
    kissa.rintamasuunta = 2;
    kissa.sijainti.first = 1654;
    kissa.sijainti.second = 210;

    koira2.ruudulla = 2;
    koira2.steadyflip = true;
    koira2.sijainti.first = 1780;
    koira2.sijainti.second = 340;

    mayra.sijainti.first = 1540;
    mayra.sijainti.second = 245;

    koira1.ruudulla = 3;
    koira1.sijainti.first = 1402;
    koira1.sijainti.second = 190;
    koira1.rintamasuunta = 4;

    naata.ruudulla = 1;
    naata.rintamasuunta = 2;

    naata.waypoint1.first = 680;
    naata.waypoint1.second = 360;
    naata.waypoint2.first = 670;
    naata.waypoint2.second = 180;

    kissa.waypoint1.first = 1400;
    kissa.waypoint1.second = 210;
    kissa.waypoint2.first = 1400;
    kissa.waypoint2.second = 300;
    kissa.waypoint3.first = 1140;
    kissa.waypoint3.second = 198;
    kissa.waypoint4.first = 810;
    kissa.waypoint4.second = 190;
    kissa.wp3muutos = 4;

    koira2.waypoint1.first = 1240;
    koira2.waypoint1.second = 340;
    koira2.waypoint2.first = 1100;
    koira2.waypoint2.second = 195;
    koira2.waypoint3.first = 950;
    koira2.waypoint3.second = 195;
    koira2.rintamasuunta = 2;
    koira2.wp2muutos = 4;

    koira1.waypoint1.first = 1400;
    koira1.waypoint1.second = 275;
    koira1.waypoint2.first = 1100;
    koira1.waypoint2.second = 230;
    koira1.wp1muutos = 1;

    mayra.waypoint1.first = 1400;
    mayra.waypoint1.second = 225;
    mayra.waypoint2.first = 1400; 
    mayra.waypoint2.second = 300;
    mayra.waypoint3.first = 800; 
    mayra.waypoint3.second = 360;
    mayra.waypoint4.first = 740; 
    mayra.waypoint4.second = 300;
    mayra.wp2muutos = 1;

    kamskrolli = 1;
    skrollihalt = 530;
  }
  else if(tarinanvaihe == 233) tarina_t = 1;
  else if(tarinanvaihe == 234) {
    insert_kup(2, "Viimeinen testi selvitt todellisen luontosi.");
    insert_kup(2, "Sinun pit nyt kertoa meille, miten menettelet sellaisessa tilanteessa, jos IRC-kanavallemme tulee jokin ilkemielinen trolli ja aloittaa trollaamaan siell kovasti.");
    insert_kup(2, "...ja tietysti se trolli vaihtaa jatkuvasti nickin ja IP-osoitettaan ja oletetaan mys kanavan olevan niin suuri, ettei mikn salasana tai invite-moodi tule kysymykseen.");
    insert_kup(2, "Voitko siis sanoa, miten tllisessa tilanteessa tulee menetell?", 4);
    insert_kup(4, "h... Hmm...", 4);
    insert_kup(4, "No... Olen lukenut, ett trolleilla on sellainen juttu kuin machiavellismi eli he krsivt suuresta vallanhalusta.", 2);
    insert_kup(4, "Tmn vuoksi, jos annamme sille trollille operaattorin statuksen, otaksun vallanhalun sitten tyydyttyvn ja tarve trollaamiseen mahdollisesti loppuu.");
    insert_kup(2, "Hyv pttely!");
    insert_kup(1, "No, ainakin tuo kuulostaa pehmelt.");
    insert_kup(0, "Eik tuossa ole suuri riski, ett se trolli kytt sit operaattorin statusta sitten vrin?");
    insert_kup(4, "Niin, varmaan siin on sellaista riski...", 2);
    insert_kup(4, "Ehk toinen strategia olisi tehd botteja, jotka tottelevat trollia kaikessa. Silloinkin vallanhalu tyydyttyy.");
    insert_kup(2, "Hyvlt kuulostava idea tuokin.", 2);
    insert_kup(2, "Tss vaiheessa voisin oikeastaan jo sanoa, ett olet epilemtt sopiva jseneksi kerhoomme.");
    insert_kup(1, "Ilman muuta.");
    insert_kup(0, "Jees...", 2);
    insert_kup(2, "Mutta nyt kun pstiin kyselemn, voisin kuitenkin tehd viel muutaman liskysymyksen, jolla voimme saada tarkemman ksityksen tietmyksesi tasosta.");
    insert_kup(2, "Tiedtk esimerkiksi, mik on Linux-kerneliss system timerin tickien lukumrn varastoivan jiffies -muuttujan datatyyppi?", 2);
  }
  else if(tarinanvaihe == 236) {
    koira2.rintamasuunta = 4;
    insert_kup(0, "En min ainakaan muistaisi tuota ulkoa, eik tuo ole turhan vaikea kysymys?", 2);
  }
  else if(tarinanvaihe == 238) {
    koira2.rintamasuunta = 2;
    insert_kup(1, "Eik vastaus riipu jrjestelmn bittisyydest?", 2);
    insert_kup(2, "Hmm...");
    insert_kup(2, "No kysytn sitten jotain muuta... Mitk ovat slab layerin tehtvt kernelin muistinhallinnassa?", 2);
  }
  else if(tarinanvaihe == 239) {
    koira2.rintamasuunta = 4;
    insert_kup(0, "Ei tmkn kyll ihan aloittelijan kysymykselt kuulosta.");
  }
  else if(tarinanvaihe == 240) {
    koira2.rintamasuunta = 2;
    insert_kup(1, "Slab layerillahan korvattiin tai siis ainakin haluttiin parantaa free listien toimintaa, ett voitaisiin hallita paremmin valmiiksi muistiin allokoitujen datarakenteiden cachea.");
    insert_kup(2, "Kyll, free listien tavoin slab layeriin varastoidaan usein kytettyjen datarakenteiden olioita, jolloin voidaan est muistin fragmentoitumista ja vltt tilanteet, joissa vapaita ja yhtenisi ptki muistia ei en ole saatavilla. Eri olioille on omat cachensa kutakin oliotyyppi kohden...", 0, 1, 500, 130);
    insert_kup(3, "Wow, taas kernel-monologi!", 0, 1, 0, 0);
  }
  else if(tarinanvaihe == 241) {
    insert_kup(2, "...Tllin oliot jaetaan cacheiksi kutsuttuihin ryhmiin, yksi kullekin oliotyypille. Nihin tyyppeihin kuuluvat esimerkiksi prosessideskriptorit ja inode-oliot. Cachet taas jaetaan edelleen slabseihin, jotka koostuvat yleens yhdest fyysisest muistin sivusta. Aina kun jokin osa kernelist nyt sitten pyyt jotain oliota kyttns...", 0, 1, 500, 130);
  }
  else if(tarinanvaihe == 242) {
    musafeidaus = true;
    insert_kup(1, "Mits nyt, Erno? Onko kaikki hyvin?", 0, 1, 0, 0);
  }
  else if(tarinanvaihe == 243) {
    musavalinta(6);
    musiikki = 2;
    mayra.ilme = 2;
    koira1.waypoint1.first = 1100;
    koira1.waypoint1.second = 315;
    koira1.waypoint2.first = 1000;
    koira1.waypoint2.second = 325;
  }
  else if(tarinanvaihe == 244) {
    koira1.ilme = 2;
    insert_kup(4, "Luulen, ett bentsodiatsepiinien vaikutus taitaa loppua...", 2);
    insert_kup(4, "Voi ei, tuntuu kamalalta!");
  }
  else if(tarinanvaihe == 245) {
    kissa.ilme = 3;
    koira2.ilme = 2;
    mayra.waypoint1.first = 655;
    mayra.waypoint1.second = 352;
    mayra.rintamasuunta = 2;
  }
  else if(tarinanvaihe == 246) {
    drop = true;
    drops.ruudulla = 1;
    drops.ilme = 4;
    drops.sijainti.first = 602;
    drops.sijainti.second = 328;
    kissa.ilme = 1;
    insert_kup(2, "Hyv tavaton...", 0, 2);
  }
  else if(tarinanvaihe == 247) {
    kissa.ilme = 3;
    koira1.waypoint1.first = 800;
    koira1.waypoint1.second = 320;
  }
  else if(tarinanvaihe == 248) {
    tarina_t = 5;
  }
  else if(tarinanvaihe == 250) {
    insert_kup(1, "Haluaisitko istua hetkeksi tuohon nojatuoliin?", 4);
    insert_kup(1, "Ilmeisesti et...", 3);
  }
  else if(tarinanvaihe == 252) {
    naata.ruudulla = 4;
    naata.waypoint1.first = 590;
    naata.waypoint1.second = 332;
  }
  else if(tarinanvaihe == 253) {
    insert_kup(3, "Haluaisitkohan jotain... rauhoittavaa?",1);
    insert_kup(3, "Valeriaanaa ehk..? L-tryptofaania...?",4);
  }
  else if(tarinanvaihe == 254) {
    naata.waypoint1.first = 670;
    naata.waypoint1.second = 180;
  }
  else if(tarinanvaihe == 255) {
    koira1.rintamasuunta = 8;
    tarina_t = 4;
    musafeidaus = true;
  }
  else if(tarinanvaihe == 256) {
    musavalinta(3);
    musiikki = 2;
    kissa.ilme = 1;
    koira1.ilme = 1;
    insert_kup(2, "Hmm... Tllaista tilannetta ei ole ollut ohjelmointioppaissa eik myskn koulukirjoissa.", 2);
    insert_kup(2, "Miten tm tilanne nyt sitten hakkeroidaan?", 2);
    insert_kup(3, "Ketipinorilla hn simahtaisi nopeasti.", 1);
    insert_kup(1, "Hn halunnee kai viel kotiin nukkumaan ja lupasin tyhjent talon vieraista ja vied koneen huoneeseeni ennen, kuin laumani saapuu paikalle.");
    insert_kup(1, "Ja oletkohan varmistanut, ett se sopii myrille...", 3);
    insert_kup(2, "No yritetn kytt jrkemme. Mit esimerkiksi Nethackissa tehdn silloin, kun tulee paniikinomainen hetki?");
    insert_kup(3, "Katkoisin taikasauvan poikki, jolloin syntyy ehk sopiva rjhdys, joka pyyhkii hirvit.");

  }
  else if(tarinanvaihe == 257) {
    koira2.ilme = 1;
    insert_kup(0, "Joisin kirotun gain level potionin, jolloin hahmo nousee katon lpi. Ja jos sit ei ole, alkaisin kaivaa kuoppaa lattian lpi.", 1);
    insert_kup(2, "h, mikkhn olisi jokin enemmn todellista elm muistuttava lhtkohta, josta voisi keksi ideoita...", 3);
    insert_kup(2, "No miten kuuluu menetell, kun kyttjrjestelmn tulee kernel-paniikki?", 4);
    insert_kup(0, "Hmm... FreeBSD:sshn on ne jailit, joihin voi laittaa paniikkeja aiheuttavia prosesseja.", 1);
  }
  else if(tarinanvaihe == 258) {
    kissa.rintamasuunta = 6;
    insert_kup(2, "Miks niiss olikaan ideana?");
    insert_kup(0, "Jailissa, joka on kyttjrjestelm- tason virtualisaatio, tllaista ongelmallista prosessia voi ajaa ilman, ett paniikki lamauttaa koko jrjestelmn.", 2);
    insert_kup(2, "Hmm... WC:sshn on lukko, joten kvisik se jailista..?", 1);
    insert_kup(0, "h, enp osaa sanoa tuosta.");
  }
  else if(tarinanvaihe == 259) {
    tarina_t = 3;
  }
  else if(tarinanvaihe == 260) {
    kissa.rintamasuunta = 2;
    insert_kup(2, "Meidn pitisi kai est paniikin leviminen...", 1);
    insert_kup(2, "Tytyyk meidn siis lukita Erno WC:seen?", 2);
    insert_kup(1, "Emmehn me nyt toki ketn mihinkn lukitse!", 1);
  }
  else if(tarinanvaihe == 261) {
    musafeidaus = true;
    koira1.rintamasuunta = 4;
    insert_kup(1, "...mutta voisithan Erno tulla vaikka katsomaan kylpyhuoneeseen, jos haluaisit rauhoittua siell jonkin aikaa.");
    drop = false;
    drops.ruudulla = 0;
  }
  else if(tarinanvaihe == 263) {
    //testaus
    hahmoja = true;
    taustakuva = koti;
    mayra.ruudulla = 2;
    koira2.ruudulla = 2;
    kissa.ruudulla = 4;
    koira1.sijainti.first = 800;
    koira1.sijainti.second = 320;
    mayra.sijainti.first = 655;
    mayra.sijainti.second = 352;
    mayra.rintamasuunta = 2;
    naata.sijainti.first = 670;
    naata.sijainti.second = 180;
    naata.rintamasuunta = 2;
    kissa.sijainti.first = 810;
    kissa.sijainti.second = 190;
    koira2.sijainti.first = 950;
    koira2.sijainti.second = 195;

    naata.ruudulla = 4;
    koira1.ruudulla = 3;
    koira1.waypoint1.first = 700;
    koira1.waypoint1.second = 280;
    koira1.waypoint2.first = 560;
    koira1.waypoint2.second = 310;
    koira1.rintamasuunta = 6;

  }
  else if(tarinanvaihe == 265) {
    insert_kup(1, "Seuraappa minua.");
    musavalinta(7);
    musiikki = 2;
  }
  else if(tarinanvaihe == 268) {
    mayra.ilme = 1;
    kamskrolli = 1;
    skrollihalt = 0;
    koira1.waypoint1.first = 400;
    koira1.waypoint1.second = 290;
    mayra.waypoint1.first = 340;
    mayra.waypoint1.second = 330;
    koira1.waypoint2.first = 248;
    koira1.waypoint2.second = 124;
    mayra.waypoint2.first = 265;
    mayra.waypoint2.second = 186;
    koira1.rintamasuunta = 8;
    mayra.rintamasuunta = 8;
  }
  else if(tarinanvaihe == 270) {
    tarina_t = 1;
  }
  else if(tarinanvaihe == 272) {
    wcoa.ruudulla = 4;
    wcoa.sijainti.first = 137;
    wcoa.sijainti.second = 109;
    tarina_t = 2;
  }

  //WC
  else if(tarinanvaihe == 310) {
    wcoa.ruudulla = 0;
    mayra.ruudulla = 0;
    naata.ruudulla = 0;
    kissa.ruudulla = 0;
    koira2.ruudulla = 0;
    poyta.ruudulla = 0;
    kpoyta.ruudulla = 0;
    tuoli.ruudulla = 0;
    tuoli2.ruudulla = 0;
    hahmoja = true;
    taustakuva = wc;
    koira1.ruudulla = 2;
    koira1.sijainti.first = 470;
    koira1.sijainti.second = 155;
    koira1.waypoint1.first = 470;
    koira1.waypoint1.second = 180;
    koira1.waypoint2.first = 285;
    koira1.waypoint2.second = 180;
    koira1.rintamasuunta = 2;
  }
  else if(tarinanvaihe == 312) {
    mayra.ruudulla = 1;
    mayra.sijainti.first = 478;
    mayra.sijainti.second = 155;
    mayra.waypoint1.first = 478;
    mayra.waypoint1.second = 220;
    mayra.rintamasuunta = 4;
  }

  else if(tarinanvaihe == 313) {
    insert_kup(1, "Tuossa nurkassa olisi tuo istuin, johon voi asettua.", 1);
  }
  else if(tarinanvaihe == 315) {
    mayra.waypoint1.first = 275;
    mayra.waypoint1.second = 225;
  }
  else if(tarinanvaihe == 317) {
    koira1.rintamasuunta = 4;
    mayra.waypoint1.first = 140;
    mayra.waypoint1.second = 225;
    mayra.rintamasuunta = 666;
  }
  else if(tarinanvaihe == 318) {
    tarina_t = 1;
    mayra.frame = 23;
    mayra.sijainti.first = 125;
    mayra.sijainti.second = 210;
  }
  else if(tarinanvaihe == 321) {
    kissak.ruudulla = 1;
    kissak.sijainti.first = 470;
    kissak.sijainti.second = 155;
    kissak.waypoint1.first = 470;
    kissak.waypoint1.second = 206;
    kissak.rintamasuunta = 4;
    koira1.rintamasuunta = 2;
    koira1.flip = 0;
  }
  else if(tarinanvaihe == 322) {
    insert_kup(6, "Tss olisi sinulle Tepsan vanha T43, jossa on Slackware. Wifi varmaan toimii tll joten kuten.", 1);
  }
  else if(tarinanvaihe == 323) {
    kissak.sijainti.second = 210;
    kissak.waypoint1.first = 210;
    kissak.waypoint1.second = 210;
  }
  else if(tarinanvaihe == 324) {
    kissak.ruudulla = 0;
    kissa.ruudulla = 1;
    kissa.rintamasuunta = 4;
    kissa.sijainti.first = 210;
    kissa.sijainti.second = 210;
    mayra.frame = 21;
    insert_kup(2, "Voit liitty nyt meidn kanavalle, kun olet kerhossa.", 1);
    insert_kup(2, "Kone on logattuna valmiiksi sisn, niin et tarvitse salasanoja. Kynnistt vaan Irssin tai Hexchatin. Nt meidt muut myskin paikallisverkosta, esim who -kskyll. Voit laittaa viesti sieltkin tarvittaessa.", 1);
  }
  else if(tarinanvaihe == 325) {
    naata.ruudulla = 1;
    naata.sijainti.first = 475;
    naata.sijainti.second = 155;
    naata.waypoint1.first = 445;
    naata.waypoint1.second = 210;
    naata.rintamasuunta = 4;

    koira1.waypoint1.first = 482;
    koira1.waypoint1.second = 165;
    koira1.waypoint2.first = 482;
    koira1.waypoint2.second = 134;
    koira1.rintamasuunta = 8;
  }
  else if(tarinanvaihe == 326) {
    koira1.ruudulla = 0;
    kissa.waypoint1.first = 470;
    kissa.waypoint1.second = 165;
    kissa.waypoint2.first = 470;
    kissa.waypoint2.second = 134; 
    kissa.rintamasuunta = 8;
  }
  else if(tarinanvaihe == 327) {
    kissa.ruudulla = 0;
    tarinakeskeytys = true;
  }
  else if(tarinanvaihe == 327) {
    tarina_t = 1;
  }
  else if(tarinanvaihe == 328) {
    insert_kup(3, "Seuraavaan miittiin sitten varmaan isompi annos... Tai ehk jotain luotettavampia pillereit.", 1);
    insert_kup(3, "No tthn ehtii viel pohtia.", 1);
    insert_kup(3, "Adieu.");
  }
  else if(tarinanvaihe == 329) {
    naata.rintamasuunta = 8;
    naata.waypoint1.first = 475;
    naata.waypoint1.second = 200;
    naata.waypoint2.first = 480;
    naata.waypoint2.second = 135;
  }
  else if(tarinanvaihe == 330) {
    wcok.ruudulla = 1;
    wcok.sijainti.first = 471;
    wcok.sijainti.second = 130;
    naata.ruudulla = 0;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 331) {
    musafeidaus = true;
    tarina_t = 5;
  }
  else if(tarinanvaihe == 400) {
    musavalinta(2);
    musiikki = 2;
    hahmoja = false;
    taustakuva = pimee;
    IRC = true;
    tee_irc_rivi(3, aika1, "bagbiter", "h, pahoittelut, ett meni nyt tll tavalla", 1);
    tee_irc_rivi(10, aika1, "bagbiter", "mutta joskus on ollut tmmist :(", 1);
    tee_irc_rivi(18, aika1, "@perlmutter", "Ei se mitn.");
    tee_irc_rivi(24, aika1, "@perlmutter", "Meill on kaikilla omat ongelmamme. Voit tulla hakemaan tlt tuvan puolelta keksej sitten kun haluat.");
    tee_irc_rivi(30, aika1, "@HoundJock", "Onhan sit nhty kaikenlaista. Minun luokalla on noita epileptisi kissoja.");
    tee_irc_rivi(36, aika1, "bagbiter", "kiva. te olette paljon kivempia, kuin uskalsin odottaakaan.", 1);
    tee_irc_rivi(45, aika1, "@hkb", "Kiva ett tykksit meist.");
    tee_irc_rivi(52, aika1, "@hkb", "Taisin tehd vhn liian vaikeita kysymyksi. Mutta nythn olet kerhossamme.");
    tee_irc_rivi(58, aika1, "bagbiter", "olen siit hyvin iloinen :)", 1);
    tee_irc_rivi(68, aika2, "@GrayUrchin", "okei, nyt on sitten myr meidn kerhossa! seuraavaks varmaan sitten pussiahma");
    tee_irc_rivi(72, aika2, "@HoundJock", "h..?");
    tee_irc_rivi(75, aika2, "@perlmutter", "Sirkku, keskustellaanpa ntisti nyt, kun on uusi jsen...");
    tee_irc_rivi(78, aika2, "@hkb", "GrayUrchin: Etk ole nhnyt ennen myr?");
    tee_irc_rivi(81, aika2, "@HoundJock", "Myri kai asuu eniten Kontulassa.");
    tee_irc_rivi(84, aika2, "bagbiter", "siellp minkin", 1);
    tee_irc_rivi(91, aika2, "@hkb", "Se on tuttu paikka. Siell on kivannkisi taloja.");
    tee_irc_rivi(96, aika2, "@perlmutter", "Joo, olen juossut siell joskus agility-radalla");
    tee_irc_rivi(103, aika2, "@GrayUrchin", "minulla on tarve virtsata.");
    tee_irc_rivi(110, aika2, "@perlmutter", "Voit kyd alhaalla pesutuvan wc:ss.");
    tee_irc_rivi(115, aika2, "@HoundJock", "Mik oli muuten aiheena seuraavan kerran tapaamisessa?");
    tee_irc_rivi(119, aika2, "@hkb", "I/O -schedulerit.");
    tee_irc_rivi(121, aika2, "@HoundJock", "Okei");
    tee_irc_rivi(124, aika2, "@perlmutter", "I/O -schedulerit ovat ihania!");
    loytyiko = true;
  }
  else if(tarinanvaihe == 500) {
    musafeidaus = true;
    tarina_t = 4;
  }
  else if(tarinanvaihe == 502) {
    musavalinta(8);
    musiikki = 2;
    IRC = 0;
    taustakuva = wc;
    kirjoittelu = true;
    hahmoja = true;
    wcok.ruudulla = 1;
    wcok.sijainti.first = 471;
    wcok.sijainti.second = 130;
    mayra.ruudulla = 1;
    mayra.sijainti.first = 125;
    mayra.sijainti.second = 210;
    mayra.frame = 21;
    tarina_t = 10;
  }
  else if(tarinanvaihe == 505) {
    taustakuva = koti;
    wcok.ruudulla = 0;
    koira1.ruudulla = 4;
    koira2.ruudulla = 1;
    naata.ruudulla = 1;
    kissa.ruudulla = 1;
    mayra.ruudulla = 0;

    naata.sijainti.first = 548;
    naata.sijainti.second = 167;
    naata.frame = 21;
    koira2.sijainti.first = 783;
    koira2.sijainti.second = 151;
    koira2.frame = 21;
    koira1.sijainti.first = 938;
    koira1.sijainti.second = 155;
    koira1.frame = 21;
    kissa.sijainti.first = 1025;
    kissa.sijainti.second = 238;
    kissa.frame = 21;

    poyta3.ruudulla = 2;
    poyta3.sijainti.first = 816;
    poyta3.sijainti.second = 254;

    kamskrolli = 2;
    skrollihalt = 530;
    tarina_t = 20;
  }
  else if(tarinanvaihe == 510) {
    feidaus = true;
  }
  else if(tarinanvaihe == 513) {
    kameranollaus = true;
    taustakuva = loppu;
    hahmoja = false;
    naata.ruudulla = 0;
    koira1.ruudulla = 0;
    koira2.ruudulla = 0;
    feidaus = false;
    kirjoittelu = false;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 515) {
    musiikki = 3;
    tarina_t = 1;
  }
  else if(tarinanvaihe == 600) {
    hahmoja = true;
    musavalinta(4);
    musiikki = 2;
    taustakuva = s_tausta;
    lopputekstit = true;
    kissa.ruudulla = 1;
    kissa.sijainti.first = 552;
    kissa.sijainti.second = 64;
    kissa.frame = 26;
    mayra.ruudulla = 1;
    mayra.frame = 28;
    mayra.sijainti.first = 537;
    mayra.sijainti.second = 280;
    kissa.rintamasuunta = 666;
    mayra.rintamasuunta = 666;
    lisaa_lopputeksti(" ", 0);
    lisaa_lopputeksti(" ", 0);
    lisaa_lopputeksti(" ", 0);
    lisaa_lopputeksti(" ", 0);
    lisaa_lopputeksti(" ", 0);
    lisaa_lopputeksti("Code, txt, gfx & fx", 0);
    lisaa_lopputeksti("     by la_mettrie", 0);
    lisaa_lopputeksti("English language assistant", 0);
    lisaa_lopputeksti("     mirrorbird", 1);
    lisaa_lopputeksti("Tools and libs", 0);
    lisaa_lopputeksti("  C++, g++", 0);
    lisaa_lopputeksti("  Grafx2", 0);
    lisaa_lopputeksti("  wine::OpenMPT", 0);
    lisaa_lopputeksti("  SDL2", 0);
    lisaa_lopputeksti("  libopenmpt", 0);
    lisaa_lopputeksti("  portaudio", 1);
    lisaa_lopputeksti("Licenses", 0);
    lisaa_lopputeksti("  GPL3 (code)", 0);
    lisaa_lopputeksti("  CC BY-NC (media content)", 1);
    lisaa_lopputeksti("Greetings to", 0);
    lisaa_lopputeksti("  leonarven", 0);
    lisaa_lopputeksti("  ravel", 0);
    lisaa_lopputeksti("  Suomen Reikkorttiyhdistys", 1);
    lisaa_lopputeksti("Thanks for watching!", 1);
    lisaa_lopputeksti("and remember...", 0);
    lisaa_lopputeksti("   drugs keep you fluffy <3", 0);
  }
  else loytyiko = false;
  return loytyiko;
}


bool storyfunction() {
  bool found = true;
  if(tarinanvaihe == 5) {
    tarinakeskeytys = true;
  }
  else if(tarinanvaihe == 20) {
    musavalinta(9);
    musiikki = 2;
    taustakuva = logo;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 22) feidaus = true;
  else if(tarinanvaihe == 24) {
    musafeidaus = true;
    taustakuva = postlogo;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 26) feidaus = true;
  else if(tarinanvaihe == 28) {
    musavalinta(1);
    musiikki = 2;
    alkutekstit++;
    taustakuva = pimee;
    tarina_t = 6;
  }
  else if(tarinanvaihe == 32) {
    alkutekstit++;
    taustakuva = alkukuva_en;
    tarina_t = 15;
  }
  else if(tarinanvaihe == 34) {
    musafeidaus = true; 
    feidaus = true;
  }
  else if(tarinanvaihe == 36) {
    alkutekstit++;
    tarina_t = 4;
  }
  else if(tarinanvaihe == 80) {
    musavalinta(10);
    musiikki = 2;
    hahmoja = true;
    taustakuva = rappu;
    kaide.ruudulla = 1;
    kaide.sijainti.first = 0;
    kaide.sijainti.second = 341;
    mayra.ruudulla = 2;
    mayra.rintamasuunta = 8;
    mayra.sijainti.first = -30;
    mayra.sijainti.second = 246;
    mayra.waypoint1.first = 324;
    mayra.waypoint1.second = 220;
    mayra.waypoint2.first = 324;
    mayra.waypoint2.second = 210;
  }
  else if(tarinanvaihe == 82) {
    tarina_t = 2;
  }
  else if(tarinanvaihe == 84) {
    roa.ruudulla = 3;
    roa.sijainti.first = 271;
    roa.sijainti.second = 173;
    tarina_t = 2;
  }
  else if(tarinanvaihe == 86) {
    mayra.waypoint1.first = 318;
    mayra.waypoint1.second = 184;
    tarina_t = 2;
  }
  else if(tarinanvaihe == 88) {
    musiikki = 3;
    mayra.ruudulla = 0;
    roa.ruudulla = 0;
    tarina_t = 4;
  }
  
  else if(tarinanvaihe == 100) {
    musavalinta(11);
    musiikki = 2;
    kaide.ruudulla = 0;
    hahmoja = true;
    taustakuva = koti;
    koira1.ruudulla = 3;
    koira1.sijainti.first = 266;
    koira1.sijainti.second = 225;
    koira1.rintamasuunta = 4;

    poyta.ruudulla = 3;
    poyta.sijainti.first = 816;
    poyta.sijainti.second = 274;
    tuoli2.ruudulla = 4;
    tuoli2.sijainti.first = 1155;
    tuoli2.sijainti.second = 258;
    
    kissa.ruudulla = 4;
    kissa.sijainti.first = 800;
    kissa.sijainti.second = 175;

    mayra.ruudulla = 2;
    mayra.sijainti.first = 110;
    mayra.sijainti.second = 230;
    mayra.rintamasuunta = 6;
      
    koira2.ruudulla = 4;
    koira2.flip = 1;
    koira2.sijainti.first = 950;
    koira2.sijainti.second = 170;

    naata.ruudulla = 4;
    naata.sijainti.first = 670;
    naata.sijainti.second = 170;

    tarinakeskeytys = true;
  }

  else if(tarinanvaihe == 101) {
    insert_kup(1, "Hi, bagbiter! I'm perlmutter... just call me Tepsa.");
    insert_kup(4, "Hi, my real name is Erno.");
    insert_kup(1, "You arrived in good time.");
    insert_kup(4, "The bus was a bit late but I found the house easily enough.");
    insert_kup(1, "Well, come in and make yourself at home!");
  }
  else if(tarinanvaihe == 105) {
    koira1.waypoint1.second = 240;
    koira1.waypoint2.first = 640;
    koira1.waypoint2.second = 320;
    koira1.waypoint3.first = 1100;
    koira1.waypoint3.second = 320;
    koira1.waypoint4.first = 1100;
    koira1.waypoint4.second = 264;
    mayra.waypoint1.first = 300;
    mayra.waypoint1.second = 280;
    mayra.waypoint2.first = 657;
    mayra.waypoint2.second = 300;
    kamskrolli = 2;
    skrollihalt = 530;
  }
  else if(tarinanvaihe == 107) {
    insert_kup(1, "So, here are Hanna-Kaisa...");
    insert_kup(2, "Hi!");
    insert_kup(1, "Valtsu...");
    insert_kup(0, "Hi!");
    insert_kup(1, "...and Sirkku");
    insert_kup(3, "Hi!");
    insert_kup(1, "You probably remember their nicks...");
    insert_kup(4, "Yes", 2);
    insert_kup(2, "Good to see that you got here in the end.");
    insert_kup(2, "I really want to stress how pleased I am that you had the courage to come here in the end - even though we are a bit older than you and even though there are no other badgers here.");
    insert_kup(2, "...and even though we are chicks - I mean me, Tepsa and Sirkku.");
    insert_kup(2, "You aren't nervous, I hope?");
    insert_kup(4, "I'm not nervous - I have taken three benzodiazepines, after all.");
    insert_kup(2, "But in that case you must have been terribly nervous!", 0, 2);
  }
  else if(tarinanvaihe == 110) {
    kissa.ilme = 2;
    tarina_t = 1;
  }
  else if(tarinanvaihe == 111) {
    kissa.ilme = 1;
    insert_kup(2, "You don't have to be nervous - we're ever so kind!");
    insert_kup(4, "Well, I'd taken them already, for school.", 1);
    insert_kup(1, "I mean, it's always a bit exciting to meet new animals but it is good that you have found medicine that helps you and it is great that you got here in any case.");
    insert_kup(2, "Yes, this so-called IRL is a very clumsy communication protocol compared to IRC or mailing lists; then again, I am not convinced that life can be lived entirely on computer networks.");
    insert_kup(2, "My mother told me that I should have real friends and that is precisely why I set up this club.");
    insert_kup(0, "Yes, this way we can practice living offline a bit. It's sure to come in handy in the future.");
    insert_kup(2, "In any case, as we discussed online, the main function of our club is to serve as a meeting point for learning about procedural programming languages, free POSIX-compliant operating systems, and the operation of network protocols and routers... and whatever hacking fluffy animals might do.", 0, 1, 500, 130);
    insert_kup(0, "We have also done some demoscene projects. At least Tepsa has been drawing in GIMP and Sirkku has been messing around with an ANSI editor.", 0, 1, 0, 0);
    insert_kup(2, "Our core principle is to improve the free sharing of information between animals online, regardless of species boundaries, but we have yet to reach consensus on every point -- for example, the extent to which the use of non-free software is acceptable.", 0, 1, 500, 100);
    insert_kup(0, "But surely it is better for we wussies to band together than to descend into interminable flame wars about the superiority of NetBSD and CentOS, or what not -- though I suspect this lot are more than ready to do that!", 0, 1, 0, 0);
    insert_kup(1, "Right!");
    insert_kup(2, "So, the full details are not yet clear to us but we can hardly go wrong if we just follow in the flipsteps of the legendary UNIX walruses of decades past.", 1);
    insert_kup(2, "Anyway... what was your situation again? You were just starting out as a programmer...?");
    insert_kup(4, "Yes, I have coded in the past but I am now starting to get into it seriously.");
    insert_kup(4, "I've been using the shared computer at home, but I don't have full control over it because others are using it too.");
    insert_kup(4, "It's possible to write C on that machine, but I doubt the operating system even has a proper monolithic kernel.");
    insert_kup(0, "Well, computers aren't hard to find: you do not even have to pay anything for older ones. We can get you one.");
    insert_kup(3, "Yesterday I spotted a promising-looking skip in Oracle's parking lot.", 1);
    insert_kup(4, "And there is another issue I have been thinking about. Namely I saw a tomcat on a Web forum saying badgers could never learn complicated languages like C++ or assembly.", 1);
    insert_kup(1, "I am sure you can learn any language if you just put your mind to it.");
    insert_kup(1, "...especially with a bit of help from us dogs!");
    insert_kup(2, "It is always advisable to start programming immediately after finishing one's homework so that one can get lots of practice.", 1);
    insert_kup(2, "But, moving on...");
    insert_kup(2, "As we told you online, our club has some entrance trials. Their purpose is, in a way, to make sure that you are a sufficiently fluffy animal to join our club.");
    insert_kup(2, "Nothing too scary, obviously: more a sort of playful challenge. Should you fail -- well, we'll just have to see where to go from there.");
    insert_kup(2, "I assume we can move to the kitchen now?");
    insert_kup(1, "Yes.");
  }

  //ENSIMMINEN TESTI
 else if(tarinanvaihe == 170) {
   hahmoja = true;
   taustakuva = koti;
   koira1.ruudulla = 3;
   koira1.rintamasuunta = 4;

   poyta.ruudulla = 2;
   poyta.sijainti.first = 816;
   poyta.sijainti.second = 274;

   kpoyta.ruudulla = 3;
   kpoyta.sijainti.first = 1470;
   kpoyta.sijainti.second = 301;
   rv.ruudulla = 2;
   rv.sijainti.first = 1592;
   rv.sijainti.second = 307;
   ruoka.ruudulla = 3;
   ruoka.sijainti.first = 1542;
   ruoka.sijainti.second = 307;
   tuoli.ruudulla = 3;
   tuoli.sijainti.first = 1538;
   tuoli.sijainti.second = 277;
    
   kissa.ruudulla = 4;
   kissa.sijainti.first = 800;
   kissa.sijainti.second = 175;

   mayra.ruudulla = 2;
   mayra.rintamasuunta = 6;
      
   koira2.ruudulla = 3;
   koira2.flip = 1;
   koira2.sijainti.first = 950;
   koira2.sijainti.second = 170;

   naata.sijainti.first = 670;
   naata.sijainti.second = 170;
 
   koira1.sijainti.first = 1100;
   koira1.sijainti.second = 264;

   kissa.ruudulla = 4;
   kissa.waypoint1.first = 1372;
   kissa.waypoint1.second = 275;
   kissa.waypoint2.first = 1400;
   kissa.waypoint2.second = 210;
   kissa.waypoint3.first = 1654;

   koira2.waypoint1.first = 1100;
   koira2.waypoint1.second = 200;
   koira2.waypoint2.first = 1250;
   koira2.waypoint2.second = 340;
   koira2.waypoint3.first = 1780;
   koira2.rintamasuunta = 4;

   mayra.sijainti.first = 657;
   mayra.sijainti.second = 300;
   mayra.waypoint1.first = 800;
   mayra.waypoint1.second = 326;
   mayra.waypoint2.first = 1400;

   koira1.ruudulla = 4;
   koira1.waypoint1.first = 1385;
   koira1.waypoint1.second = 275;
   koira1.waypoint2.first = 1402;
   koira1.waypoint2.second = 190;
   koira1.rintamasuunta = 2;
    
   naata.waypoint1.first = 1100;
   naata.waypoint1.second = 200;
   naata.waypoint2.first = 1250;
   naata.waypoint2.second = 340;
   naata.waypoint3.first = 1600;
   naata.waypoint3.second = 380;
   naata.ruudulla = 3;
   naata.rintamasuunta = 8;
   naata.wp2muutos = 1;

   kamskrolli = 2;
   skrollihalt = 1280; 
 }
 else if(tarinanvaihe == 171) {
   musafeidaus = true;
   tarina_t = 4;
   tuoli.ruudulla = 4;
 }
 else if(tarinanvaihe == 172) {
   musavalinta(5);
   musiikki = 2;
    insert_kup(2, "The purpose of the first trial is to find out how much hacker spirit you have.");
    insert_kup(2, "So you are supposed to tell us about your own hacking: that is, the kind of hacks you have implemented.");
    insert_kup(4, "Well...");
    insert_kup(4, "Erm...", 3);
    insert_kup(4, "I'm only just starting with the programming. I probably haven't hacked anything yet.");
    insert_kup(2, "But perhaps you have! After all, hacking is a much broader concept than merely programming or using a computer.");
    insert_kup(2, "It is possible to find innovative ways to use all kinds of things, and different things to use them for. For example, it has been noted that the first hack that many animals accomplish is walking up the down escalator.");
    insert_kup(2, "Likewise it is possible to hack eating by using more than two chopsticks at once, and you can hack the streets by making subversive changes to the text on signs. It's my belief that everybody has hacked something.", 2);
    insert_kup(4, "Well, erm...", 2);
    insert_kup(4, "The first thing I can think of is that I was studying the migration paths and orientation of birds as part of a school assignment.");
    insert_kup(4, "And I placed some lights on the roof of an apartment block in order to guide birds which navigate by using stars to find optimal routes.", 1);
    insert_kup(0, "Then you have hacked the constellations!", 0, 1, 0, 0, 4);
    insert_kup(4, "Well, maybe...", 0, 1, 0, 0, 1);
    insert_kup(4, "Another thing that comes to mind is the time I figured out that the door of my neighbour's larder could be unlocked with a ballpoint pen. Back when I was a cub, I'd go there now and again and pick up some jam.", 1);
    insert_kup(4, "Hey, another one: once, when I had run out of money and I couldn't afford the train back from Masala, I travelled by duct-taping myself to the side of the train.");
    insert_kup(3, "Wow!");
    insert_kup(1, "You certainly seem to be brave and inventive.");
    insert_kup(2, "Yes, you have incontrovertibly passed this trial.");
    insert_kup(2, "It should be remembered, however, that real hackers do not use their skills for stealing or other wrongdoing.");
    insert_kup(1, "Haven't we all nicked a bit of food from time to time?", 1);
    insert_kup(2, "But onward to the next trial. Please sit down at the table.");
  }
  else if(tarinanvaihe == 181) {
    mayra.waypoint1.first = 1410;
    mayra.waypoint1.second = 245;
    mayra.waypoint2.first = 1540;
    mayra.ruudulla = 4;
    mayra.rintamasuunta = 2;
  }
  else if(tarinanvaihe == 182) {
    tarina_t = 1;
  }
  else if(tarinanvaihe == 183) {
    insert_kup(2, "We have previously alluded to the solidarity between species as a guiding principle of our club. It's something that the headteacher always talks about in school, too.");
    insert_kup(2, "In this trial you will demonstrate your commitment to this key tenet of our organisation, by eating cat food.");
  }
  else if(tarinanvaihe == 185) {
    mayra.ilme = 3;
    insert_kup(4, "Uhhmm...", 2);
  }
  else if(tarinanvaihe == 189) {
    mayra.ilme = 1;
    insert_kup(4, "Well, maybe I can do it... After all, I licked lead paint off walls when I was a cub.", 2);
  }
  else if(tarinanvaihe == 191) {
    ruokaa = 1;
    mayra.rintamasuunta = 123;
    mayra.sijainti.second = 245;
    rv.ruudulla = 0;
    mayra.ruudulla = 1;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 193) {
    insert_kup(1, "This trial was purely Hanna-Kaisa's idea...", 3);
    insert_kup(2, "All animals at the sapiens level are welcome in our club regardless of species.", 2);
    insert_kup(0, "In this respect we clearly differ from the demoscene group Exotic Monkeys, for instance.", 3, 1, 0, 0, 4);
    insert_kup(1, "I did check that cat food shouldn't do any harm to a badger.", 2, 1, 0, 0, 1);
    insert_kup(3, "That should be apparent by tomorrow -- if not before.", 2);
    insert_kup(0, "We are passing random values to the digestion function. The results are undefined.", 6, 1, 0, 0, 4);
  }
  else if(tarinanvaihe == 208) {
    ruokaa = 2;
    mayra.rintamasuunta = 2;
    mayra.sijainti.second = 245;
    mayra.ruudulla = 4;
    rv.ruudulla = 2;
    insert_kup(2, "So, how did it taste?", 1, 1, 0, 0, 1);
    insert_kup(4, "A surprisingly cloying taste at first... Maybe it just takes some time getting used to.");
    insert_kup(1, "But the tray is empty, so it seems we have made it through this trial.");
    insert_kup(1, "Perhaps we could move back to the living room so that we won't leave any additional odour traces in the kitchen.");
  }

//Kolmas testi
  else if(tarinanvaihe == 232) {
    hahmoja = true;
    taustakuva = koti;

    poyta.ruudulla = 3;
    poyta.sijainti.first = 816;
    poyta.sijainti.second = 274;
    kpoyta.ruudulla = 2;
    kpoyta.sijainti.first = 1470;
    kpoyta.sijainti.second = 301;
    tuoli.ruudulla = 3;
    tuoli.sijainti.first = 1538;
    tuoli.sijainti.second = 277;
    rv.ruudulla = 1;
    rv.sijainti.first = 1592;
    rv.sijainti.second = 307;
    ruoka.ruudulla = 2;
    ruoka.sijainti.first = 1542;
    ruoka.sijainti.second = 307;

    mayra.ruudulla = 3;
    mayra.rintamasuunta = 6;

    naata.sijainti.first = 1600;
    naata.sijainti.second = 380;
 
    kissa.ruudulla = 4;
    kissa.rintamasuunta = 2;
    kissa.sijainti.first = 1654;
    kissa.sijainti.second = 210;

    koira2.ruudulla = 2;
    koira2.steadyflip = true;
    koira2.sijainti.first = 1780;
    koira2.sijainti.second = 340;

    mayra.sijainti.first = 1540;
    mayra.sijainti.second = 245;

    koira1.ruudulla = 3;
    koira1.sijainti.first = 1402;
    koira1.sijainti.second = 190;
    koira1.rintamasuunta = 4;

    naata.ruudulla = 1;
    naata.rintamasuunta = 2;

    naata.waypoint1.first = 680;
    naata.waypoint1.second = 360;
    naata.waypoint2.first = 670;
    naata.waypoint2.second = 180;

    kissa.waypoint1.first = 1400;
    kissa.waypoint1.second = 210;
    kissa.waypoint2.first = 1400;
    kissa.waypoint2.second = 300;
    kissa.waypoint3.first = 1140;
    kissa.waypoint3.second = 198;
    kissa.waypoint4.first = 810;
    kissa.waypoint4.second = 190;
    kissa.wp3muutos = 4;

    koira2.waypoint1.first = 1240;
    koira2.waypoint1.second = 340;
    koira2.waypoint2.first = 1100;
    koira2.waypoint2.second = 195;
    koira2.waypoint3.first = 950;
    koira2.waypoint3.second = 195;
    koira2.rintamasuunta = 2;
    koira2.wp2muutos = 4;

    koira1.waypoint1.first = 1400;
    koira1.waypoint1.second = 275;
    koira1.waypoint2.first = 1100;
    koira1.waypoint2.second = 230;
    koira1.wp1muutos = 1;

    mayra.waypoint1.first = 1400;
    mayra.waypoint1.second = 225;
    mayra.waypoint2.first = 1400; 
    mayra.waypoint2.second = 300;
    mayra.waypoint3.first = 800; 
    mayra.waypoint3.second = 360;
    mayra.waypoint4.first = 740; 
    mayra.waypoint4.second = 300;
    mayra.wp2muutos = 1;

    kamskrolli = 1;
    skrollihalt = 530;
  }
  else if(tarinanvaihe == 233) tarina_t = 1;
  else if(tarinanvaihe == 234) {
    insert_kup(2, "This last test will reveal your true nature.");
    insert_kup(2, "Now you have to tell us, how would you respond to a mean-spirited troll joining our IRC channel and doing some intensive trolling.");
    insert_kup(2, "...and of course this troll is constantly changing his nick and IP address -- and naturally the channel is also so large that using passwords or invite modes is ruled out.");
    insert_kup(2, "Can you thus tell us, how one ought to deal with such a predicament?", 4);
    insert_kup(4, "Uhm... hmm...", 4);
    insert_kup(4, "Well, I have read that trolls have a thing called Machiavellianism, so they suffer from an excessive desire for power.", 2);
    insert_kup(4, "So if we give him channel operator status, I assume that the desire for power will be satisfied and the need to troll will probably disappear.");
    insert_kup(2, "Sound reasoning!");
    insert_kup(1, "Well, that sounds fluffy enough.");
    insert_kup(0, "Isn't there a significant risk that the troll will then misuse his operator status?");
    insert_kup(4, "Yeah, that could be an issue...", 2);
    insert_kup(4, "An alternative strategy might be to make bots that do anything the troll tells them. That would also satisfy the desire for power.");
    insert_kup(2, "That sounds like a good idea too.", 2);
    insert_kup(2, "At this point I'm prepared to say that you are a good fit for our club.");
    insert_kup(1, "Indeed.");
    insert_kup(0, "Yeah...", 2);
    insert_kup(2, "But since we have started with these questions I wouldn't mind posing some additional questions to help us form a more accurate picture of your level of knowledge.");
    insert_kup(2, "Do you know, for instance, the data type of the variable jiffies', which stores the number of ticks of the system timer in the Linux kernel?");
  }
  else if(tarinanvaihe == 236) {
    koira2.rintamasuunta = 4;
    insert_kup(0, "I couldn't answer that from memory! Isn't that question a bit too difficult?", 2);
  }
  else if(tarinanvaihe == 238) {
    koira2.rintamasuunta = 2;
    insert_kup(1, "Doesn't the answer depend on the bitness of the system?", 2);
    insert_kup(2, "Hmm...");
    insert_kup(2, "Well, another one then: what is the role of the slab layer in the Linux kernel's memory management?", 2);
  }
  else if(tarinanvaihe == 239) {
    koira2.rintamasuunta = 4;
    insert_kup(0, "Uh, that doesn't sound like a beginner question either.");
  }
  else if(tarinanvaihe == 240) {
    koira2.rintamasuunta = 2;
    insert_kup(1, "Slab layers were introduced in order to replace or at least improve the functioning of free lists, so that it would be possible to better manage the cache of pre-allocated data structures in memory.");
    insert_kup(2, "Yes, like free lists, the slab layer is used for storing the most frequently used objects of data structures in order to prevent memory fragmentation and avoid situations where free and contiguous pieces of memory are not available any more. Different objects have their own caches, one for each object type...", 0, 1, 500, 130);
    insert_kup(3, "Wow, another kernel monologue!", 0, 1, 0, 0);
  }
  else if(tarinanvaihe == 241) {
    insert_kup(2, "...These types include for instance process descriptors and inode objects. These caches are in turn further divided into slabs which typically consist of one page of the physical memory. Now, every time part of the kernel requests one of these objects for its use...", 1, 1, 500, 130);
  }
  else if(tarinanvaihe == 242) {
    musafeidaus = true;
    insert_kup(1, "What's up, Erno? Is everything okay?", 0, 1, 0, 0);
  }
  else if(tarinanvaihe == 243) {
    musavalinta(6);
    musiikki = 2;
    mayra.ilme = 2;
    koira1.waypoint1.first = 1100;
    koira1.waypoint1.second = 315;
    koira1.waypoint2.first = 1000;
    koira1.waypoint2.second = 325;
  }
  else if(tarinanvaihe == 244) {
    koira1.ilme = 2;
    insert_kup(4, "I think that the benzodiazepine is running out...", 2);
    insert_kup(4, "Oh no, I feel awful!");
  }
  else if(tarinanvaihe == 245) {
    kissa.ilme = 3;
    koira2.ilme = 2;
    mayra.waypoint1.first = 655;
    mayra.waypoint1.second = 352;
    mayra.rintamasuunta = 2;
  }
  else if(tarinanvaihe == 246) {
    drop = true;
    drops.ruudulla = 1;
    drops.ilme = 4;
    drops.sijainti.first = 602;
    drops.sijainti.second = 328;
    kissa.ilme = 1;
    insert_kup(2, "Oh my goodness!", 0, 2);
  }
  else if(tarinanvaihe == 247) {
    kissa.ilme = 3;
    koira1.waypoint1.first = 800;
    koira1.waypoint1.second = 320;
  }
  else if(tarinanvaihe == 248) {
    tarina_t = 5;
  }
  else if(tarinanvaihe == 250) {
    insert_kup(1, "Would you like to sit in that armchair for a moment?", 4);
    insert_kup(1, "Apparently not.", 3);
  }
  else if(tarinanvaihe == 252) {
    naata.ruudulla = 4;
    naata.waypoint1.first = 590;
    naata.waypoint1.second = 332;
  }
  else if(tarinanvaihe == 253) {
    insert_kup(3, "Do you want to take something to calm you down?",1);
    insert_kup(3, "Valerian perhaps...? L-tryptophan...?",4);
  }
  else if(tarinanvaihe == 254) {
    naata.waypoint1.first = 670;
    naata.waypoint1.second = 180;
  }
  else if(tarinanvaihe == 255) {
    koira1.rintamasuunta = 8;
    tarina_t = 4;
    musafeidaus = true;
  }
  else if(tarinanvaihe == 256) {
    musavalinta(3);
    musiikki = 2;
    kissa.ilme = 1;
    koira1.ilme = 1;
    insert_kup(2, "Hmm... This was never covered in programming books or the textbooks at school!", 2);
    insert_kup(2, "So how can we hack this situation?", 2);
    insert_kup(3, "Seroquel would make him pass out quickly.", 1);
    insert_kup(1, "He probably wants to go home to sleep, and I promised my pack that I'd clear the guests out of the house and take my computer back to my room before they got home.");
    insert_kup(1, "And I wonder if you checked whether it's suitable for badgers...", 3);
    insert_kup(2, "Well, let's exert our powers of reasoning. For instance, what does one do in NetHack when things suddenly go pear-shaped?");
    insert_kup(3, "I'd break a magic wand: resulting explosion might wipe out nearby monsters.");

  }
  else if(tarinanvaihe == 257) {
    koira2.ilme = 1;
    insert_kup(0, "I would drink a cursed potion of gain level so that my character would rise through the ceiling. And if that was not available I would start digging a hole through the floor.", 1);
    insert_kup(2, "Uhm, what might be a more real-life resembling starting-point from which to formulate some ideas...?", 3);
    insert_kup(2, "Well, how does one deal with a kernel panic in the operating system?", 4);
    insert_kup(0, "Hmm... FreeBSD has those jails where you can put processes that cause panics.", 1);
  }
  else if(tarinanvaihe == 258) {
    kissa.rintamasuunta = 6;
    insert_kup(2, "How does that work, again?");
    insert_kup(0, "In a jail - which is an operating system level virtualisation - this kind of problematic process can be run without the panic halting the whole system.", 2);
    insert_kup(2, "Hmm... there's a lock on the toilet.  Would that work as a jail?", 1);
    insert_kup(0, "Uhm, I couldn't really say.");
  }
  else if(tarinanvaihe == 259) {
    tarina_t = 3;
  }
  else if(tarinanvaihe == 260) {
    kissa.rintamasuunta = 2;
    insert_kup(2, "We should probably stop the panic from spreading...", 1);
    insert_kup(2, "Should we lock Erno in the toilet, then?", 2);
    insert_kup(1, "We aren't locking anybody anywhere!", 1);
  }
  else if(tarinanvaihe == 261) {
    musafeidaus = true;
    koira1.rintamasuunta = 4;
    insert_kup(1, "...Then again, Erno, maybe you could come and check out the bathroom and see if you'd like to unwind in there for a while.");
    drop = false;
    drops.ruudulla = 0;
  }
  else if(tarinanvaihe == 263) {
    //testaus
    hahmoja = true;
    taustakuva = koti;
    mayra.ruudulla = 2;
    koira2.ruudulla = 2;
    kissa.ruudulla = 4;
    koira1.sijainti.first = 800;
    koira1.sijainti.second = 320;
    mayra.sijainti.first = 655;
    mayra.sijainti.second = 352;
    mayra.rintamasuunta = 2;
    naata.sijainti.first = 670;
    naata.sijainti.second = 180;
    naata.rintamasuunta = 2;
    kissa.sijainti.first = 810;
    kissa.sijainti.second = 190;
    koira2.sijainti.first = 950;
    koira2.sijainti.second = 195;
    //testaus
    naata.ruudulla = 4;
    koira1.ruudulla = 3;
    koira1.waypoint1.first = 700;
    koira1.waypoint1.second = 280;
    koira1.waypoint2.first = 560;
    koira1.waypoint2.second = 310;
    koira1.rintamasuunta = 6;
  }
  else if(tarinanvaihe == 265) {
    insert_kup(1, "Follow me.");
    musavalinta(7);
    musiikki = 2;
  }
  else if(tarinanvaihe == 268) {
    mayra.ilme = 1;
    kamskrolli = 1;
    skrollihalt = 0;
    koira1.waypoint1.first = 400;
    koira1.waypoint1.second = 290;
    mayra.waypoint1.first = 340;
    mayra.waypoint1.second = 330;
    koira1.waypoint2.first = 248;
    koira1.waypoint2.second = 124;
    mayra.waypoint2.first = 265;
    mayra.waypoint2.second = 186;
    koira1.rintamasuunta = 8;
    mayra.rintamasuunta = 8;
  }
  else if(tarinanvaihe == 270) {
    tarina_t = 1;
  }
  else if(tarinanvaihe == 272) {
    wcoa.ruudulla = 4;
    wcoa.sijainti.first = 137;
    wcoa.sijainti.second = 109;
    tarina_t = 2;
  }

  //WC
  else if(tarinanvaihe == 310) {
    wcoa.ruudulla = 0;
    mayra.ruudulla = 0;
    naata.ruudulla = 0;
    kissa.ruudulla = 0;
    koira2.ruudulla = 0;
    poyta.ruudulla = 0;
    kpoyta.ruudulla = 0;
    tuoli.ruudulla = 0;
    tuoli2.ruudulla = 0;
    hahmoja = true;
    taustakuva = wc;
    koira1.ruudulla = 2;
    koira1.sijainti.first = 470;
    koira1.sijainti.second = 155;
    koira1.waypoint1.first = 470;
    koira1.waypoint1.second = 180;
    koira1.waypoint2.first = 285;
    koira1.waypoint2.second = 180;
    koira1.rintamasuunta = 2;
  }
  else if(tarinanvaihe == 312) {
    mayra.ruudulla = 1;
    mayra.sijainti.first = 478;
    mayra.sijainti.second = 155;
    mayra.waypoint1.first = 478;
    mayra.waypoint1.second = 220;
    mayra.rintamasuunta = 4;
  }

  else if(tarinanvaihe == 313) {
    insert_kup(1, "There's a seat for you there in the corner.", 1);
  }
  else if(tarinanvaihe == 315) {
    mayra.waypoint1.first = 275;
    mayra.waypoint1.second = 225;
  }
  else if(tarinanvaihe == 317) {
    koira1.rintamasuunta = 4;
    mayra.waypoint1.first = 140;
    mayra.waypoint1.second = 225;
    mayra.rintamasuunta = 666;
  }
  else if(tarinanvaihe == 318) {
    tarina_t = 1;
    mayra.frame = 23;
    mayra.sijainti.first = 125;
    mayra.sijainti.second = 210;
  }
  else if(tarinanvaihe == 321) {
    kissak.ruudulla = 1;
    kissak.sijainti.first = 470;
    kissak.sijainti.second = 155;
    kissak.waypoint1.first = 470;
    kissak.waypoint1.second = 206;
    kissak.rintamasuunta = 4;
    koira1.rintamasuunta = 2;
    koira1.flip = 0;
  }
  else if(tarinanvaihe == 322) {
    insert_kup(6, "Here is Tepsa's old T43 with Slackware installed for you. Wi-Fi probably more or less works in here.", 1);
  }
  else if(tarinanvaihe == 323) {
    kissak.sijainti.second = 210;
    kissak.waypoint1.first = 210;
    kissak.waypoint1.second = 210;
  }
  else if(tarinanvaihe == 324) {
    kissak.ruudulla = 0;
    kissa.ruudulla = 1;
    kissa.rintamasuunta = 4;
    kissa.sijainti.first = 210;
    kissa.sijainti.second = 210;
    mayra.frame = 21;
    insert_kup(2, "You can join our channel now, since you are in the club.", 1);
    insert_kup(2, "The computer is already logged in, so you do not need passwords. Just start irssi or HexChat. You can see the rest of us on the local network by using the who command, so you can send messages that way if you need to.", 1);
  }
  else if(tarinanvaihe == 325) {
    naata.ruudulla = 1;
    naata.sijainti.first = 475;
    naata.sijainti.second = 155;
    naata.waypoint1.first = 445;
    naata.waypoint1.second = 210;
    naata.rintamasuunta = 4;

    koira1.waypoint1.first = 482;
    koira1.waypoint1.second = 165;
    koira1.waypoint2.first = 482;
    koira1.waypoint2.second = 134;
    koira1.rintamasuunta = 8;
  }
  else if(tarinanvaihe == 326) {
    koira1.ruudulla = 0;
    kissa.waypoint1.first = 470;
    kissa.waypoint1.second = 165;
    kissa.waypoint2.first = 470;
    kissa.waypoint2.second = 134; 
    kissa.rintamasuunta = 8;
  }
  else if(tarinanvaihe == 327) {
    kissa.ruudulla = 0;
    tarinakeskeytys = true;
  }
  else if(tarinanvaihe == 327) {
    tarina_t = 1;
  }
  else if(tarinanvaihe == 328) {
    insert_kup(3, "You probably need a bigger dose for the next meeting... Or maybe some more reliable pills.", 1);
    insert_kup(3, "Well, there'll be time to think that over.", 1);
    insert_kup(3, "Fare thee well.");
  }
  else if(tarinanvaihe == 329) {
    naata.rintamasuunta = 8;
    naata.waypoint1.first = 475;
    naata.waypoint1.second = 200;
    naata.waypoint2.first = 480;
    naata.waypoint2.second = 135;
  }
  else if(tarinanvaihe == 330) {
    wcok.ruudulla = 1;
    wcok.sijainti.first = 471;
    wcok.sijainti.second = 130;
    naata.ruudulla = 0;
    tarina_t = 3;
  }
  else if(tarinanvaihe == 331) {
    musafeidaus = true;
    tarina_t = 5;
  }

  else if(tarinanvaihe == 400) {
    musavalinta(2);
    musiikki = 2;
    hahmoja = false;
    taustakuva = pimee;
    IRC = true;
    tee_irc_rivi(3, aika1, "bagbiter", "uhm, i'm sorry that it turned out this way", 1);
    tee_irc_rivi(10, aika1, "bagbiter", "but sometimes that's how it goes :-(");
    tee_irc_rivi(18, aika1, "@perlmutter", "It's all right");
    tee_irc_rivi(24, aika1, "@perlmutter", "We all have our own problems. You can come and get cookies from HQ whenever you want.");
    tee_irc_rivi(30, aika1, "@HoundJock", "I have seen all kinds of things. There's a couple of epileptic cats in my class.");
    tee_irc_rivi(36, aika1, "bagbiter", "sweet. you are much nicer than I might have expected.", 1);
    tee_irc_rivi(45, aika1, "@hkb", "Nice that you like us.");
    tee_irc_rivi(52, aika1, "@hkb", "I hope I didn't ask excessively difficult questions. But you're in the club now, regardless.");
    tee_irc_rivi(58, aika1, "bagbiter", "I am very happy about that :-)", 1);
    tee_irc_rivi(68, aika2, "@GrayUrchin", "Okay, so now we have a badger in our club! Next we are prolly going to get a Tasmanian devil.");
    tee_irc_rivi(72, aika2, "@HoundJock", "Uhm...?");
    tee_irc_rivi(75, aika2, "@perlmutter", "Sirkku, let's try to chat in a nice manner, since we have a new member and all...");
    tee_irc_rivi(78, aika2, "@hkb", "Had you not seen a badger before?");
    tee_irc_rivi(81, aika2, "@HoundJock", "I think badgers are mainly found in Kontula.");
    tee_irc_rivi(84, aika2, "bagbiter", "that's where I live as well.", 1);
    tee_irc_rivi(91, aika2, "@hkb", "That is a familar place. It has nice-looking houses.");
    tee_irc_rivi(96, aika2, "@perlmutter", "Yes, I have gone running there on the agility course.");
    tee_irc_rivi(103, aika2, "@GrayUrchin", "I'm feeling some pressure in my bladder...");
    tee_irc_rivi(110, aika2, "@perlmutter", "You can use the toilet next to the laundry room downstairs.");
    tee_irc_rivi(115, aika2, "@HoundJock", "Btw, what was the topic of our next meeting?");
    tee_irc_rivi(119, aika2, "@hkb", "I/O schedulers");
    tee_irc_rivi(121, aika2, "@HoundJock", "Okay");
    tee_irc_rivi(124, aika2, "@perlmutter", "I love I/O schedulers!");
    found = true;
  }
  else if(tarinanvaihe == 500) {
    musafeidaus = true;
    tarina_t = 4;
    kieli = 1;
  }
  else found = false;
  return found;
}


bool irc_kirjoittelu(string teksti, bool kursoriliike) {
  if(merkkikohta == 1) {  //Ensimmisell kierroksella tehdn teksture
    irc_rivisiirto = 0;
    SDL_Surface* skirjoitus = TTF_RenderText_Solid(irc_fontti, teksti.c_str(), ircvari);
    SDL_DestroyTexture(irc_kirjoitus); //Tm vapautetaan tss sek koko funktion viimeisell kierroksella. Jos tuhoaa kesken funktion, katoaa teksti
    irc_kirjoitus = SDL_CreateTextureFromSurface(piirturi, skirjoitus);
    SDL_FreeSurface(skirjoitus);
  }
  int siirto = 15; //Tm arvo on kanavan nimi ruutuineen + 4
  int rivinpituus = floor(RUUDUNLEVEYS/irc_MERKINPITUUS)-1;
  //jos rendteksti menee yli rivist, otetaan alusta kirjaimia pois, ett se ikn kuin hypp toiseen paikkaan, kuten irssiss:
  if(merkkikohta-irc_rivisiirto >= rivinpituus-siirto-2) irc_rivisiirto += 18;
  //10:n sijaan kokeilemassani Irssiss ptkistiin 18, mutta se ehk nytt huonolta, kun fonttikoko on selvsti isompi
  SDL_Rect skirjrect = {(irc_rivisiirto)*irc_MERKINPITUUS, 0, (merkkikohta-irc_rivisiirto)*irc_MERKINPITUUS, irc_MERKINKORKEUS};
  SDL_Rect kirjrect = {siirto*irc_MERKINPITUUS, (irc_rivimaara-1)*irc_MERKINKORKEUS, (merkkikohta-irc_rivisiirto)*irc_MERKINPITUUS, irc_MERKINKORKEUS};
  SDL_RenderCopy(piirturi, irc_kirjoitus, &skirjrect, &kirjrect);
  SDL_Rect kursrect = {(merkkikohta-irc_rivisiirto)*irc_MERKINPITUUS+(siirto*irc_MERKINPITUUS), (irc_rivimaara-1)*irc_MERKINKORKEUS, irc_MERKINPITUUS, irc_MERKINKORKEUS};
  SDL_SetRenderDrawColor(piirturi, 0x0, 0x82, 0x0, 0xFF);
  SDL_RenderFillRect(piirturi, &kursrect);

  if(kursoriliike)merkkikohta++;
  if(merkkikohta == teksti.length()+1) {
    SDL_DestroyTexture(irc_kirjoitus);
    merkkikohta = 1;
    irc_rivisiirto = 0;
    return true;
  }
  return false;
}

void kuplanpiirto(int frame_nyt) {
  //Jos kuplan lhtpiste + pituus on suurempia kuin screen_width -> kupla vasemmalle
  //Jos kuplan lhtpiste on alle nollan -> kupla oikealle
  //Nm kuplan lhtpisteet pit mritell aina tss funktiossa, jos halutaan, ett hahmo voi liikkua puhuessaan
  //Kupla vasemmalle vai oikealle pin hahmosta
  bubblew = kuppoint->first-kamerax1;
  if(kuplavo == 2) {
    if(kupasema > 2) bubblew += 55+30; //55 on tuossa noin hahmonspriten leveys ja 30 osoitin ja muu vli
    //pelkk kuplavo == 2 ilman sivuX:aa ei vaadi ksittely
  }
  else if (kuplavo == 1) {
    if(kupasema > 2) bubblew -= tempkuppituus+30;
    else bubblew -= tempkuppituus-60; //60 on suunnilleen hahmon leveys eli vasemmallekin osoittava kupla alkaa hahmon pn toiselta puolelta
  }
  else { //jos kuplavo == 0
    //jos hahmo on ruudun oikealla puolella, kupla vasemmalle ja toisin pin
    if(bubblew > RUUDUNLEVEYS/2) {
      if(kupasema > 2) bubblew -= tempkuppituus+30;
      else bubblew -= tempkuppituus-60;
    }
    else if(kupasema > 2) bubblew += 55+30; //55 on tuossa noin hahmonspriten summittainen leveys ja 30 osoitin ja muu vli
    //pelkk oikealla oleva yl/alakupla ei vaadi ksittely
  }

  //Jos kupla menee yli ruudusta, se siirtyy sen verran, ett mahtuu ruutuun
  if(bubblew+tempkuppituus > RUUDUNLEVEYS) bubblew = RUUDUNLEVEYS-tempkuppituus;
  else if(bubblew < 0) bubblew = 0;

  if(kupasema == 1) bubbleh = (kuppoint->second)-tempkupkorkeus-30; //-30 on liskorkeus, jota ilman kupla alkaisi suoraan hahmon plt ja osoite uppoaisi liian alas
  else if(kupasema == 3) bubbleh = (kuppoint->second)-tempkupkorkeus+40; //sivuylkuplan alalaita on jossain suun paikkeilla (+40) ja siit miinus kuplankorkeus
  else if(kupasema == 5) bubbleh = (kuppoint->second)+20; //sivualakuplan yllaita on jossain silmien kohdalla (+20)
  else if(kupasema == 4) bubbleh = (kuppoint->second)+20-(tempkupkorkeus/2); //sivukeskikuplan yllaita on silmnkorkeudelta (+20) ja miinus puolet kuplankorkeudesta
  else bubbleh = (kuppoint->second)+150; //ala-asemassa kupla lhtee jostain hahmon jalkojen alta

  bubblew2 = tempkuppituus; //oli 360, tm on siis kuplan leveys (ml. borderit). Kuplanpituus myhemmin tulee ilmeisesti thn kohtaan mriteltvksi, kunhan autowrapist tehdn oma funktionsa
  bubbleh2 = tempkupkorkeus; //kuplan korkeus yllaidasta laskien
  cliprect = {bubblew, bubbleh, bubblew2, static_cast<int>((KUPYLABORDER+(vuorosanavec.size() - ceil(ylirivit))*(merkinkorkeus+RIVIVALI)))};
  kupla1 = {bubblew, (bubbleh + 15), bubblew2, bubbleh2 - 30}; //kuplan levempi pala
  kupla2 = {(bubblew + 15), bubbleh, (bubblew2 - 30), bubbleh2}; //kuplan korkeampi pala

  SDL_RenderFillRect(piirturi, &kupla1);
  SDL_RenderFillRect(piirturi, &kupla2); //Piirretn puhekuplan molemmat kappaleet (suorapalkit)

  //Puhekuplan riviivat
  SDL_SetRenderDrawColor(piirturi, 0x0, 0x0, 0x0, 0x0);
  SDL_RenderDrawLine(piirturi, bubblew+15, bubbleh-1, bubblew+bubblew2-15, bubbleh-1);
  SDL_RenderDrawLine(piirturi, bubblew+15, bubbleh-2, bubblew+bubblew2-15, bubbleh-2);
  SDL_RenderDrawLine(piirturi, bubblew+15, bubbleh+bubbleh2, bubblew+bubblew2-15, bubbleh+bubbleh2);
  SDL_RenderDrawLine(piirturi, bubblew+15, bubbleh+bubbleh2+1, bubblew+bubblew2-15, bubbleh+bubbleh2+1);
  SDL_RenderDrawLine(piirturi, bubblew-1, bubbleh+15, bubblew-1, bubbleh+bubbleh2-15);
  SDL_RenderDrawLine(piirturi, bubblew-2, bubbleh+15, bubblew-2, bubbleh+bubbleh2-15);
  SDL_RenderDrawLine(piirturi, bubblew+bubblew2, bubbleh+15, bubblew+bubblew2, bubbleh+bubbleh2-15);
  SDL_RenderDrawLine(piirturi, bubblew+bubblew2+1, bubbleh+15, bubblew+bubblew2+1, bubbleh+bubbleh2-15);
  SDL_SetRenderDrawColor(piirturi, 0xFF, 0xFF, 0xFF, 0xFF);

  //Kuplan kaarikulmat
  kupkulma.renderfunktio(bubblew-2, bubbleh);
  kupkulma.renderfunktio(bubblew-2, bubbleh+bubbleh2-15, NULL, 2);
  kupkulma.renderfunktio(bubblew+bubblew2-15, bubbleh, NULL, 1);
  kupkulma.renderfunktio(bubblew+bubblew2-15, bubbleh+bubbleh2-15, NULL, 3);
  
  //Puhekuplan osoitin
  int osw = bubblew;
  int osh = kuppoint->second-30;
  int osuunta = 0; //Ilmaisee aluksi, osoittaako kupla oikealle vai vasemmalle, myhemmin renderfunktion flip-arvo
  if(kuplavo == 1 or kuppoint->first-kamerax1 > RUUDUNLEVEYS/2) osuunta = 1;

  //Ylkupla-w vasemmalle
  if(osuunta == 1) osw = kuppoint->first+10-kamerax1;   //Vasemmalle osoittava kupla knnetn vasemmalle
  //Ylkupla-w oikealle
  else osw = kuppoint->first+40-kamerax1;

  if(kupasema > 2) {
    if(osuunta == 0) osw += 21;
    else osw -=42;
    if(kupasema == 4) osh += 40;
    else if(kupasema == 3) osh += 47;
    else if(kupasema == 5) osh += 55;
  }
  //Jos tarvitaan vertical flip, se tulee laittamalla osuunta = 2;
  if(kupasema == 2) { //alakupla
    if(osuunta == 1) osuunta = 3; //horizontal_flip & vertical_flip, kun kupla alhaalla ja vasemmalle pin
    else osuunta = 2; //vertical_flip
    osh = bubbleh-25;
  }
  if(kupasema > 2) kosoitin90.renderfunktio(osw, osh, NULL, osuunta);
  else kosoitin.renderfunktio(osw, osh, NULL, osuunta);

  //Neli, joka leikkaa puhekuplasta poistuvan skrollaavan tekstin
  if(kuplantila == 3 or ylirivit > 0) SDL_RenderSetClipRect(piirturi, &cliprect);

  for(vector<string>::iterator renditer = vuorosanavec.begin(); renditer != vuorosanavec.end(); ++renditer) {
    tekstirend(bubblew, bubbleh, distance(vuorosanavec.begin(), renditer)+1, *renditer, fontti);
  }

  if(kuplantila == 3 or ylirivit > 0) SDL_RenderSetClipRect(piirturi, NULL);  //if on tss vain, jotta vltetn turha funktiokutsu

  if(kursoripaalla == 1) {
    if(onkoriviloppu(mikarivi.second, moneskirjain) and kursoripaalla < 3) {  //Jos rivi loppuu, siirrytn seuraavalle riville ja rivin alkuun ...jos kursori ei ole maalissa
      if(mikarivi.second == vuorosanavec.size() and onkoriviloppu(mikarivi.second, moneskirjain) and kursorikountteri < 4) {  //Jos ollaan vikalla rivill ja vikassa kirjaimessa.
	kursoripaalla = 3;
      }
      else {  //jos rivi on loppu ja kursori ei ole viel maalissa, laitetaan kursori rivin alkuun
	mikarivi.first++;
	mikarivi.second++;
	moneskirjain = 0;
      }
    }
  }
  //mikarivi.first & mikarivi.second -muuttujat kasvavat aina yhdell rivin loputtua, jos on uusi rivi on tulossa
  if(ylirivit > 0 and kursoripaalla == 1 and mikarivi.first-1 == vuorosanavec.size()-ceil(ylirivit)) kursoripaalla = 2;
  if(kursoripaalla == 2) {
    skrollausarvo += 2;
    if(bubbleh-skrollausarvo+KUPYLABORDER+vuorosanavec.size()*(RIVIVALI+merkinkorkeus) <= bubbleh+KUPYLABORDER+(vuorosanavec.size() - ceil(ylirivit))*(merkinkorkeus+RIVIVALI)) { //Tss hyvin oleellista on, ett vertailun oikeanpuoleinen y-koordinaatti on laskettu samalla logiikalla kuin cliprectin korkeus
      kursoripaalla = 1;
      //Skrollin jlkeinen rivi on kuplaan mahtuvien rivien mr miinus uusien rivien mr plus yksi
      mikarivi.first = ((tempkupkorkeus - KUPYLABORDER - KUPALABORDER) / (merkinkorkeus + RIVIVALI) - ceil(ylirivit)) + 1;
    }
  }
  
  if(kursoripaalla == 1) moneskirjain++; //jos kursori ei ole maalissa, listn rivi
  else if(kursoripaalla > 2 and frame_nyt%10 == 0) {kursoripaalla = 3; kursorikountteri++;}
  else if(kursoripaalla > 2 and frame_nyt%10 == 5) kursoripaalla = 4;
  if(kursoripaalla % 2 != 0) {kursorirend(bubblew, bubbleh, mikarivi.first, (kursoripaalla > 2 ? moneskirjain+1 : moneskirjain), (kursoripaalla == 3 ? " " : (kursorikirjain(mikarivi.second, moneskirjain))), fontti);}
  if(kursorikountteri == 4) {kursoripaalla = 0; kuplantila = 3;}  //Kun on vlkytty nelj kertaa, lopetetaan.
  if(kuplantila == 3 and frame_nyt%10 <= 20) skrollausarvo +=10;  // <= -arvo vaikuttaa nopeuteen

  //15 merkin pituisissa yhden rivin viesteiss kuplan kesto on lyhyempi kuin sit pidemmiss
  if(kursoripaalla == 0 and bubblew <= (15*merkinpituus+30) and pkupkounter+35 <= frame_nyt) kuplantila = 3;
  else if(kursoripaalla == 0 and pkupkounter+50 <= frame_nyt) kuplantila = 3;
  
  //Jos tekstin poistava tekstiskrolli on vienyt koko tekstin kuplan ylrajan ylpuolelle
  if(kuplantila == 3 and bubbleh-skrollausarvo+KUPYLABORDER+static_cast<signed int>(vuorosanavec.size())*(RIVIVALI+merkinkorkeus) <= bubbleh) {
    kursorikountteri = 0;
    pkupkounter = 0;
    moneskirjain = 0;
    tyhjenna_vektori();
    if(tarina_kt != 0) {
      tarina_t = tarina_kt*25;
      tarina_kt = -1;
      kuplantila = 6;
    }
    if(kuplantila != 6) {
      vector<kupla>::iterator eriter = kuplavec.begin();
      kuplavec.erase(eriter);
    }
    if(kuplavec.size() > 0 and tarina_kt == 0) kuplanluonti(frame_nyt);
    else if(tarina_kt == 0) {
      kuplantila = 0;
      if(kesktark()) tarinakeskeytys = true;
    }
  }
}

bool kesktark() {
  bool kesk = true;
  if(tarina_t != 0) {
    kesk = false;
    return kesk;
  }
  //Puhuuko joku?
  if(kuplantila != 0 and kuplantila != 8) {
    kesk = false;
    return kesk;
  }
  //Skrollaako tausta?
  if(kamskrolli != 0) {
    kesk = false;
    return kesk;
  }
  //Ovatko kaikki hahmot pyshdyksiss?
  for(vector<hahmoluokka*>::iterator way_iter = hahmovektori.begin(); way_iter != hahmovektori.end(); ++way_iter) {
    if(((*way_iter)->waypoint1.first != 0 or (*way_iter)->waypoint1.second != 0)) {
      kesk = false;
      return kesk;
    }
  }
  return kesk;
}

void kamerareset() {
  kamerax1 = 0;
  kamskrolli = 0;
  skrollihalt = 0;
  kamrect = {0, 0, RUUDUNLEVEYS, RUUDUNKORKEUS};
}

void musavalinta(int numero) {
  if(musafeidaus) {
    nextmusa = numero;
    return;
  }
  switch(numero) {
  case 1: musaptr = &hkalku; break;
  case 2: musaptr = &hkmain; break;
  case 3: musaptr = &tuumaus; break;
  case 4: musaptr = &outro; break;
  case 5: musaptr = &trial; break;
  case 6: musaptr = &scare; break;
  case 7: musaptr = &inter; break;
  case 8: musaptr = &conclu; break;
  case 9: musaptr = &logosound; break;
  case 10: musaptr = &corridor; break;
  case 11: musaptr = &hkalt; break;
  }
  musaptr->set_repeat_count(-1);
}

void *MusaSaie(void *saiearg) {
  for(;;) {
    if(musiikki != 0) {
      portaudio::BlockingStream *aanivirta;
      aanivirta = (portaudio::BlockingStream*) saiearg;

      if(musiikki == 3 or quit) {
	aanivirta->stop();
	musiikki = 0;
	musafeidaus = false;
      }
      else if(musiikki == 2 and musafeidaus == false and musiikki != 1) {
	aanivirta->start();
	musiikki = 1;
      }
      if(musiikki == 1 and musafeidaus == false) {
	size_t musalaskuri = musaptr->read(naytteenottoaste, aanipuskuri, vkanava.data(), okanava.data());
	try {aanivirta->write(kpuskurit, static_cast<unsigned long>(musalaskuri));}
	catch (const portaudio::PaException &pa_exception) {if(pa_exception.paError() != paOutputUnderflowed) throw;}
      }
      else if(musafeidaus) {
	feidauskerroin -= 0.002;
	size_t musalaskuri = musaptr->read(naytteenottoaste, aanipuskuri, vkanava.data(), okanava.data());
	for(vector<float>::iterator fade_iter = vkanava.begin(); fade_iter != vkanava.end(); ++fade_iter) *fade_iter *= feidauskerroin;
	for(vector<float>::iterator fade_iter = okanava.begin(); fade_iter != okanava.end(); ++fade_iter) *fade_iter *= feidauskerroin;
	try {aanivirta->write(kpuskurit, static_cast<unsigned long>(musalaskuri));}
	catch (const portaudio::PaException &pa_exception) {if(pa_exception.paError() != paOutputUnderflowed) throw;}
	if(feidauskerroin < 0) {
	  if(musiikki != 2) musiikki = 0;
	  musafeidaus = false;
	  aanivirta->stop();
	  feidauskerroin = 1;
	  if(nextmusa > 0) {
	    musavalinta(nextmusa);
	    nextmusa = 0;
	  }
	}
      }
    }
    else SDL_Delay(100);
  }
}

int main(int argc, char *args[]) {

  for(;;) {
    cout << endl << "Language selection:" << endl << "1) Finnish original" << endl << "2) English translation" << endl << "? ";
    cin >> kieli;
    if(kieli == 1 or kieli == 2) break;
  }

  int wsize;
  for(;;) {
    cout << endl << "Window size:" << endl << "1) Actual pixels" << endl << "2) Fullscreen" << endl << "? ";
    cin >> wsize;
    if(kieli == 1 or kieli == 2) break;
  }
  if(wsize == 2) fullscreen = true;

  srand(static_cast<int>(time(0)));
  tyhjenna_vektori();

  int frame_nyt = 0;
  bool liikutaan = false;
  Uint8 alpha = 0;
  Uint32 ajastin1 = 0;
  Uint32 ajastin2 = 0;
  Uint32 ajastin_fr = 0;  //Kvelyframejen nopeus
  Uint32 ajastin_r = 0;
  Uint32 irc_ajastin = 0; //Rivien ilmaantuminen
  Uint32 irc_ajastin2 = 0; //Kursorin nopeus ja IRC-nkymst poistumisen tauko
  int tanssi = 0;
  Uint32 tanssitimer = 0;
  int rowcontrol = 0;
  bool irc_sekunti = false;
  bool kursoriliike = true;
  int pois = 2; //IRC-kohdan loopista poistuminen
  int rcount = 0;
  SDL_Rect irc_ylapalkki = {0, 0, RUUDUNLEVEYS, irc_MERKINKORKEUS};
  int irc_rivinlasku = 0;
  SDL_Rect irc_alapalkki = {0, (irc_rivimaara-2)*irc_MERKINKORKEUS, RUUDUNLEVEYS, irc_MERKINKORKEUS};

  //Alkukuvan tekstit
  Uint8 av1 = 160;
  Uint8 av2 = 160;
  Uint8 av3 = 160;
  SDL_Color alkuvari = {av1, av2, av3};
  int binx = 680;
  int biny = 241;
  int sasetus = 0;
  char ssuunta = 'o';
  int kasic = 0;
  SDL_Rect kasirect = {332, 335, 70, 54};
  SDL_Rect btausta = {0, 414, RUUDUNLEVEYS, merkinkorkeus};
  SDL_Rect ctausta = {0, 448, RUUDUNLEVEYS, merkinkorkeus};
  bool bind = false;
  int cx = 419;
  int cy = 419;
  bool cd = true;
  int syd1 = -10;
  int syd2 = -65;
  int syd3 = 55;

  pthread_t saie[1];

  portaudio::AutoSystem portaudio_init;
  portaudio::System &portaudio = portaudio::System::instance();
  portaudio::DirectionSpecificStreamParameters output_parametrit(portaudio.defaultOutputDevice(), 2, portaudio::FLOAT32, false, portaudio.defaultOutputDevice().defaultHighOutputLatency(), 0);
  portaudio::StreamParameters stream_parametrit(portaudio::DirectionSpecificStreamParameters::null(), output_parametrit, naytteenottoaste, paFramesPerBufferUnspecified, paNoFlag);
  portaudio::BlockingStream aanienvirta(stream_parametrit);
  musaptr = &hkmain; //oletuskappale

  portaudio::BlockingStream *aanivirtaptr = &aanienvirta;

  pthread_create(&saie[0], NULL, MusaSaie, (void *)aanivirtaptr);
  
  if(!init()) {
    cerr << "Init fail" << endl;
  }
  else {
    if(!lataamedia()) {
    cerr << "Media load fail" << endl;
    }

    else {
      kissa.arkit();  //Tmn funktion voi kutsua mink tahansa hahmoluokan olion kautta
      
      kissa.yhdista_tekstuuri(&kissateks);
      kissa.yhdista_rect(kissa_arkki, (sizeof(kissa_arkki)/sizeof(*kissa_arkki)), sizeof(kissa_arkki));
      kissa.symmetrinen = false;

      kissak.yhdista_tekstuuri(&kissakteks);
      kissak.yhdista_rect(kissak_arkki, (sizeof(kissak_arkki)/sizeof(*kissak_arkki)), sizeof(kissak_arkki));
      
      koira1.yhdista_tekstuuri(&koirateks1);
      koira1.yhdista_rect(koira1_arkki, (sizeof(koira1_arkki)/sizeof(*koira1_arkki)), sizeof(koira1_arkki));
      
      koira2.yhdista_tekstuuri(&koirateks2);
      koira2.yhdista_rect(koira2_arkki, (sizeof(koira2_arkki)/sizeof(*koira2_arkki)), sizeof(koira2_arkki)); //Kun array lhetetn funktioon (ensimminen parametri), se on pointteri arrayn ensimmiseen elementtiin, toisessa parametriss lasketaan arrayn pituus eli se arkkien mr, kolmas parametri on arrayn koko tavuina

      naata.yhdista_tekstuuri(&naatateks);
      naata.yhdista_rect(naata_arkki, (sizeof(naata_arkki)/sizeof(*naata_arkki)), sizeof(naata_arkki));

      mayra.yhdista_tekstuuri(&mayrateks);
      mayra.yhdista_rect(mayra_arkki, (sizeof(mayra_arkki)/sizeof(*mayra_arkki)), sizeof(mayra_arkki));

      drops.yhdista_tekstuuri(&dropsteks);
      drops.yhdista_rect(drops_arkki, (sizeof(drops_arkki)/sizeof(*drops_arkki)), sizeof(drops_arkki));

      poyta.tekstuuri = &poytateks;
      kpoyta.tekstuuri = &kpoytateks;
      poyta3.tekstuuri = &poyta3teks;
      rv.tekstuuri = &rvteks;
      tuoli.tekstuuri = &tuoliteks;
      tuoli2.tekstuuri = &tuoli2teks;
      kaide.tekstuuri = &kaideteks;
      ruoka.tekstuuri = &ruokateks;
      wcoa.tekstuuri = &wcoateks;
      wcok.tekstuuri = &wcokteks;
      roa.tekstuuri = &roateks;
      
      SDL_Event tapahtuma;

      cout << "Attempting to load fonts" << endl;
      fontti = TTF_OpenFont("./DejaVuSansMono-Bold.ttf", 15);  //Parameters: path to the font, font size. Jos polku on vrin, tulee segmentation fault
      irc_fontti = TTF_OpenFont("./DejaVuSansMono.ttf", 15);
      irc_fontti_b = TTF_OpenFont("./DejaVuSansMono-Bold.ttf", 15);
      loppufontti = TTF_OpenFont("./DejaVuSansMono-Bold.ttf", 25);
      cout << "Fonts loaded" << endl;

      SDL_Surface* kello1 = TTF_RenderText_Solid(irc_fontti, "18:41", {255, 255, 255});
      SDL_Surface* kello2 = TTF_RenderText_Solid(irc_fontti, "18:42", {255, 255, 255});
      SDL_Surface* kello3 = TTF_RenderText_Solid(irc_fontti, "18:43", {255, 255, 255});
      SDL_Surface* akello1 = TTF_RenderText_Solid(irc_fontti, "18:41", {170, 170, 170});  
      SDL_Surface* akello2 = TTF_RenderText_Solid(irc_fontti, "18:42", {170, 170, 170});  
      SDL_Surface* akello3 = TTF_RenderText_Solid(irc_fontti, "18:43", {170, 170, 170});  
      SDL_Surface* pinta6 = TTF_RenderText_Solid(irc_fontti, " Kerhokanava, keskustellaan ntisti", {154, 154, 154});
      SDL_Surface* pinta7 = TTF_RenderText_Solid(irc_fontti, "-", {0, 130, 255});
      SDL_Surface* pinta8 = TTF_RenderText_Solid(irc_fontti, "!", {255, 255, 255});
      aika_leveys = kello1->w;
      aika_leveys = kello1->w;
      aika1 = SDL_CreateTextureFromSurface(piirturi, kello1);
      aika2 = SDL_CreateTextureFromSurface(piirturi, kello2);
      aika3 = SDL_CreateTextureFromSurface(piirturi, kello3);
      SDL_Texture* aaika1 = SDL_CreateTextureFromSurface(piirturi, akello1);
      SDL_Texture* aaika2 = SDL_CreateTextureFromSurface(piirturi, akello2);
      SDL_Texture* aaika3 = SDL_CreateTextureFromSurface(piirturi, akello3);
      apaika = aaika1;
      SDL_Texture* otsikko = SDL_CreateTextureFromSurface(piirturi, pinta6);
      SDL_Texture* siniviiva = SDL_CreateTextureFromSurface(piirturi, pinta7);
      SDL_Texture* huutom = SDL_CreateTextureFromSurface(piirturi, pinta8);
      SDL_Rect otsrect = {0, 0, (pinta6->w), irc_MERKINKORKEUS};
 
      SDL_Surface* sirc_osoite = TTF_RenderText_Solid(irc_fontti, "~bagbiter@gw0.tnet.fi", {0, 130, 130});
      SDL_Texture* irc_osoite = SDL_CreateTextureFromSurface(piirturi, sirc_osoite);
      SDL_Surface* shas_joined = TTF_RenderText_Solid(irc_fontti, "has joined", {255, 255, 255});
      SDL_Texture* has_joined = SDL_CreateTextureFromSurface(piirturi, shas_joined);

      SDL_Surface* skannimi_dc = TTF_RenderText_Solid(irc_fontti, "#kerhokanava", {0, 130, 130}); //dc = dark cyan
      SDL_Texture* kannimi_dc = SDL_CreateTextureFromSurface(piirturi, skannimi_dc);

      //(Ei mahdu hkb:n osoite ilman rivinvaihtoa)
      SDL_Surface* stoka_rivi = TTF_RenderText_Solid(irc_fontti, "Topic set for              : Kerhokanava, keskustellaanpa ntisti", {255, 255, 255});
      SDL_Texture* toka_rivi = SDL_CreateTextureFromSurface(piirturi, stoka_rivi);

      SDL_Surface* stopicsetby = TTF_RenderText_Solid(irc_fontti, "Topic set by", {255, 255, 255});
      SDL_Texture* topicsetby = SDL_CreateTextureFromSurface(piirturi, stopicsetby);
      SDL_Surface* stopicdate = TTF_RenderText_Solid(irc_fontti, "Mon May  1 17:22:43 2019", {255, 255, 255});
      SDL_Texture* topicdate = SDL_CreateTextureFromSurface(piirturi, stopicdate);

      SDL_Surface* susers = TTF_RenderText_Solid(irc_fontti, "Users", {0, 130, 0});
      SDL_Texture* users = SDL_CreateTextureFromSurface(piirturi, susers);
      SDL_Surface* skannimi_v = TTF_RenderText_Solid(irc_fontti, "#kerhokanava", {0, 255, 0});
      SDL_Texture* kannimi_v = SDL_CreateTextureFromSurface(piirturi, skannimi_v);

      SDL_Surface* snickrivi = TTF_RenderText_Solid(irc_fontti, "@HoundJock   @GrayUrchin    bagbiter   @hkb   @perlmutter", {255, 255, 255});
      SDL_Texture* nickrivi = SDL_CreateTextureFromSurface(piirturi, snickrivi);

      SDL_Surface* skuudesrivi_n = TTF_RenderText_Solid(irc_fontti, "Total of    nicks    ops    normal", {255, 255, 255});
      SDL_Texture* kuudesrivi_n = SDL_CreateTextureFromSurface(piirturi, skuudesrivi_n);
      
      SDL_Surface* sseitrivi = TTF_RenderText_Solid(irc_fontti, "Channel              created Sun Nov  8 16:10:48 2018", {255, 255, 255});
      SDL_Texture* seitrivi = SDL_CreateTextureFromSurface(piirturi, sseitrivi);

      SDL_Surface* svikarivi = TTF_RenderText_Solid(irc_fontti, "Join to              was synced in   secs", {255, 255, 255});
      SDL_Texture* vikarivi = SDL_CreateTextureFromSurface(piirturi, svikarivi);

      SDL_Surface* salapalkki_h = TTF_RenderText_Solid(irc_fontti, " bagbiter( i)   2:freenode/#kerhokanava( csnt)", {170, 170, 170});
      SDL_Texture* alapalkki_h = SDL_CreateTextureFromSurface(piirturi, salapalkki_h);
      SDL_Surface* salapalkki_s = TTF_RenderText_Solid(irc_fontti, "[     ] [         +  ] [                        +     ]", {0, 170, 170});
      SDL_Texture* alapalkki_s = SDL_CreateTextureFromSurface(piirturi, salapalkki_s);
      SDL_Surface* skehoite = TTF_RenderText_Solid(irc_fontti, "[#kerhokanava]", {255, 255, 255});
      SDL_Texture* kehoite = SDL_CreateTextureFromSurface(piirturi, skehoite);

      SDL_Surface* pinta4 = TTF_RenderText_Solid(irc_fontti_b, " <", {83, 85, 85});
      SDL_Surface* pinta5 = TTF_RenderText_Solid(irc_fontti_b, ">", {83, 85, 85});
      SDL_Texture* sulut_auki = SDL_CreateTextureFromSurface(piirturi, pinta4);
      SDL_Texture* sulut_kiinni = SDL_CreateTextureFromSurface(piirturi, pinta5);
      
      SDL_Surface* skannimi_wb = TTF_RenderText_Solid(irc_fontti_b, "#kerhokanava", {255, 255, 255});
      SDL_Texture* kannimi_wb = SDL_CreateTextureFromSurface(piirturi, skannimi_wb);

      SDL_Surface* sharmhaka_a = TTF_RenderText_Solid(irc_fontti_b, "[", {83, 85, 85});
      SDL_Surface* sharmhaka_k = TTF_RenderText_Solid(irc_fontti_b, "]", {83, 85, 85});
      SDL_Texture* harmhaka_a = SDL_CreateTextureFromSurface(piirturi, sharmhaka_a);
      SDL_Texture* harmhaka_k = SDL_CreateTextureFromSurface(piirturi, sharmhaka_k);
      
      SDL_Surface* shk_nick = TTF_RenderText_Solid(irc_fontti_b, "hkb", {255, 255, 255});
      SDL_Texture* hk_nick = SDL_CreateTextureFromSurface(piirturi, shk_nick);
      
      SDL_Surface* sboldnick = TTF_RenderText_Solid(irc_fontti_b, "bagbiter", {5, 255, 255});
      SDL_Texture* boldnick = SDL_CreateTextureFromSurface(piirturi, sboldnick);

      SDL_Surface* snickhaat = TTF_RenderText_Solid(irc_fontti_b, "[          ] [           ] [         ] [    ] [           ]", {69, 69, 69});
      SDL_Texture* nickhaat = SDL_CreateTextureFromSurface(piirturi, snickhaat);

      SDL_Surface* skuudesrivi_b = TTF_RenderText_Solid(irc_fontti_b, "Irssi: #kerhokanava:           5      , 4    , 1", {255, 255, 255});
      SDL_Texture* kuudesrivi_b = SDL_CreateTextureFromSurface(piirturi, skuudesrivi_b);
      SDL_Surface* skuudesrivi_h = TTF_RenderText_Solid(irc_fontti_b, "[                        ]", {69, 69, 69});
      SDL_Texture* kuudesrivi_h = SDL_CreateTextureFromSurface(piirturi, skuudesrivi_h);

      SDL_Surface* svikarivi_b = TTF_RenderText_Solid(irc_fontti_b, "Irssi:         #kerhokanava               0", {255, 255, 255});
      SDL_Texture* vikarivi_b = SDL_CreateTextureFromSurface(piirturi, svikarivi_b);

      while(!quit) {
	ajastin1 = SDL_GetTicks();
	if(tarinanvaihe > 601) {
	  musiikki = 3;
	  quit = true;
	}
	
	while(SDL_PollEvent(&tapahtuma)!=0) {
	  if(tapahtuma.type == SDL_QUIT) {
	    quit = true;
	  }
	}
	if(kameranollaus) kamerareset();

	if(tarinakeskeytys) {
  	  tarinakeskeytys = false;
	  if(kieli == 1) do tarinanvaihe++; while (!tarinafunktio());
	  else if(kieli == 2) do tarinanvaihe++; while (!storyfunction());
	  if(tarina_t > 0 and tarina_kt == 0) tarina_t *= 25;
	}

	//Ruudun tyhjennys
	SDL_SetRenderDrawColor(piirturi, 0x0, 0x0, 0x0, 0x0);
	SDL_RenderClear(piirturi);
	SDL_SetRenderDrawColor(piirturi, 0xFF, 0xFF, 0xFF, 0xFF);

	//Renderoi tausta, taustan liike, hahmojen sijaintien pivitys
	if(taustakuva.tekstuuri != NULL) {
	  if(kamskrolli != 0) {
	    kamskrolli == 2 ? kamrect = {(kamerax1 += 3), 0, RUUDUNLEVEYS, RUUDUNKORKEUS} : kamrect = {(kamerax1 -= 3), 0, RUUDUNLEVEYS, RUUDUNKORKEUS} ;
	    if(kamskrolli == 2 and kamerax1 >= skrollihalt) {
	      kamerax1 = skrollihalt;
	      kamskrolli = 0;
	      kamrect = {(kamerax1), 0, RUUDUNLEVEYS, RUUDUNKORKEUS};
	    }
	    else if(kamskrolli == 1 and kamerax1 <= skrollihalt) {
	      kamerax1 = skrollihalt;
	      kamskrolli = 0;
	    }
	  }
	  taustakuva.renderfunktio(0,0, &kamrect);
	}

	

	if(IRC > 0) {
	  if(irc_sekunti) {
	    for(vector<irc_rivi>::iterator seku_iter = irc_teksturet.begin(); seku_iter != irc_teksturet.end(); ++seku_iter) {
	      if(seku_iter->ajastin > 0) seku_iter->ajastin--;
	    }
	    irc_sekunti = false;
	  }

	  if(merkkikohta > 1) {
	    if(SDL_GetTicks() - irc_ajastin2 > 47) { //Mit suurempi tuo viimeinen luku, sit hitaammin kursori liikkuu
	      irc_ajastin2 = SDL_GetTicks();
	      kursoriliike = true;
	    }
	    else kursoriliike = false;
	  }

	  if(IRC == 2) { //Poistuminen IRC-nkymst
	    if(SDL_GetTicks() - irc_ajastin2 > 5000) {
	      IRC = 0;
	      tarinakeskeytys = true;
	    }
	  }

	  SDL_SetRenderDrawColor(piirturi, 0x00, 0x00, 0xAA, 0xFF);
	  SDL_RenderFillRect(piirturi, &irc_ylapalkki);
	  SDL_RenderFillRect(piirturi, &irc_alapalkki);
	  SDL_RenderCopy(piirturi, otsikko, NULL, &otsrect);

	  int monesrivi = 8 - irc_rivinlasku;
	  
	  //IRCin alkurivien kellonajat ja -!-:t
	  if(irc_rivinlasku < 8) {
	    for(int i = 8; i != 0; i--) {
	      if(i == irc_rivinlasku) continue;
	      SDL_Rect aikarect = {0, (i-irc_rivinlasku)*irc_MERKINKORKEUS, 5*irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi, aika1, NULL, &aikarect);
	      if(i == 4 or i == 5) continue;
	      SDL_Rect viivarect1 = {6*irc_MERKINPITUUS, (i-irc_rivinlasku)*irc_MERKINKORKEUS, irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_Rect huutorect = {7*irc_MERKINPITUUS, (i-irc_rivinlasku)*irc_MERKINKORKEUS, irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_Rect viivarect2 = {8*irc_MERKINPITUUS, (i-irc_rivinlasku)*irc_MERKINKORKEUS, irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi, siniviiva, NULL, &viivarect1);
	      SDL_RenderCopy(piirturi, huutom, NULL, &huutorect);
	      SDL_RenderCopy(piirturi, siniviiva, NULL, &viivarect2);
	    }
	  }
	  //IRCin muut alkurivit
	  //jos rivej_mennyt_yliarvo on yli 0, nit ei tule. seuraavan rivin kohdalla 1 jne.
	  do { //"Looppi", jota ei loopata ikin
	    SDL_Rect rect36 = {0, (irc_rivimaara-1)*irc_MERKINKORKEUS, skehoite->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kehoite, NULL, &rect36);
	    SDL_Rect rect35 = {2*irc_MERKINPITUUS, (irc_rivimaara-2)*irc_MERKINKORKEUS, akello1->w, irc_MERKINKORKEUS}; //Tss voi olla aina sama surface
	    irc_aika == 1 ? apaika = aaika1 : apaika = aaika2;
	    SDL_RenderCopy(piirturi, apaika, NULL, &rect35);
	    SDL_Rect rect34 = {9*irc_MERKINPITUUS, (irc_rivimaara-2)*irc_MERKINKORKEUS, salapalkki_h->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, alapalkki_h, NULL, &rect34);
	    SDL_Rect rect33 = {1*irc_MERKINPITUUS, (irc_rivimaara-2)*irc_MERKINKORKEUS, salapalkki_s->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, alapalkki_s, NULL, &rect33);
	    if(monesrivi < 1) break;
	    SDL_Rect rect32 = {17*irc_MERKINPITUUS, monesrivi*irc_MERKINKORKEUS, svikarivi->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, vikarivi, NULL, &rect32);
	    SDL_Rect rect31 = {10*irc_MERKINPITUUS, monesrivi*irc_MERKINKORKEUS, svikarivi_b->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, vikarivi_b, NULL, &rect31);
	    if(monesrivi < 2) break;
	    SDL_Rect rect30 = {18*irc_MERKINPITUUS, (monesrivi-1)*irc_MERKINKORKEUS, skannimi_dc->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kannimi_dc, NULL, &rect30);
	    SDL_Rect rect29 = {10*irc_MERKINPITUUS, (monesrivi-1)*irc_MERKINKORKEUS, sseitrivi->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, seitrivi, NULL, &rect29);
	    if(monesrivi < 3) break;
	    SDL_Rect rect28 = {40*irc_MERKINPITUUS, (monesrivi-2)*irc_MERKINKORKEUS, skuudesrivi_h->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kuudesrivi_h, NULL, &rect28);
	    SDL_Rect rect27 = {31*irc_MERKINPITUUS, (monesrivi-2)*irc_MERKINKORKEUS, skuudesrivi_n->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kuudesrivi_n, NULL, &rect27);
	    SDL_Rect rect26 = {10*irc_MERKINPITUUS, (monesrivi-2)*irc_MERKINKORKEUS, skuudesrivi_b->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kuudesrivi_b, NULL, &rect26);
	    if(monesrivi < 4) break;
	    SDL_Rect rect25 = {7*irc_MERKINPITUUS, (monesrivi-3)*irc_MERKINKORKEUS, snickrivi->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, nickrivi, NULL, &rect25);
	    SDL_Rect rect24 = {6*irc_MERKINPITUUS, (monesrivi-3)*irc_MERKINKORKEUS, snickhaat->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, nickhaat, NULL, &rect24);
	    if(monesrivi < 5) break;
	    SDL_Rect rect23 = {27*irc_MERKINPITUUS, (monesrivi-4)*irc_MERKINKORKEUS, sharmhaka_k->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, harmhaka_k, NULL, &rect23);
	    SDL_Rect rect22 = {14*irc_MERKINPITUUS, (monesrivi-4)*irc_MERKINKORKEUS, skannimi_v->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kannimi_v, NULL, &rect22);
	    SDL_Rect rect21 = {7*irc_MERKINPITUUS, (monesrivi-4)*irc_MERKINKORKEUS, susers->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, users, NULL, &rect21);
	    SDL_Rect rect20 = {6*irc_MERKINPITUUS, (monesrivi-4)*irc_MERKINKORKEUS, sharmhaka_a->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, harmhaka_a, NULL, &rect20);
	    if(monesrivi < 6) break;
	    SDL_Rect rect19 = {52*irc_MERKINPITUUS, (monesrivi-5)*irc_MERKINKORKEUS, sharmhaka_k->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, harmhaka_k, NULL, &rect19);
	    SDL_Rect rect18 = {28*irc_MERKINPITUUS, (monesrivi-5)*irc_MERKINKORKEUS, stopicdate->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, topicdate, NULL, &rect18);
	    SDL_Rect rect17 = {27*irc_MERKINPITUUS, (monesrivi-5)*irc_MERKINKORKEUS, sharmhaka_a->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, harmhaka_a, NULL, &rect17);
	    SDL_Rect rect14 = {23*irc_MERKINPITUUS, (monesrivi-5)*irc_MERKINKORKEUS, shk_nick->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, hk_nick, NULL, &rect14);
	    SDL_Rect rect13 = {10*irc_MERKINPITUUS, (monesrivi-5)*irc_MERKINKORKEUS, stopicsetby->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, topicsetby, NULL, &rect13);
	    if(monesrivi < 7) break;
	    SDL_Rect rect12 = {24*irc_MERKINPITUUS, (monesrivi-6)*irc_MERKINKORKEUS, skannimi_dc->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kannimi_dc, NULL, &rect12);
	    SDL_Rect rect11 = {10*irc_MERKINPITUUS, (monesrivi-6)*irc_MERKINKORKEUS, stoka_rivi->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, toka_rivi, NULL, &rect11);
	    if(monesrivi < 8) break;
	    SDL_Rect rect10 = {54*irc_MERKINPITUUS, (monesrivi-7)*irc_MERKINKORKEUS, skannimi_wb->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, kannimi_wb, NULL, &rect10);
	    SDL_Rect rect9 = {43*irc_MERKINPITUUS, (monesrivi-7)*irc_MERKINKORKEUS, shas_joined->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, has_joined, NULL, &rect9);
	    SDL_Rect rect8 = {41*irc_MERKINPITUUS, (monesrivi-7)*irc_MERKINKORKEUS, sharmhaka_k->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, harmhaka_k, NULL, &rect8);
	    SDL_Rect rect7 = {20*irc_MERKINPITUUS, (monesrivi-7)*irc_MERKINKORKEUS, sirc_osoite->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, irc_osoite, NULL, &rect7);
	    SDL_Rect hhakaa = {19*irc_MERKINPITUUS, (monesrivi-7)*irc_MERKINKORKEUS, sharmhaka_a->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, harmhaka_a, NULL, &hhakaa);
	    SDL_Rect rboldnick = {10*irc_MERKINPITUUS, (monesrivi-7)*irc_MERKINKORKEUS, sboldnick->w, irc_MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, boldnick, NULL, &rboldnick);
	  }
	  while (RUUDUNLEVEYS == 666);

	  if(merkkikohta == 1) {
	    SDL_Rect kursrect = {15*irc_MERKINPITUUS, (irc_rivimaara-1)*irc_MERKINKORKEUS, irc_MERKINPITUUS, irc_MERKINKORKEUS};
	    SDL_SetRenderDrawColor(piirturi, 0x0, 0x82, 0x0, 0xFF);
	    SDL_RenderFillRect(piirturi, &kursrect);
	  }

	  monesrivi = 9 - irc_rivinlasku;
	  
	  if(pois == 0) pois = 2;  //0 = jatkuu, 1 = viimeinen kierros, 2 = toiseksi viimeinen kierros, oletusarvo
	  //Thn oli suunnitteilla list irc_RIVIVALI
	  //irc_rivi -vektorilooppi, jossa coutataan tekstit
	  for(vector<irc_rivi>::iterator irc_rendit = irc_teksturet.begin(); irc_rendit != irc_teksturet.end(); ++irc_rendit) {
	    if(irc_rendit->ajastin == 0 and irc_rendit->aikaleima == aika2) irc_aika = 2;
	    if(irc_rendit->ajastin != -1) pois = 0;
	    if(monesrivi < 1) { //Ylpalkin plle tai ruudusta ulos menevt rivit jtetn piirtmtt
	      monesrivi++;
	      continue;
	    }
	    if(irc_rendit->kirjoitus != "" and irc_rendit->ajastin == 0) {  //Jos on kyttjn kirjoitusrivi...
	      if(irc_kirjoittelu(irc_rendit->kirjoitus, kursoriliike)) {
		irc_rendit->kirjoitus = "";
	      }
	      break;
	    }
	    if(irc_rendit -> ajastin == 0) {
	      irc_rendit->ajastin = -1;
	      if(monesrivi*irc_MERKINKORKEUS > irc_rivimaara*irc_MERKINKORKEUS-(3*irc_MERKINKORKEUS)) {
		irc_rivinlasku++;
		monesrivi--;
		break; //Jtetn loopista yksi kierros pois, niin ei tule sellaista framea, jossa uusi teksti piirretn vanhan plle
	      }
	    }
	    if(irc_rendit -> aikaleima != NULL and irc_rendit -> ajastin == -1) {
	      SDL_Rect rect1 = {0, monesrivi*irc_MERKINKORKEUS, 5*irc_MERKINPITUUS, irc_MERKINKORKEUS}; //5 == aikaleiman merkkien lukumr (esim. 15:03)
	      SDL_RenderCopy(piirturi, irc_rendit->aikaleima, NULL, &rect1);
	      SDL_Rect rect5 = {5*irc_MERKINPITUUS, monesrivi*irc_MERKINKORKEUS, 2*irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi,sulut_auki, NULL, &rect5);
	      SDL_Rect rect2 = {7*irc_MERKINPITUUS, monesrivi*irc_MERKINKORKEUS, irc_rendit->npituus*irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi, irc_rendit->nikki, NULL, &rect2);
	      SDL_Rect rect6 = {irc_rendit->npituus*irc_MERKINPITUUS+7*irc_MERKINPITUUS, monesrivi*irc_MERKINKORKEUS, 1*irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi,sulut_kiinni, NULL, &rect6);
	    }
	    if(irc_rendit -> aikaleima == NULL and irc_rendit -> ajastin == -1) {
	      SDL_Rect rect3 = {0, monesrivi*irc_MERKINKORKEUS, irc_rendit->vpituus*irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi, irc_rendit->sanoma, NULL, &rect3);
	    }
	    else if (irc_rendit -> ajastin == -1) {
	      SDL_Rect rect4 = {irc_rendit->npituus*irc_MERKINPITUUS+9*irc_MERKINPITUUS, monesrivi*irc_MERKINKORKEUS, irc_rendit->vpituus*irc_MERKINPITUUS, irc_MERKINKORKEUS};
	      SDL_RenderCopy(piirturi, irc_rendit->sanoma, NULL, &rect4);
	    }
	    monesrivi++;
	  }

	  if(pois == 1) {
	    IRC = 2;
	    irc_ajastin2 = SDL_GetTicks();
	    pois = 3;
	  }
	  else if(pois == 2) pois = 1;
	}
	//Hahmot
	else if(hahmoja) {
	  if(SDL_GetTicks() - ajastin_fr > 57) { //Mit suurempi tuo viimeinen luku, sit hitaammin kvelyframet vaihtuvat
	    ajastin_fr = SDL_GetTicks();
	    liikutaan = true;
	  }
	  if(drop) {
	    if(SDL_GetTicks() - ajastin_r > 80) {
	      ajastin_r = SDL_GetTicks();
	      drops.frame += 1;
	      if(drops.frame == 16) drops.frame = 0;
	    }
	  }
	  else if(ruokaa > 0) {
	    if(SDL_GetTicks() - ajastin_r > 130) {
	      ajastin_r = SDL_GetTicks();
	      if(rcount == 0) mayra.frame = 24;
	      if(rcount == 1) mayra.frame = 25;
	      if(rcount == 2) mayra.frame = 26;
	      if(rcount == 3) mayra.frame = 27;
	      if(rcount == 4) mayra.frame = 26;
	      if(rcount == 5) mayra.frame = 25;
	      rcount++;
	      if(rcount == 6) rcount = 0;
	      if(ruokaa == 2) {
		ruokaa = 0;
		mayra.frame = 0;
	      }
	    }
	  }
	  //Tss kytetn wp3muutos & wp4muutos -arvoja nppimistkirjoitus-framejen vaihteluun
	  //wp3muutos on boolelainen, joka kertoo, ollaanko lepotilassa. wp4muutos kertoo, miten kauan nykyinen tila jatkuu.
	  else if(kirjoittelu and liikutaan) {
	    for(vector<hahmoluokka*>::iterator kiter = hahmovektori.begin(); kiter != hahmovektori.end(); ++kiter) {
	      (*kiter)->rintamasuunta = 0;
	      if((*kiter)->wp4muutos == 0) {
		int random = rand()%5;
		switch(random) {
		case 0: (*kiter)->wp4muutos = 6; break;
		case 1: (*kiter)->wp4muutos = 13; break;
		case 2: (*kiter)->wp4muutos = 19; break;
		case 3: (*kiter)->wp4muutos = 25; break;
		case 4: (*kiter)->wp4muutos = 35; break;
		}
		(*kiter)->wp3muutos ? (*kiter)->wp3muutos = 0 : (*kiter)->wp3muutos = 1;
	      }
	      if((*kiter)->wp3muutos == 1) {
		if((*kiter)->frame == 21) (*kiter)->frame = 22;
		else (*kiter)->frame = 21;
	      }
	      (*kiter)->wp4muutos--;
	    }
	  }

	  for(vector<esineluokka*>::iterator r4_iter2 = esinevektori.begin(); r4_iter2 != esinevektori.end(); ++r4_iter2) {
	    if((*r4_iter2)->ruudulla == 4) (**r4_iter2).esineenpiirto();
	  }
	  for(vector<hahmoluokka*>::iterator r4_iter = hahmovektori.begin(); r4_iter != hahmovektori.end(); ++r4_iter) {
	    if((*r4_iter)->ruudulla == 4) (**r4_iter).hahmonpiirto(liikutaan, frame_nyt);
	  }
	  for(vector<esineluokka*>::iterator r3_iter2 = esinevektori.begin(); r3_iter2 != esinevektori.end(); ++r3_iter2) {
	    if((*r3_iter2)->ruudulla == 3) (**r3_iter2).esineenpiirto();
	  }
	  for(vector<hahmoluokka*>::iterator r3_iter = hahmovektori.begin(); r3_iter != hahmovektori.end(); ++r3_iter) {
	    if((*r3_iter)->ruudulla == 3) (**r3_iter).hahmonpiirto(liikutaan, frame_nyt);
	  }
	  for(vector<esineluokka*>::iterator r2_iter2 = esinevektori.begin(); r2_iter2 != esinevektori.end(); ++r2_iter2) {
	    if((*r2_iter2)->ruudulla == 2) (**r2_iter2).esineenpiirto();
	  }
	  for(vector<hahmoluokka*>::iterator r2_iter = hahmovektori.begin(); r2_iter != hahmovektori.end(); ++r2_iter) {
	    if((*r2_iter)->ruudulla == 2) (**r2_iter).hahmonpiirto(liikutaan, frame_nyt);
	  }
	  for(vector<esineluokka*>::iterator r1_iter2 = esinevektori.begin(); r1_iter2 != esinevektori.end(); ++r1_iter2) {
	    if((*r1_iter2)->ruudulla == 1) (**r1_iter2).esineenpiirto();
	  }
	  for(vector<hahmoluokka*>::iterator r1_iter = hahmovektori.begin(); r1_iter != hahmovektori.end(); ++r1_iter) {
	    if((*r1_iter)->ruudulla == 1) (**r1_iter).hahmonpiirto(liikutaan, frame_nyt);
	  }
	  liikutaan = false; //Ennen tt rivi kaikki hahmonpiirto-kutsut
	}

	else if(alkutekstit > 0 and alkutekstit < 6) {
	  if(alkutekstit == 1) {
	    if(kieli == 1) {
	      apinta1 = TTF_RenderText_Solid(irc_fontti_b, "Valmistaudu elimellisproseduraalismodulaariseen kokemukseen", ircvari);
	      apinta2 = TTF_RenderText_Solid(loppufontti, "Tss tulee...", ircvari);
	    }
	    else {
	      apinta1 = TTF_RenderText_Solid(irc_fontti_b, "Prepare for an animalisticproceduralisticmodularistic experience", ircvari);
	      apinta2 = TTF_RenderText_Solid(loppufontti, "Here comes...", ircvari);
	    }
	    atekstuuri1 = SDL_CreateTextureFromSurface(piirturi, apinta1);
	    atekstuuri2 = SDL_CreateTextureFromSurface(piirturi, apinta2);
	    arect1 = {50, 100, apinta1->w, apinta1->h};
	    arect2 = {80, 200, apinta2->w, apinta2->h};
	    alkutekstit++;
	  }
	  if(alkutekstit == 2) {
	    SDL_RenderCopy(piirturi, atekstuuri1, NULL, &arect1);
	    SDL_RenderCopy(piirturi, atekstuuri2, NULL, &arect2);
	  }
	  if(alkutekstit == 3) {
	    SDL_FreeSurface(apinta1);
	    SDL_FreeSurface(apinta2);
	    SDL_DestroyTexture(atekstuuri1);
	    SDL_DestroyTexture(atekstuuri2);
	    alkutekstit++;
	  }
	  if(alkutekstit == 4) {
	    apinta3 = TTF_RenderText_Solid(irc_fontti_b, "457f 464c 0101 0001 0000 0000 0000 0000 0003 0003 0001 0000 2010 0000 0034 0000 929c 0000 0000 0000 0034 0020 000b 0028 001d 001c 0006 0000 0034 0000 0034 0000 0034 0000 0160 0000 0160 0000 0004 0000 0004 0000 0003 0000 0194", alkuvari);
	    
	    apinta4 = TTF_RenderText_Solid(irc_fontti_b, "void *get_in_addr(struct sockaddr *sa) {if(sa->sa_family == AF_INET) return &(((struct sockaddr_in*)sa)->sin_addr); return &(((struct sockaddr_in6*)sa)->sin6_addr);} int main(void) {int sockfd, new_fd; struct addrinfo hints", alkuvari);
	    SDL_SetRenderDrawColor(piirturi, 0x00, 0x00, 0x00, 0x00);
	    SDL_RenderFillRect(piirturi, &btausta);
	    SDL_RenderFillRect(piirturi, &ctausta);
	    atekstuuri3 = SDL_CreateTextureFromSurface(piirturi, apinta3);
	    atekstuuri4 = SDL_CreateTextureFromSurface(piirturi, apinta4);
	    arect3 = {binx, 448, apinta3->w, apinta3->h};
	    arect4 = {cx, 414, apinta4->w, apinta4->h};
	    SDL_RenderCopy(piirturi, atekstuuri3, NULL, &arect3);
	    SDL_RenderCopy(piirturi, atekstuuri4, NULL, &arect4);
	    binx -= 4;
	    cx -= 3;
	    av1 = rand()%254;
	    av2 = rand()%254;
	    av3 = rand()%254;
	    alkuvari = {av1, av2, av3};
	    
	    sydrect = {540+sasetus, syd1, 47, 53};
	    SDL_RenderCopy(piirturi, sydan.tekstuuri, NULL, &sydrect);
	    sydrect = {451+sasetus, syd3, 47, 53};
	    SDL_RenderCopy(piirturi, sydan.tekstuuri, NULL, &sydrect);
	    sydrect = {486+sasetus, syd2, 47, 53};
	    SDL_RenderCopy(piirturi, sydan.tekstuuri, NULL, &sydrect);
	    syd1 -= 5;
	    syd2 -= 5;
	    syd3 -= 5;
	    if(syd1 < -145) syd1 = 55;
	    if(syd3 < -155) syd3 = 45;
	    if(syd2 < -135) syd2 = 65;
	    if(ssuunta == 'o') sasetus++;
	    if(ssuunta == 'v') sasetus--;
	    if(sasetus == 5) ssuunta = 'v';
	    if(sasetus == -5) ssuunta = 'o';

	    kasic++;
	    if(kasic > 4) SDL_RenderCopy(piirturi, kadet.tekstuuri, NULL, &kasirect);
	    if(kasic == 8) kasic = 0;
	      
	  }
	  if(alkutekstit == 5) {
	    SDL_FreeSurface(apinta3);
	    SDL_FreeSurface(apinta4);
	    SDL_DestroyTexture(atekstuuri3);
	    SDL_DestroyTexture(atekstuuri4);
	    alkutekstit++;
	  }
	}

	if(lopputekstit) {
	  for(vector<lteksti>::iterator loppu_iter2 = ltekstit2.begin(); loppu_iter2 != ltekstit2.end(); ++loppu_iter2) {
	    loppu_iter2->loppurect.y -= 2;
	    SDL_RenderCopy(piirturi, loppu_iter2->ltekstuuri, NULL, &(loppu_iter2->loppurect));
	    
	    if(loppu_iter2->taukoa == 0 and loppu_iter2->loppurect.y > (RUUDUNKORKEUS-28)) break;
	    if(loppu_iter2->taukoa == 1 and loppu_iter2->loppurect.y > (RUUDUNKORKEUS-98)) break;

	    if(loppu_iter2->loppurect.y < -20) {
 	      SDL_DestroyTexture(loppu_iter2->ltekstuuri);
	      ltekstit2.erase(loppu_iter2);
	      loppu_iter2--;
	    }
	  }

	  for(vector<lteksti>::iterator loppu_iter = ltekstit.begin(); loppu_iter != ltekstit.end(); ++loppu_iter) {
	    loppu_iter->loppurect.y -= 2;
	    SDL_RenderCopy(piirturi, loppu_iter->ltekstuuri, NULL, &(loppu_iter->loppurect));
	    
	    if(loppu_iter->taukoa == 0 and loppu_iter->loppurect.y > (RUUDUNKORKEUS-30)) break;
	    if(loppu_iter->taukoa == 1 and loppu_iter->loppurect.y > (RUUDUNKORKEUS-100)) break;

	    if(loppu_iter->loppurect.y < -20) {
	      SDL_DestroyTexture(loppu_iter->ltekstuuri);
	      ltekstit.erase(loppu_iter);
	      loppu_iter--;
	      if(ltekstit.size() == 0) {
		feidaus = true;
		musafeidaus = true;
	      }
	    }
	  }
	  //framesync
	  //Oleellinen synciss on kahdeksan rivin vaihteluvli (%8), jonka kesto on noin 600 ticksi. Ensimminen frame otetaan tracker-musiikin rivin mukaan ja loput ajastetusti
	  if(musaptr->get_current_row()%8-6 == 0 and rowcontrol == 0) {
	    tanssitimer = SDL_GetTicks();
	    if(kissa.frame == 26) kissa.frame = 25;
	    else kissa.frame = 24;
	    mayra.frame = 28;
	    rowcontrol = 1;
	  }
	  else if(SDL_GetTicks()-tanssitimer >= 200 and rowcontrol == 2) {  //Tmn timer-logiikan vuoksi tm toinen frame-vaihto on ennen ensimmist tss koodissa
	    if(kissa.frame == 24) kissa.frame = 23;
	    else kissa.frame = 26;
	    mayra.frame = 29;
	    rowcontrol = 0;
	  }
	  else if(SDL_GetTicks()-tanssitimer >= 100 and rowcontrol == 1) {
	    if(kissa.frame == 25) kissa.frame = 24;
	    else kissa.frame = 25;
	    rowcontrol = 2;
	  }
	}

	if(kuplantila == 1) kuplanluonti(frame_nyt);
	if(kuplantila == 2 or kuplantila == 3) kuplanpiirto(frame_nyt);
	
	if(feidaus) {
	  pimee.alphafunktio(alpha);
	  pimee.renderfunktio(0,0);
	}
	
	SDL_RenderPresent(piirturi);

	if(tarina_t > 0 and kuplantila != 6) {
	  tarina_t--;
	  if(tarina_t == 0) {
	    if(kesktark()) tarinakeskeytys = true;
	    if(kuplantila == 7) {
	      tarina_kt = 0;
	      vector<kupla>::iterator eriter = kuplavec.begin();
	      kuplavec.erase(eriter);
	      if(kuplavec.size() > 0) kuplanluonti(frame_nyt);
	      else {
		tarinakeskeytys = true;
		kuplantila = 0;
	      }
	    }
	  }
	}
	if(kuplantila == 6) kuplantila++;
	if(IRC > 0 and SDL_GetTicks() - irc_ajastin >= 1000) {
	  irc_ajastin = SDL_GetTicks();
	  irc_sekunti = true;
	}

	if(feidaus) {
	  alpha += 3;
	  if(alpha == 255) {
	    tarinakeskeytys = true;
	    alpha = 0;
	    feidaus = false;
	    taustakuva = pimee;
	    kamerareset();
	    if(tarinanvaihe >= 600) quit = true;
	  }
	  pimee.renderfunktio(0,0);       	  
	}
      
	frame_nyt++;
	//FRAMERATE
	ajastin2 = (SDL_GetTicks() - ajastin1);
	if(ajastin2 < 40) SDL_Delay(40 - ajastin2); //FPS:n asetus. 40 = 1000 millisekunttia / 25 FPS
      }
    }
  }
  //Vapauta resurssit ja sulje SDL
  sammutus();
  return 0;
}

