#version 120

uniform sampler2D texture;
uniform sampler2D noiseTexture;

uniform float time = 1.0;

uniform float distortionResolutionX = 1280.0;
uniform float distortionResolutionY = 720.0;
uniform float distortionX = 0.01;
uniform float distortionY = 0.01;
uniform float noiseAlpha = 0.1;
uniform float shakeSizeY = 0.005;
uniform float glitchSize = 0.001;

uniform float iterations = 21;
uniform float speed = 10.0;
uniform float displacement = 0.15;
uniform float tightness = 1.0;
uniform float yoffset = 0.75;
uniform float yscale = 0.45;
uniform vec3 flametone = vec3(10.0, 0.0, 0.0);



float getRandomNoise(vec2 coord)
{
	return texture2D(noiseTexture,coord).r;
}

float noise( in vec3 x ) // iq noise function
{
	vec3 p = floor(x);
    vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);
	vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
	vec2 rg = texture2D( noiseTexture, (uv+ 0.5)/256.0, -100.0 ).yx;
	return mix( rg.x, rg.y, f.z ) * 3.0 - 1.0;
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(tan(time/10),tan(time/10)))) * tan(time));
}
float shape(in vec2 pos) // a blob shape to distort
{
	return clamp( sin(pos.x*0.1416) - pos.y+yoffset, 0.0, 1.0 );
}

vec4 distortion()
{
	vec2 coord = gl_TexCoord[0].st;

	float nx = 0.0;
float ny = 0.0;
for (int i=1; i<iterations+1; i++)
{
		float ii = pow(float(i), 2.0);
		float ifrac = float(i)/float(iterations);
		float t = ifrac * time * speed;
		float d = (1.0-ifrac) * displacement;
		nx += noise( vec3(coord.x*ii-time*ifrac, coord.y*yscale*ii-t, 0.0)) * d * 2.0;
		ny += noise( vec3(coord.x*ii+time*ifrac, coord.y*yscale*ii-t, time*ifrac/ii)) * d;
	}
	float flame = shape( vec2(coord.x+nx+0.5, coord.y+ny+0.5) );
	vec3 col = pow(flame, tightness) * flametone;
    
    // tonemapping
    col = col / (1.0+col);
    col = pow(col, vec3(1.0/2.2));
    col = clamp(col, 0.0, 1.0);
	
	return vec4(col, 1.0);
	
	
}

void main()
{
	gl_FragColor = distortion();
}