; carcharodon minor
;
; a 128b intro by Gasman / Hooy-Program
; for Outline 2019

stack_a	equ 0x2D28
rom_beep	equ 0x03F8

CALC_EXCHANGE	equ 0x01
CALC_END_CALC	equ	0x38
CALC_CONST		equ 0x34

	org 0x6000

row_loop
	push bc
	ld a,c
	rrca
	jr c,no_anim_shark

	exx
	ld d,a

	ld hl,0x5800
	ld a,055o
	call background
	ld a,011o
	call background

	ld hl,0x5940
fin_lp
	ld a,l
	rlca
	rlca
	rlca
	and 0x07 ; line number 2..7
	ld b,a

	ld a,l
	cpl
	and 0x1f

	add a,d  ; a = image x coord

	ld c,a

	rlca
	rlca
	rlca
	cpl
	and 0x03 ; a = shark number 3..2..1..0
	add a,26+7
	sub b
	ld e,a  ; first shark-relative x at which to plot

	ld a,c
	and 31 ; a = shark-relative x

	cp e

	jr c,skip_plot_fin
	ld (hl),0
skip_plot_fin
	inc l
	jr nz,fin_lp

	exx

no_anim_shark

	ld a,c
	and 0x0f
	jr nz,no_reset_rhythm

	ld de,notes_0
	ld hl,%1010101010110110  ; baby shark, doo doo dudu dudu
	ld a,c
	cpl
	and 0x30
	jr nz,no_last_pattern
	ld hl,%1010100000000000  ; baby shark
	ld e,low notes_1
no_last_pattern
no_reset_rhythm
	add hl,hl
	push hl
	jr c,no_pause
	ld b,6
halt6
	halt
	djnz halt6
no_pause
	jr nc,no_beep

beep_de
	ld a,(de)
	add a,7
	inc de
	push de
beep
	call stack_a
	rst 0x28
	db CALC_CONST, 0x2d, 0x4d ; 0.1ish
	db CALC_EXCHANGE
	db CALC_END_CALC
	call rom_beep
	pop de

no_beep
	pop hl

	pop bc
	inc c
	jr row_loop

background
	ld b,0xc0
background_lp
	ld (hl),a
	inc hl
	ld (hl),a
	inc hl
	djnz background_lp
	ret

notes_1 db 0, 0, 0xff ; C C Bb minus 7
notes_0	db 0xfb, 0xfd ; G A C C C CC CC minus 7 - use the empty memory after this for the C=0
