pico-8 cartridge // http://www.pico-8.com
version 16
__lua__
-- oxo
-- by gasman

cube = {
 {-1, -1, -1},
 {-1, 1, -1},
 {1, 1, -1},
 {1, -1, -1},
 {1, -1, 1},
 {-1, -1, 1},
 {-1, 1, 1},
 {1, 1, 1},
}
cube_edges = {
 {1,2},{2,3},{3,4},{4,1},
 {4,5},{5,6},{6,1},{6,7},{7,2},
 {7,8},{3,8},{5,8},
}
cube_faces = {
 {1,2,3,4, 4}, {4,5,6,1, 8}, {6,7,2,1, 10},
 {5,8,7,6, 4}, {3,2,7,8, 8}, {4,3,8,5, 10},
}
transformed_cube = {}

function add_edge(v1, v2)
 x1 = v1[1] * 4 + 8
 y1 = v1[2] * 4 + 8
 light1 = mid(0, 0.3 + (v1[3] - v1[2]/2) / 1.4, 1)
 x2 = v2[1] * 4 + 8
 y2 = v2[2] * 4 + 8
 light2 = mid(0, 0.3 + (v2[3] - v2[2]/2) / 1.4, 1)

 xstep = (x2-x1) / (y2-y1)
 lightstep = (light2-light1) / (y2-y1)

 if (y1 < y2) then
  for y=flr(y1+0.5),flr(y2-0.5) do
   x = flr(x1)
   if(endpoints[y] == nil) then
    endpoints[y] = {x, light1, x, light1}
   else
    if(x < endpoints[y][1]) then
     endpoints[y][1] = x
     endpoints[y][2] = light1
    end

    if(x > endpoints[y][3]) then
     endpoints[y][3] = x
     endpoints[y][4] = light1
    end
   end

   x1 += xstep
   light1 += lightstep
  end
 else
  for y=flr(y2+0.5),flr(y1-0.5) do
   x = flr(x2)
   if(endpoints[y] == nil) then
    endpoints[y] = {x, light2, x, light2}
   else
    if(x < endpoints[y][1]) then
     endpoints[y][1] = x
     endpoints[y][2] = light2
    end

    if(x > endpoints[y][3]) then
     endpoints[y][3] = x
     endpoints[y][4] = light2
    end

   end

   x2 += xstep
   light2 += lightstep
  end
 end
end

function plasma()
 a = time() / 10
 b = time() / 11

 for x=0,15 do
  for y=0,15 do
   val = cos((sin(x*0.2*cos(a) + a * 8) + cos(y*0.15*cos(b) + 4))/4) + time()
   mset(x,y, flr(val*1.99 % 8) + 16)
  end
 end
end

function transform_cube()
 a = time() * 0.25
 cosa = cos(a)
 sina = sin(a)
 b = time() * 0.3
 cosb = cos(b)
 sinb = sin(b)
 c = time() * 0.35
 cosc = cos(c)
 sinc = sin(c)

 for i, v in pairs(cube) do
  z1 = -v[2] * sina + v[3] * cosa

  x2 = v[1] * cosb - z1 * sinb
  y2 = v[2] * cosa + v[3] * sina
  z3 = v[1] * sinb + z1 * cosb

  x3 = x2 * cosc + y2 * sinc
  y3 = -x2 * sinc + y2 * cosc

  transformed_cube[i] = {x3, y3, z3}
 end
end

function gouraudcube(cube_scale, map_top, map_height)
 transform_cube()
 visible_edges = {}

 for f in all(cube_faces) do
   endpoints = {}

   v1 = transformed_cube[f[1]]
   v2 = transformed_cube[f[2]]
   v3 = transformed_cube[f[3]]
   v4 = transformed_cube[f[4]]

   -- some sort of dot-product voodoo to decide if this is a forward-facing polygon
   xpz = (v2[1] - v1[1]) * (v4[2] - v1[2]) - (v2[2] - v1[2]) * (v4[1] - v1[1])
   if (xpz >= 0) then
    add_edge(v1, v2)
    add_edge(v2, v3)
    add_edge(v3, v4)
    add_edge(v4, v1)
    for y,row in pairs(endpoints) do
     lightstep = (row[4] - row[2]) / (row[3] - row[1] + 1)
     light = row[2]
     for x=row[1],row[3] do
      mset(x, y, flr(light*12.99))
      light += lightstep
     end
    end

    visible_edges[shl(f[1], 8) + f[2]] = 1
    visible_edges[shl(f[2], 8) + f[3]] = 1
    visible_edges[shl(f[3], 8) + f[4]] = 1
    visible_edges[shl(f[4], 8) + f[1]] = 1
   end
 end

 map(0,map_top,0,map_top*8,16,map_height)

 for l,o in pairs(visible_edges) do
  v1 = transformed_cube[shr(band(l, 0xff00), 8)]
  v2 = transformed_cube[band(l, 0xff)]
  line(v1[1] * 32 * cube_scale + 64, v1[2] * 32 * cube_scale + 64, v2[1] * 32 * cube_scale + 64, v2[2] * 32 * cube_scale + 64, 10)
 end
end

function wirecube_part(cube_scale)
 transform_cube()
 for edge in all(cube_edges) do
  v1 = transformed_cube[edge[1]]
  v2 = transformed_cube[edge[2]]
  line(v1[1] * 32 * cube_scale + 64, v1[2] * 32 * cube_scale + 64, v2[1] * 32 * cube_scale + 64, v2[2] * 32 * cube_scale + 64, 10)
 end
end

function plasma_part()
 plasma()
 map(0,0,0,0,16,16)
end

function scancube_part(cube_scale, local_t)
 -- clear map
 for a=0x2000,0x2780,0x80 do
  memset(a,0,0x10)
 end

 scan_speed = local_t ^ 1.8
 gouraudcube(cube_scale, flr((scan_speed * 16) % 16), flr(local_t))
end

function plasmacube_part()
 plasma()
 gouraudcube(1, 0, 16)
end

function _init()
 music(0)
end

pattern_duration = 4*64/60
function _draw()
 -- clear screen
 rectfill(0,0,127,127,0)

 music_pattern_pos = time() / pattern_duration
 if(music_pattern_pos < 2) then
  plasma_part()
 elseif(music_pattern_pos < 4) then
  local cube_scale = mid(0, (4 - music_pattern_pos) * 8, 1)
  wirecube_part(cube_scale)
 elseif(music_pattern_pos < 6) then
  local cube_scale = mid(0, (music_pattern_pos - 4) * 8, 1)
  scancube_part(cube_scale, (music_pattern_pos - 4) * 2)
 else
  plasmacube_part()
 end

 -- print(stat(1), 0, 0, 10)
end

__gfx__
000000000050500000505000000500000055500000d5d00000d5d000005d500000ddd000006d6000006d600000d6d00000666000000000000000000000000000
0000000000000000050505000555550005555500055555000d5d5d000ddddd000ddddd000ddddd0006d6d6000666660006666600000000000000000000000000
0000000050505050505050500505050055555550d5d5d5d0d5d5d5d05d5d5d50ddddddd06d6d6d606d6d6d60d6d6d6d066666660000000000000000000000000
0000000000000000050505005555555055555550555555505d5d5d50ddddddd0ddddddd0ddddddd0d6d6d6d06666666066666660000000000000000000000000
0000000050505050505050500505050055555550d5d5d5d0d5d5d5d05d5d5d50ddddddd06d6d6d606d6d6d60d6d6d6d066666660000000000000000000000000
0000000000000000050505000555550005555500055555000d5d5d000ddddd000ddddd000ddddd0006d6d6000666660006666600000000000000000000000000
000000000050500000505000000500000055500000d5d00000d5d000005d500000ddd000006d6000006d600000d6d00000666000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000b3b0000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000030000003b30000b3b3b000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000300000003000000030000003b300003b3b300b3b3b3b00000000000000000000000000000000000000000000000000000000000000000
00000000000300000030300000333000003b300003b3b3000b3b3b003b3b3b300000000000000000000000000000000000000000000000000000000000000000
0000000000000000000300000003000000030000003b300003b3b300b3b3b3b00000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000030000003b30000b3b3b000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000b3b0000000000000000000000000000000000000000000000000000000000000000000
__sfx__
00010000110500c0500c0500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00100000180501b0501f050220502405000000180501b0501f05022050240500000000000000000000000000180501b0501f050220502405000000180501b0502105022050210501d050000001b0501f05016050
001000000000000000180301b0301f030220302403000000180301b0301f03022030240301b0101f010220102401000000180301b0301f030220302403000000180301b0302103022030210301d030000001b030
00100000002400c24000240002300c23000230002300c220002400c24000240002300c23000230002300c220002400c24000240002300c23000230002300c220002400c24000240002300c23000230002300c220
0010000000000000001b5501a550165500000018550165500000013550000000f55011550135501855000000000001b7501d7501f7502275000000000001b7501d75024750227500000000000000000000000000
00100000002400c24000240002300c23000230002300c220002400c24000240002300c23000230002300c220002400c24000240002300c23000230002300c2201122000000000001322000000000001622000000
__music__
01 01020344
00 01020344
00 01020344
00 01020344
00 01020304
00 01020504
00 01020304
00 01020304
00 01020304
02 01020504

