# Crossing the Border

Unfortunately I was not able to attend Nordlicht 2019 [Nordlicht 2019
Website](https://nordlicht.demoparty.info/). But... There are the
remote entries!

This entry was made for the "GFX Compo (Oldschool)" competition, the
entry must run on oldschool hardware (in this case a C64), and an
executable is allowed (or even mandatory). I chose to use a 100%
[BASIC](https://www.c64-wiki.com/wiki/BASIC "CBM Basic V2") program to
display a very nice image. At the same time I am exploring the
competition rules. Where, exactly is the border and how far "Crossing
the Border" is allowed.

The image shows two realms with a common border. Is there an army
waiting or an uneasy truce? Maybe they are friends. In all cases for
further development "Crossing the Border" is a mandatory step.

# Tools used

## Basic DATA generator

The `convert.hs` script is a [Haskell](https://www.haskell.org/)
program to generate the Basic `DATA` statements which store the image
and the colour information of the image. The tool will take any binary
file and it will convert it to a Basic program. This Basic program can
be loaded directly by a C64, so the linked list of statements is
correct.

## Grafx2

[Grafx2](http://grafx2.chez.com/) graphics program for pixel
artists. It has the possibility to save the image in the C64 format
which ensures that the image and colour data is saved in a C64
compatible format. And, of course, that no more than two colors per
8*8 cell are allowed as we use the
[HiRes](https://www.c64-wiki.com/wiki/hires "320 X 200") mode.

## mtpaint

[Mtpaint](http://mtpaint.sourceforge.net/) is another graphics program
for the pixel artist. It has some nice features which Grafx2 is
lacking so I use both programs alternately.

# Steps


  * ![Step 00](step.00.png)
  * ![Step 01](step.01.png)
  * ![Step 02](step.02.png)
  * ![Step 03](step.03.png)
  * ![Step 04](step.04.png)
  * ![Step 05](step.05.png)
  * ![Step 06](step.06.png)
  * ![Step 07](step.07.png)

# Colophon

For further information see the [Crossing the
Borders](https://v2.pikacode.com/pararaum/nordlicht2019) homepage. For
greetings have a look at the Basic code.
